/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.StringAlignment;
import de.jstacs.algorithms.alignment.cost.Costs;
import java.text.NumberFormat;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALESequence;

public class TALEAligner {
    public static StringAlignment align(TALE tale1, TALE tale2, Costs costs, Alignment.AlignmentType at, double extraGapOpening, double extraGapExtension) {
        TALESequence s1 = new TALESequence(tale1);
        TALESequence s2 = new TALESequence(tale2);
        Alignment al = new Alignment(costs);
        String str1 = null;
        StringAlignment psa = null;
        if (s1.getLength() >= s2.getLength()) {
            psa = al.getAlignment(at, s1, s2);
            str1 = psa.getAlignedString(1);
        } else if (s1.getLength() < s2.getLength()) {
            psa = al.getAlignment(at, s2, s1);
            str1 = psa.getAlignedString(1);
            psa = new StringAlignment(psa.getCost(), psa.getAlignedString(1), psa.getAlignedString(0));
        }
        if (at == Alignment.AlignmentType.SEMI_GLOBAL) {
            int i;
            str1 = str1.replaceAll(" ", "");
            double cost = psa.getCost();
            if (str1.startsWith("-")) {
                cost += extraGapOpening;
                i = 0;
                while (str1.charAt(i) == '-') {
                    cost += extraGapExtension;
                    i += 2;
                }
            }
            if (str1.endsWith("-")) {
                cost += extraGapOpening;
                i = str1.length() - 1;
                while (str1.charAt(i) == '-') {
                    cost += extraGapExtension;
                    i -= 2;
                }
            }
            psa = new StringAlignment(cost, psa.getAlignedString(0), psa.getAlignedString(1));
        }
        return psa;
    }

    public static String alignmentToString(StringAlignment sa, NumberFormat nf) {
        String s1 = sa.getAlignedString(0);
        String s2 = sa.getAlignedString(1);
        StringBuffer pat = new StringBuffer();
        int i = 0;
        while (i < s1.length()) {
            if (s1.charAt(i) == ' ' || s1.charAt(i) == '-' || s2.charAt(i) == '-') {
                pat.append(" ");
            } else if (s1.charAt(i) == s2.charAt(i)) {
                pat.append('|');
            } else {
                pat.append(':');
            }
            ++i;
        }
        return String.valueOf(s1) + "\n" + pat.toString() + "\n" + s2 + "\nCost: " + nf.format(sa.getCost());
    }
}

