/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.Storable;
import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.StringAlignment;
import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.clustering.hierachical.Hclust;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import projects.tals.TALgetterDiffSM;
import projects.xanthogenomes.AlignmentPValues;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALEAligner;
import projects.xanthogenomes.TALEFamilyTreePlotter;
import projects.xanthogenomes.alignmentCosts.RVDCosts;
import projects.xanthogenomes.tools.ClassAssignmentTool;

public class TALEFamilyBuilder
implements Storable {
    private static NumberFormat format = DecimalFormat.getInstance(Locale.US);
    private static NumberFormat formatE = new DecimalFormat("0.##E0");
    public static double RELATIVE_MISMATCH_SHORT = 0.3;
    private TALEFamily[] families;
    private double[][] dmat;
    private Costs costs;
    private Alignment.AlignmentType at;
    private Hclust.Linkage linkage;
    private double extraGapOpening;
    private double extraGapExtension;
    private double cut;
    private double pval;
    private String[] reservedNames;

    public TALEFamilyBuilder(TALE[] tales) throws IllegalArgumentException, IOException, WrongAlphabetException {
        this(tales, new AffineCosts(5.0, new RVDCosts(1.0, 0.2, 0.8, 0.0)), Hclust.Linkage.AVERAGE, Alignment.AlignmentType.SEMI_GLOBAL, 1.0, 0.1, 5.0, 0.01);
    }

    public TALEFamilyBuilder(TALE[] tales, Costs costs, Hclust.Linkage linkage, Alignment.AlignmentType at, double extraGapOpening, double extraGapExtension, double cut, double pval) {
        this.pval = pval;
        this.at = at;
        this.costs = costs;
        this.cut = cut;
        this.extraGapExtension = extraGapExtension;
        this.extraGapOpening = extraGapOpening;
        this.linkage = linkage;
        Pair<double[][], ClusterTree<TALE>> pair = TALEFamilyBuilder.cluster(tales, linkage, costs, at, extraGapOpening, extraGapExtension);
        ClusterTree<TALE> tree = pair.getSecondElement();
        this.dmat = pair.getFirstElement();
        ClusterTree<TALE>[] subtrees = Hclust.cutTree(cut, tree);
        LinkedList<TALEFamily> list = new LinkedList<TALEFamily>();
        int k = 0;
        int i = 0;
        while (i < subtrees.length) {
            LinkedList curr = new LinkedList();
            curr.add(subtrees[i]);
            while (curr.size() > 0) {
                ClusterTree currTree = (ClusterTree)curr.removeFirst();
                if (currTree.getNumberOfElements() > 1) {
                    int l2;
                    int l1;
                    ClusterTree<T>[] children = currTree.getSubTrees();
                    double d = currTree.getMaximumDistance();
                    if (d / (double)Math.min(l1 = TALEFamilyBuilder.getMaximumTALELength(children[0]), l2 = TALEFamilyBuilder.getMaximumTALELength(children[1])) >= RELATIVE_MISMATCH_SHORT) {
                        curr.add(children[0]);
                        curr.add(children[1]);
                        continue;
                    }
                    currTree.leafOrder(this.dmat);
                    list.add(new TALEFamily(String.valueOf(k + 1), currTree, this));
                    ++k;
                    continue;
                }
                currTree.leafOrder(this.dmat);
                list.add(new TALEFamily(String.valueOf(k + 1), currTree, this));
                ++k;
            }
            ++i;
        }
        this.families = list.toArray(new TALEFamily[0]);
    }

    private static int getMaximumTALELength(ClusterTree<TALE> tree) {
        TALE[] members = tree.getClusterElements();
        int l = members[0].getNumberOfRepeats();
        int j = 1;
        while (j < members.length) {
            if (members[j].getNumberOfRepeats() > l) {
                l = members[j].getNumberOfRepeats();
            }
            ++j;
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    public TALEFamilyBuilder(StringBuffer xml) throws NonParsableException {
        block3: {
            super();
            this.at = (Alignment.AlignmentType)XMLParser.extractObjectForTags(xml, "at");
            this.costs = (Costs)XMLParser.extractObjectForTags(xml, "costs");
            this.cut = (Double)XMLParser.extractObjectForTags(xml, "cut");
            sb = XMLParser.extractForTag(xml, "dmatStore");
            this.dmat = sb != null ? TALEFamilyBuilder.parseDmat(sb) : (double[][])XMLParser.extractObjectForTags(xml, "dmat");
            this.extraGapOpening = (Double)XMLParser.extractObjectForTags(xml, "extraGapOpening");
            this.extraGapExtension = (Double)XMLParser.extractObjectForTags(xml, "extraGapExtension");
            tempXML = new StringBuffer(xml);
            try {
                this.families = (TALEFamily[])XMLParser.extractObjectForTags(xml, "families");
                break block3;
            }
            catch (Exception ex) {
                xml = tempXML;
                temp = (String[])XMLParser.extractObjectForTags(xml, "families");
                this.families = new TALEFamily[temp.length];
                i = 0;
                ** while (i < this.families.length)
            }
lbl-1000:
            // 1 sources

            {
                this.families[i] = new TALEFamily(new StringBuffer(temp[i]));
                ++i;
                continue;
            }
        }
        this.linkage = (Hclust.Linkage)XMLParser.extractObjectForTags(xml, "linkage");
        this.reservedNames = (String[])XMLParser.extractObjectForTags(xml, "reservedNames");
        this.pval = (Double)XMLParser.extractObjectForTags(xml, "pval");
    }

    public Alignment.AlignmentType getAlignmentType() {
        return this.at;
    }

    public double getExtraGapOpening() {
        return this.extraGapOpening;
    }

    public double getExtraGapExtension() {
        return this.extraGapExtension;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, (Object)this.at, "at");
        XMLParser.appendObjectWithTags(xml, this.costs, "costs");
        XMLParser.appendObjectWithTags(xml, this.cut, "cut");
        StringBuffer dmat2 = TALEFamilyBuilder.storeDmat(this.dmat);
        XMLParser.addTags(dmat2, "dmatStore");
        xml.append(dmat2);
        XMLParser.appendObjectWithTags(xml, this.extraGapOpening, "extraGapOpening");
        XMLParser.appendObjectWithTags(xml, this.extraGapExtension, "extraGapExtension");
        XMLParser.appendObjectWithTags(xml, this.families, "families");
        XMLParser.appendObjectWithTags(xml, (Object)this.linkage, "linkage");
        XMLParser.appendObjectWithTags(xml, this.reservedNames, "reservedNames");
        XMLParser.appendObjectWithTags(xml, this.pval, "pval");
        return xml;
    }

    private static StringBuffer storeDmat(double[][] dmat) {
        StringBuffer sb = new StringBuffer();
        DecimalFormat df = new DecimalFormat("#.######");
        int i = 0;
        while (i < dmat.length) {
            int j = 0;
            while (j < dmat[i].length) {
                if (j > 0) {
                    sb.append(";");
                }
                sb.append(df.format(dmat[i][j]));
                ++j;
            }
            sb.append("$");
            ++i;
        }
        return sb;
    }

    private static double[][] parseDmat(StringBuffer sb) {
        int off = 0;
        int n = 0;
        while ((off = sb.indexOf("$", off) + 1) > 0) {
            ++n;
        }
        double[][] dmat = new double[n][];
        off = 0;
        int off2 = 0;
        n = 0;
        while ((off2 = sb.indexOf("$", off)) >= 0) {
            String[] parts = sb.substring(off, off2).split(";");
            dmat[n] = new double[parts.length];
            int j = 0;
            while (j < parts.length) {
                parts[j] = parts[j].replaceAll(",", ".");
                dmat[n][j] = Double.parseDouble(parts[j]);
                ++j;
            }
            ++n;
            off = off2 + 1;
        }
        return dmat;
    }

    public double getCut() {
        return this.cut;
    }

    public void setToOld() {
        int i = 0;
        while (i < this.families.length) {
            TALE[] mems = this.families[i].getFamilyMembers();
            int j = 0;
            while (j < mems.length) {
                mems[j].setIsNew(false);
                ++j;
            }
            ++i;
        }
    }

    public TALE[] getAllTALEs() {
        LinkedList<TALE> all = new LinkedList<TALE>();
        int i = 0;
        while (i < this.families.length) {
            TALE[] temp = this.families[i].getFamilyMembers();
            int j = 0;
            while (j < temp.length) {
                all.add(temp[j]);
                ++j;
            }
            ++i;
        }
        return all.toArray(new TALE[0]);
    }

    public ClusterTree<TALEFamily> clusterFamilies() {
        LinkedList<ClusterTree<Integer>> intTrees = new LinkedList<ClusterTree<Integer>>();
        LinkedList<ClusterTree<TALE>> leaves = new LinkedList<ClusterTree<TALE>>();
        IntList familyRootOriginalIndexes = new IntList();
        int minIndex = 0;
        int i = 0;
        while (i < this.families.length) {
            ClusterTree<TALE> famTree = this.families[i].getTree();
            int index = famTree.getMinimumOriginalIndex();
            if (index < minIndex) {
                minIndex = index;
            }
            familyRootOriginalIndexes.add(famTree.getOriginalIndex());
            ClusterTree<Integer> indexTree = famTree.getIndexTree();
            ClusterTree<TALE>[] myLeaves = famTree.getLeaves();
            int j = 0;
            while (j < myLeaves.length) {
                leaves.add(myLeaves[j]);
                ++j;
            }
            intTrees.add(indexTree);
            ++i;
        }
        TALE[] tales = new TALE[leaves.size()];
        int i2 = 0;
        while (i2 < leaves.size()) {
            ClusterTree leaf = (ClusterTree)leaves.get(i2);
            tales[leaf.getOriginalIndex()] = ((TALE[])leaf.getClusterElements())[0];
            ++i2;
        }
        double[][] dmat = TALEFamilyBuilder.computeDistMatrix(tales, this.costs, this.at, this.extraGapOpening, this.extraGapExtension);
        Hclust clust = new Hclust(null, this.linkage);
        ClusterTree<Integer> superCluster = clust.cluster(dmat, intTrees, -minIndex);
        ClusterTree<TALEFamily> famTree = superCluster.dropBelow(familyRootOriginalIndexes, this.families);
        return famTree;
    }

    private static double[][] computeDistMatrix(TALE[] tales, Costs costs, Alignment.AlignmentType at, double extraGapOpening, double extraGapExtension) {
        double[][] dmat = new double[tales.length][tales.length];
        int j = 0;
        while (j < tales.length) {
            int k = 0;
            while (k < tales.length) {
                double sc;
                dmat[j][k] = sc = TALEAligner.align(tales[j], tales[k], costs, at, extraGapOpening, extraGapExtension).getCost();
                ++k;
            }
            ++j;
        }
        return dmat;
    }

    private static double[][] computeDistMatrix2(TALE[] tales, Costs costs, Alignment.AlignmentType at, double extraGapOpening, double extraGapExtension) {
        double[][] dmat = new double[tales.length][tales.length];
        int j = 0;
        while (j < tales.length) {
            int k = j;
            while (k < tales.length) {
                double sc;
                dmat[j][k] = sc = TALEAligner.align(tales[j], tales[k], costs, at, extraGapOpening, extraGapExtension).getCost();
                dmat[k][j] = sc;
                ++k;
            }
            ++j;
        }
        return dmat;
    }

    private double[][] computeDistMatrix3(TALE[] tales, int firstNew, Costs costs, Alignment.AlignmentType at, double extraGapOpening, double extraGapExtension) {
        double[][] dmat = new double[tales.length][tales.length];
        int j = 0;
        while (j < tales.length) {
            int k = 0;
            while (k < tales.length) {
                double sc;
                dmat[j][k] = j < firstNew && k < firstNew ? this.dmat[j][k] : (sc = TALEAligner.align(tales[j], tales[k], costs, at, extraGapOpening, extraGapExtension).getCost());
                ++k;
            }
            ++j;
        }
        return dmat;
    }

    private static Pair<double[][], ClusterTree<TALE>> cluster(TALE[] tales, Hclust.Linkage linkage, Costs costs, Alignment.AlignmentType at, double extraGapOpening, double extraGapExtension) {
        Hclust<TALE> hclust = new Hclust<TALE>(null, linkage);
        double[][] dmat = TALEFamilyBuilder.computeDistMatrix(tales, costs, at, extraGapOpening, extraGapExtension);
        ClusterTree<TALE> tree = hclust.cluster(dmat, tales);
        return new Pair<double[][], ClusterTree<TALE>>(dmat, tree);
    }

    public void splitClass(String className) {
        LinkedList<TALEFamily> famList = new LinkedList<TALEFamily>();
        String[] allFamIDs = ClassAssignmentTool.SchemaFamilyIdGenerator.getFamIDs();
        LinkedList<String> free = new LinkedList<String>();
        int i = 0;
        while (i < allFamIDs.length) {
            boolean found = false;
            int j = 0;
            while (j < this.families.length) {
                if (allFamIDs[i].equals(this.families[j].getFamilyId())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                free.add(allFamIDs[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.families.length) {
            if (className.equals(this.families[i].getFamilyId())) {
                double dist = this.families[i].getTree().getDistance();
                ClusterTree<TALE>[] trees = Hclust.cutTree(dist - 1.0E-6, this.families[i].getTree());
                trees[0].leafOrder(this.dmat);
                this.families[i] = new TALEFamily(this.families[i].getFamilyId(), trees[0], this);
                TALEFamilyBuilder.renameTALEs(trees[0], this.families[i].getFamilyId());
                famList.add(this.families[i]);
                int j = 1;
                while (j < trees.length) {
                    trees[j].leafOrder(this.dmat);
                    String newName = (String)free.removeFirst();
                    TALEFamilyBuilder.renameTALEs(trees[j], newName);
                    famList.add(new TALEFamily(newName, trees[j], this));
                    ++j;
                }
            } else {
                famList.add(this.families[i]);
            }
            ++i;
        }
        this.families = famList.toArray(new TALEFamily[0]);
        LinkedList<TALE> allTALEs = new LinkedList<TALE>();
        for (TALEFamily fam : famList) {
            TALE[] tales = fam.getFamilyMembers();
            int i2 = 0;
            while (i2 < tales.length) {
                allTALEs.add(tales[i2]);
                ++i2;
            }
        }
        this.dmat = TALEFamilyBuilder.computeDistMatrix(allTALEs.toArray(new TALE[0]), this.costs, this.at, this.extraGapOpening, this.extraGapExtension);
    }

    private static void renameTALEs(ClusterTree<TALE> clusterTree, String newName) {
        TALE[] tales = clusterTree.getClusterElements();
        Object[] els = new ComparableElement[tales.length];
        int i = 0;
        while (i < tales.length) {
            String id = tales[i].getId();
            id = id.replaceAll(" .*", "");
            id = id.replaceAll("^Tal[A-Z]{2}", "");
            int num = Integer.parseInt(id);
            els[i] = new ComparableElement<TALE, Integer>(tales[i], num);
            ++i;
        }
        Arrays.sort(els);
        i = 1;
        while (i <= els.length) {
            TALE curr = (TALE)((ComparableElement)els[i - 1]).getElement();
            curr.setId(curr.getId().replaceAll("^Tal[A-Z]{2}[0-9]+", String.valueOf(newName) + i));
            ++i;
        }
    }

    public void removeTALEsFromFamilies(LinkedList<TALE> toRemove) {
        LinkedList<ClusterTree<TALE>> remainingTALEs = new LinkedList<ClusterTree<TALE>>();
        LinkedList[] lists = new LinkedList[this.families.length];
        int minIndex = 0;
        int[] indexMap = new int[this.getNumberOfTales()];
        int i = 0;
        while (i < this.families.length) {
            int index;
            ClusterTree<TALE>[] leaves = this.families[i].getTree().getLeaves();
            int j = 0;
            while (j < leaves.length) {
                int idx;
                TALE temp = leaves[j].getClusterElements()[0];
                if (!toRemove.contains(temp)) {
                    remainingTALEs.add(leaves[j]);
                    indexMap[idx] = idx = leaves[j].getOriginalIndex();
                } else {
                    if (lists[i] == null) {
                        lists[i] = new LinkedList();
                    }
                    idx = leaves[j].getOriginalIndex();
                    indexMap[idx] = -1;
                    lists[i].add(leaves[j]);
                }
                ++j;
            }
            if (this.families[i].getFamilySize() == 0) {
                this.families[i] = null;
            }
            if ((index = this.families[i].getTree().getMinimumOriginalIndex()) < minIndex) {
                minIndex = index;
            }
            ++i;
        }
        i = 0;
        int j = 0;
        while (j < indexMap.length) {
            if (indexMap[j] > -1) {
                indexMap[j] = i++;
            }
            ++j;
        }
        TALE[] remain = new TALE[remainingTALEs.size()];
        int i2 = 0;
        while (i2 < remainingTALEs.size()) {
            ClusterTree rem = (ClusterTree)remainingTALEs.get(i2);
            int idx = rem.getOriginalIndex();
            rem.setOriginalIndex(indexMap[idx]);
            remain[indexMap[idx]] = ((TALE[])rem.getClusterElements())[0];
            ++i2;
        }
        double[][] newDmat = TALEFamilyBuilder.computeDistMatrix(remain, this.costs, this.at, this.extraGapOpening, this.extraGapExtension);
        LinkedList<TALEFamily> famList = new LinkedList<TALEFamily>();
        int i3 = 0;
        while (i3 < lists.length) {
            if (lists[i3] != null) {
                TALEFamily temp = this.families[i3].removeTALE(newDmat, lists[i3], -minIndex, this);
                if (temp != null) {
                    famList.add(temp);
                }
            } else {
                famList.add(this.families[i3]);
            }
            ++i3;
        }
        this.families = famList.toArray(new TALEFamily[0]);
        this.dmat = newDmat;
    }

    private int getNumberOfTales() {
        int num = 0;
        int i = 0;
        while (i < this.families.length) {
            num += this.families[i].getFamilySize();
            ++i;
        }
        return num;
    }

    public void addTALEsToFamilies(Pair<Integer, LinkedList<TALE>>[] assignment, TALE[] unassigned, FamilyIdGenerator idGenerator) {
        int j;
        if (idGenerator == null) {
            idGenerator = new DefaultFamilyIdGenerator();
        }
        int numNew = unassigned.length;
        int i = 0;
        while (i < assignment.length) {
            numNew += assignment[i].getSecondElement().size();
            ++i;
        }
        TALE[] allTALEs = new TALE[this.dmat.length + numNew];
        int minIndex = 0;
        int maxIndex = 0;
        int i2 = 0;
        while (i2 < this.families.length) {
            ClusterTree<TALE> famTree = this.families[i2].getTree();
            ClusterTree<TALE>[] leaves = famTree.getLeaves();
            j = 0;
            while (j < leaves.length) {
                int idx = leaves[j].getOriginalIndex();
                allTALEs[idx] = leaves[j].getClusterElements()[0];
                if (idx > maxIndex) {
                    maxIndex = idx;
                }
                ++j;
            }
            int index = famTree.getMinimumOriginalIndex();
            if (index < minIndex) {
                minIndex = index;
            }
            ++i2;
        }
        if (maxIndex + 1 != this.dmat.length) {
            throw new RuntimeException("Indexes do not match " + (maxIndex + 1) + " <-> " + this.dmat.length);
        }
        int k = maxIndex + 1;
        int i3 = 0;
        while (i3 < assignment.length) {
            LinkedList<TALE> nt = assignment[i3].getSecondElement();
            j = 0;
            while (j < nt.size()) {
                allTALEs[k] = nt.get(j);
                ++j;
                ++k;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < unassigned.length) {
            allTALEs[k] = unassigned[i3];
            ++i3;
            ++k;
        }
        double[][] newDmat = this.computeDistMatrix3(allTALEs, maxIndex + 1, this.costs, this.at, this.extraGapOpening, this.extraGapExtension);
        TALEFamily[] newFams = new TALEFamily[this.families.length];
        System.arraycopy(this.families, 0, newFams, 0, this.families.length);
        k = maxIndex + 1;
        int i4 = 0;
        while (i4 < assignment.length) {
            Integer famIdx = assignment[i4].getFirstElement();
            LinkedList<TALE> newTALEs = assignment[i4].getSecondElement();
            int j2 = 0;
            while (j2 < newTALEs.size()) {
                newFams[famIdx.intValue()] = newFams[famIdx].addTALE(newDmat, newTALEs.get(j2), k, -minIndex, this);
                int newMinIdx = newFams[famIdx].tree.getMinimumOriginalIndex();
                if (newMinIdx < minIndex) {
                    minIndex = newMinIdx;
                }
                ++j2;
                ++k;
            }
            ++i4;
        }
        ClusterTree[] createdTrees = null;
        if (unassigned.length > 0) {
            ClusterTree[] newLeaves = new ClusterTree[unassigned.length];
            int i5 = 0;
            while (i5 < unassigned.length) {
                newLeaves[i5] = new ClusterTree<TALE>(unassigned[i5], k);
                ++i5;
                ++k;
            }
            Hclust hclust = new Hclust(null, this.linkage);
            ClusterTree newTree = hclust.cluster(-minIndex, newDmat, newLeaves);
            createdTrees = Hclust.cutTree(this.cut, newTree);
            LinkedList<ClusterTree> temp = new LinkedList<ClusterTree>();
            int i6 = 0;
            while (i6 < createdTrees.length) {
                double d = createdTrees[i6].getMaximumDistance();
                TALE[] members = (TALE[])createdTrees[i6].getClusterElements();
                int l = TALEFamilyBuilder.getMaximumTALELength(createdTrees[i6]);
                if (d / (double)l >= RELATIVE_MISMATCH_SHORT) {
                    ClusterTree<T>[] subs = Hclust.cutTree(RELATIVE_MISMATCH_SHORT * (double)l, createdTrees[i6]);
                    int j3 = 0;
                    while (j3 < subs.length) {
                        temp.add(subs[j3]);
                        ++j3;
                    }
                } else {
                    temp.add(createdTrees[i6]);
                }
                ++i6;
            }
            createdTrees = temp.toArray(new ClusterTree[0]);
        } else {
            createdTrees = new ClusterTree[]{};
        }
        TALEFamily[] allFams = new TALEFamily[newFams.length + createdTrees.length];
        System.arraycopy(newFams, 0, allFams, 0, newFams.length);
        int i7 = 0;
        while (i7 < createdTrees.length) {
            createdTrees[i7].leafOrder(newDmat);
            allFams[i7 + newFams.length] = new TALEFamily(null, createdTrees[i7], this);
            ++i7;
        }
        idGenerator.setFamilyIDs(allFams, this);
        this.dmat = newDmat;
        this.families = allFams;
    }

    public Pair<Integer, Double> getClosestFamilyIndex(TALE tale, FamilyDistance dist, boolean filterByLength) {
        int closest = -1;
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.families.length) {
            double[] d = this.families[i].getDistance(tale, dist, this);
            if (!(filterByLength && d[1] >= RELATIVE_MISMATCH_SHORT || !(d[0] < min))) {
                min = d[0];
                closest = i;
            }
            ++i;
        }
        return new Pair<Integer, Double>(closest, min);
    }

    public Pair<TALEFamily, Double> getMostSignificantFamily(TALE tale, AlignmentPValues pv, FamilyDistance dist) {
        Pair<Integer, Double> pair = this.getMostSignificantFamilyIndex(tale, pv, dist);
        return new Pair<TALEFamily, Double>(this.getFamily(pair.getFirstElement()), pair.getSecondElement());
    }

    public Pair<Integer, Double> getMostSignificantFamilyIndex(TALE tale, AlignmentPValues pv, FamilyDistance dist) {
        int closest = -1;
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.families.length) {
            double d = this.families[i].getSignificance(tale, pv, dist, this);
            if (d < min) {
                min = d;
                closest = i;
            }
            ++i;
        }
        return new Pair<Integer, Double>(closest, min);
    }

    public TALEFamily getFamily(int index) {
        return this.families[index];
    }

    public TALEFamily[] getFamilies() {
        return this.families;
    }

    public String[] getReservedNames() {
        return this.reservedNames;
    }

    public void setReservedNames(String[] reservedNames) {
        this.reservedNames = reservedNames;
    }

    public Costs getCosts() {
        return this.costs;
    }

    public double getPVal() {
        return this.pval;
    }

    private class DefaultFamilyIdGenerator
    implements FamilyIdGenerator {
        private DefaultFamilyIdGenerator() {
        }

        @Override
        public void setFamilyIDs(TALEFamily[] families, TALEFamilyBuilder builder) {
            int max = 0;
            int i = 0;
            while (i < families.length) {
                int l;
                String id;
                if (families[i].getFamilyId() != null && (id = families[i].getFamilyId()).matches("^[0-9]+$") && (l = Integer.parseInt(id)) > max) {
                    max = l;
                }
                ++i;
            }
            i = 0;
            while (i < families.length) {
                if (families[i].getFamilyId() == null) {
                    families[i].setFamilyId(String.valueOf(++max));
                }
                ++i;
            }
        }
    }

    static enum FamilyDistance {
        MIN,
        MAX,
        MEAN;

    }

    public static interface FamilyIdGenerator {
        public void setFamilyIDs(TALEFamily[] var1, TALEFamilyBuilder var2);
    }

    public static class TALEFamily
    implements PlotGeneratorResult.PlotGenerator,
    Comparable<TALEFamily> {
        private String id;
        private StringAlignment[][] alignments;
        private ClusterTree<TALE> tree;

        private TALEFamily(String familyId, ClusterTree<TALE> tree, TALEFamilyBuilder builder) {
            this.tree = tree;
            this.id = familyId;
            TALE[] members = tree.getClusterElements();
            this.alignments = new StringAlignment[members.length][members.length];
            int j = 0;
            while (j < members.length) {
                int k = 0;
                while (k < members.length) {
                    if (j != k) {
                        StringAlignment sa;
                        this.alignments[j][k] = sa = TALEAligner.align(members[j], members[k], builder.costs, builder.at, builder.extraGapOpening, builder.extraGapExtension);
                    }
                    ++k;
                }
                ++j;
            }
        }

        public TALEFamily(StringBuffer xml) throws NonParsableException {
            xml = XMLParser.extractForTag(xml, "TALEClass");
            this.alignments = (StringAlignment[][])XMLParser.extractObjectForTags(xml, "alignments");
            this.id = (String)XMLParser.extractObjectForTags(xml, "id");
            this.tree = (ClusterTree)XMLParser.extractObjectForTags(xml, "tree");
        }

        @Override
        public int compareTo(TALEFamily tf2) {
            return this.id.compareTo(tf2.getFamilyId());
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer xml = new StringBuffer();
            XMLParser.appendObjectWithTags(xml, this.alignments, "alignments");
            XMLParser.appendObjectWithTags(xml, this.id, "id");
            XMLParser.appendObjectWithTags(xml, this.tree, "tree");
            XMLParser.addTags(xml, "TALEClass");
            return xml;
        }

        public String getSpecificityConsensus(TALgetterDiffSM model) throws IllegalArgumentException, WrongAlphabetException {
            double[][] spec = this.getSpecificityProfile(model);
            DNAAlphabetContainer dna = DNAAlphabetContainer.SINGLETON;
            StringBuffer sb = new StringBuffer();
            sb.append(dna.getSymbol(0, ToolBox.getMaxIndex(spec[0])));
            int i = 1;
            while (i < spec.length) {
                sb.append(dna.getSymbol(0, ToolBox.getMaxIndex(spec[i])));
                if (i < spec.length - 1) {
                    sb.append("  ");
                }
                ++i;
            }
            return sb.toString();
        }

        public double[][] getSpecificityProfile(TALgetterDiffSM model) throws IllegalArgumentException, WrongAlphabetException {
            Pair<TALE[], String[]> al = this.getInducedMultipleAlignment();
            DiscreteAlphabet modelCon = (DiscreteAlphabet)model.getRVDAlphabet().getAlphabetAt(0);
            String[] als = al.getSecondElement();
            double[][] specs = null;
            int i = 0;
            while (i < als.length) {
                String[] parts = als[i].trim().split(" ");
                if (specs == null) {
                    specs = new double[parts.length + 1][4];
                }
                double[][] temp = new double[parts.length + 1][4];
                int j = 0;
                while (j < parts.length) {
                    if (parts[j].equals("--") || !modelCon.isSymbol(parts[j])) {
                        temp[j + 1] = new double[4];
                        Arrays.fill(temp[j + 1], 0.25);
                    } else {
                        Sequence seq = Sequence.create(model.getRVDAlphabet(), parts[j]);
                        Pair<double[][], double[]> pair = model.getSpecificitiesAndImportances(seq);
                        temp[j + 1] = pair.getFirstElement()[1];
                        int k = 0;
                        while (k < temp[j + 1].length) {
                            temp[j + 1][k] = temp[j + 1][k] * pair.getSecondElement()[0] + 0.25 * (1.0 - pair.getSecondElement()[0]);
                            ++k;
                        }
                        if (j == 0 || parts[j - 1].equals("--")) {
                            temp[j] = pair.getFirstElement()[0];
                        }
                    }
                    ++j;
                }
                j = 0;
                while (j < temp.length) {
                    int k = 0;
                    while (k < temp[j].length) {
                        double[] dArray = specs[j];
                        int n = k;
                        dArray[n] = dArray[n] + temp[j][k] / (double)als.length;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            return specs;
        }

        public String getFamilyId() {
            return this.id;
        }

        public void setFamilyId(String newId) {
            this.id = newId;
        }

        public StringAlignment getAlignmentForIDs(String id1, String id2) {
            TALE[] members = this.getFamilyMembers();
            int i = 0;
            while (i < members.length) {
                if (id1.equals(members[i].getId())) {
                    int j = 0;
                    while (j < members.length) {
                        if (id2.equals(members[j].getId())) {
                            return this.alignments[i][j];
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return null;
        }

        private FamilyDistance getDist(TALEFamilyBuilder builder) {
            FamilyDistance dist = null;
            if (builder.linkage == Hclust.Linkage.SINGLE) {
                dist = FamilyDistance.MIN;
            } else if (builder.linkage == Hclust.Linkage.COMPLETE) {
                dist = FamilyDistance.MAX;
            } else if (builder.linkage == Hclust.Linkage.AVERAGE) {
                dist = FamilyDistance.MEAN;
            }
            return dist;
        }

        public double[] getDistance(TALE tale, FamilyDistance dist, TALEFamilyBuilder builder) {
            if (dist == null) {
                dist = this.getDist(builder);
            }
            TALE[] members = this.getFamilyMembers();
            double[] ds = new double[members.length];
            int i = 0;
            while (i < members.length) {
                ds[i] = TALEAligner.align(tale, members[i], builder.costs, builder.at, builder.extraGapOpening, builder.extraGapExtension).getCost();
                ++i;
            }
            int idx = ToolBox.getMinIndex(ds);
            double minD = ds[idx] / (double)Math.min(tale.getNumberOfRepeats(), members[idx].getNumberOfRepeats());
            if (dist == FamilyDistance.MAX) {
                return new double[]{ToolBox.max(ds), minD};
            }
            if (dist == FamilyDistance.MIN) {
                return new double[]{ToolBox.min(ds), minD};
            }
            if (dist == FamilyDistance.MEAN) {
                return new double[]{ToolBox.mean(0, ds.length, ds), minD};
            }
            return new double[]{Double.NaN, Double.NaN};
        }

        public double getSignificance(TALE tale, AlignmentPValues pv, FamilyDistance dist, TALEFamilyBuilder builder) {
            Costs c2;
            if (dist == null) {
                dist = this.getDist(builder);
            }
            if (pv == null && builder.costs instanceof AffineCosts && (c2 = ((AffineCosts)builder.costs).getInternalCosts()) instanceof RVDCosts) {
                RVDCosts c3 = (RVDCosts)c2;
                pv = new AlignmentPValues(builder.getAllTALEs(), c3);
            }
            TALE[] members = this.getFamilyMembers();
            double[] ds = new double[members.length];
            int i = 0;
            while (i < members.length) {
                double temp = TALEAligner.align(tale, members[i], builder.costs, builder.at, builder.extraGapOpening, builder.extraGapExtension).getCost();
                ds[i] = pv.getLog10PValue(tale, members[i], temp, builder.extraGapOpening, builder.extraGapExtension);
                ++i;
            }
            if (dist == FamilyDistance.MAX) {
                return ToolBox.max(ds);
            }
            if (dist == FamilyDistance.MIN) {
                return ToolBox.min(ds);
            }
            if (dist == FamilyDistance.MEAN) {
                double di = 0.0;
                int i2 = 0;
                while (i2 < ds.length) {
                    di += Math.log1p(-Math.exp(ds[i2] * Math.log(10.0)));
                    ++i2;
                }
                return Math.log1p(-Math.exp(di)) / Math.log(10.0);
            }
            return Double.NaN;
        }

        public double getFamilySignificance(AlignmentPValues pv, TALEFamilyBuilder builder) {
            Costs c2;
            if (pv == null && builder.costs instanceof AffineCosts && (c2 = ((AffineCosts)builder.costs).getInternalCosts()) instanceof RVDCosts) {
                RVDCosts c3 = (RVDCosts)c2;
                pv = new AlignmentPValues(builder.getAllTALEs(), c3);
            }
            if (pv == null) {
                return Double.NaN;
            }
            double famsig = 0.0;
            TALE[] members = this.getFamilyMembers();
            int i = 1;
            while (i < this.alignments.length) {
                int j = 0;
                while (j < i) {
                    double p = pv.getLog10PValue(members[i], members[j], this.alignments[i][j].getCost(), builder.extraGapOpening, builder.extraGapExtension);
                    p = Math.log1p(-Math.exp(p * Math.log(10.0)));
                    famsig += p;
                    ++j;
                }
                ++i;
            }
            return Math.log1p(-Math.exp(famsig)) / Math.log(10.0);
        }

        public TALE[] getFamilyMembers() {
            return this.tree.getClusterElements();
        }

        public int getFamilySize() {
            return this.tree.getNumberOfElements();
        }

        public int getLengthOfLongestFamilyMember() {
            TALE[] tales;
            int max = 0;
            TALE[] tALEArray = tales = this.getFamilyMembers();
            int n = tales.length;
            int n2 = 0;
            while (n2 < n) {
                TALE tale = tALEArray[n2];
                int l = tale.getNumberOfRepeats();
                if (l > max) {
                    max = l;
                }
                ++n2;
            }
            return max;
        }

        public String toString(TALgetterDiffSM model, TALEFamilyBuilder builder) {
            Costs c2;
            StringBuffer sb = new StringBuffer();
            sb.append("Class " + this.id + " for (" + builder.costs.getClass().getSimpleName() + ", " + builder.cut + ", " + (Object)((Object)builder.at) + ")\n");
            sb.append("distance: " + format.format(this.tree.getDistance()) + "\n");
            if (builder.costs instanceof AffineCosts && (c2 = ((AffineCosts)builder.costs).getInternalCosts()) instanceof RVDCosts) {
                RVDCosts c3 = (RVDCosts)c2;
                double p = this.getFamilySignificance(new AlignmentPValues(builder.getAllTALEs(), c3), builder);
                sb.append("significance: p=" + formatE.format(Math.pow(10.0, p)) + "\n");
            }
            sb.append("\n" + this.inducedMultipleAlignmentToString() + "\n");
            if (model != null) {
                try {
                    String cons = this.getSpecificityConsensus(model);
                    sb.append("Most likely common binding sequence:\n");
                    sb.append(cons);
                    sb.append("\n");
                }
                catch (WrongAlphabetException cons) {
                    // empty catch block
                }
            }
            sb.append("\n\nClass tree:\n");
            sb.append(String.valueOf(this.tree.toNewick()) + "\n\n");
            sb.append("Alignment scores:\n");
            TALE[] members = this.tree.getClusterElements();
            int i = 1;
            while (i < members.length) {
                int j = 0;
                while (j < i) {
                    sb.append(String.valueOf(members[i].getId()) + " vs. " + members[j].getId() + ": " + format.format(this.alignments[i][j].getCost()) + "\n");
                    ++j;
                }
                ++i;
            }
            return sb.toString();
        }

        public ClusterTree<TALE> getTree() {
            return this.tree;
        }

        @Override
        public void generatePlot(GraphicsAdaptor adaptor) throws IOException {
            Graphics2D dummy = adaptor.getGraphics(10, 10);
            TALEFamilyTreePlotter plotter = new TALEFamilyTreePlotter(30);
            int[] dim = plotter.getDimension(dummy, this);
            Graphics2D graphics = adaptor.getGraphics(dim[0], dim[1]);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dim[0], dim[1]);
            graphics.setColor(Color.black);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            plotter.plot(graphics, this);
        }

        public void plotFamilyToFile(String nameBase, GraphicsAdaptor adaptor) throws IOException {
            this.generatePlot(adaptor);
            adaptor.generateOutput(String.valueOf(nameBase) + "." + adaptor.getGraphicsExtension());
        }

        private TALEFamily removeTALE(double[][] dmat, LinkedList<ClusterTree<TALE>> tales, int indexOff, TALEFamilyBuilder builder) {
            ClusterTree<TALE>[] leaves = this.tree.getLeaves();
            LinkedList list = new LinkedList();
            Collections.addAll(list, leaves);
            System.out.println("before " + list);
            System.out.println("to remove " + tales);
            list.removeAll(tales);
            System.out.println("after " + list);
            if (list.size() == 0) {
                return null;
            }
            Hclust hclust = new Hclust(null, builder.linkage);
            ClusterTree<TALE> newTree = hclust.cluster(indexOff, dmat, list.toArray(new ClusterTree[0]));
            newTree.leafOrder(dmat);
            TALEFamilyBuilder.renameTALEs(newTree, this.getFamilyId());
            TALEFamily fam = new TALEFamily(this.getFamilyId(), newTree, builder);
            return fam;
        }

        private TALEFamily addTALE(double[][] dmat, TALE tale, int newIndex, int indexOff, TALEFamilyBuilder builder) {
            ClusterTree<TALE>[] leaves = this.tree.getLeaves();
            LinkedList<ClusterTree<TALE>> list = new LinkedList<ClusterTree<TALE>>();
            Collections.addAll(list, leaves);
            list.add(new ClusterTree<TALE>(tale, newIndex));
            Hclust hclust = new Hclust(null, builder.linkage);
            ClusterTree<TALE> newTree = hclust.cluster(indexOff, dmat, list.toArray(new ClusterTree[0]));
            newTree.leafOrder(dmat);
            TALEFamily fam = new TALEFamily(this.getFamilyId(), newTree, builder);
            return fam;
        }

        public String inducedMultipleAlignmentToString() {
            StringBuffer sb = new StringBuffer();
            Pair<TALE[], String[]> al = this.getInducedMultipleAlignment();
            String[] als = al.getSecondElement();
            TALE[] tales = al.getFirstElement();
            int i = 0;
            while (i < als.length) {
                sb.append(String.valueOf(als[i]) + "\t" + tales[i].getId() + "\n");
                ++i;
            }
            return sb.toString();
        }

        public Pair<TALE[], String[]> getInducedMultipleAlignment() {
            return this.getInducedMultipleAlignment(this.getTree(), this);
        }

        private Pair<TALE[], String[]> getInducedMultipleAlignment2(ClusterTree<TALE> tree, TALEFamily family) {
            int k;
            int j;
            int j2;
            TALE[] members = tree.getClusterElements();
            if (members.length == 1) {
                Sequence rvds = members[0].getRvdSequence();
                return new Pair<TALE[], String[]>(new TALE[]{members[0]}, new String[]{" " + rvds.toString()});
            }
            if (members.length == 2) {
                StringAlignment al = family.getAlignmentForIDs(members[0].getId(), members[1].getId());
                return new Pair<TALE[], String[]>(new TALE[]{members[0], members[1]}, new String[]{al.getAlignedString(0), al.getAlignedString(1)});
            }
            ClusterTree<TALE>[] subs = tree.getSubTrees();
            TALE top = subs[0].getClusterElements()[subs[0].getNumberOfElements() - 1];
            TALE bot = subs[1].getClusterElements()[0];
            Pair<TALE[], String[]> topPair = this.getInducedMultipleAlignment(subs[0], family);
            Pair<TALE[], String[]> botPair = this.getInducedMultipleAlignment(subs[1], family);
            String[] topTemp = topPair.getSecondElement();
            StringBuffer[] topAls = new StringBuffer[topTemp.length];
            int i = 0;
            while (i < topAls.length) {
                topAls[i] = new StringBuffer(topTemp[i].replaceAll(" ", ""));
                ++i;
            }
            String[] botTemp = botPair.getSecondElement();
            StringBuffer[] botAls = new StringBuffer[botTemp.length];
            int i2 = 0;
            while (i2 < botAls.length) {
                botAls[i2] = new StringBuffer(botTemp[i2].replaceAll(" ", ""));
                ++i2;
            }
            StringAlignment al = family.getAlignmentForIDs(top.getId(), bot.getId());
            String al2 = al.getAlignedString(0).replaceAll(" ", "");
            String al3 = al.getAlignedString(1).replaceAll(" ", "");
            int frontTopNew = 0;
            while (al2.charAt(frontTopNew) == '-') {
                ++frontTopNew;
            }
            int frontTopOld = 0;
            while (topAls[topAls.length - 1].charAt(frontTopOld) == '-') {
                ++frontTopOld;
            }
            int frontBotNew = 0;
            while (al3.charAt(frontBotNew) == '-') {
                ++frontBotNew;
            }
            int frontBotOld = 0;
            while (botAls[0].charAt(frontBotOld) == '-') {
                ++frontBotOld;
            }
            int frontTop = Math.max(frontTopNew, frontTopOld);
            int frontBot = Math.max(frontBotNew, frontBotOld);
            int i3 = frontTopOld;
            while (i3 < frontTop) {
                j2 = 0;
                while (j2 < topAls.length) {
                    topAls[j2].insert(0, "-");
                    ++j2;
                }
                ++i3;
            }
            i3 = frontBotOld;
            while (i3 < frontBot) {
                j2 = 0;
                while (j2 < botAls.length) {
                    botAls[j2].insert(0, "-");
                    ++j2;
                }
                ++i3;
            }
            int maxLen = 0;
            int i4 = 0;
            while (i4 < topAls.length) {
                if (topAls[i4].length() > maxLen) {
                    maxLen = topAls[i4].length();
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < botAls.length) {
                if (botAls[i4].length() > maxLen) {
                    maxLen = botAls[i4].length();
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < topAls.length) {
                j = topAls[i4].length();
                while (j < maxLen) {
                    topAls[i4].append("-");
                    ++j;
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < botAls.length) {
                j = botAls[i4].length();
                while (j < maxLen) {
                    botAls[i4].append("-");
                    ++j;
                }
                ++i4;
            }
            LinkedList resTales = new LinkedList();
            LinkedList<String> resAls = new LinkedList<String>();
            Collections.addAll(resTales, topPair.getFirstElement());
            Collections.addAll(resTales, botPair.getFirstElement());
            int i5 = 0;
            while (i5 < topAls.length) {
                k = topAls[i5].length() - 2;
                while (k >= 0) {
                    topAls[i5].insert(k, " ");
                    k -= 2;
                }
                resAls.add(topAls[i5].toString());
                ++i5;
            }
            i5 = 0;
            while (i5 < botAls.length) {
                k = botAls[i5].length() - 2;
                while (k >= 0) {
                    botAls[i5].insert(k, " ");
                    k -= 2;
                }
                resAls.add(botAls[i5].toString());
                ++i5;
            }
            return new Pair<TALE[], String[]>(resTales.toArray(new TALE[0]), resAls.toArray(new String[0]));
        }

        private Pair<TALE[], String[]> getInducedMultipleAlignment(ClusterTree<TALE> tree, TALEFamily family) {
            TALE[] members = tree.getClusterElements();
            if (members.length == 1) {
                Sequence rvds = members[0].getRvdSequence();
                return new Pair<TALE[], String[]>(new TALE[]{members[0]}, new String[]{" " + rvds.toString()});
            }
            if (members.length == 2) {
                StringAlignment al = family.getAlignmentForIDs(members[0].getId(), members[1].getId());
                return new Pair<TALE[], String[]>(new TALE[]{members[0], members[1]}, new String[]{al.getAlignedString(0), al.getAlignedString(1)});
            }
            ClusterTree<TALE>[] subs = tree.getSubTrees();
            TALE[][] tales = new TALE[subs.length][];
            StringBuffer[][] als = new StringBuffer[subs.length][];
            int i = 0;
            while (i < subs.length) {
                Pair<TALE[], String[]> pair = this.getInducedMultipleAlignment(subs[i], family);
                tales[i] = pair.getFirstElement();
                String[] temp = pair.getSecondElement();
                als[i] = new StringBuffer[temp.length];
                int j = 0;
                while (j < als[i].length) {
                    als[i][j] = new StringBuffer(temp[j].replaceAll(" ", ""));
                    ++j;
                }
                ++i;
            }
            TALE prev = tales[0][tales[0].length - 1];
            String prevAl = als[0][als[0].length - 1].toString();
            int i2 = 1;
            while (i2 < subs.length) {
                int n;
                int l;
                int k;
                TALE curr = tales[i2][0];
                String currAl = als[i2][0].toString();
                StringAlignment al = family.getAlignmentForIDs(prev.getId(), curr.getId());
                String al2 = al.getAlignedString(0).replaceAll(" ", "");
                String al3 = al.getAlignedString(1).replaceAll(" ", "");
                int idx1 = prevAl.length() - 1;
                int idx2 = al2.length() - 1;
                int[] addPrev = new int[prevAl.length() + 1];
                int[] addCurr = new int[al2.length() + 1];
                while (idx1 >= 0 || idx2 >= 0) {
                    if (idx1 >= 0 && idx2 >= 0 && prevAl.charAt(idx1) == al2.charAt(idx2)) {
                        --idx1;
                        --idx2;
                        continue;
                    }
                    if (idx1 >= 0 && prevAl.charAt(idx1) == '-') {
                        int n2 = idx2 + 1;
                        addCurr[n2] = addCurr[n2] + 1;
                        --idx1;
                        continue;
                    }
                    if (idx2 < 0 || al2.charAt(idx2) != '-') continue;
                    int n3 = idx1 + 1;
                    addPrev[n3] = addPrev[n3] + 1;
                    --idx2;
                }
                int j = 0;
                while (j < i2) {
                    k = 0;
                    while (k < als[j].length) {
                        l = addPrev.length - 1;
                        while (l >= 0) {
                            n = 0;
                            while (n < addPrev[l]) {
                                als[j][k].insert(l, '-');
                                ++n;
                            }
                            --l;
                        }
                        ++k;
                    }
                    ++j;
                }
                StringBuffer temp = new StringBuffer(al3);
                int l2 = addCurr.length - 1;
                while (l2 >= 0) {
                    int n4 = 0;
                    while (n4 < addCurr[l2]) {
                        temp.insert(l2, '-');
                        ++n4;
                    }
                    --l2;
                }
                al3 = temp.toString();
                idx1 = currAl.length() - 1;
                idx2 = al3.length() - 1;
                addCurr = new int[currAl.length() + 1];
                addPrev = new int[al3.length() + 1];
                while (idx1 >= 0 || idx2 >= 0) {
                    if (idx1 >= 0 && idx2 >= 0 && currAl.charAt(idx1) == al3.charAt(idx2)) {
                        --idx1;
                        --idx2;
                        continue;
                    }
                    if (idx1 >= 0 && currAl.charAt(idx1) == '-') {
                        int n5 = idx2 + 1;
                        addPrev[n5] = addPrev[n5] + 1;
                        --idx1;
                        continue;
                    }
                    if (idx2 < 0 || al3.charAt(idx2) != '-') continue;
                    int n6 = idx1 + 1;
                    addCurr[n6] = addCurr[n6] + 1;
                    --idx2;
                }
                int j2 = 0;
                while (j2 < i2) {
                    int k2 = 0;
                    while (k2 < als[j2].length) {
                        int l3 = addPrev.length - 1;
                        while (l3 >= 0) {
                            int n7 = 0;
                            while (n7 < addPrev[l3]) {
                                als[j2][k2].insert(l3, '-');
                                ++n7;
                            }
                            --l3;
                        }
                        ++k2;
                    }
                    ++j2;
                }
                k = 0;
                while (k < als[i2].length) {
                    l = addCurr.length - 1;
                    while (l >= 0) {
                        n = 0;
                        while (n < addCurr[l]) {
                            als[i2][k].insert(l, '-');
                            ++n;
                        }
                        --l;
                    }
                    ++k;
                }
                prev = tales[i2][tales[i2].length - 1];
                prevAl = als[i2][als[i2].length - 1].toString();
                ++i2;
            }
            LinkedList<StringBuffer> tempAls = new LinkedList<StringBuffer>();
            int i3 = 0;
            while (i3 < tales.length) {
                int j = 0;
                while (j < tales[i3].length) {
                    tempAls.add(als[i3][j]);
                    ++j;
                }
                ++i3;
            }
            boolean[][] onlyGaps = new boolean[tempAls.size()][((StringBuffer)tempAls.get(0)).length()];
            boolean[][] onlyGapsEnd = new boolean[tempAls.size()][((StringBuffer)tempAls.get(0)).length()];
            int i4 = 0;
            while (i4 < onlyGaps.length) {
                int j = 0;
                while (((StringBuffer)tempAls.get(i4)).charAt(j) == '-') {
                    onlyGaps[i4][j] = true;
                    ++j;
                }
                j = ((StringBuffer)tempAls.get(i4)).length() - 1;
                while (((StringBuffer)tempAls.get(i4)).charAt(j) == '-') {
                    onlyGapsEnd[i4][j] = true;
                    --j;
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < onlyGaps[0].length) {
                int j = 0;
                while (j < tempAls.size() && ((StringBuffer)tempAls.get(j)).charAt(i4) == '-' && !onlyGaps[j][i4]) {
                    ++j;
                }
                if (j > 0 && j < tempAls.size() && ((StringBuffer)tempAls.get(j)).charAt(i4) == '-') {
                    int k = 0;
                    while (k < j) {
                        ((StringBuffer)tempAls.get(k)).delete(i4, i4 + 1);
                        ((StringBuffer)tempAls.get(k)).insert(0, '-');
                        ++k;
                    }
                }
                j = tempAls.size() - 1;
                while (j >= 0 && ((StringBuffer)tempAls.get(j)).charAt(i4) == '-' && !onlyGaps[j][i4]) {
                    --j;
                }
                if (j > 0 && j < tempAls.size() && ((StringBuffer)tempAls.get(j)).charAt(i4) == '-') {
                    int k = tempAls.size() - 1;
                    while (k > j) {
                        ((StringBuffer)tempAls.get(k)).delete(i4, i4 + 1);
                        ((StringBuffer)tempAls.get(k)).insert(0, '-');
                        --k;
                    }
                }
                ++i4;
            }
            onlyGaps = onlyGapsEnd;
            i4 = onlyGaps[0].length - 1;
            while (i4 >= 0) {
                int j = 0;
                while (j < tempAls.size() && ((StringBuffer)tempAls.get(j)).charAt(i4) == '-' && !onlyGaps[j][i4]) {
                    ++j;
                }
                if (j > 0 && j < tempAls.size() && ((StringBuffer)tempAls.get(j)).charAt(i4) == '-') {
                    int k = 0;
                    while (k < j) {
                        ((StringBuffer)tempAls.get(k)).delete(i4, i4 + 1);
                        ((StringBuffer)tempAls.get(k)).append('-');
                        ++k;
                    }
                }
                j = tempAls.size() - 1;
                while (j >= 0 && ((StringBuffer)tempAls.get(j)).charAt(i4) == '-' && !onlyGaps[j][i4]) {
                    --j;
                }
                if (j > 0 && j < tempAls.size() && ((StringBuffer)tempAls.get(j)).charAt(i4) == '-') {
                    int k = tempAls.size() - 1;
                    while (k > j) {
                        ((StringBuffer)tempAls.get(k)).delete(i4, i4 + 1);
                        ((StringBuffer)tempAls.get(k)).append('-');
                        --k;
                    }
                }
                --i4;
            }
            LinkedList<TALE> resTales = new LinkedList<TALE>();
            LinkedList<String> resAls = new LinkedList<String>();
            int i5 = 0;
            while (i5 < tales.length) {
                int j = 0;
                while (j < tales[i5].length) {
                    resTales.add(tales[i5][j]);
                    ++j;
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < tempAls.size()) {
                int k = ((StringBuffer)tempAls.get(i5)).length() - 2;
                while (k >= 0) {
                    ((StringBuffer)tempAls.get(i5)).insert(k, ' ');
                    k -= 2;
                }
                resAls.add(((StringBuffer)tempAls.get(i5)).toString());
                ++i5;
            }
            return new Pair<TALE[], String[]>(resTales.toArray(new TALE[0]), resAls.toArray(new String[0]));
        }
    }
}

