/*
 * Decompiled with CFR 0.152.
 */
package supplementary.cookbook.recipes;

import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.PRCurve;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.ROCCurve;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.results.ImageResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.REnvironment;
import java.io.File;

public class CurvePlotter {
    public static void main(String[] args) throws Exception {
        StringBuffer buf2 = FileManager.readFile(new File(String.valueOf(args[0]) + "myClassifier.xml"));
        AbstractClassifier trainedClassifier = (AbstractClassifier)XMLParser.extractObjectForTags(buf2, "classifier");
        DataSet[] test = new DataSet[2];
        test[0] = new DNADataSet(args[1]);
        int length = test[0].getElementLength();
        test[1] = new DataSet(new DNADataSet(args[2]), length);
        PerformanceMeasure[] m = new AbstractPerformanceMeasure[]{new PRCurve(), new ROCCurve()};
        PerformanceMeasureParameterSet mp = new PerformanceMeasureParameterSet(m);
        ResultSet rs = trainedClassifier.evaluate((AbstractPerformanceMeasureParameterSet<? extends PerformanceMeasure>)mp, true, test);
        try (REnvironment r = null;){
            try {
                r = new REnvironment();
                int i = 0;
                while (i < rs.getNumberOfResults()) {
                    Result res = rs.getResultAt(i);
                    if (res instanceof AbstractScoreBasedClassifier.DoubleTableResult) {
                        AbstractScoreBasedClassifier.DoubleTableResult dtr = (AbstractScoreBasedClassifier.DoubleTableResult)res;
                        ImageResult ir = AbstractScoreBasedClassifier.DoubleTableResult.plot(r, dtr);
                        REnvironment.showImage(dtr.getName(), ir.getValue());
                    } else {
                        System.out.println(res);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (r != null) {
                    r.close();
                }
            }
        }
    }
}

