/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.DigitalNet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.util.Num;
import umontreal.ssj.util.PrintfFormat;

public class DigitalNetBase2
extends DigitalNet {
    private int[] originalMat;
    protected int[] genMat;
    protected int[] digitalShift;

    @Override
    public void printGeneratorMatrices(int s) {
        int[] mat = new int[this.numCols];
        int[] matTrans = new int[this.numRows];
        for (int j = 0; j < s; ++j) {
            int c;
            int r;
            System.out.println("dim = " + (j + 1) + PrintfFormat.NEWLINE);
            for (r = 0; r < this.numRows; ++r) {
                matTrans[r] = 0;
            }
            for (c = 0; c < this.numCols; ++c) {
                mat[c] = this.genMat[j * this.numCols + c];
                int n = c;
                mat[n] = mat[n] >> this.outDigits - this.numRows;
                r = this.numRows - 1;
                while (r >= 0) {
                    int n2 = r;
                    matTrans[n2] = matTrans[n2] << 1;
                    int n3 = r--;
                    matTrans[n3] = matTrans[n3] | mat[c] & 1;
                    int n4 = c;
                    mat[n4] = mat[n4] >> 1;
                }
            }
            for (r = 0; r < this.numRows; ++r) {
                StringBuffer sb = new StringBuffer();
                int x = matTrans[r];
                for (c = 0; c < this.numCols; ++c) {
                    sb.insert(0, x & 1);
                    x >>= 1;
                }
                System.out.println(sb);
            }
            System.out.println("----------------------------------");
        }
    }

    public void printGeneratorMatricesTrans(int s) {
        for (int j = 0; j < s; ++j) {
            System.out.println("dim = " + (j + 1) + PrintfFormat.NEWLINE);
            for (int c = 0; c < this.numCols; ++c) {
                System.out.println(this.genMat[j * this.numCols + c]);
            }
            System.out.println("----------------------------------");
        }
    }

    @Override
    public double getCoordinate(int i, int j) {
        int pos = 0;
        int grayCode = i ^ i >> 1;
        int res = this.digitalShift == null ? 0 : this.digitalShift[j];
        while (grayCode >> pos != 0) {
            if ((grayCode >> pos & 1) != 0) {
                res ^= this.genMat[j * this.numCols + pos];
            }
            ++pos;
        }
        if (this.digitalShift != null) {
            return (double)res * this.normFactor + this.EpsilonHalf;
        }
        return (double)res * this.normFactor;
    }

    @Override
    public double getCoordinateNoGray(int i, int j) {
        int res = this.digitalShift == null ? 0 : this.digitalShift[j];
        int pos = 0;
        while (i >> pos != 0) {
            if ((i >> pos & 1) != 0 && pos < this.numCols) {
                res ^= this.genMat[j * this.numCols + pos];
            }
            ++pos;
        }
        if (this.digitalShift != null) {
            return (double)res * this.normFactor + this.EpsilonHalf;
        }
        return (double)res * this.normFactor;
    }

    @Override
    public PointSetIterator iterator() {
        return new DigitalNetBase2Iterator();
    }

    @Override
    public PointSetIterator iteratorNoGray() {
        return new DigitalNetBase2IteratorNoGray();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("DigitalNetBase2: ");
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public void clearRandomShift() {
        super.clearRandomShift();
        this.digitalShift = null;
    }

    @Override
    public void addRandomShift(int d1, int d2, RandomStream stream) {
        if (null == stream) {
            throw new IllegalArgumentException(PrintfFormat.NEWLINE + "   Calling addRandomShift with null stream");
        }
        if (0 == d2) {
            d2 = Math.max(1, this.dim);
        }
        if (this.digitalShift == null) {
            this.digitalShift = new int[d2];
            this.capacityShift = d2;
        } else if (d2 > this.capacityShift) {
            int d3;
            for (d3 = Math.max(4, this.capacityShift); d2 > d3; d3 *= 2) {
            }
            int[] temp = new int[d3];
            this.capacityShift = d3;
            for (int i = 0; i < d1; ++i) {
                temp[i] = this.digitalShift[i];
            }
            this.digitalShift = temp;
        }
        int maxj = this.outDigits < 31 ? (1 << this.outDigits) - 1 : Integer.MAX_VALUE;
        for (int i = d1; i < d2; ++i) {
            this.digitalShift[i] = stream.nextInt(0, maxj);
        }
        this.dimShift = d2;
        this.shiftStream = stream;
    }

    @Override
    public void addRandomShift(RandomStream stream) {
        this.addRandomShift(0, this.dim, stream);
    }

    private void leftMultiplyMat(int j, int[] Mj) {
        for (int c = 0; c < this.numCols; ++c) {
            int col = 0;
            for (int d = 0; d < this.outDigits; ++d) {
                col ^= (Mj[d] & this.originalMat[j * this.numCols + c]) >> d;
            }
            this.genMat[j * this.numCols + c] = col;
        }
    }

    private void rightMultiplyMat(int j, int[] Mj) {
        for (int c = 0; c < this.numCols; ++c) {
            int mask = 1 << this.outDigits - 1;
            int col = this.originalMat[j * this.numCols + c];
            for (int r = 0; r < c; ++r) {
                if ((Mj[c] & mask) != 0) {
                    col ^= this.originalMat[j * this.numCols + r];
                }
                mask >>= 1;
            }
            this.genMat[j * this.numCols + c] = col;
        }
    }

    @Override
    public void leftMatrixScramble(RandomStream stream) {
        int j;
        int allOnes = (1 << this.outDigits) - 1;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols];
        }
        int[][] scrambleMat = new int[this.dim][this.outDigits];
        for (j = 0; j < this.dim; ++j) {
            scrambleMat[j][0] = allOnes;
            for (int d = 1; d < this.outDigits; ++d) {
                scrambleMat[j][d] = stream.nextInt(0, allOnes >> d) << d;
            }
        }
        for (j = 0; j < this.dim; ++j) {
            this.leftMultiplyMat(j, scrambleMat[j]);
        }
    }

    @Override
    public void iBinomialMatrixScramble(RandomStream stream) {
        int j;
        int allOnes = (1 << this.outDigits) - 1;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols];
        }
        int[][] scrambleMat = new int[this.dim][this.outDigits];
        for (j = 0; j < this.dim; ++j) {
            scrambleMat[j][0] = allOnes;
            int lastRow = stream.nextInt(0, allOnes) | 1;
            for (int d = 1; d < this.outDigits; ++d) {
                scrambleMat[j][d] = (1 << d & lastRow) == 0 ? 0 : allOnes >> d << d;
            }
        }
        for (j = 0; j < this.dim; ++j) {
            this.leftMultiplyMat(j, scrambleMat[j]);
        }
    }

    @Override
    public void stripedMatrixScramble(RandomStream stream) {
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols];
        }
        int[] scrambleMat = new int[this.outDigits];
        int allOnes = (1 << this.outDigits) - 1;
        for (int d = 0; d < this.outDigits; ++d) {
            scrambleMat[d] = allOnes >> d << d;
        }
        for (int j = 0; j < this.dim; ++j) {
            this.leftMultiplyMat(j, scrambleMat);
        }
    }

    @Override
    public void rightMatrixScramble(RandomStream stream) {
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols];
        }
        int[] scrambleMat = new int[this.outDigits];
        int boundInt = 0;
        for (int c = 0; c < this.numCols; ++c) {
            scrambleMat[c] = (1 | stream.nextInt(0, boundInt += 1 << c)) << this.outDigits - c - 1;
        }
        for (int j = 0; j < this.dim; ++j) {
            this.rightMultiplyMat(j, scrambleMat);
        }
    }

    private int randomBitVector(RandomStream stream, int numBits) {
        if (numBits < 1) {
            throw new IllegalArgumentException("numBits must be >= 1");
        }
        if (numBits > 31) {
            throw new IllegalArgumentException("numBits must be <= 31");
        }
        int maxj = numBits < 31 ? (1 << numBits) - 1 : Integer.MAX_VALUE;
        return stream.nextInt(0, maxj) << 31 - numBits;
    }

    public void nestedUniformScramble(RandomStream stream, double[][] output) {
        this.nestedUniformScramble(stream, output, 0);
    }

    public void nestedUniformScramble(RandomStream stream, double[][] output, int numBits) {
        assert (output.length == this.numPoints);
        assert (output.length > 0);
        assert (output[0].length == this.dim);
        if (numBits == 0) {
            numBits = this.outDigits;
        }
        int[] poslist = new int[2 * this.numPoints];
        int[] bvlist = new int[2 * this.numPoints];
        int[] counts = new int[256];
        int[] binpos = new int[256];
        for (int j = 0; j < this.dim; ++j) {
            int i;
            bvlist[0] = 0;
            poslist[0] = 0;
            for (int i2 = 1; i2 < this.numPoints; ++i2) {
                int pos = 0;
                int bv = 1;
                while ((i2 & bv) == 0) {
                    ++pos;
                    bv <<= 1;
                }
                bvlist[i2] = bvlist[i2 - 1] ^ this.genMat[j * this.numCols + pos];
                poslist[i2] = i2;
            }
            for (int b = 0; b < 4; ++b) {
                int i3;
                for (i = 0; i < 256; ++i) {
                    counts[i] = 0;
                }
                int m = b % 2 * this.numPoints;
                int bb = 8 * b;
                int bv = 255 << bb;
                for (i3 = 0; i3 < this.numPoints; ++i3) {
                    int n = (bvlist[m + i3] & bv) >>> bb;
                    counts[n] = counts[n] + 1;
                }
                binpos[0] = (1 - b % 2) * this.numPoints;
                for (i3 = 0; i3 < 255; ++i3) {
                    binpos[i3 + 1] = binpos[i3] + counts[i3];
                }
                for (i3 = 0; i3 < this.numPoints; ++i3) {
                    int pos;
                    int n = pos = (bvlist[m + i3] & bv) >>> bb;
                    binpos[n] = binpos[n] + 1;
                    bvlist[k] = bvlist[m + i3];
                    poslist[k] = poslist[m + i3];
                }
            }
            int bv = this.randomBitVector(stream, numBits);
            output[poslist[0]][j] = (double)(bvlist[0] ^ bv) * this.normFactor + this.EpsilonHalf;
            for (i = 1; i < this.numPoints; ++i) {
                int bv2 = bvlist[i - 1];
                bv2 ^= bvlist[i];
                bv2 = this.randomBitVector(stream, numBits) & (1 << (int)Num.log2(bv2)) - 1;
                output[poslist[i]][j] = (double)(bvlist[i] ^ (bv ^= bv2)) * this.normFactor + this.EpsilonHalf;
            }
        }
    }

    private void ScrambleError(String method) {
        throw new UnsupportedOperationException(PrintfFormat.NEWLINE + "  " + method + " is meaningless for DigitalNetBase2");
    }

    @Override
    public void leftMatrixScrambleDiag(RandomStream stream) {
        this.ScrambleError("leftMatrixScrambleDiag");
    }

    @Override
    public void leftMatrixScrambleFaurePermut(RandomStream stream, int sb) {
        this.ScrambleError("leftMatrixScrambleFaurePermut");
    }

    @Override
    public void leftMatrixScrambleFaurePermutDiag(RandomStream stream, int sb) {
        this.ScrambleError("leftMatrixScrambleFaurePermutDiag");
    }

    @Override
    public void leftMatrixScrambleFaurePermutAll(RandomStream stream, int sb) {
        this.ScrambleError("leftMatrixScrambleFaurePermutAll");
    }

    @Override
    public void iBinomialMatrixScrambleFaurePermut(RandomStream stream, int sb) {
        this.ScrambleError("iBinomialMatrixScrambleFaurePermut");
    }

    @Override
    public void iBinomialMatrixScrambleFaurePermutDiag(RandomStream stream, int sb) {
        this.ScrambleError("iBinomialMatrixScrambleFaurePermutDiag");
    }

    @Override
    public void iBinomialMatrixScrambleFaurePermutAll(RandomStream stream, int sb) {
        this.ScrambleError("iBinomialMatrixScrambleFaurePermutAll");
    }

    @Override
    public void stripedMatrixScrambleFaurePermutAll(RandomStream stream, int sb) {
        this.ScrambleError("stripedMatrixScrambleFaurePermutAll");
    }

    protected class DigitalNetBase2IteratorNoGray
    extends DigitalNetBase2Iterator {
        @Override
        public void setCurPointIndex(int i) {
            if (i == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = i;
            this.curCoordIndex = 0;
            this.addShiftToCache();
            int pos = 0;
            while (i >> pos != 0) {
                if ((i >> pos & 1) != 0 && pos < DigitalNetBase2.this.numCols) {
                    for (int j = 0; j < DigitalNetBase2.this.dim; ++j) {
                        int n = j;
                        this.cachedCurPoint[n] = this.cachedCurPoint[n] ^ DigitalNetBase2.this.genMat[j * DigitalNetBase2.this.numCols + pos];
                    }
                }
                ++pos;
            }
        }

        @Override
        public int resetToNextPoint() {
            if (this.curPointIndex + 1 >= DigitalNetBase2.this.numPoints) {
                return ++this.curPointIndex;
            }
            int diff = this.curPointIndex ^ this.curPointIndex + 1;
            int pos = 0;
            while (diff >> pos != 0) {
                if ((diff >> pos & 1) != 0 && pos < DigitalNetBase2.this.numCols) {
                    for (int j = 0; j < DigitalNetBase2.this.dim; ++j) {
                        int n = j;
                        this.cachedCurPoint[n] = this.cachedCurPoint[n] ^ DigitalNetBase2.this.genMat[j * DigitalNetBase2.this.numCols + pos];
                    }
                }
                ++pos;
            }
            this.curCoordIndex = 0;
            return ++this.curPointIndex;
        }
    }

    protected class DigitalNetBase2Iterator
    extends DigitalNet.DigitalNetIterator {
        protected int dimS;

        public DigitalNetBase2Iterator() {
            this.EpsilonHalf = 0.5 / Num.TWOEXP[DigitalNetBase2.this.outDigits];
            this.cachedCurPoint = new int[DigitalNetBase2.this.dim + 1];
            this.dimS = DigitalNetBase2.this.dim;
            this.init2();
        }

        @Override
        public void init() {
        }

        public void init2() {
            this.resetCurPointIndex();
        }

        @Override
        public double nextDouble() {
            return this.nextCoordinate();
        }

        @Override
        public double nextCoordinate() {
            if (this.curPointIndex >= DigitalNetBase2.this.numPoints || this.curCoordIndex >= this.dimS) {
                this.outOfBounds();
            }
            if (DigitalNetBase2.this.digitalShift == null) {
                return (double)this.cachedCurPoint[this.curCoordIndex++] * DigitalNetBase2.this.normFactor;
            }
            return (double)this.cachedCurPoint[this.curCoordIndex++] * DigitalNetBase2.this.normFactor + this.EpsilonHalf;
        }

        protected void addShiftToCache() {
            if (DigitalNetBase2.this.digitalShift == null) {
                for (int j = 0; j < DigitalNetBase2.this.dim; ++j) {
                    this.cachedCurPoint[j] = 0;
                }
            } else {
                if (DigitalNetBase2.this.dimShift < this.dimS) {
                    DigitalNetBase2.this.addRandomShift(DigitalNetBase2.this.dimShift, this.dimS, DigitalNetBase2.this.shiftStream);
                }
                for (int j = 0; j < DigitalNetBase2.this.dim; ++j) {
                    this.cachedCurPoint[j] = DigitalNetBase2.this.digitalShift[j];
                }
            }
        }

        @Override
        public void resetCurPointIndex() {
            this.addShiftToCache();
            this.curPointIndex = 0;
            this.curCoordIndex = 0;
        }

        @Override
        public void setCurPointIndex(int i) {
            if (i == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = i;
            this.curCoordIndex = 0;
            this.addShiftToCache();
            int grayCode = i ^ i >> 1;
            int pos = 0;
            while (grayCode >> pos != 0) {
                if ((grayCode >> pos & 1) != 0) {
                    for (int j = 0; j < DigitalNetBase2.this.dim; ++j) {
                        int n = j;
                        this.cachedCurPoint[n] = this.cachedCurPoint[n] ^ DigitalNetBase2.this.genMat[j * DigitalNetBase2.this.numCols + pos];
                    }
                }
                ++pos;
            }
        }

        @Override
        public int resetToNextPoint() {
            int pos = 0;
            while ((this.curPointIndex >> pos & 1) != 0) {
                ++pos;
            }
            if (pos < DigitalNetBase2.this.numCols) {
                for (int j = 0; j < DigitalNetBase2.this.dim; ++j) {
                    int n = j;
                    this.cachedCurPoint[n] = this.cachedCurPoint[n] ^ DigitalNetBase2.this.genMat[j * DigitalNetBase2.this.numCols + pos];
                }
            }
            this.curCoordIndex = 0;
            return ++this.curPointIndex;
        }

        @Override
        public int nextPoint(double[] p, int d) {
            if (this.curPointIndex >= DigitalNetBase2.this.numPoints || d > this.dimS) {
                this.outOfBounds();
            }
            if (DigitalNetBase2.this.digitalShift == null) {
                for (int j = 0; j < d; ++j) {
                    p[j] = (double)this.cachedCurPoint[j] * DigitalNetBase2.this.normFactor;
                }
            } else {
                for (int j = 0; j < d; ++j) {
                    p[j] = (double)this.cachedCurPoint[j] * DigitalNetBase2.this.normFactor + this.EpsilonHalf;
                }
            }
            return this.resetToNextPoint();
        }
    }
}

