/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.DigitalNetBase2;
import umontreal.ssj.hups.F2wStructure;
import umontreal.ssj.util.PrintfFormat;

public class F2wNetLFSR
extends DigitalNetBase2 {
    private F2wStructure param;

    public F2wNetLFSR(int w, int r, int modQ, int step, int nbcoeff, int[] coeff, int[] nocoeff, int dim) {
        this.param = new F2wStructure(w, r, modQ, step, nbcoeff, coeff, nocoeff);
        this.param.initParamLFSR();
        this.initNet(r, w, dim);
    }

    public F2wNetLFSR(String filename, int no, int dim) {
        this.param = new F2wStructure(filename, no);
        this.param.initParamLFSR();
        this.initNet(this.param.r, this.param.w, dim);
    }

    @Override
    public String toString() {
        String s = "F2wNetLFSR:" + PrintfFormat.NEWLINE;
        return s + this.param.toString();
    }

    private void initNet(int r, int w, int dim) {
        this.numCols = r * w;
        this.numRows = 31;
        this.outDigits = 31;
        this.numPoints = 1 << this.numCols;
        this.dim = dim;
        this.normFactor = 4.656612873077393E-10;
        this.genMat = new int[dim * this.numCols];
        for (int j = 0; j < this.numCols; ++j) {
            this.param.state = 1 << r * w - 1 - j;
            this.param.initF2wLFSR();
            this.genMat[j] = this.param.output;
            for (int i = 1; i < dim; ++i) {
                this.param.F2wLFSR();
                this.genMat[i * this.numCols + j] = this.param.output;
            }
        }
    }
}

