/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.Rank1Lattice;
import umontreal.ssj.util.PrintfFormat;

public class KorobovLattice
extends Rank1Lattice {
    protected int genA;
    private int genT;

    private void initN(int n, int t) {
        int j;
        int a = this.genA % n + (this.genA < 0 ? n : 0);
        this.genT = t;
        long[] B = new long[this.dim];
        B[0] = 1L;
        for (j = 0; j < t; ++j) {
            B[0] = B[0] * (long)a;
        }
        this.v[0] = (double)B[0] * this.normFactor;
        for (j = 1; j < this.dim; ++j) {
            B[j] = (long)a * B[j - 1] % (long)n;
            this.v[j] = this.normFactor * (double)B[j];
        }
    }

    public KorobovLattice(int n, int a, int s) {
        super(n, null, 0);
        this.genA = a;
        this.dim = s;
        this.v = new double[s];
        this.initN(n, 0);
    }

    public KorobovLattice(int n, int a, int s, int t) {
        super(n, null, 0);
        if (t < 0) {
            throw new IllegalArgumentException("KorobovLattice: must have t >= 0");
        }
        this.dim = s;
        this.genA = a;
        this.v = new double[s];
        this.initN(n, t);
    }

    @Override
    public void setNumPoints(int n) {
        this.initN(n, this.genT);
    }

    public int getA() {
        return this.genA;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("KorobovLattice:" + PrintfFormat.NEWLINE);
        sb.append("Multiplier a: " + this.genA + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        return sb.toString();
    }
}

