/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.probdist.BetaDist;
import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.util.Num;

public class FisherFDist
extends ContinuousDistribution {
    protected int n1;
    protected int n2;
    protected double C1;
    private static final int DECPREC = 15;

    public FisherFDist(int n1, int n2) {
        this.setParams(n1, n2);
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp(this.C1 + 0.5 * (double)(this.n1 - 2) * Math.log(x) - 0.5 * (double)(this.n1 + this.n2) * Math.log((double)this.n2 + (double)this.n1 * x));
    }

    @Override
    public double cdf(double x) {
        return FisherFDist.cdf(this.n1, this.n2, x);
    }

    @Override
    public double barF(double x) {
        return FisherFDist.barF(this.n1, this.n2, x);
    }

    @Override
    public double inverseF(double u) {
        return FisherFDist.inverseF(this.n1, this.n2, u);
    }

    @Override
    public double getMean() {
        return FisherFDist.getMean(this.n1, this.n2);
    }

    @Override
    public double getVariance() {
        return FisherFDist.getVariance(this.n1, this.n2);
    }

    @Override
    public double getStandardDeviation() {
        return FisherFDist.getStandardDeviation(this.n1, this.n2);
    }

    public static double density(int n1, int n2, double x) {
        if (n1 <= 0) {
            throw new IllegalArgumentException("n1 <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("n2 <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp((double)n1 / 2.0 * Math.log(n1) + (double)n2 / 2.0 * Math.log(n2) + (double)(n1 - 2) / 2.0 * Math.log(x) - (Num.lnBeta((double)n1 / 2.0, (double)n2 / 2.0) + (double)(n1 + n2) / 2.0 * Math.log((double)n2 + (double)n1 * x)));
    }

    @Deprecated
    public static double cdf(int n1, int n2, int d, double x) {
        if (n1 <= 0) {
            throw new IllegalArgumentException("n1 <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("n2 <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        return BetaDist.cdf((double)n1 / 2.0, (double)n2 / 2.0, d, (double)n1 * x / ((double)n1 * x + (double)n2));
    }

    public static double cdf(int n1, int n2, double x) {
        return FisherFDist.cdf(n1, n2, 15, x);
    }

    @Deprecated
    public static double barF(int n1, int n2, int d, double x) {
        if (n1 <= 0) {
            throw new IllegalArgumentException("n1 <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("n2 <= 0");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        return BetaDist.barF((double)n1 / 2.0, (double)n2 / 2.0, d, (double)n1 * x / ((double)n1 * x + (double)n2));
    }

    public static double barF(int n1, int n2, double x) {
        return FisherFDist.barF(n1, n2, 15, x);
    }

    @Deprecated
    public static double inverseF(int n1, int n2, int d, double u) {
        if (n1 <= 0) {
            throw new IllegalArgumentException("n1 <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("n2 <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u < 0 or u > 1");
        }
        if (u <= 0.0) {
            return 0.0;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double z = BetaDist.inverseF((double)n1 / 2.0, (double)n2 / 2.0, d, u);
        return (double)n2 * z / ((double)n1 * (1.0 - z));
    }

    public static double inverseF(int n1, int n2, double u) {
        return FisherFDist.inverseF(n1, n2, 15, u);
    }

    public static double getMean(int n1, int n2) {
        if (n1 <= 0) {
            throw new IllegalArgumentException("n1 <= 0");
        }
        if (n2 <= 2) {
            throw new IllegalArgumentException("n2 <= 2");
        }
        return (double)n2 / ((double)n2 - 2.0);
    }

    public static double getVariance(int n1, int n2) {
        if (n1 <= 0) {
            throw new IllegalArgumentException("n1 <= 0");
        }
        if (n2 <= 4) {
            throw new IllegalArgumentException("n2 <= 4");
        }
        return 2.0 * (double)n2 * (double)n2 * (double)(n2 + n1 - 2) / ((double)n1 * ((double)n2 - 2.0) * ((double)n2 - 2.0) * ((double)n2 - 4.0));
    }

    public static double getStandardDeviation(int n1, int n2) {
        return Math.sqrt(FisherFDist.getVariance(n1, n2));
    }

    @Deprecated
    public int getN() {
        return this.n1;
    }

    @Deprecated
    public int getM() {
        return this.n2;
    }

    public int getN1() {
        return this.n1;
    }

    public int getN2() {
        return this.n2;
    }

    public void setParams(int n1, int n2) {
        if (n1 <= 0) {
            throw new IllegalArgumentException("n1 <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("n2 <= 0");
        }
        this.n1 = n1;
        this.n2 = n2;
        this.supportA = 0.0;
        this.C1 = (double)n1 / 2.0 * Math.log(n1) + (double)n2 / 2.0 * Math.log(n2) - Num.lnBeta((double)n1 / 2.0, (double)n2 / 2.0);
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.n1, this.n2};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : n1 = " + this.n1 + ", n2 = " + this.n2;
    }
}

