/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdistmulti.norta;

import umontreal.ssj.probdist.DiscreteDistributionInt;
import umontreal.ssj.probdistmulti.norta.NortaInitDisc;

public class NI1
extends NortaInitDisc {
    private double tolerance;

    public NI1(double rX, DiscreteDistributionInt dist1, DiscreteDistributionInt dist2, double tr, double tolerance) {
        super(rX, dist1, dist2, tr);
        this.tolerance = tolerance;
        this.computeParams();
    }

    @Override
    public double computeCorr() {
        double fb;
        double fa;
        double c;
        double b;
        double a;
        double x2;
        double x1;
        double ITMAX = 100.0;
        double EPS = 1.0E-15;
        double e = 0.0;
        double d = 0.0;
        double cc = this.rX * this.sd1 * this.sd2;
        double ccc = cc + this.mu1 * this.mu2;
        if (this.rX == 0.0) {
            return 0.0;
        }
        if (this.rX > 0.0) {
            x1 = 0.0;
            x2 = 1.0;
            a = x1;
            b = x2;
            c = x2;
            fa = -cc;
            fb = this.integ(b) - ccc;
        } else {
            x1 = -1.0;
            x2 = 0.0;
            a = x1;
            b = x2;
            c = x2;
            fa = this.integ(a) - ccc;
            fb = -cc;
        }
        double fc = fb;
        int i = 1;
        while ((double)i <= 100.0) {
            if (fb > 0.0 && fc > 0.0 || fb < 0.0 && fc < 0.0) {
                c = a;
                fc = fa;
                e = d = b - a;
            }
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tolerance1 = 2.0E-15 * Math.abs(b) + 0.5 * this.tolerance;
            double xm = 0.5 * (c - b);
            if (Math.abs(xm) <= tolerance1 || fb == 0.0) {
                return b;
            }
            if (Math.abs(e) >= tolerance1 && Math.abs(fa) > Math.abs(fb)) {
                double min2;
                double q;
                double pp;
                double s = fb / fa;
                if (a == c) {
                    pp = 2.0 * xm * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double rrr = fb / fc;
                    pp = s * (2.0 * xm * q * (q - rrr) - (b - a) * (rrr - 1.0));
                    q = (q - 1.0) * (rrr - 1.0) * (s - 1.0);
                }
                if (pp > 0.0) {
                    q = -q;
                }
                pp = Math.abs(pp);
                double min1 = 3.0 * xm * q - Math.abs(tolerance1 * q);
                double d2 = min1 < (min2 = Math.abs(e * q)) ? min1 : min2;
                if (2.0 * pp < d2) {
                    e = d;
                    d = pp / q;
                } else {
                    e = d = xm;
                }
            } else {
                e = d = xm;
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tolerance1 ? (b += d) : (xm > 0.0 ? (b += Math.abs(tolerance1)) : (b += -Math.abs(tolerance1)));
            fb = this.integ(b) - ccc;
            ++i;
        }
        return b;
    }

    @Override
    public String toString() {
        String desc = super.toString();
        desc = desc + "tolerance : " + this.tolerance + "\n";
        return desc;
    }
}

