/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.randvar.ChiSquareGen;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.randvar.RandomVariateGen;

public class StudentNoncentralGen
extends RandomVariateGen {
    private NormalGen normgen;
    private ChiSquareGen chigen;
    private int n;

    @Override
    public double nextDouble() {
        double x = this.normgen.nextDouble();
        double y = this.chigen.nextDouble();
        return x / Math.sqrt(y / (double)this.n);
    }

    public StudentNoncentralGen(NormalGen ngen, ChiSquareGen cgen) {
        super(null, null);
        this.setNormalGen(ngen);
        this.setChiSquareGen(cgen);
    }

    public void setNormalGen(NormalGen ngen) {
        if (1.0 != ngen.getSigma()) {
            throw new IllegalArgumentException("   variance of normal must be 1");
        }
        this.normgen = ngen;
    }

    public void setChiSquareGen(ChiSquareGen cgen) {
        this.chigen = cgen;
        this.n = cgen.getN();
    }
}

