/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.ClassificationRate;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasureParameterSet;
import de.jstacs.classifiers.trainSMBased.TrainSMBasedClassifier;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.sequenceScores.SequenceScore;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.parameters.HomMMParameterSet;
import java.io.PrintWriter;

public class SDIIHomogen {
    public static void main(String[] args) throws Exception {
        int max_order_bg = 2;
        int max_order_fg = 2;
        int order_bg = 2;
        int order_fg = 2;
        DNADataSet codingTrain = new DNADataSet("coding_train.txt", '#');
        DNADataSet nonTrain = new DNADataSet("noncoding_train.txt", '#');
        DNADataSet codingTest = new DNADataSet("coding_test.txt", '#');
        DNADataSet nonTest = new DNADataSet("noncoding_test.txt", '#');
        PerformanceMeasureParameterSet params = new PerformanceMeasureParameterSet(new ClassificationRate());
        double[][][] crs = new double[max_order_fg + 1][max_order_bg + 1][3];
        SequenceScore m_fg = null;
        SequenceScore m_bg = null;
        int i = 0;
        while (i <= max_order_fg) {
            int j = 0;
            while (j <= max_order_bg) {
                System.out.println("################################################");
                System.out.println("Foreground order = " + i + " , background order = " + j);
                System.out.println();
                HomogeneousMM fg = new HomogeneousMM(new HomMMParameterSet(DNAAlphabetContainer.SINGLETON, 0.0, "", (byte)i));
                HomogeneousMM bg = new HomogeneousMM(new HomMMParameterSet(DNAAlphabetContainer.SINGLETON, 0.0, "", (byte)j));
                TrainSMBasedClassifier cl = new TrainSMBasedClassifier(fg, bg);
                cl.train(codingTrain, nonTrain);
                System.out.println(cl);
                crs[i][j][0] = (Double)cl.evaluate((AbstractPerformanceMeasureParameterSet<? extends PerformanceMeasure>)params, true, codingTest, null).getResultAt(0).getValue();
                crs[i][j][1] = (Double)cl.evaluate((AbstractPerformanceMeasureParameterSet<? extends PerformanceMeasure>)params, true, null, nonTest).getResultAt(0).getValue();
                crs[i][j][2] = (Double)cl.evaluate((AbstractPerformanceMeasureParameterSet<? extends PerformanceMeasure>)params, true, codingTest, nonTest).getResultAt(0).getValue();
                if (i == order_fg && j == order_bg) {
                    m_fg = cl.getModel(0);
                    m_bg = cl.getModel(1);
                }
                j = (byte)(j + 1);
            }
            i = (byte)(i + 1);
        }
        double codingElements = codingTrain.getNumberOfElements();
        double nonCodingElements = nonTrain.getNumberOfElements();
        System.out.println("Klassenwahrscheinlichkeiten: fg = " + codingElements / (codingElements + nonCodingElements) + " , bg = " + nonCodingElements / (codingElements + nonCodingElements));
        System.out.println();
        System.out.println();
        System.out.println("Gesamt-Ergebnis: ");
        System.out.println();
        System.out.println("Ordnung_fg\tOrdnung_bg\tSn\tSp\tCR");
        int i2 = 0;
        while (i2 <= max_order_fg) {
            int j = 0;
            while (j <= max_order_bg) {
                System.out.println(String.valueOf(i2) + "\t" + j + "\t" + crs[i2][j][0] + "\t" + crs[i2][j][1] + "\t" + crs[i2][j][2]);
                ++j;
            }
            ++i2;
        }
        System.out.println();
        System.out.println("Gesamt-Ergebnis (relevanter Ausschnitt): ");
        System.out.println();
        System.out.println("Ordnung_fg\tOrdnung_bg\tSn\tSp\tCR");
        i2 = 0;
        while (i2 <= max_order_fg) {
            System.out.println(String.valueOf(i2) + "\t" + i2 + "\t" + crs[i2][i2][0] + "\t" + crs[i2][i2][1] + "\t" + crs[i2][i2][2]);
            ++i2;
        }
        System.out.println();
        double[] codingTestScores_fg = m_fg.getLogScoreFor(codingTest);
        double[] nonCodingTestScores_fg = m_fg.getLogScoreFor(nonTest);
        double[] codingTestScores_bg = m_bg.getLogScoreFor(codingTest);
        double[] nonCodingTestScores_bg = m_bg.getLogScoreFor(nonTest);
        PrintWriter wr = new PrintWriter("scores_" + order_fg + "_" + order_bg + ".tsv");
        int i3 = 0;
        while (i3 < codingTestScores_fg.length) {
            wr.println("fg\t" + i3 + "\t" + (codingTestScores_fg[i3] - codingTestScores_bg[i3]));
            ++i3;
        }
        i3 = 0;
        while (i3 < nonCodingTestScores_fg.length) {
            wr.println("bg\t" + i3 + "\t" + (nonCodingTestScores_fg[i3] - nonCodingTestScores_bg[i3]));
            ++i3;
        }
        wr.close();
        double t_real = Math.log(nonCodingElements / (codingElements + nonCodingElements)) - Math.log(codingElements / (codingElements + nonCodingElements));
        System.out.println("t estimated from training set = " + t_real);
        System.out.println("t\tTP\tFP\tFN\tTN\tCR");
        double t = -10.0;
        while (t <= 15.0) {
            int TP = 0;
            int FN = 0;
            int i4 = 0;
            while (i4 < codingTestScores_fg.length) {
                double diff = codingTestScores_fg[i4] - codingTestScores_bg[i4];
                if (diff > t) {
                    ++TP;
                } else {
                    ++FN;
                }
                ++i4;
            }
            int TN = 0;
            int FP = 0;
            int i5 = 0;
            while (i5 < nonCodingTestScores_fg.length) {
                double diff = nonCodingTestScores_fg[i5] - nonCodingTestScores_bg[i5];
                if (diff < t) {
                    ++TN;
                } else {
                    ++FP;
                }
                ++i5;
            }
            double CR = (double)(TP + TN) / (double)(TP + TN + FP + FN);
            System.out.println(String.valueOf(t) + "\t" + TP + "\t" + FP + "\t" + FN + "\t" + TN + "\t" + CR);
            t += 0.1;
        }
    }
}

