/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment;

import de.jstacs.algorithms.alignment.StringAlignment;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public class PairwiseStringAlignment
extends StringAlignment {
    private int start;
    private int end;
    private int nummatches;
    private int start2;
    private int end2;

    protected PairwiseStringAlignment(String r1, String r2, double cost, int startPos, int endPos, int numMatches) {
        super(cost, r1, r2);
        this.start = startPos;
        this.end = endPos;
        this.start2 = -1;
        this.end2 = -1;
        this.nummatches = numMatches;
    }

    protected PairwiseStringAlignment(String r1, String r2, double cost, int startPos, int endPos, int startPos2, int endPos2, int numMatches) {
        super(cost, r1, r2);
        this.start = startPos;
        this.end = endPos;
        this.start2 = startPos2;
        this.end2 = endPos2;
        this.nummatches = numMatches;
    }

    public PairwiseStringAlignment(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public int getNumberOfMatches() {
        return this.nummatches;
    }

    public int getStartIndexOfAlignmentForFirst() {
        return this.start;
    }

    public int getStartIndexOfAlignmentForSecond() {
        return this.start2;
    }

    public int getEndIndexOfAlignmentForFirst() {
        return this.end;
    }

    public int getEndIndexOfAlignmentForSecond() {
        return this.end2;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "PairwiseStringAlignment");
        super.fromXML(xml);
        this.end = (Integer)XMLParser.extractObjectForTags(xml, "end");
        this.nummatches = (Integer)XMLParser.extractObjectForTags(xml, "nummatches");
        this.start = (Integer)XMLParser.extractObjectForTags(xml, "start");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        super.toXML();
        XMLParser.appendObjectWithTags(xml, this.end, "end");
        XMLParser.appendObjectWithTags(xml, this.nummatches, "nummatches");
        XMLParser.appendObjectWithTags(xml, this.start, "start");
        XMLParser.addTags(xml, "PairwiseStringAlignment");
        return xml;
    }
}

