/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment.cost;

import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public class SimpleCosts
implements Costs {
    private double match;
    private double mismatch;
    private double gap;

    public SimpleCosts(double match, double mismatch, double gap) {
        this.gap = gap;
        if (mismatch <= 0.0) {
            throw new IllegalArgumentException("Problem: mismatch <= 0");
        }
        this.mismatch = mismatch;
        if (match > 0.0) {
            throw new IllegalArgumentException("Problem: match > 0");
        }
        this.match = match;
    }

    public SimpleCosts(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "SimpleCosts");
        this.gap = (Double)XMLParser.extractObjectForTags(xml, "gap");
        this.match = (Double)XMLParser.extractObjectForTags(xml, "match");
        this.mismatch = (Double)XMLParser.extractObjectForTags(xml, "mismatch");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.gap, "gap");
        XMLParser.appendObjectWithTags(xml, this.match, "match");
        XMLParser.appendObjectWithTags(xml, this.mismatch, "mismatch");
        XMLParser.addTags(xml, "SimpleCosts");
        return xml;
    }

    @Override
    public double getCostFor(Sequence s1, Sequence s2, int i, int j) {
        return s1.discreteVal(i - 1) != s2.discreteVal(j - 1) ? this.mismatch : this.match;
    }

    @Override
    public double getInsertCosts() {
        return this.gap;
    }

    @Override
    public double getDeleteCosts() {
        return this.gap;
    }
}

