/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.algorithms.optimization.MultiThreadedFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractOptimizableFunction;
import de.jstacs.data.DataSet;
import java.util.Arrays;

public abstract class AbstractMultiThreadedOptimizableFunction
extends AbstractOptimizableFunction
implements MultiThreadedFunction {
    protected Worker[] worker;
    protected double[] params;

    public static final int getNumberOfAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public AbstractMultiThreadedOptimizableFunction(int threads, DataSet[] data, double[][] weights, boolean norm, boolean freeParams) throws IllegalArgumentException {
        super(data, weights, norm, freeParams);
        if (threads < 1) {
            throw new IllegalArgumentException("The number of threads has to be positive.");
        }
        this.worker = new Worker[threads];
        this.prepareThreads();
    }

    @Override
    public void setDataAndWeights(DataSet[] data, double[][] weights) throws IllegalArgumentException {
        super.setDataAndWeights(data, weights);
        if (this.worker != null) {
            this.prepareThreads();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void prepareThreads() {
        long numBases = 0L;
        long numSeqs = 0L;
        int i = 0;
        while (i < this.data.length) {
            int l = this.data[i].getElementLength();
            int m = this.data[i].getNumberOfElements();
            numSeqs += (long)m;
            if (l != 0) {
                numBases += (long)(l * m);
            } else {
                int n = 0;
                while (n < m) {
                    numBases += (long)this.data[i].getElementAt(n).getLength();
                    ++n;
                }
            }
            ++i;
        }
        long[] bases = new long[this.worker.length];
        long[] seqs = new long[this.worker.length];
        long remBases = numBases;
        long remSeqs = numSeqs;
        int endClass = 0;
        int endSeq = 0;
        boolean out = false;
        int i2 = 0;
        while (i2 < this.worker.length) {
            long part = (long)Math.ceil((double)remBases / (double)(this.worker.length - i2));
            int startSeq = endSeq;
            int startClass = endClass;
            seqs[i2] = 0L;
            bases[i2] = 0L;
            int remWorker = this.worker.length - i2;
            while (remSeqs >= (long)remWorker && endClass < this.data.length && endSeq < this.data[endClass].getNumberOfElements()) {
                do {
                    int l = this.data[endClass].getElementAt(endSeq).getLength();
                    int n = i2;
                    bases[n] = bases[n] + (long)l;
                    int n2 = i2;
                    seqs[n2] = seqs[n2] + 1L;
                } while (remSeqs - seqs[i2] >= (long)remWorker && bases[i2] < part && ++endSeq < this.data[endClass].getNumberOfElements());
                if (remSeqs - seqs[i2] < (long)remWorker || bases[i2] >= part) break;
                endSeq = 0;
                ++endClass;
            }
            if (!out && startClass == endClass && startSeq == endSeq) {
                out = true;
            }
            remBases -= bases[i2];
            remSeqs -= seqs[i2];
            if (this.worker[i2] != null) {
                if (!this.worker[i2].isWaiting()) {
                    this.stopThreads();
                    throw new RuntimeException();
                }
                this.worker[i2].setIndices(startClass, startSeq, endClass, endSeq);
            } else {
                this.worker[i2] = new Worker(i2, startClass, startSeq, endClass, endSeq);
                this.worker[i2].start();
            }
            ++i2;
        }
        if (out) {
            System.out.println("Warning: Splitting and assigning the data (" + numBases + " characters, " + numSeqs + " sequences) to threads (" + this.worker.length + "), yields at least one empty thread.\n" + "#characters = " + Arrays.toString(bases) + "\n" + "#seqs = " + Arrays.toString(seqs) + "\n");
        }
    }

    @Override
    public double[] evaluateGradientOfFunction(double[] x) throws DimensionException, EvaluationException {
        this.setParams(x);
        this.waitUntilWorkersFinished(WorkerTask.EVALUATE_GRADIENT);
        return this.joinGradients();
    }

    protected abstract void evaluateGradientOfFunction(int var1, int var2, int var3, int var4, int var5);

    protected abstract double[] joinGradients() throws EvaluationException;

    @Override
    public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        this.setParams(x);
        this.waitUntilWorkersFinished(WorkerTask.EVALUATE);
        return this.joinFunction();
    }

    protected abstract void evaluateFunction(int var1, int var2, int var3, int var4, int var5) throws EvaluationException;

    protected abstract double joinFunction() throws EvaluationException, DimensionException;

    @Override
    public final void setParams(double[] params) throws DimensionException {
        if (this.params == null || this.params.length != params.length) {
            this.params = (double[])params.clone();
        } else {
            System.arraycopy(params, 0, this.params, 0, params.length);
        }
        this.setThreadIndependentParameters();
        this.waitUntilWorkersFinished(WorkerTask.SET_PARAMETERS);
    }

    protected abstract void setThreadIndependentParameters() throws DimensionException;

    protected abstract void setParams(int var1) throws DimensionException;

    private synchronized void waitUntilWorkersFinished(WorkerTask wt) {
        int t = 0;
        while (t < this.worker.length) {
            this.worker[t].setTask(wt);
            ++t;
        }
        boolean exception = false;
        int t2 = -1;
        while (true) {
            int i = 0;
            while (i < this.worker.length && this.worker[i].isWaiting()) {
                if (this.worker[i].exception) {
                    exception = true;
                    t2 = i;
                }
                ++i;
            }
            if (i == this.worker.length) {
                if (!exception) break;
                i = 0;
                while (i < this.worker.length) {
                    this.worker[i].interrupt();
                    ++i;
                }
                this.stopThreads();
                throw new RuntimeException("Terminate program, since at least thread " + t2 + " throws an exception.");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public final void stopThreads() {
        if (this.worker.length > 1) {
            int i = 0;
            while (i < this.worker.length) {
                this.worker[i].setTask(WorkerTask.STOP);
                ++i;
            }
            this.worker = null;
        }
    }

    @Override
    public final int getNumberOfThreads() {
        return this.worker.length;
    }

    protected class Worker
    extends Thread {
        private WorkerTask task;
        private int index;
        private int startClass;
        private int startSeq;
        private int endClass;
        private int endSeq;
        private boolean exception;

        public Worker(int index, int startClass, int startSeq, int endClass, int endSeq) {
            super("worker thread " + index);
            this.setDaemon(true);
            this.index = index;
            this.setIndices(startClass, startSeq, endClass, endSeq);
        }

        public int[] getIndices() {
            return new int[]{this.startClass, this.startSeq, this.endClass, this.endSeq};
        }

        public void setIndices(int startClass, int startSeq, int endClass, int endSeq) {
            this.startClass = startClass;
            this.startSeq = startSeq;
            this.endClass = endClass;
            this.endSeq = endSeq;
            this.task = WorkerTask.WAIT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            this.exception = false;
            while (this.task != WorkerTask.STOP) {
                if (this.task != WorkerTask.WAIT) {
                    try {
                        switch (this.task) {
                            case SET_PARAMETERS: {
                                AbstractMultiThreadedOptimizableFunction.this.setParams(this.index);
                                break;
                            }
                            case EVALUATE: {
                                AbstractMultiThreadedOptimizableFunction.this.evaluateFunction(this.index, this.startClass, this.startSeq, this.endClass, this.endSeq);
                                break;
                            }
                            case EVALUATE_GRADIENT: {
                                AbstractMultiThreadedOptimizableFunction.this.evaluateGradientOfFunction(this.index, this.startClass, this.startSeq, this.endClass, this.endSeq);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.exception = true;
                        e.printStackTrace();
                    }
                    AbstractMultiThreadedOptimizableFunction abstractMultiThreadedOptimizableFunction = AbstractMultiThreadedOptimizableFunction.this;
                    synchronized (abstractMultiThreadedOptimizableFunction) {
                        this.task = WorkerTask.WAIT;
                        AbstractMultiThreadedOptimizableFunction.this.notify();
                        continue;
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public synchronized void setTask(WorkerTask task) {
            this.task = task;
            this.notify();
        }

        public boolean isWaiting() {
            return this.task == WorkerTask.WAIT;
        }
    }

    private static enum WorkerTask {
        STOP,
        WAIT,
        SET_PARAMETERS,
        EVALUATE,
        EVALUATE_GRADIENT;

    }
}

