/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.ArbitraryFloatSequence;
import de.jstacs.data.sequences.MultiDimensionalSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.ArrayHandler;

public class MultiDimensionalArbitraryFloatSequence
extends MultiDimensionalSequence<float[]> {
    public MultiDimensionalArbitraryFloatSequence(SequenceAnnotation[] seqAn, ArbitraryFloatSequence ... sequence) throws WrongLengthException, WrongAlphabetException {
        super(seqAn, sequence);
    }

    @Override
    public void fillContainer(float[] container, int pos) {
        int s = 0;
        while (s < this.content.length) {
            container[s] = (float)this.content[s].continuousVal(pos);
            ++s;
        }
    }

    @Override
    public float[] getEmptyContainer() {
        return new float[this.content.length];
    }

    protected MultiDimensionalArbitraryFloatSequence getInstance(SequenceAnnotation[] seqAn, Sequence ... seqs) throws WrongLengthException, WrongAlphabetException {
        return new MultiDimensionalArbitraryFloatSequence(seqAn, ArrayHandler.cast(ArbitraryFloatSequence.class, seqs));
    }

    @Override
    public int compareTo(float[] t1, float[] t2) {
        if (t1.length == t2.length) {
            int i = 0;
            while (i < t1.length) {
                if (t1[i] != t2[i]) {
                    return (int)Math.signum(t1[i] - t2[i]);
                }
                ++i;
            }
            return 0;
        }
        return t1.length - t2.length;
    }
}

