/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.Result;

public class TextResult
extends Result {
    private FileParameter.FileRepresentation value;
    private String mime;
    private String extendedType;
    private String producer;
    private boolean export;
    private boolean isTempFile;

    public TextResult(String name, String comment, FileParameter.FileRepresentation file, String mime, String producer, String extendedType, boolean export) {
        super(name, comment, DataType.FILE);
        this.value = file;
        this.mime = mime;
        this.producer = producer;
        this.extendedType = extendedType;
        this.export = export;
        this.isTempFile = true;
    }

    public TextResult(String name, String comment, FileParameter.FileRepresentation file, boolean isTempFile, String mime, String producer, String extendedType, boolean export) {
        super(name, comment, DataType.FILE);
        this.value = file;
        this.mime = mime;
        this.producer = producer;
        this.extendedType = extendedType;
        this.export = export;
        this.isTempFile = isTempFile;
    }

    public TextResult(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public boolean getExport() {
        return this.export;
    }

    public static boolean equals(String[] p1, String mime2) {
        if (p1 == null || mime2 == null) {
            return false;
        }
        String[] p2 = mime2.split("\\,");
        int i = 0;
        while (i < p1.length) {
            int j = 0;
            while (j < p2.length) {
                if (p1[i].equals(p2[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean equals(String mime1, String mime2) {
        if (mime1 == null || mime2 == null) {
            return false;
        }
        String[] p1 = mime1.split("\\,");
        return TextResult.equals(p1, mime2);
    }

    public void fill(FileParameter par) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
        FileParameter.FileRepresentation temp;
        if (TextResult.equals(par.getAcceptedMimeType(), this.mime)) {
            temp = this.value.clone();
            if (temp.getFilename() == null || temp.getFilename().length() == 0) {
                temp.setFilename(this.getName());
            }
            if (temp.getExtension() == null) {
                temp.setExtension(this.mime);
            }
        } else {
            throw new SimpleParameter.IllegalValueException(this.name, "Mime " + this.mime + " does not match required mime " + par.getAcceptedMimeType() + ".");
        }
        par.setValue(temp);
    }

    public String getMime() {
        return this.mime;
    }

    public String getExtendedType() {
        return this.extendedType;
    }

    public void setExtendedType(String extendedType) {
        this.extendedType = extendedType;
    }

    public boolean isTempFile() {
        return this.isTempFile;
    }

    public void setTempFile(boolean set) {
        this.isTempFile = set;
    }

    @Override
    public String getXMLTag() {
        return "TextResult";
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        XMLParser.appendObjectWithTags(buf, this.mime, "mime");
        if (this.isTempFile()) {
            this.value.getContent();
            this.value.setFilename("");
        }
        XMLParser.appendObjectWithTags(buf, this.value, "value");
        XMLParser.appendObjectWithTags(buf, this.producer, "producer");
        XMLParser.appendObjectWithTags(buf, this.export, "export");
        XMLParser.appendObjectWithTags(buf, this.extendedType, "extype");
        XMLParser.appendObjectWithTags(buf, this.isTempFile, "isTempFile");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer buf) throws NonParsableException {
        this.mime = (String)XMLParser.extractObjectForTags(buf, "mime");
        this.value = (FileParameter.FileRepresentation)XMLParser.extractObjectForTags(buf, "value");
        this.producer = (String)XMLParser.extractObjectForTags(buf, "producer");
        try {
            this.export = (Boolean)XMLParser.extractObjectForTags(buf, "export");
        }
        catch (NonParsableException e) {
            this.export = false;
        }
        this.extendedType = (String)XMLParser.extractObjectForTags(buf, "extype");
        try {
            this.isTempFile = (Boolean)XMLParser.extractObjectForTags(buf, "isTempFile");
        }
        catch (NonParsableException e) {
            this.isTempFile = true;
        }
    }

    @Override
    public FileParameter.FileRepresentation getValue() {
        return this.value;
    }

    public Object getProducer() {
        return this.producer;
    }
}

