/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.continuous.gamma;

import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.sequenceScores.statisticalModels.differentiable.continuous.gamma.IntegrableFunction;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import umontreal.ssj.util.Num;

public class GammaPriorFunction
extends DifferentiableFunction
implements IntegrableFunction {
    private double chi1;
    private double chi2;
    private double nu;

    public GammaPriorFunction(double mua, double mug, double ess) {
        this.chi1 = Math.log(mug);
        this.chi2 = -mua;
        this.nu = ess;
    }

    public double evaluateSecondOrderDerivativeAt(double[] x, int dimension) throws DimensionException, EvaluationException {
        double temp = Math.exp(this.nu * x[0] * Math.log(x[1]) - this.nu * Gamma.logOfGamma(x[0]) + this.nu * (this.chi1 * x[0] + this.chi2 * x[1]));
        if (dimension == 0) {
            return temp * this.nu * (this.nu * Math.pow(this.chi1 + Math.log(x[1]) - Num.digamma(x[0]), 2.0) - Num.trigamma(x[0]));
        }
        if (dimension == 1) {
            return temp / x[1] / x[1] * this.nu * (x[0] * (this.nu * x[0] - 1.0) + 2.0 * this.nu * this.chi2 * x[0] * x[1] + this.nu * this.chi2 * this.chi2 * x[1] * x[1]);
        }
        throw new EvaluationException("wrong dimension");
    }

    @Override
    public double[][] getLimits() {
        return new double[][]{{1.0E-10, Double.POSITIVE_INFINITY}, {1.0E-10, Double.POSITIVE_INFINITY}};
    }

    @Override
    public double[] evaluateGradientOfFunction(double[] x) throws DimensionException, EvaluationException {
        double temp = Math.exp(this.nu * x[0] * Math.log(x[1]) - this.nu * Gamma.logOfGamma(x[0]) + this.nu * (this.chi1 * x[0] + this.chi2 * x[1]));
        double[] grad = new double[]{temp * this.nu * (this.chi1 + Math.log(x[1]) - Num.digamma(x[0])), temp / x[1] * this.nu * (x[0] + this.chi2 * x[1])};
        return grad;
    }

    @Override
    public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        double currVal = -Gamma.logOfGamma(x[0]) + Math.log(x[1]) * x[0] + this.chi2 * x[1] + x[0] * this.chi1;
        currVal *= this.nu;
        currVal = Math.exp(currVal);
        return currVal;
    }

    @Override
    public int getDimensionOfScope() {
        return 2;
    }

    @Override
    public boolean isUnimodal() {
        return true;
    }
}

