/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.localMixture;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.sequenceScores.QuickScanningSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import de.jstacs.utils.random.DiMRGParams;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jstacs.utils.random.FastDirichletMRGParams;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.text.NumberFormat;
import java.util.Arrays;

public class LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder
extends AbstractDifferentiableStatisticalModel
implements Mutable,
QuickScanningSequenceScore {
    private int order;
    private int distance;
    private double ess;
    private double[] localMixtureScore;
    private double[][] ancestorScore;
    private double[][] depGrad;
    private double[][] componentMixtureParameters;
    private double[][][] ancestorMixtureParameters;
    private double[][][][] dependencyParameters;
    private double[] componentMixtureLogNorm;
    private double[][] ancestorMixtureLogNorm;
    private double[][][] dependencyLogNorm;
    private double[][] componentMixturePotential;
    private double[][][] ancestorMixturePotential;
    private double[][][][] dependencyPotential;
    private int[] componentMixtureIndex;
    private int[][] ancestorMixtureIndex;
    private int[][][] dependencyIndex;
    private int numParameter;
    private double q;
    private double[] e;
    private double[][] logGamma;
    private PriorType type;
    private int[] seq;
    private double[][] scoreHash;
    private static final String XML_TAG = "SLIM";

    public LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder(AlphabetContainer alphabets, int length, int order, int distance, double ess, double q, PriorType t) throws IllegalArgumentException {
        super(alphabets, length);
        if (!alphabets.isSimple()) {
            throw new IllegalArgumentException("Check alphabet");
        }
        if (ess < 0.0) {
            throw new IllegalArgumentException("Check ess");
        }
        this.ess = ess;
        if (order < 0) {
            throw new IllegalArgumentException("Check number of local components");
        }
        this.order = order;
        this.distance = distance;
        this.type = t;
        if (q <= 0.0 || q >= 1.0) {
            throw new IllegalArgumentException("Check q");
        }
        this.q = q;
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        this.dependencyParameters = new double[length][][][];
        this.componentMixtureParameters = new double[length][];
        this.ancestorMixtureParameters = new double[length][][];
        int l = 0;
        while (l < length) {
            this.componentMixtureParameters[l] = new double[Math.min(l, order) + 1];
            this.dependencyParameters[l] = new double[this.componentMixtureParameters[l].length][][];
            this.ancestorMixtureParameters[l] = new double[this.componentMixtureParameters[l].length][];
            int context = 1;
            int dist = 1;
            int o = 0;
            while (o < this.componentMixtureParameters[l].length) {
                this.dependencyParameters[l][o] = new double[context][a];
                if (o != 0) {
                    dist = Math.min(l - o + 1, distance);
                }
                this.ancestorMixtureParameters[l][o] = new double[dist];
                context *= a;
                ++o;
            }
            ++l;
        }
        this.initHash();
        this.init();
    }

    public LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.initHash();
        this.init();
    }

    public int getOrder() {
        return this.order;
    }

    public int getDistance() {
        return this.distance;
    }

    private void init() {
        int l;
        this.seq = new int[this.length];
        this.localMixtureScore = new double[this.order + 1];
        this.ancestorScore = new double[this.order + 1][this.length - 1];
        this.e = new double[this.order + 1];
        try {
            this.logGamma = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixtureParameters);
            this.componentMixturePotential = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixtureParameters);
            this.componentMixtureLogNorm = new double[this.length];
            this.componentMixtureIndex = new int[this.length];
            this.ancestorMixturePotential = (double[][][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureParameters);
            this.dependencyPotential = (double[][][][])ArrayHandler.clone((Cloneable[])this.dependencyParameters);
            this.dependencyLogNorm = new double[this.length][][];
            this.dependencyIndex = new int[this.length][][];
            this.ancestorMixtureLogNorm = new double[this.length][];
            this.ancestorMixtureIndex = new int[this.length][];
            l = 0;
            while (l < this.length) {
                this.dependencyLogNorm[l] = new double[this.componentMixtureParameters[l].length][];
                this.dependencyIndex[l] = new int[this.componentMixtureParameters[l].length][];
                int o = 0;
                while (o < this.componentMixtureParameters[l].length) {
                    this.dependencyLogNorm[l][o] = new double[this.dependencyParameters[l][o].length];
                    this.dependencyIndex[l][o] = new int[this.dependencyParameters[l][o].length];
                    ++o;
                }
                this.ancestorMixtureLogNorm[l] = new double[this.componentMixtureParameters[l].length];
                this.ancestorMixtureIndex[l] = new int[this.componentMixtureParameters[l].length];
                ++l;
            }
            int a = (int)this.alphabets.getAlphabetLengthAt(0);
            this.depGrad = new double[this.dependencyParameters[this.length - 1][this.dependencyParameters[this.length - 1].length - 1].length][a];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.precompute();
        this.numParameter = 0;
        l = 0;
        while (l < this.length) {
            this.componentMixtureIndex[l] = this.numParameter;
            this.numParameter += this.componentMixtureParameters[l].length;
            int c = 0;
            while (c < this.componentMixtureParameters[l].length) {
                this.ancestorMixtureIndex[l][c] = this.numParameter;
                this.numParameter += this.ancestorMixtureParameters[l][c].length;
                int b = 0;
                while (b < this.dependencyParameters[l][c].length) {
                    this.dependencyIndex[l][c][b] = this.numParameter;
                    this.numParameter += this.dependencyParameters[l][c][b].length;
                    ++b;
                }
                ++c;
            }
            ++l;
        }
        if (this.type == PriorType.Complex_Mixture) {
            this.precomputeLogGamma();
        }
    }

    private void initHash() {
        if (this.distance < 8) {
            this.scoreHash = new double[this.length][];
            int i = 0;
            while (i < this.scoreHash.length) {
                int l = Math.min(this.distance + 1, i + 1);
                int dim = (int)Math.pow((int)this.alphabets.getAlphabetLengthAt(i), l);
                this.scoreHash[i] = new double[dim];
                Arrays.fill(this.scoreHash[i], Double.NaN);
                ++i;
            }
        } else {
            this.scoreHash = null;
        }
    }

    private void clearHash() {
        if (this.scoreHash != null) {
            int i = 0;
            while (i < this.scoreHash.length) {
                Arrays.fill(this.scoreHash[i], 1.0);
                ++i;
            }
        }
    }

    private void precompute() {
        int l = 0;
        while (l < this.length) {
            this.componentMixtureLogNorm[l] = Normalisation.logSumNormalisation(this.componentMixtureParameters[l], 0, this.componentMixtureParameters[l].length, this.componentMixturePotential[l], 0);
            int c = 0;
            while (c < this.componentMixtureParameters[l].length) {
                this.ancestorMixtureLogNorm[l][c] = Normalisation.logSumNormalisation(this.ancestorMixtureParameters[l][c], 0, this.ancestorMixtureParameters[l][c].length, this.ancestorMixturePotential[l][c], 0);
                int b = 0;
                while (b < this.dependencyParameters[l][c].length) {
                    this.dependencyLogNorm[l][c][b] = Normalisation.logSumNormalisation(this.dependencyParameters[l][c][b], 0, this.dependencyParameters[l][c][b].length, this.dependencyPotential[l][c][b], 0);
                    ++b;
                }
                ++c;
            }
            ++l;
        }
        this.clearHash();
    }

    @Override
    public LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder clone() throws CloneNotSupportedException {
        LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder clone = (LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder)super.clone();
        clone.seq = (int[])this.seq.clone();
        clone.componentMixtureParameters = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixtureParameters);
        clone.ancestorMixtureParameters = (double[][][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureParameters);
        clone.dependencyParameters = (double[][][][])ArrayHandler.clone((Cloneable[])this.dependencyParameters);
        clone.componentMixtureLogNorm = (double[])this.componentMixtureLogNorm.clone();
        clone.ancestorMixtureLogNorm = (double[][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureLogNorm);
        clone.dependencyLogNorm = (double[][][])ArrayHandler.clone((Cloneable[])this.dependencyLogNorm);
        clone.componentMixturePotential = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixturePotential);
        clone.ancestorMixturePotential = (double[][][])ArrayHandler.clone((Cloneable[])this.ancestorMixturePotential);
        clone.dependencyPotential = (double[][][][])ArrayHandler.clone((Cloneable[])this.dependencyPotential);
        clone.componentMixtureIndex = (int[])this.componentMixtureIndex.clone();
        clone.ancestorMixtureIndex = (int[][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureIndex);
        clone.dependencyIndex = (int[][][])ArrayHandler.clone((Cloneable[])this.dependencyIndex);
        clone.localMixtureScore = (double[])this.localMixtureScore.clone();
        clone.ancestorScore = (double[][])ArrayHandler.clone((Cloneable[])this.ancestorScore);
        clone.depGrad = (double[][])ArrayHandler.clone((Cloneable[])this.depGrad);
        clone.e = (double[])this.e.clone();
        clone.logGamma = (double[][])ArrayHandler.clone((Cloneable[])this.logGamma);
        clone.clearHash();
        return clone;
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        double f = this.ess == 0.0 ? (double)(a * (this.order + 1)) : this.ess;
        int l = 0;
        while (l < this.length) {
            if (this.type == PriorType.Complex_Mixture && this.componentMixtureParameters[l].length > 1) {
                int idx = (int)Math.floor(r.nextDouble() * (double)this.componentMixtureParameters[l].length);
                double v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
                Arrays.fill(this.e, v * f);
                this.e[idx] = this.q * f;
            } else {
                Arrays.fill(this.e, f / (double)this.componentMixtureParameters[l].length);
            }
            LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.draw(this.componentMixtureParameters[l], this.componentMixtureParameters[l].length, new DirichletMRGParams(0, this.componentMixtureParameters[l].length, this.e));
            int c = 0;
            while (c < this.componentMixtureParameters[l].length) {
                int k = this.ancestorMixtureParameters[l][c].length;
                LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.draw(this.ancestorMixtureParameters[l][c], k, new FastDirichletMRGParams(this.e[c] / (double)k));
                FastDirichletMRGParams depPars = new FastDirichletMRGParams(this.e[c] / (double)(this.dependencyParameters[l][c].length * a));
                int b = 0;
                while (b < this.dependencyParameters[l][c].length) {
                    LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.draw(this.dependencyParameters[l][c][b], a, depPars);
                    ++b;
                }
                ++c;
            }
            ++l;
        }
        this.precompute();
    }

    static void draw(double[] array, int end, DiMRGParams pars) {
        if (end > 1) {
            DirichletMRG.DEFAULT_INSTANCE.generateLog(array, 0, end, pars);
        }
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        int l = 0;
        while (l < this.length) {
            Arrays.fill(this.componentMixtureParameters[l], Math.log(this.q / ((double)this.componentMixtureParameters[l].length - 1.0)));
            this.componentMixtureParameters[l][0] = Math.log(1.0 - this.q);
            int c = 0;
            while (c < this.componentMixtureParameters[l].length) {
                Arrays.fill(this.ancestorMixtureParameters[l][c], 0.0);
                int b = 0;
                while (b < this.dependencyParameters[l][c].length) {
                    Arrays.fill(this.dependencyParameters[l][c][b], Math.exp(this.componentMixtureParameters[l][c]) / (double)this.dependencyParameters[l][c].length / (double)this.dependencyParameters[l][c][b].length);
                    ++b;
                }
                ++c;
            }
            ++l;
        }
        double w = 1.0;
        int a = this.alphabets.getAlphabetIndexForPosition(0);
        int i = 0;
        while (i < data[index].getNumberOfElements()) {
            if (weights != null && weights[index] != null) {
                w = weights[index][i];
            }
            Sequence s = data[index].getElementAt(i);
            int l2 = 0;
            while (l2 < this.length) {
                int c = 0;
                while (c < this.componentMixtureParameters[l2].length) {
                    int context = this.getOffset(s, l2, c, this.dependencyParameters[0][0][0].length);
                    int k = 0;
                    while (k < this.ancestorMixtureParameters[l2][c].length) {
                        context = this.next(context, s, 0, l2, c, k);
                        double[] dArray = this.dependencyParameters[l2][c][context];
                        int n = s.discreteVal(l2);
                        dArray[n] = dArray[n] + w;
                        ++k;
                    }
                    ++c;
                }
                ++l2;
            }
            ++i;
        }
        int l3 = 0;
        while (l3 < this.length) {
            int c = 0;
            while (c < this.componentMixtureParameters[l3].length) {
                int b = 0;
                while (b < this.dependencyParameters[l3][c].length) {
                    Normalisation.sumNormalisation(this.dependencyParameters[l3][c][b]);
                    a = 0;
                    while (a < this.dependencyParameters[l3][c][b].length) {
                        this.dependencyParameters[l3][c][b][a] = Math.log(this.dependencyParameters[l3][c][b][a]);
                        ++a;
                    }
                    ++b;
                }
                ++c;
            }
            ++l3;
        }
        this.precompute();
    }

    private double unifGamma(double e, int anz) {
        return (double)anz * Gamma.logOfGamma(e / (double)anz) - Gamma.logOfGamma(e);
    }

    private double precomputePartLogGamma(int l) {
        double lg = 0.0;
        int i = 0;
        while (i < this.componentMixtureParameters[l].length) {
            lg += Gamma.logOfGamma(this.e[i]) * this.componentMixtureParameters[l][i];
            ++i;
        }
        lg -= Gamma.logOfGamma(this.ess);
        int c = 0;
        while (c < this.componentMixtureParameters[l].length) {
            lg += this.unifGamma(this.e[c], this.ancestorMixtureParameters[l][c].length);
            int b = 0;
            while (b < this.dependencyParameters[l][c].length) {
                lg += this.unifGamma(this.e[c] / (double)this.dependencyParameters[l][c].length, this.dependencyParameters[l][c][b].length);
                ++b;
            }
            ++c;
        }
        return lg;
    }

    private void precomputeLogGamma() {
        int l = 0;
        while (l < this.length) {
            double v;
            double w;
            if (this.componentMixtureParameters[l].length == 1) {
                w = 1.0;
                v = 0.0;
            } else {
                w = this.q;
                v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
            }
            Arrays.fill(this.e, v * this.ess);
            int i = 0;
            while (i < this.componentMixtureParameters[l].length) {
                this.e[i] = w * this.ess;
                double[] dArray = this.logGamma[l];
                int n = i;
                dArray[n] = dArray[n] + this.precomputePartLogGamma(l);
                this.e[i] = v * this.ess;
                ++i;
            }
            ++l;
        }
    }

    private static final double logPrior(double ess, double[] parameter, double logNorm) {
        double res = 0.0;
        double e = ess / (double)parameter.length;
        int i = 0;
        while (i < parameter.length) {
            res += e * parameter[i];
            ++i;
        }
        return res - ess * logNorm;
    }

    private void setLogPriorTerm(int l, int index, double logP) {
        this.localMixtureScore[index] = logP;
        int i = 0;
        while (i < this.componentMixtureParameters[l].length) {
            int n = index;
            this.localMixtureScore[n] = this.localMixtureScore[n] + this.e[i] * this.componentMixtureParameters[l][i];
            ++i;
        }
        int n = index;
        this.localMixtureScore[n] = this.localMixtureScore[n] - this.ess * this.componentMixtureLogNorm[l];
        int c = 0;
        while (c < this.componentMixtureParameters[l].length) {
            int n2 = index;
            this.localMixtureScore[n2] = this.localMixtureScore[n2] + LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.logPrior(this.e[c], this.ancestorMixtureParameters[l][c], this.ancestorMixtureLogNorm[l][c]);
            int b = 0;
            while (b < this.dependencyParameters[l][c].length) {
                int n3 = index;
                this.localMixtureScore[n3] = this.localMixtureScore[n3] + LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.logPrior(this.e[c] / (double)this.dependencyParameters[l][c].length, this.dependencyParameters[l][c][b], this.dependencyLogNorm[l][c][b]);
                ++b;
            }
            ++c;
        }
    }

    @Override
    public double getLogPriorTerm() {
        double logPrior = 0.0;
        double logP = 0.0;
        int l = 0;
        while (l < this.length) {
            double v;
            double w;
            if (this.componentMixtureParameters[l].length == 1) {
                w = 1.0;
                v = 0.0;
            } else {
                w = this.q;
                v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
            }
            switch (this.type) {
                case BDeu: {
                    Arrays.fill(this.e, this.ess / (double)this.componentMixtureParameters[l].length);
                    this.setLogPriorTerm(l, 0, 1.0);
                    logPrior += this.localMixtureScore[0];
                    break;
                }
                case Complex_Mixture: {
                    Arrays.fill(this.e, v * this.ess);
                    int i = 0;
                    while (i < this.componentMixtureParameters[l].length) {
                        this.e[i] = w * this.ess;
                        this.setLogPriorTerm(l, i, logP);
                        int n = i;
                        this.localMixtureScore[n] = this.localMixtureScore[n] + this.logGamma[l][i];
                        this.e[i] = v * this.ess;
                        ++i;
                    }
                    logPrior += Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
                    break;
                }
                case Simple_Mixture: {
                    int c = 0;
                    while (c < this.componentMixtureParameters[l].length) {
                        this.localMixtureScore[c] = 0.0;
                        int i = 0;
                        while (i < this.componentMixtureParameters[l].length) {
                            int n = c;
                            this.localMixtureScore[n] = this.localMixtureScore[n] + (i == c ? w : v) * this.ess * this.componentMixtureParameters[l][i];
                            ++i;
                        }
                        int n = c++;
                        this.localMixtureScore[n] = this.localMixtureScore[n] - this.ess * this.componentMixtureLogNorm[l];
                    }
                    logPrior += Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
                    double e = this.ess / (double)this.componentMixtureParameters[l].length;
                    int c2 = 0;
                    while (c2 < this.componentMixtureParameters[l].length) {
                        logPrior += LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.logPrior(e, this.ancestorMixtureParameters[l][c2], this.ancestorMixtureLogNorm[l][c2]);
                        int b = 0;
                        while (b < this.dependencyParameters[l][c2].length) {
                            logPrior += LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.logPrior(e / (double)this.dependencyParameters[l][c2].length, this.dependencyParameters[l][c2][b], this.dependencyLogNorm[l][c2][b]);
                            ++b;
                        }
                        ++c2;
                    }
                    break;
                }
            }
            ++l;
        }
        return logPrior;
    }

    private static final void addGrad(double ess, double[] potential, double[] grad, int start, double w) {
        double e = ess / (double)potential.length;
        int i = 0;
        while (i < potential.length) {
            int n = start + i;
            grad[n] = grad[n] + w * (e - ess * potential[i]);
            ++i;
        }
    }

    private void addGradientPartOfLogPriorTerm(double[] grad, int start, int l, double w) throws Exception {
        int i = 0;
        while (i < this.componentMixtureParameters[l].length) {
            int n = start + this.componentMixtureIndex[l] + i;
            grad[n] = grad[n] + w * (this.e[i] - this.ess * this.componentMixturePotential[l][i]);
            ++i;
        }
        int c = 0;
        while (c < this.componentMixtureParameters[l].length) {
            LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.addGrad(this.e[c], this.ancestorMixturePotential[l][c], grad, start + this.ancestorMixtureIndex[l][c], w);
            int b = 0;
            while (b < this.dependencyParameters[l][c].length) {
                LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.addGrad(this.e[c] / (double)this.dependencyParameters[l][c].length, this.dependencyPotential[l][c][b], grad, start + this.dependencyIndex[l][c][b], w);
                ++b;
            }
            ++c;
        }
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        double logP = 0.0;
        int l = 0;
        while (l < this.length) {
            double v;
            double w;
            if (this.componentMixtureParameters[l].length == 1) {
                w = 1.0;
                v = 0.0;
            } else {
                w = this.q;
                v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
            }
            switch (this.type) {
                case BDeu: {
                    Arrays.fill(this.e, this.ess / (double)this.componentMixtureParameters[l].length);
                    this.addGradientPartOfLogPriorTerm(grad, start, l, 1.0);
                    break;
                }
                case Complex_Mixture: {
                    Arrays.fill(this.e, v * this.ess);
                    int i = 0;
                    while (i < this.componentMixtureParameters[l].length) {
                        this.e[i] = w * this.ess;
                        this.setLogPriorTerm(l, i, logP);
                        this.e[i] = v * this.ess;
                        ++i;
                    }
                    Normalisation.logSumNormalisation(this.localMixtureScore, 0, this.componentMixtureParameters[l].length);
                    i = 0;
                    while (i < this.componentMixtureParameters[l].length) {
                        this.e[i] = w * this.ess;
                        this.addGradientPartOfLogPriorTerm(grad, start, l, this.localMixtureScore[i]);
                        this.e[i] = v * this.ess;
                        ++i;
                    }
                    break;
                }
                case Simple_Mixture: {
                    int i;
                    int c = 0;
                    while (c < this.componentMixtureParameters[l].length) {
                        this.localMixtureScore[c] = 0.0;
                        i = 0;
                        while (i < this.componentMixtureParameters[l].length) {
                            int n = c;
                            this.localMixtureScore[n] = this.localMixtureScore[n] + (i == c ? w : v) * this.ess * this.componentMixtureParameters[l][i];
                            ++i;
                        }
                        int n = c++;
                        this.localMixtureScore[n] = this.localMixtureScore[n] - this.ess * this.componentMixtureLogNorm[l];
                    }
                    Normalisation.logSumNormalisation(this.localMixtureScore, 0, this.componentMixtureParameters[l].length);
                    c = 0;
                    while (c < this.componentMixtureParameters[l].length) {
                        i = 0;
                        while (i < this.componentMixtureParameters[l].length) {
                            int n = start + this.componentMixtureIndex[l] + c;
                            grad[n] = grad[n] + this.localMixtureScore[i] * (i == c ? w : v) * this.ess;
                            ++i;
                        }
                        int n = start + this.componentMixtureIndex[l] + c;
                        grad[n] = grad[n] - this.ess * this.componentMixturePotential[l][c];
                        ++c;
                    }
                    double e = this.ess / (double)this.componentMixtureParameters[l].length;
                    int c2 = 0;
                    while (c2 < this.componentMixtureParameters[l].length) {
                        LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.addGrad(e, this.ancestorMixturePotential[l][c2], grad, start + this.ancestorMixtureIndex[l][c2], 1.0);
                        int b = 0;
                        while (b < this.dependencyParameters[l][c2].length) {
                            LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.addGrad(e / (double)this.dependencyParameters[l][c2].length, this.dependencyPotential[l][c2][b], grad, start + this.dependencyIndex[l][c2][b], 1.0);
                            ++b;
                        }
                        ++c2;
                    }
                    break;
                }
            }
            ++l;
        }
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    private int getOffset(Sequence seq, int start, int order, int a) {
        int offset = 0;
        int o = 1;
        while (o < order) {
            offset = offset * a + seq.discreteVal(start - o);
            ++o;
        }
        return offset;
    }

    private int getOffset(int[] seq, int start, int order, int a) {
        int offset = 0;
        int o = 1;
        while (o < order) {
            offset = offset * a + seq[start - o];
            ++o;
        }
        return offset;
    }

    private int next(int context, Sequence seq, int start, int l, int c, int m) {
        return (context * this.dependencyParameters[l][c][0].length + seq.discreteVal(start + l - c - m)) % this.dependencyParameters[l][c].length;
    }

    private int next(int context, int[] seq, int start, int l, int c, int m) {
        return (context * this.dependencyParameters[l][c][0].length + seq[start + l - c - m]) % this.dependencyParameters[l][c].length;
    }

    @Override
    public boolean[][] getInfixFilter(int kmer, double thresh, int ... start) {
        if (this.order > 1) {
            throw new RuntimeException("Not implemented");
        }
        double[][] val = this.getCum_Complex(kmer);
        double[] cum = val[0];
        double[] revCum = val[1];
        int a = this.dependencyParameters[0][0][0].length;
        boolean[][] use = new boolean[start.length][(int)Math.pow(a, kmer)];
        int maxSymbol = a - 1;
        int z = 0;
        int[] seq = new int[kmer + 1];
        double[][] prefixScore = new double[start.length][kmer + 1];
        int l = 0;
        double[] best = new double[start.length];
        Arrays.fill(best, Double.NEGATIVE_INFINITY);
        do {
            int s = 0;
            while (s < start.length) {
                this.getInfixScores(s, start[s], l, kmer, seq, prefixScore, null);
                if (prefixScore[s][kmer] > best[s]) {
                    best[s] = prefixScore[s][kmer];
                }
                use[s][z] = cum[start[s]] + prefixScore[s][kmer] + revCum[start[s] + kmer] >= thresh;
                ++s;
            }
            ++z;
            l = kmer - 1 - LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.next(seq, maxSymbol);
        } while (seq[kmer] == 0);
        return use;
    }

    protected double[][] getCum_Naive(int kmer) {
        int len = this.getLength();
        double[] max = new double[len];
        double[] cum = new double[len + 1];
        double[] revCum = new double[len + 1];
        double last = 0.0;
        int l = 0;
        while (l < max.length) {
            max[l] = Double.NEGATIVE_INFINITY;
            int a = 0;
            while (a < this.dependencyPotential[l][0][0].length) {
                double v = 0.0;
                int c = 0;
                while (c < this.componentMixtureParameters[l].length) {
                    int an = 0;
                    int i = 1;
                    while (i < this.dependencyParameters[l][c].length) {
                        if (this.dependencyPotential[l][c][an][a] < this.dependencyPotential[l][c][i][a]) {
                            an = i;
                        }
                        ++i;
                    }
                    this.localMixtureScore[c] = this.componentMixtureParameters[l][c] - this.componentMixtureLogNorm[l] + this.dependencyParameters[l][c][an][a] - this.dependencyLogNorm[l][c][an];
                    ++c;
                }
                v = Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
                if (v > max[l]) {
                    max[l] = v;
                }
                ++a;
            }
            cum[l + 1] = last + max[l];
            last = cum[l + 1];
            ++l;
        }
        last = 0.0;
        l = len - 1;
        while (l >= 0) {
            revCum[l] = last + max[l];
            last = revCum[l];
            --l;
        }
        return new double[][]{cum, revCum};
    }

    protected double[][] getCum_Complex(int kmer) {
        int s;
        int start = this.getLength() - kmer + 1;
        int len = this.getLength();
        double[][] max = new double[kmer][];
        int k = 0;
        while (k < max.length) {
            max[k] = new double[len - k];
            Arrays.fill(max[k], Double.NEGATIVE_INFINITY);
            ++k;
        }
        int a = this.dependencyParameters[0][0][0].length;
        double[][] prefixScore = new double[len][kmer + 1];
        int maxSymbol = a - 1;
        int[] seq = new int[kmer + 1];
        int l = 0;
        do {
            s = 0;
            while (s < start) {
                this.getInfixScores(s, s, l, kmer, seq, prefixScore, max);
                ++s;
            }
            l = kmer - 1 - LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.next(seq, maxSymbol);
        } while (seq[kmer] == 0);
        s = start;
        while (s < len) {
            int gmer = len - s;
            Arrays.fill(seq, 0);
            l = 0;
            do {
                this.getInfixScores(s, s, l, gmer, seq, prefixScore, max);
                l = gmer - 1 - LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.next(seq, maxSymbol);
            } while (seq[gmer] == 0);
            ++s;
        }
        double[] cum = new double[len + 1];
        Arrays.fill(cum, Double.POSITIVE_INFINITY);
        cum[0] = 0.0;
        int i = 0;
        while (i < len) {
            int j = Math.min(i, kmer - 1);
            while (j >= 0) {
                if (cum[i + 1] > cum[i - j] + max[j][i - j]) {
                    cum[i + 1] = cum[i - j] + max[j][i - j];
                }
                --j;
            }
            ++i;
        }
        double[] revCum = new double[len + 1];
        Arrays.fill(revCum, Double.POSITIVE_INFINITY);
        revCum[len] = 0.0;
        i = len - 1;
        while (i >= 0) {
            int j = Math.min(len - 1 - i, kmer - 1);
            while (j >= 0) {
                if (revCum[i] > revCum[i + 1 + j] + max[j][i]) {
                    revCum[i] = revCum[i + 1 + j] + max[j][i];
                }
                --j;
            }
            --i;
        }
        return new double[][]{cum, revCum};
    }

    protected void getInfixScores(int s, int start, int l, int kmer, int[] seq, double[][] prefixScore, double[][] max) {
        while (l < kmer) {
            int pos = l + start;
            int ll = kmer - 1 - l;
            int current = seq[ll];
            this.localMixtureScore[0] = this.componentMixtureParameters[pos][0] - this.componentMixtureLogNorm[pos] + this.dependencyParameters[pos][0][0][current] - this.dependencyLogNorm[pos][0][0];
            int c = 1;
            while (c < this.componentMixtureParameters[pos].length) {
                int g = this.ancestorMixtureParameters[pos][c].length;
                int m = 0;
                while (m < g) {
                    int an;
                    if (ll + c + m < kmer) {
                        an = seq[ll + c + m];
                    } else {
                        an = 0;
                        int i = 1;
                        while (i < this.dependencyParameters[pos][c].length) {
                            if (this.dependencyPotential[pos][c][an][current] < this.dependencyPotential[pos][c][i][current]) {
                                an = i;
                            }
                            ++i;
                        }
                    }
                    this.ancestorScore[c][m] = this.ancestorMixtureParameters[pos][c][m] - this.ancestorMixtureLogNorm[pos][c] + this.dependencyParameters[pos][c][an][current] - this.dependencyLogNorm[pos][c][an];
                    ++m;
                }
                this.localMixtureScore[c] = this.componentMixtureParameters[pos][c] - this.componentMixtureLogNorm[pos] + Normalisation.getLogSum(0, g, this.ancestorScore[c]);
                ++c;
            }
            double score = Normalisation.getLogSum(0, this.componentMixtureParameters[pos].length, this.localMixtureScore);
            prefixScore[s][l + 1] = prefixScore[s][l] + score;
            if (max != null && prefixScore[s][l + 1] > max[l][s]) {
                max[l][s] = prefixScore[s][l + 1];
            }
            ++l;
        }
    }

    private static int next(int[] seq, int maxSymbol) {
        int i = 0;
        while (seq[i] == maxSymbol) {
            seq[i++] = 0;
        }
        int n = i;
        seq[n] = seq[n] + 1;
        return i;
    }

    @Override
    public double getLogScoreFor(Sequence seq2, int start) {
        int i = 0;
        while (i < this.seq.length) {
            this.seq[i] = seq2.discreteVal(start + i);
            ++i;
        }
        int al = (int)this.alphabets.getAlphabetLengthAt(0);
        int pw = (int)Math.pow(al, this.distance);
        double score = 0.0;
        int idx = 0;
        int l = 0;
        while (l < this.length) {
            if (l > this.distance) {
                idx %= pw;
            }
            idx = idx * al + this.seq[l];
            double hscore = 1.0;
            if (this.scoreHash != null) {
                hscore = this.scoreHash[l][idx];
            }
            if (hscore > 0.0) {
                int current = this.seq[l];
                this.localMixtureScore[0] = this.componentMixtureParameters[l][0] - this.componentMixtureLogNorm[l] + this.dependencyParameters[l][0][0][current] - this.dependencyLogNorm[l][0][0];
                int c = 1;
                while (c < this.componentMixtureParameters[l].length) {
                    int k = this.ancestorMixtureParameters[l][c].length;
                    int an = this.getOffset(this.seq, l, c, this.dependencyParameters[0][0][0].length);
                    int l1 = this.dependencyParameters[l][c][0].length;
                    int l2 = this.dependencyParameters[l][c].length;
                    int m = 0;
                    while (m < k) {
                        an = (an * l1 + this.seq[l - c - m]) % l2;
                        this.ancestorScore[c][m] = this.ancestorMixtureParameters[l][c][m] - this.ancestorMixtureLogNorm[l][c] + this.dependencyParameters[l][c][an][current] - this.dependencyLogNorm[l][c][an];
                        ++m;
                    }
                    this.localMixtureScore[c] = this.componentMixtureParameters[l][c] - this.componentMixtureLogNorm[l] + Normalisation.getLogSum(0, k, this.ancestorScore[c]);
                    ++c;
                }
                hscore = Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
                if (this.scoreHash != null) {
                    this.scoreHash[l][idx] = hscore;
                }
            }
            score += hscore;
            ++l;
        }
        return score;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double score = 0.0;
        int l = 0;
        while (l < this.length) {
            int m;
            int an;
            int k;
            int current = seq.discreteVal(start + l);
            this.localMixtureScore[0] = this.componentMixtureParameters[l][0] - this.componentMixtureLogNorm[l] + this.dependencyParameters[l][0][0][current] - this.dependencyLogNorm[l][0][0];
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                k = this.ancestorMixtureParameters[l][c].length;
                an = this.getOffset(seq, start + l, c, this.dependencyParameters[0][0][0].length);
                m = 0;
                while (m < k) {
                    an = this.next(an, seq, start, l, c, m);
                    this.ancestorScore[c][m] = this.ancestorMixtureParameters[l][c][m] - this.ancestorMixtureLogNorm[l][c] + this.dependencyParameters[l][c][an][current] - this.dependencyLogNorm[l][c][an];
                    ++m;
                }
                this.localMixtureScore[c] = this.componentMixtureParameters[l][c] - this.componentMixtureLogNorm[l] + Normalisation.logSumNormalisation(this.ancestorScore[c], 0, k);
                ++c;
            }
            score += Normalisation.logSumNormalisation(this.localMixtureScore, 0, this.componentMixtureParameters[l].length);
            c = 0;
            while (c < this.componentMixtureParameters[l].length) {
                indices.add(this.componentMixtureIndex[l] + c);
                partialDer.add(this.localMixtureScore[c] - this.componentMixturePotential[l][c]);
                ++c;
            }
            int a = 0;
            while (a < this.dependencyParameters[l][0][0].length) {
                indices.add(this.dependencyIndex[l][0][0] + a);
                partialDer.add(this.localMixtureScore[0] * ((double)(a == current ? 1 : 0) - this.dependencyPotential[l][0][0][a]));
                ++a;
            }
            c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                int a2 = 0;
                while (a2 < this.dependencyParameters[l][c].length) {
                    Arrays.fill(this.depGrad[a2], 0.0);
                    ++a2;
                }
                k = this.ancestorMixtureParameters[l][c].length;
                an = this.getOffset(seq, start + l, c, this.dependencyParameters[0][0][0].length);
                m = 0;
                while (m < k) {
                    indices.add(this.ancestorMixtureIndex[l][c] + m);
                    partialDer.add(this.localMixtureScore[c] * (this.ancestorScore[c][m] - this.ancestorMixturePotential[l][c][m]));
                    an = this.next(an, seq, start, l, c, m);
                    int a3 = 0;
                    while (a3 < this.depGrad[an].length) {
                        double[] dArray = this.depGrad[an];
                        int n = a3;
                        dArray[n] = dArray[n] + this.ancestorScore[c][m] * ((double)(a3 == current ? 1 : 0) - this.dependencyPotential[l][c][an][a3]);
                        ++a3;
                    }
                    ++m;
                }
                int a4 = 0;
                while (a4 < this.dependencyParameters[l][c].length) {
                    int b = 0;
                    while (b < this.dependencyParameters[l][c][a4].length) {
                        if (this.depGrad[a4][b] != 0.0) {
                            indices.add(this.dependencyIndex[l][c][a4] + b);
                            partialDer.add(this.localMixtureScore[c] * this.depGrad[a4][b]);
                        }
                        ++b;
                    }
                    ++a4;
                }
                ++c;
            }
            ++l;
        }
        return score;
    }

    @Override
    public int getNumberOfParameters() {
        return this.numParameter;
    }

    private void get(int start, double[] parameter, double[] array) {
        int i = 0;
        while (i < parameter.length) {
            array[start + i] = parameter[i];
            ++i;
        }
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        double[] res = new double[this.numParameter];
        int l = 0;
        while (l < this.length) {
            this.get(this.componentMixtureIndex[l], this.componentMixtureParameters[l], res);
            int c = 0;
            while (c < this.componentMixtureParameters[l].length) {
                this.get(this.ancestorMixtureIndex[l][c], this.ancestorMixtureParameters[l][c], res);
                int b = 0;
                while (b < this.dependencyParameters[l][c].length) {
                    this.get(this.dependencyIndex[l][c][b], this.dependencyParameters[l][c][b], res);
                    ++b;
                }
                ++c;
            }
            ++l;
        }
        return res;
    }

    private void set(int start, double[] parameter, double[] array) {
        int i = 0;
        while (i < parameter.length) {
            parameter[i] = array[start + i];
            ++i;
        }
    }

    public void set(int position, double[] pars) {
        int i = 0;
        while (i < this.dependencyParameters[position].length) {
            int j = 0;
            while (j < this.dependencyParameters[position][i].length) {
                System.arraycopy(pars, 0, this.dependencyParameters[position][i][j], 0, pars.length);
                ++j;
            }
            ++i;
        }
        Arrays.fill(this.componentMixtureParameters[position], -1000.0);
        this.componentMixtureParameters[position][0] = 0.0;
        this.precompute();
    }

    @Override
    public void setParameters(double[] params, int start) {
        int l = 0;
        while (l < this.length) {
            this.set(start + this.componentMixtureIndex[l], this.componentMixtureParameters[l], params);
            int c = 0;
            while (c < this.componentMixtureParameters[l].length) {
                this.set(start + this.ancestorMixtureIndex[l][c], this.ancestorMixtureParameters[l][c], params);
                int b = 0;
                while (b < this.dependencyParameters[l][c].length) {
                    this.set(start + this.dependencyIndex[l][c][b], this.dependencyParameters[l][c][b], params);
                    ++b;
                }
                ++c;
            }
            ++l;
        }
        this.precompute();
    }

    @Override
    public String getInstanceName() {
        return "slim(" + this.order + ", " + this.distance + ", " + (Object)((Object)this.type) + " " + this.ess + " " + this.q + ")";
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        XMLParser.appendObjectWithTags(xml, this.order, "order");
        XMLParser.appendObjectWithTags(xml, this.distance, "distance");
        XMLParser.appendObjectWithTags(xml, this.ess, "ess");
        XMLParser.appendObjectWithTags(xml, this.componentMixtureParameters, "componentMixtureParameters");
        XMLParser.appendObjectWithTags(xml, this.ancestorMixtureParameters, "ancestorMixtureParameters");
        XMLParser.appendObjectWithTags(xml, this.dependencyParameters, "dependencyParameters");
        XMLParser.appendObjectWithTags(xml, (Object)this.type, "priorType");
        XMLParser.appendObjectWithTags(xml, this.q, "q");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabets");
        this.length = (Integer)XMLParser.extractObjectForTags(xml, "length");
        this.order = (Integer)XMLParser.extractObjectForTags(xml, "order");
        this.distance = (Integer)XMLParser.extractObjectForTags(xml, "distance");
        this.ess = (Double)XMLParser.extractObjectForTags(xml, "ess");
        this.componentMixtureParameters = (double[][])XMLParser.extractObjectForTags(xml, "componentMixtureParameters");
        this.ancestorMixtureParameters = (double[][][])XMLParser.extractObjectForTags(xml, "ancestorMixtureParameters");
        this.dependencyParameters = (double[][][][])XMLParser.extractObjectForTags(xml, "dependencyParameters");
        this.type = (PriorType)((Object)XMLParser.extractObjectForTags(xml, "priorType"));
        this.q = (Double)XMLParser.extractObjectForTags(xml, "q");
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer res = new StringBuffer();
        DiscreteAlphabet abc = (DiscreteAlphabet)this.alphabets.getAlphabetAt(0);
        int l = 0;
        while (l < this.length) {
            int c = 0;
            while (c < this.componentMixtureParameters[l].length) {
                res.append("P_" + l + "(c=" + c + ")=" + nf.format(this.componentMixturePotential[l][c]) + "\n");
                if (c != 0) {
                    res.append("P_" + l + "(p|c=" + c + ")=" + ToolBox.toString(this.ancestorMixturePotential[l][c], nf) + "\n");
                }
                int b = 0;
                while (b < this.dependencyParameters[l][c].length) {
                    res.append("P_" + l + "(x|");
                    if (c > 0) {
                        int h = b;
                        res.append("y=");
                        int j = 0;
                        while (j < c) {
                            res.append(abc.getSymbolAt(h % this.dependencyParameters[0][0][0].length));
                            h /= this.dependencyParameters[0][0][0].length;
                            ++j;
                        }
                        res.append(",");
                    }
                    res.append("c=" + c + ")=" + ToolBox.toString(this.dependencyPotential[l][c][b], nf) + "\n");
                    ++b;
                }
                res.append("\n");
                ++c;
            }
            res.append("\n");
            ++l;
        }
        return String.valueOf(res.toString()) + this.getGraphviz();
    }

    public double[][][] getConditionalProbabilities(int component) throws CloneNotSupportedException {
        double[][][] condProbs = new double[this.dependencyPotential.length][][];
        int i = 0;
        while (i < condProbs.length) {
            condProbs[i] = this.dependencyPotential[i].length > component ? (double[][])ArrayHandler.clone((Cloneable[])this.dependencyPotential[i][component]) : new double[0][0];
            ++i;
        }
        return condProbs;
    }

    public double[][] getPWMParameters() throws CloneNotSupportedException {
        double[][] pwm = new double[this.length][];
        int l = 0;
        while (l < this.length) {
            pwm[l] = (double[])this.dependencyParameters[l][0][0].clone();
            Normalisation.logSumNormalisation(pwm[l]);
            ++l;
        }
        return pwm;
    }

    public double[][] getMixtureProbabilities() throws CloneNotSupportedException {
        return (double[][])ArrayHandler.clone((Cloneable[])this.componentMixturePotential);
    }

    public double[][] getAncestorProbabilities(int component) {
        double[][] ancProb = new double[this.ancestorMixturePotential.length][];
        int i = 0;
        while (i < ancProb.length) {
            ancProb[i] = this.ancestorMixturePotential[i].length > component ? (double[])this.ancestorMixturePotential[i][component].clone() : new double[0];
            ++i;
        }
        return ancProb;
    }

    public String getGraphviz() {
        StringBuffer res = new StringBuffer();
        int l = 0;
        while (l < this.length) {
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                int p = 0;
                while (p < this.ancestorMixturePotential[l][c].length) {
                    String w = Integer.toHexString((int)(256.0 * (1.0 - this.componentMixturePotential[l][c] * this.ancestorMixturePotential[l][c][p])));
                    if (w.length() == 1) {
                        w = "0" + w;
                    }
                    res.append(String.valueOf(l - p - 1) + " -> " + l + "[" + "color=\"#" + w + w + w + "\"]\n");
                    ++p;
                }
                ++c;
            }
            ++l;
        }
        return res.toString();
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return 1;
    }

    @Override
    public boolean modify(int offsetLeft, int offsetRight) {
        if (offsetLeft != 0 || offsetRight != 0) {
            int oldLength = this.length;
            this.length = oldLength - offsetLeft + offsetRight;
            boolean modLength = oldLength != this.length;
            int a = (int)this.alphabets.getAlphabetLengthAt(0);
            double[][][][] newDependencyParameters = new double[this.length][][][];
            double[][] newComponentMixtureParameters = new double[this.length][];
            double[][][] newAncestorMixtureParameters = new double[this.length][][];
            int oldIndex = offsetLeft;
            int l = 0;
            while (l < this.length) {
                int dist;
                int o;
                int m = Math.min(l, this.order) + 1;
                newAncestorMixtureParameters[l] = new double[m][];
                if (oldIndex >= 0 && oldIndex < oldLength) {
                    int n = Math.min(m, this.componentMixtureParameters[oldIndex].length);
                    if (m == this.componentMixtureParameters[oldIndex].length) {
                        newDependencyParameters[l] = this.dependencyParameters[oldIndex];
                        newComponentMixtureParameters[l] = this.componentMixtureParameters[oldIndex];
                    } else {
                        newDependencyParameters[l] = new double[m][][];
                        newComponentMixtureParameters[l] = new double[m];
                        int i = 0;
                        while (i < n) {
                            double sum = ToolBox.sum(0, n, this.componentMixturePotential[oldIndex]);
                            double f = (double)n / (double)m;
                            newComponentMixtureParameters[l][i] = Math.log(this.componentMixturePotential[oldIndex][i] / sum * f);
                            newDependencyParameters[l][i] = this.dependencyParameters[oldIndex][i];
                            ++i;
                        }
                        i = n;
                        while (i < m) {
                            newDependencyParameters[l][i] = new double[newDependencyParameters[l][i - 1].length * a][a];
                            int b = 0;
                            int j = 0;
                            while (j < newDependencyParameters[l][i - 1].length) {
                                int c = 0;
                                while (c < a) {
                                    System.arraycopy(newDependencyParameters[l][i - 1][j], 0, newDependencyParameters[l][i][b], 0, newDependencyParameters[l][i - 1][j].length);
                                    ++c;
                                    ++b;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        Arrays.fill(newComponentMixtureParameters[l], n, m, -Math.log(m));
                    }
                    newAncestorMixtureParameters[l][0] = new double[1];
                    o = 1;
                    while (o < newAncestorMixtureParameters[l].length) {
                        dist = Math.min(l - o + 1, this.distance);
                        newAncestorMixtureParameters[l][o] = new double[dist];
                        Arrays.fill(newAncestorMixtureParameters[l][o], -Math.log(dist));
                        if (o < this.ancestorMixtureParameters[oldIndex].length) {
                            int h = Math.min(dist, this.ancestorMixtureParameters[oldIndex][o].length);
                            double sum = ToolBox.sum(0, h, this.ancestorMixturePotential[oldIndex][o]);
                            double f = (double)h / (double)dist;
                            int j = 0;
                            while (j < h) {
                                newAncestorMixtureParameters[l][o][j] = Math.log(this.ancestorMixturePotential[oldIndex][o][j] / sum * f);
                                ++j;
                            }
                        }
                        ++o;
                    }
                } else {
                    newComponentMixtureParameters[l] = new double[m];
                    newDependencyParameters[l] = new double[newComponentMixtureParameters[l].length][][];
                    newAncestorMixtureParameters[l] = new double[newComponentMixtureParameters[l].length][];
                    int context = 1;
                    dist = 1;
                    o = 0;
                    while (o < newComponentMixtureParameters[l].length) {
                        newDependencyParameters[l][o] = new double[context][a];
                        if (o != 0) {
                            dist = Math.min(l - o + 1, this.distance);
                        }
                        newAncestorMixtureParameters[l][o] = new double[dist];
                        context *= a;
                        ++o;
                    }
                }
                ++l;
                ++oldIndex;
            }
            this.dependencyParameters = newDependencyParameters;
            this.componentMixtureParameters = newComponentMixtureParameters;
            this.ancestorMixtureParameters = newAncestorMixtureParameters;
            if (modLength) {
                this.init();
            } else {
                this.precompute();
            }
        }
        return true;
    }

    @Override
    public void fillInfixScore(int[] seq, int start, int length, double[] scores) {
        int l = start;
        while (l < start + length) {
            int current = seq[l];
            this.localMixtureScore[0] = this.componentMixtureParameters[l][0] - this.componentMixtureLogNorm[l] + this.dependencyParameters[l][0][0][current] - this.dependencyLogNorm[l][0][0];
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                int k = this.ancestorMixtureParameters[l][c].length;
                int an = this.getOffset(seq, l, c, this.dependencyParameters[0][0][0].length);
                int m = 0;
                while (m < k) {
                    an = this.next(an, seq, 0, l, c, m);
                    this.ancestorScore[c][m] = this.ancestorMixtureParameters[l][c][m] - this.ancestorMixtureLogNorm[l][c] + this.dependencyParameters[l][c][an][current] - this.dependencyLogNorm[l][c][an];
                    ++m;
                }
                this.localMixtureScore[c] = this.componentMixtureParameters[l][c] - this.componentMixtureLogNorm[l] + Normalisation.getLogSum(0, k, this.ancestorScore[c]);
                ++c;
            }
            scores[l] = Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
            ++l;
        }
    }

    public static enum PriorType {
        BDeu,
        Simple_Mixture,
        Complex_Mixture;

    }
}

