/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models;

import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.AbstractHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.SimpleState;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.TrainableState;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.filter.Filter;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.BaumWelchParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.HMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.MaxHMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.ViterbiParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.BasicHigherOrderTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.HigherOrderTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.TrainableTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.Transition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.elements.TransitionElement;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.AbstractMixtureTrainSM;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import de.jstacs.utils.Time;
import de.jstacs.utils.ToolBox;
import java.util.Arrays;
import java.util.HashMap;
import javax.naming.OperationNotSupportedException;

public class HigherOrderHMM
extends AbstractHMM {
    protected int[] container;
    protected double[] logEmission;
    protected boolean[] filterRes;
    private double[][][] forwardIntermediate;
    protected double[] backwardIntermediate;
    protected int[][] numberOfSummands;
    protected IntList stateList;
    protected boolean skipInit;
    protected String type;
    private static final String XML_TAG = "HigherOrderHMM";

    public HigherOrderHMM(HMMTrainingParameterSet trainingParameterSet, String[] name, Emission[] emission, BasicHigherOrderTransition.AbstractTransitionElement ... te) throws Exception {
        this(trainingParameterSet, name, null, null, emission, te);
    }

    public HigherOrderHMM(HMMTrainingParameterSet trainingParameterSet, String[] name, int[] emissionIdx, boolean[] forward, Emission[] emission, BasicHigherOrderTransition.AbstractTransitionElement ... te) throws Exception {
        this(null, null, trainingParameterSet, name, null, emissionIdx, forward, emission, null, te);
    }

    public HigherOrderHMM(String sequenceAnnotationType, int[][] statesGroups, HMMTrainingParameterSet trainingParameterSet, String[] name, Filter[] filter, int[] emissionIdx, boolean[] forward, Emission[] emission, int[] transIndex, BasicHigherOrderTransition.AbstractTransitionElement ... te) throws Exception {
        super(statesGroups, trainingParameterSet, name, filter, emissionIdx, forward, emission, transIndex, te);
        this.type = sequenceAnnotationType;
        this.filterRes = new boolean[this.states.length];
    }

    @Override
    protected void createHelperVariables() {
        if (this.container == null) {
            this.container = new int[3];
            this.logEmission = new double[this.states.length];
            int m = 0;
            int max = this.transition.getMaximalMarkovOrder();
            int i = 0;
            while (i <= max) {
                m = Math.max(m, this.transition.getNumberOfIndexes(i));
                ++i;
            }
            this.forwardIntermediate = new double[2][m][this.transition.getMaximalInDegree() + 1];
            this.backwardIntermediate = new double[this.states.length + 1];
            this.numberOfSummands = new int[2][this.forwardIntermediate[0].length];
            this.stateList = new IntList();
        }
    }

    public HigherOrderHMM(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.createHelperVariables();
        this.filterRes = new boolean[this.states.length];
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }

    @Override
    protected void appendFurtherInformation(StringBuffer xml) {
        XMLParser.appendObjectWithTags(xml, this.skipInit, "skipInit");
        XMLParser.appendObjectWithTags(xml, this.type, "type");
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.skipInit = XMLParser.extractObjectForTags(xml, "skipInit", Boolean.TYPE);
        this.type = XMLParser.extractObjectForTags(xml, "type", String.class);
    }

    @Override
    public HigherOrderHMM clone() throws CloneNotSupportedException {
        HigherOrderHMM clone = (HigherOrderHMM)super.clone();
        clone.container = null;
        clone.createHelperVariables();
        clone.filterRes = (boolean[])this.filterRes.clone();
        return clone;
    }

    @Override
    protected void createStates() {
        this.states = new SimpleState[this.emissionIdx.length];
        int i = 0;
        while (i < this.emissionIdx.length) {
            this.states[i] = new SimpleState(this.emission[this.emissionIdx[i]], this.name[i], this.forward[i]);
            ++i;
        }
    }

    @Override
    public double getLogPriorTerm() {
        double res = this.transition.getLogPriorTerm();
        int e = 0;
        while (e < this.emission.length) {
            res += this.emission[e].getLogPriorTerm();
            ++e;
        }
        return res;
    }

    @Override
    public double getLogProbForPath(IntList path, int startPos, Sequence seq) throws Exception {
        if (!this.finalState[path.get(path.length() - 1)]) {
            throw new IllegalArgumentException("The last state of the path is no final state. Hence the path is not valid.");
        }
        double res = 0.0;
        int layer = 0;
        this.container[1] = 0;
        for (int l = 0; l < path.length(); ++l) {
            int state = path.get(l);
            if (this.filter[state] == null || this.filter[state].isAccepted(startPos, seq)) {
                int childIdx = this.transition.getChildIdx(layer, this.container[1], state);
                if (childIdx < 0) {
                    throw new IllegalArgumentException("Impossible path");
                }
                res += this.transition.getLogScoreFor(layer, this.container[1], childIdx, seq, startPos) + this.states[state].getLogScoreFor(startPos, startPos, seq);
                this.transition.fillTransitionInformation(layer, this.container[1], childIdx, this.container);
                if (this.container[2] != 1) continue;
                ++startPos;
                ++layer;
                continue;
            }
            return Double.NEGATIVE_INFINITY;
        }
        return res;
    }

    @Override
    protected void fillLogStatePosteriorMatrix(double[][] statePosterior, int startPos, int endPos, Sequence seq, boolean silentZero) throws Exception {
        int len = endPos - startPos + 1;
        if (this.transition.getMaximalMarkovOrder() == 0) {
            int l = 0;
            while (l < len) {
                int s = 0;
                while (s < this.states.length) {
                    this.transition.fillTransitionInformation(0, 0, s, this.container);
                    double d = this.transition.getLogScoreFor(0, 0, s, seq, startPos + l) + this.states[this.container[0]].getLogScoreFor(startPos + l, startPos + l, seq);
                    statePosterior[this.container[0]][l + 1] = d;
                    this.logEmission[s] = d;
                    ++s;
                }
                double d = Normalisation.getLogSum(this.logEmission);
                int s2 = 0;
                while (s2 < this.states.length) {
                    double[] dArray = statePosterior[s2];
                    int n = l + 1;
                    dArray[n] = dArray[n] - d;
                    ++s2;
                }
                ++l;
            }
        } else {
            this.fillFwdMatrix(startPos, endPos, seq);
            this.fillBwdMatrix(startPos, endPos, seq);
            double logProb = this.bwdMatrix[0][0];
            int l = 0;
            while (l <= len) {
                int s = 0;
                while (s < this.states.length) {
                    statePosterior[s][l] = Double.NEGATIVE_INFINITY;
                    ++s;
                }
                int c = 0;
                while (c < this.fwdMatrix[l].length) {
                    int state = this.transition.getLastContextState(l, c);
                    if (!(state < 0 || silentZero && this.states[state].isSilent())) {
                        statePosterior[state][l] = Normalisation.getLogSum(statePosterior[state][l], this.fwdMatrix[l][c] + this.bwdMatrix[l][c]);
                    }
                    ++c;
                }
                s = 0;
                while (s < this.states.length) {
                    double[] dArray = statePosterior[s];
                    int n = l;
                    dArray[n] = dArray[n] - logProb;
                    ++s;
                }
                ++startPos;
                ++l;
            }
        }
    }

    protected int[] getAllowedContext(int pos, int start, int[] allowedStatesGroup, int maxOrder) {
        if (allowedStatesGroup == null || pos - start < maxOrder || allowedStatesGroup[pos - 1] == -1) {
            return this.defContext[Math.min(maxOrder, pos - start)];
        }
        return this.preComputedContext[allowedStatesGroup[pos - 1]];
    }

    protected void fillLogEmission(int startPos, Sequence seq) throws OperationNotSupportedException, WrongLengthException {
        int stateID = 0;
        while (stateID < this.states.length) {
            this.logEmission[stateID] = this.states[stateID].getLogScoreFor(startPos, startPos, seq);
            ++stateID;
        }
    }

    protected void fillFilter(int startPos, Sequence seq) {
        int stateID = 0;
        while (stateID < this.states.length) {
            this.filterRes[stateID] = this.filter[stateID] == null || this.filter[stateID].isAccepted(startPos, seq);
            ++stateID;
        }
    }

    protected int getIndex(int i) {
        return i;
    }

    @Override
    protected void fillFwdMatrix(int startPos, int endPos, Sequence seq, int[] allowedStatesGroup) throws OperationNotSupportedException, WrongLengthException {
        int stateID;
        int n;
        int context;
        int x;
        int[] allContext;
        int h;
        int l = 0;
        this.provideMatrix(0, endPos - startPos + 1);
        Arrays.fill(this.numberOfSummands[0], 0);
        this.numberOfSummands[0][0] = 1;
        this.forwardIntermediate[0][0][0] = 0.0;
        int s = startPos;
        int maxOrder = this.transition.getMaximalMarkovOrder();
        while (startPos <= endPos) {
            this.fillLogEmission(startPos, seq);
            this.fillFilter(startPos, seq);
            h = l % 2;
            Arrays.fill(this.numberOfSummands[1 - h], 0);
            allContext = this.getAllowedContext(startPos, s, allowedStatesGroup, maxOrder);
            x = 0;
            while (x < allContext.length) {
                context = allContext[x];
                n = this.transition.getNumberOfChildren(l, context);
                if (this.numberOfSummands[h][context] > 0) {
                    this.fwdMatrix[l][context] = Normalisation.getLogSum(0, this.numberOfSummands[h][context], this.forwardIntermediate[h][context]);
                    stateID = 0;
                    while (stateID < n) {
                        this.transition.fillTransitionInformation(l, context, stateID, this.container);
                        if (this.filterRes[this.container[0]]) {
                            int hh = (h + this.container[2]) % 2;
                            this.forwardIntermediate[hh][this.container[1]][this.numberOfSummands[hh][this.container[1]]] = this.fwdMatrix[l][context] + this.logEmission[this.getIndex(this.container[0])] + this.transition.getLogScoreFor(l, context, stateID, seq, startPos);
                            int[] nArray = this.numberOfSummands[hh];
                            int n2 = this.container[1];
                            nArray[n2] = nArray[n2] + 1;
                        }
                        ++stateID;
                    }
                } else {
                    this.fwdMatrix[l][context] = Double.NEGATIVE_INFINITY;
                }
                ++x;
            }
            ++l;
            ++startPos;
        }
        this.fillFilter(startPos, seq);
        allContext = this.getAllowedContext(startPos, s, allowedStatesGroup, maxOrder);
        h = l % 2;
        x = 0;
        while (x < allContext.length) {
            context = allContext[x];
            n = this.transition.getNumberOfChildren(l, context);
            if (this.numberOfSummands[h][context] > 0) {
                this.fwdMatrix[l][context] = Normalisation.getLogSum(0, this.numberOfSummands[h][context], this.forwardIntermediate[h][context]);
                stateID = 0;
                while (stateID < n) {
                    this.transition.fillTransitionInformation(l, context, stateID, this.container);
                    if (this.filterRes[this.container[0]] && this.states[this.container[0]].isSilent()) {
                        int[] nArray = this.numberOfSummands[h];
                        int n3 = this.container[1];
                        int n4 = nArray[n3];
                        nArray[n3] = n4 + 1;
                        this.forwardIntermediate[h][this.container[1]][n4] = this.fwdMatrix[l][context] + this.transition.getLogScoreFor(l, context, stateID, seq, startPos);
                    }
                    ++stateID;
                }
            } else {
                this.fwdMatrix[l][context] = Double.NEGATIVE_INFINITY;
            }
            ++x;
        }
    }

    @Override
    protected void fillBwdMatrix(int startPos, int endPos, Sequence seq, int[] allowedStatesGroup) throws Exception {
        this.fillBwdOrViterbiMatrix(Type.LIKELIHOOD, startPos, endPos, 1.0, seq, allowedStatesGroup, false);
    }

    protected void fillBwdOrViterbiMatrix(Type t, int startPos, int endPos, double weight, Sequence seq) throws Exception {
        this.fillBwdOrViterbiMatrix(t, startPos, endPos, weight, seq, null, false);
    }

    protected void fillBwdOrViterbiMatrix(Type t, int startPos, int endPos, double weight, Sequence seq, int[] allowedStatesGroup, boolean add) throws Exception {
        double newWeight;
        int stateID;
        int n;
        int context;
        double res;
        int maxOrder = this.transition.getMaximalMarkovOrder();
        boolean zero = maxOrder == 0;
        int l = endPos - startPos + 1;
        this.provideMatrix(1, endPos - startPos + 1);
        if (add) {
            this.fillFwdMatrix(startPos, endPos, seq, allowedStatesGroup);
            res = this.computeLogScoreFromForward(l);
        } else {
            res = Double.NaN;
        }
        this.fillFilter(endPos, seq);
        int[] allContext = this.getAllowedContext(endPos + 1, startPos, allowedStatesGroup, maxOrder);
        Arrays.fill(this.bwdMatrix[l], zero ? 0.0 : Double.NEGATIVE_INFINITY);
        int x = allContext.length - 1;
        while (x >= 0) {
            context = allContext[x];
            n = this.transition.getNumberOfChildren(l, context);
            this.numberOfSummands[0][0] = 0;
            double val = zero || this.finalState[this.transition.getLastContextState(l, context)] ? 0.0 : Double.NEGATIVE_INFINITY;
            stateID = 0;
            while (stateID < n) {
                this.transition.fillTransitionInformation(l, context, stateID, this.container);
                if (this.filterRes[this.container[0]] && this.states[this.container[0]].isSilent()) {
                    this.backwardIntermediate[this.numberOfSummands[0][0]] = this.bwdMatrix[l][this.container[1]] + this.transition.getLogScoreFor(l, context, stateID, seq, endPos);
                    if (add) {
                        newWeight = weight * Math.exp(this.fwdMatrix[l][context] + this.backwardIntermediate[this.numberOfSummands[0][0]] - res);
                        ((TrainableTransition)this.transition).addToStatistic(l, context, stateID, newWeight, seq, endPos);
                    }
                    int[] nArray = this.numberOfSummands[0];
                    nArray[0] = nArray[0] + 1;
                }
                ++stateID;
            }
            this.bwdMatrix[l][context] = this.numberOfSummands[0][0] == 0 ? val : (t == Type.VITERBI ? Math.max(val, ToolBox.max(0, this.numberOfSummands[0][0], this.backwardIntermediate)) : Normalisation.getLogSum(val, Normalisation.getLogSum(0, this.numberOfSummands[0][0], this.backwardIntermediate)));
            --x;
        }
        while (--l >= 0) {
            this.fillLogEmission(endPos, seq);
            this.fillFilter(endPos, seq);
            allContext = this.getAllowedContext(endPos, startPos, allowedStatesGroup, maxOrder);
            x = allContext.length - 1;
            while (x >= 0) {
                context = allContext[x];
                n = this.transition.getNumberOfChildren(l, context);
                if (n > 0) {
                    stateID = 0;
                    while (stateID < n) {
                        this.transition.fillTransitionInformation(l, context, stateID, this.container);
                        if (this.filterRes[this.container[0]]) {
                            this.backwardIntermediate[stateID] = this.bwdMatrix[l + this.container[2]][this.container[1]] + this.logEmission[this.getIndex(this.container[0])] + this.transition.getLogScoreFor(l, context, stateID, seq, endPos);
                            if (add) {
                                newWeight = weight * Math.exp(this.fwdMatrix[l][context] + this.backwardIntermediate[stateID] - res);
                                ((TrainableState)this.states[this.getIndex(this.container[0])]).addToStatistic(endPos, endPos, newWeight, seq);
                                ((TrainableTransition)this.transition).addToStatistic(l, context, stateID, newWeight, seq, endPos);
                            }
                        } else {
                            this.backwardIntermediate[stateID] = Double.NEGATIVE_INFINITY;
                        }
                        ++stateID;
                    }
                    this.bwdMatrix[l][context] = t == Type.VITERBI ? ToolBox.max(0, n, this.backwardIntermediate) : Normalisation.getLogSum(0, n, this.backwardIntermediate);
                }
                --x;
            }
            --endPos;
            if (l - 1 < 0) continue;
            Arrays.fill(this.bwdMatrix[l - 1], Double.NEGATIVE_INFINITY);
        }
    }

    @Override
    public Pair<IntList, Double> getViterbiPathFor(int startPos, int endPos, Sequence seq) throws Exception {
        return this.getViterbiPathFor(startPos, endPos, seq, null);
    }

    public Pair<IntList, Double> getViterbiPathFor(int startPos, int endPos, Sequence seq, int[] allowedStatesGroup) throws Exception {
        IntList path = new IntList(endPos - startPos + 1);
        double score = this.viterbi(path, startPos, endPos, 0.0, seq, allowedStatesGroup);
        return new Pair<IntList, Double>(path, score);
    }

    protected double viterbi(IntList path, int startPos, int endPos, double weight, Sequence seq, int[] allowedStatesGroup) throws Exception {
        double dist;
        double current;
        int stateID;
        int childIdx;
        int state;
        int newContext;
        int add;
        double bestDist;
        int n;
        this.fillBwdOrViterbiMatrix(Type.VITERBI, startPos, endPos, 0.0, seq, allowedStatesGroup, false);
        int l = endPos - startPos + 1;
        int layer = 0;
        int context = 0;
        if (path != null) {
            path.clear();
        }
        while (layer < l) {
            n = this.transition.getNumberOfChildren(layer, context);
            bestDist = Double.POSITIVE_INFINITY;
            add = -1000;
            newContext = -1000;
            state = -1000;
            childIdx = -1000;
            stateID = 0;
            while (stateID < n) {
                this.transition.fillTransitionInformation(layer, context, stateID, this.container);
                current = this.bwdMatrix[layer + this.container[2]][this.container[1]] + this.states[this.container[0]].getLogScoreFor(startPos, startPos, seq) + this.transition.getLogScoreFor(layer, context, stateID, seq, startPos);
                dist = current - this.bwdMatrix[layer][context];
                dist *= dist;
                if (dist < bestDist) {
                    childIdx = stateID;
                    state = this.container[0];
                    newContext = this.container[1];
                    add = this.container[2];
                    bestDist = dist;
                }
                ++stateID;
            }
            if (path == null) {
                ((TrainableTransition)this.transition).addToStatistic(layer, context, childIdx, weight, seq, startPos);
                ((TrainableState)this.states[state]).addToStatistic(startPos, startPos, weight, seq);
            } else {
                path.add(state);
            }
            startPos += add;
            layer += add;
            context = newContext;
        }
        while (true) {
            n = this.transition.getNumberOfChildren(layer, context);
            dist = this.finalState[this.transition.getLastContextState(layer, context)] ? 0.0 - this.bwdMatrix[layer][context] : Double.NEGATIVE_INFINITY;
            bestDist = dist * dist;
            add = -1000;
            newContext = -1000;
            state = -1000;
            childIdx = -1000;
            stateID = 0;
            while (stateID < n) {
                this.transition.fillTransitionInformation(layer, context, stateID, this.container);
                if (this.container[2] == 0) {
                    current = this.bwdMatrix[layer][this.container[1]] + this.states[this.container[0]].getLogScoreFor(startPos, startPos, seq) + this.transition.getLogScoreFor(layer, context, stateID, seq, startPos);
                    dist = current - this.bwdMatrix[layer][context];
                    if ((dist *= dist) < bestDist) {
                        childIdx = stateID;
                        state = this.container[0];
                        newContext = this.container[1];
                        bestDist = dist;
                    }
                }
                ++stateID;
            }
            if (state < 0) break;
            if (path == null) {
                ((TrainableTransition)this.transition).addToStatistic(layer, context, childIdx, weight, seq, startPos);
                ((TrainableState)this.states[state]).addToStatistic(startPos, startPos, weight, seq);
            } else {
                path.add(state);
            }
            context = newContext;
        }
        return this.bwdMatrix[0][0];
    }

    protected double baumWelch(int startPos, int endPos, double weight, Sequence seq, int[] allowedStatesGroup) throws Exception {
        this.fillBwdOrViterbiMatrix(Type.LIKELIHOOD, startPos, endPos, weight, seq, allowedStatesGroup, true);
        return this.bwdMatrix[0][0];
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        if (!(this.trainingParameter instanceof MaxHMMTrainingParameterSet)) {
            throw new IllegalArgumentException("This kind of training is currently not supported.");
        }
        Transition bestTransition = null;
        Emission[] bestEmissions = null;
        double best = Double.NEGATIVE_INFINITY;
        int numberOfStarts = this.trainingParameter.getNumberOfStarts();
        AbstractTerminationCondition tc = ((MaxHMMTrainingParameterSet)this.trainingParameter).getTerminationCondition();
        Compute compute = new Compute(this.threads, this);
        compute.setDataSet(data, weights);
        Time time = Time.getTimeInstance(this.sostream);
        int start = 0;
        while (start < numberOfStarts) {
            this.sostream.writeln("start " + start + " ============================");
            if (!this.skipInit) {
                this.initialize(data, weights);
            }
            compute.setParameters();
            double new_value = Double.NEGATIVE_INFINITY;
            int it = 0;
            time.reset();
            while (true) {
                double old_value = new_value;
                new_value = this.getLogPriorTerm() + compute.oneIteration();
                this.sostream.writeln(String.valueOf(it++) + "\t" + time.getElapsedTime() + "\t" + new_value + "\t" + (new_value - old_value));
                if (!tc.doNextIteration(it, old_value, new_value, null, null, Double.NaN, time)) break;
                compute.estimateFromStatistics();
            }
            if (new_value > best) {
                best = new_value;
                if (numberOfStarts > 1) {
                    bestEmissions = (Emission[])ArrayHandler.clone((Cloneable[])this.emission);
                    bestTransition = this.transition.clone();
                }
            }
            ++start;
        }
        this.sostream.writeln("best result: " + best);
        if (bestEmissions != null) {
            this.emission = bestEmissions;
            this.transition = bestTransition;
            this.createStates();
        }
        compute.stopThreads();
    }

    /*
     * Unable to fully structure code
     */
    private double doOneStep(DataSet data, double[] weights, int start, int end) throws Exception {
        weight = 1.0;
        score = 0.0;
        newValue = 0.0;
        mode = -1;
        if (this.trainingParameter instanceof ViterbiParameterSet) {
            mode = 0;
        } else if (this.trainingParameter instanceof BaumWelchParameterSet) {
            mode = 1;
        } else {
            throw new IllegalArgumentException("Training mode not available.");
        }
        n = start;
        while (n < end) {
            block12: {
                block13: {
                    seq = data.getElementAt(n);
                    if (weights != null) {
                        weight = weights[n];
                    }
                    allowedStatesGroup = null;
                    if (this.type != null && (sa = seq.getSequenceAnnotationByType(this.type, 0)) != null) {
                        res = (StorableResult)sa.getResultAt(0);
                        asg = (AbstractHMM.AllowedStatesGroups)res.getResultInstance();
                        allowedStatesGroup = asg.groups;
                    }
                    try {
                        score = mode == 0 ? this.viterbi(null, 0, seq.getLength() - 1, weight, seq, allowedStatesGroup) : this.baumWelch(0, seq.getLength() - 1, weight, seq, allowedStatesGroup);
                        newValue += weight * score;
                        break block12;
                    }
                    catch (Exception e) {
                        System.err.println("Problem with sequence " + n);
                        System.err.println(seq);
                        if (allowedStatesGroup != null) {
                            System.err.println(Arrays.toString(allowedStatesGroup));
                            stat = new HashMap<String, int[]>();
                            AbstractHMM.AllowedStatesGroups.add(allowedStatesGroup, stat, null);
                            System.err.println(AbstractHMM.AllowedStatesGroups.show(stat));
                        }
                        System.err.println();
                        sa = seq.getAnnotation();
                        if (sa == null) break block13;
                        i = 0;
                        ** while (i < sa.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        System.err.println(sa[i]);
                        ++i;
                        continue;
                    }
                }
                System.err.println();
                System.err.println("bwd");
                i = 0;
                while (i <= seq.getLength()) {
                    System.err.println(String.valueOf(i) + "\t" + (i == 0 ? "" : this.alphabets.getSymbol(i - 1, seq.discreteVal(i - 1))) + "\t" + (allowedStatesGroup == null ? "" : (i == 0 ? "" : Integer.valueOf(allowedStatesGroup[i - 1])) + "\t") + ToolBox.max(this.bwdMatrix[i]) + "\t" + Arrays.toString(this.bwdMatrix[i]));
                    ++i;
                }
                throw e;
            }
            ++n;
        }
        return newValue;
    }

    protected void initialize(DataSet data, double[] weight) throws Exception {
        this.initializeRandomly();
    }

    public void setSkiptInit(boolean skip) {
        this.skipInit = skip;
    }

    public void initializeRandomly() {
        this.transition.initializeRandomly();
        int e = 0;
        while (e < this.emission.length) {
            this.emission[e].initializeFunctionRandomly();
            ++e;
        }
    }

    protected void resetStatistics() {
        ((TrainableTransition)this.transition).resetStatistic();
        int e = 0;
        while (e < this.emission.length) {
            this.emission[e].resetStatistic();
            ++e;
        }
    }

    protected void estimateFromStatistics() {
        ((TrainableTransition)this.transition).estimateFromStatistic();
        int e = 0;
        while (e < this.emission.length) {
            this.emission[e].estimateFromStatistic();
            ++e;
        }
    }

    @Override
    public final byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        return 127;
    }

    @Override
    public ResultSet getCharacteristics() throws Exception {
        return new ResultSet(this.getNumericalCharacteristics().getResults(), {new StorableResult("model", "the xml representation of the model", this)});
    }

    @Override
    public String getInstanceName() {
        return "HMM(" + this.transition.getMaximalMarkovOrder() + ") " + this.trainingParameter.getClass().getSimpleName();
    }

    @Override
    public double[] getLogScoreFor(DataSet data) throws Exception {
        double[] logProb = new double[data.getNumberOfElements()];
        this.getLogScoreFor(data, logProb);
        return logProb;
    }

    @Override
    public void getLogScoreFor(DataSet data, double[] res) throws Exception {
        if (!data.getAlphabetContainer().checkConsistency(this.getAlphabetContainer())) {
            throw new WrongAlphabetException("The AlphabetContainer of the data set and the model do not match.");
        }
        int len = this.getLength();
        int l = data.getElementLength();
        if (len != 0 && l != len) {
            throw new WrongLengthException("The length of the data set and the model do not match.");
        }
        int n = 0;
        while (n < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(n);
            res[n] = this.logProb(0, seq.getLength() - 1, seq);
            ++n;
        }
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return null;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    protected void finalize() throws Throwable {
        this.emission = null;
        this.emissionIdx = null;
        this.forward = null;
        this.name = null;
        this.container = null;
        this.numberOfSummands = null;
        this.logEmission = null;
        this.forwardIntermediate = null;
        this.backwardIntermediate = null;
        super.finalize();
    }

    public void samplePath(IntList path, int startPos, int endPos, Sequence seq) throws Exception {
        double logTransition;
        int stateID;
        int n;
        this.fillBwdMatrix(startPos, endPos, seq);
        int l = 0;
        int context = 0;
        this.provideMatrix(0, endPos - startPos + 1);
        path.clear();
        while (startPos <= endPos) {
            n = this.transition.getNumberOfChildren(l, context);
            stateID = 0;
            while (stateID < n) {
                this.transition.fillTransitionInformation(l, context, stateID, this.container);
                logTransition = this.transition.getLogScoreFor(l, context, stateID, seq, startPos);
                this.backwardIntermediate[stateID] = this.bwdMatrix[l + this.container[2]][this.container[1]] + this.states[this.container[0]].getLogScoreFor(startPos, startPos, seq) + logTransition;
                ++stateID;
            }
            Normalisation.logSumNormalisation(this.backwardIntermediate, 0, n);
            stateID = AbstractMixtureTrainSM.draw(this.backwardIntermediate, 0);
            this.transition.fillTransitionInformation(l, context, stateID, this.container);
            path.add(this.container[0]);
            context = this.container[1];
            l += this.container[2];
            startPos += this.container[2];
        }
        int last = path.get(path.length() - 1);
        while (true) {
            int add;
            n = this.transition.getNumberOfChildren(l, context);
            this.stateList.clear();
            stateID = 0;
            while (stateID < n) {
                this.transition.fillTransitionInformation(l, context, stateID, this.container);
                if (this.states[this.container[0]].isSilent()) {
                    logTransition = this.transition.getLogScoreFor(l, context, stateID, seq, startPos);
                    this.backwardIntermediate[this.stateList.length()] = this.bwdMatrix[l][this.container[1]] + logTransition;
                    this.stateList.add(stateID);
                }
                ++stateID;
            }
            if (this.finalState[last]) {
                this.backwardIntermediate[this.stateList.length()] = 0.0;
                add = 1;
            } else {
                add = 0;
            }
            Normalisation.logSumNormalisation(this.backwardIntermediate, 0, this.stateList.length() + add);
            n = AbstractMixtureTrainSM.draw(this.backwardIntermediate, 0);
            if (add == 1 && n == this.stateList.length()) break;
            this.transition.fillTransitionInformation(l, context, this.stateList.get(n), this.container);
            path.add(this.container[0]);
            context = this.container[1];
            l += this.container[2];
            startPos += this.container[2];
            last = this.container[0];
        }
    }

    protected double computeLogScoreFromForward(int l) {
        double res = Double.NEGATIVE_INFINITY;
        if (this.transition.getMaximalMarkovOrder() > 0) {
            int i = 0;
            while (i < this.fwdMatrix[l].length) {
                if (this.finalState[this.transition.getLastContextState(l, i)]) {
                    res = Normalisation.getLogSum(res, this.fwdMatrix[l][i]);
                }
                ++i;
            }
        } else {
            res = Normalisation.getLogSum(this.fwdMatrix[l]);
        }
        return res;
    }

    public Emission[] getEmissions() throws CloneNotSupportedException {
        return (Emission[])ArrayHandler.clone((Cloneable[])this.emission);
    }

    public TransitionElement[] getTransitionElements() throws CloneNotSupportedException {
        return ((HigherOrderTransition)this.transition).getTransitionElements();
    }

    public HMMTrainingParameterSet getTrainingParams() throws CloneNotSupportedException {
        return (HMMTrainingParameterSet)this.trainingParameter.clone();
    }

    private static class Compute {
        WorkerThread[] workers;
        TrainableTransition[] transition;
        Emission[] emission;

        public Compute(int threads, HigherOrderHMM hmm) throws CloneNotSupportedException {
            this.workers = new WorkerThread[threads];
            this.workers[0] = new WorkerThread(0, hmm);
            int i = 1;
            while (i < threads) {
                this.workers[i] = new WorkerThread(i, hmm.clone());
                ++i;
            }
            this.transition = new TrainableTransition[threads];
            this.emission = new Emission[threads];
        }

        private synchronized void waitUntilWorkersFinished() {
            int t = -1;
            boolean exception = false;
            while (true) {
                int i = 0;
                while (i < this.workers.length && this.workers[i].isWaiting()) {
                    if (this.workers[i].exception) {
                        t = i;
                        exception = true;
                    }
                    ++i;
                }
                if (i == this.workers.length) {
                    if (!exception) break;
                    i = 0;
                    while (i < this.workers.length) {
                        this.workers[i].interrupt();
                        ++i;
                    }
                    this.stopThreads();
                    throw new RuntimeException("Terminate program, since at least thread " + t + " throws an exception.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void stopThreads() {
            int i = 0;
            while (i < this.workers.length) {
                this.workers[i].setState(WorkerState.STOP);
                this.workers[i] = null;
                ++i;
            }
        }

        private void setDataSet(DataSet data, double[] weights) {
            int last = 0;
            int N = data.getNumberOfElements();
            int i = 0;
            while (i < this.workers.length - 1) {
                this.workers[i].set(last, (i + 1) * N / this.workers.length, data, weights);
                last = this.workers[i].end;
                ++i;
            }
            this.workers[this.workers.length - 1].set(last, N, data, weights);
        }

        private double oneIteration() {
            int i = 0;
            while (i < this.workers.length) {
                this.workers[i].hmm.resetStatistics();
                this.workers[i].setState(WorkerState.TRAIN);
                ++i;
            }
            this.waitUntilWorkersFinished();
            double res = 0.0;
            int i2 = 0;
            while (i2 < this.workers.length) {
                res += this.workers[i2].getScore();
                ++i2;
            }
            return res;
        }

        private void estimateFromStatistics() {
            if (this.workers.length > 1) {
                int i = 0;
                while (i < this.workers.length) {
                    this.transition[i] = (TrainableTransition)this.workers[i].hmm.transition;
                    ++i;
                }
                ((TrainableTransition)this.workers[0].hmm.transition).joinStatistics(this.transition);
                int e = 0;
                while (e < this.workers[0].hmm.emission.length) {
                    int j = 0;
                    while (j < this.workers.length) {
                        this.emission[j] = this.workers[j].hmm.emission[e];
                        ++j;
                    }
                    this.workers[0].hmm.emission[e].joinStatistics(this.emission);
                    ++e;
                }
            }
            this.workers[0].hmm.estimateFromStatistics();
            this.setParameters();
        }

        private void setParameters() {
            int i = 1;
            while (i < this.workers.length) {
                this.workers[i].hmm.transition.setParameters(this.workers[0].hmm.transition);
                int e = 0;
                while (e < this.workers[0].hmm.emission.length) {
                    this.workers[i].hmm.emission[e].setParameters(this.workers[0].hmm.emission[e]);
                    ++e;
                }
                ++i;
            }
        }

        private static enum WorkerState {
            TRAIN,
            WAIT,
            STOP;

        }

        private class WorkerThread
        extends Thread {
            private boolean exception;
            private WorkerState state;
            private int idx;
            private int start;
            private int end;
            private double score;
            private DataSet data;
            private double[] weights;
            private HigherOrderHMM hmm;

            public WorkerThread(int idx, HigherOrderHMM hmm) {
                this.idx = idx;
                this.hmm = hmm;
                this.setDaemon(true);
                this.state = WorkerState.WAIT;
                this.start();
            }

            private void set(int start, int end, DataSet data, double[] weights) {
                this.start = start;
                this.end = end;
                this.score = 0.0;
                this.data = data;
                this.weights = weights;
                this.state = WorkerState.WAIT;
            }

            public double getScore() {
                return this.score;
            }

            public synchronized void setState(WorkerState state) {
                this.state = state;
                this.notify();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void run() {
                this.exception = false;
                while (this.state != WorkerState.STOP) {
                    if (this.state == WorkerState.WAIT) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    try {
                        this.score = this.hmm.doOneStep(this.data, this.weights, this.start, this.end);
                    }
                    catch (Exception e) {
                        this.exception = true;
                        e.printStackTrace();
                    }
                    Compute compute = Compute.this;
                    synchronized (compute) {
                        this.state = WorkerState.WAIT;
                        Compute.this.notify();
                    }
                }
            }

            public boolean isWaiting() {
                return this.state == WorkerState.WAIT;
            }
        }
    }

    protected static enum Type {
        LIKELIHOOD,
        VITERBI;

    }
}

