/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.AbstractConditionalDiscreteEmission;

public class HigherOrderDiscreteEmission
extends AbstractConditionalDiscreteEmission {
    protected int[] power;
    protected int order;

    public HigherOrderDiscreteEmission(AlphabetContainer con, double ess, int order) throws WrongAlphabetException {
        this(con, ess, ess, order);
    }

    public HigherOrderDiscreteEmission(AlphabetContainer con, double ess, double initESS, int order) throws WrongAlphabetException {
        this(con, ess, initESS, order, true);
    }

    public HigherOrderDiscreteEmission(AlphabetContainer con, double ess, double initESS, int order, boolean norm) throws WrongAlphabetException {
        super(con, (int)Math.pow(con.getAlphabetLengthAt(0), order), ess, initESS, norm);
        if (order < 0) {
            throw new IllegalArgumentException("The order must be non-negative");
        }
        this.order = order;
        this.createPower();
    }

    public HigherOrderDiscreteEmission(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.order = (Integer)XMLParser.extractObjectForTags(xml, "order");
        this.createPower();
    }

    protected void createPower() {
        this.power = new int[this.order];
        if (this.order > 0) {
            this.power[0] = 1;
            int a = (int)this.con.getAlphabetLengthAt(0);
            int i = 1;
            while (i < this.order) {
                this.power[i] = this.power[i - 1] * a;
                ++i;
            }
        }
    }

    @Override
    protected void appendFurtherInformation(StringBuffer xml) {
        XMLParser.appendObjectWithTags(xml, this.order, "order");
    }

    @Override
    public HigherOrderDiscreteEmission clone() throws CloneNotSupportedException {
        HigherOrderDiscreteEmission clone = (HigherOrderDiscreteEmission)super.clone();
        clone.power = (int[])this.power.clone();
        return clone;
    }

    @Override
    protected int getConditionIndex(boolean forward, int seqPos, Sequence seq) {
        int res = 0;
        int i = 0;
        while (i < this.order) {
            int p = seqPos - (i + 1);
            if (p < 0) {
                return -1;
            }
            res += this.power[i] * seq.discreteVal(p);
            ++i;
        }
        return res;
    }

    @Override
    protected String getCondition(int i) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        int a = (int)this.con.getAlphabetLengthAt(0);
        int j = 0;
        while (j < this.order) {
            int x = i % a;
            sb.append(String.valueOf(j == 0 ? "|" : ",") + " X_{-" + (j + 1) + "}=" + this.con.getSymbol(0, x));
            i /= a;
            ++j;
        }
        return sb.toString();
    }
}

