/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.filter;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.filter.Filter;

public class DiscreteFilter
implements Filter {
    private boolean[] result;
    private int offset;

    public DiscreteFilter(int offset, boolean[] result) {
        this.offset = offset;
        this.result = (boolean[])result.clone();
    }

    public DiscreteFilter(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "DiscreteFilter");
        this.offset = (Integer)XMLParser.extractObjectForTags(xml, "offset");
        this.result = (boolean[])XMLParser.extractObjectForTags(xml, "result");
    }

    @Override
    public boolean isAccepted(int anchor, Sequence seq) {
        int pos = anchor + this.offset;
        if (pos >= 0 && pos < seq.getLength()) {
            return this.result[seq.discreteVal(anchor + this.offset)];
        }
        return false;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.offset, "offset");
        XMLParser.appendObjectWithTags(xml, this.result, "result");
        XMLParser.addTags(xml, "DiscreteFilter");
        return xml;
    }
}

