/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training;

import de.jstacs.DataType;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.MultiThreadedTrainingParameterSet;

public class NumericalHMMTrainingParameterSet
extends MultiThreadedTrainingParameterSet {
    private static final String[] algorithmStrings = new String[]{"steepest descent", "conjugate gradients (F., R.)", "conjugate gradients (P., R. positive)", "quasi newton (D., F., P.)", "quasi newton (B., F., G., S.)", "limited memory quasi newton (B., F., G., S.; n=3)", "limited memory quasi newton (B., F., G., S.; n=4)", "limited memory quasi newton (B., F., G., S.; n=5)", "limited memory quasi newton (B., F., G., S.; n=6)", "limited memory quasi newton (B., F., G., S.; n=7)", "limited memory quasi newton (B., F., G., S.; n=8)", "limited memory quasi newton (B., F., G., S.; n=9)", "limited memory quasi newton (B., F., G., S.; n=10)"};
    private static final Byte[] algorithms = new Byte[]{(byte)16, (byte)17, (byte)18, (byte)19, (byte)20, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10};

    public NumericalHMMTrainingParameterSet() {
        this.addParameters();
    }

    public NumericalHMMTrainingParameterSet(int starts, AbstractTerminationCondition tc, int threads, byte algorithm, double lineEps, double startDist, TrainingType training, boolean randomly) throws Exception {
        super(starts, tc, threads);
        this.addParameters();
        ((Parameter)this.parameters.get(3)).setValue(algorithmStrings[NumericalHMMTrainingParameterSet.getIndex(algorithmStrings, algorithms, Byte.valueOf(algorithm), false)]);
        ((Parameter)this.parameters.get(4)).setValue(lineEps);
        ((Parameter)this.parameters.get(5)).setValue(startDist);
        ((Parameter)this.parameters.get(6)).setValue((Object)training);
        ((Parameter)this.parameters.get(7)).setValue(randomly);
    }

    public NumericalHMMTrainingParameterSet(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    private void addParameters() {
        try {
            this.parameters.add(new Parameter[]{new SelectionParameter(DataType.BYTE, algorithmStrings, algorithms, "algorithm", "the algorithm that should be used for numerical optimization", true)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "line epsilon", "the threshold for stopping the line search in the numerical training", true, new NumberValidator<Double>(0.0, (Double)Double.MAX_VALUE))});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "start distance", "the start distance for the line search in the numerical training", true, new NumberValidator<Double>(0.0, (Double)Double.MAX_VALUE))});
            this.parameters.add(new Parameter[]{new EnumParameter(TrainingType.class, "the function that is optimized while training", true, TrainingType.LIKELIHOOD.toString())});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BOOLEAN, "randomly", "if the initial parameters should be sampled randomly", true, true)});
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
    }

    public byte getAlgorithm() {
        return (Byte)this.getParameterForName("algorithm").getValue();
    }

    public double getLineEps() {
        return (Double)this.getParameterForName("line epsilon").getValue();
    }

    public double getStartDistance() {
        return (Double)this.getParameterForName("start distance").getValue();
    }

    public TrainingType getTrainingType() {
        return (TrainingType)((Object)this.getParameterForName("TrainingType").getValue());
    }

    public boolean randomInitialization() {
        return (Boolean)this.getParameterForName("randomly").getValue();
    }

    public static enum TrainingType {
        LIKELIHOOD(false, false),
        VITERBI(false, true),
        DISCRIMINATIVE_LIKELIHOOD(true, false),
        DISCRIMINATIVE_VITERBI(true, true),
        DISCRIMINATIVE_VITERBI2(true, true);

        protected boolean discriminative;
        protected boolean vitLike;

        private TrainingType(boolean d, boolean v) {
            this.discriminative = d;
            this.vitLike = v;
        }

        public boolean isDiscrimnative() {
            return this.discriminative;
        }

        public boolean isViterbiLike() {
            return this.vitLike;
        }
    }
}

