/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.tools;

import de.jstacs.DataType;
import de.jstacs.parameters.AbstractSelectionParameter;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.TextResult;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.File;

public interface JstacsTool {
    public static final /* synthetic */ int[] $SWITCH_TABLE$de$jstacs$DataType;

    public static String getSimpleParameterInfo(ParameterSet parameters) {
        return JstacsTool.getSimpleParameterInfo(parameters, null);
    }

    public static String getSimpleParameterInfo(ParameterSet parameters, String pref) {
        String res = null;
        if (pref != null) {
            if (parameters instanceof ToolParameterSet) {
                pref = String.valueOf(pref) + ((ToolParameterSet)parameters).getToolName() + ".";
            }
        } else {
            pref = "";
        }
        int i = 0;
        while (i < parameters.getNumberOfParameters()) {
            Parameter p = parameters.getParameterAt(i);
            if (p.hasDefaultOrIsSet()) {
                String subRes;
                ParameterSet inner = null;
                if (p instanceof SimpleParameter || p instanceof AbstractSelectionParameter) {
                    Object o;
                    res = res == null ? "" : String.valueOf(res) + "; ";
                    if (p instanceof SelectionParameter) {
                        SelectionParameter a = (SelectionParameter)p;
                        o = a.getParametersInCollection().getParameterAt(a.getSelected()).getName();
                    } else {
                        o = p.getValue();
                    }
                    res = String.valueOf(res) + pref + p.getName() + ": " + o;
                    if (p instanceof SelectionParameter && p.getDatatype() == DataType.PARAMETERSET) {
                        inner = (ParameterSet)p.getValue();
                    }
                }
                if (p instanceof ParameterSetContainer) {
                    inner = ((ParameterSetContainer)p).getValue();
                }
                if (inner != null && (subRes = JstacsTool.getSimpleParameterInfo(inner, pref)) != null) {
                    res = res == null ? "" : String.valueOf(res) + "; ";
                    res = String.valueOf(res) + subRes;
                }
            }
            ++i;
        }
        return res;
    }

    public ToolParameterSet getToolParameters();

    public ToolResult run(ToolParameterSet var1, Protocol var2, ProgressUpdater var3, int var4) throws Exception;

    public String getToolName();

    public String getToolVersion();

    public String getShortName();

    public String getDescription();

    public String getHelpText();

    public ResultEntry[] getDefaultResultInfos();

    public ToolResult[] getTestCases(String var1);

    public void clear();

    public String[] getReferences();

    public static double test(JstacsTool t, String path, boolean verbose) {
        ToolResult[] tests = t.getTestCases(path);
        if (tests == null || tests.length == 0) {
            return Double.NaN;
        }
        double success = 0.0;
        CLI.SysProtocol protocol = verbose ? new CLI.SysProtocol() : new CLI.QuietSysProtocol();
        ProgressUpdater progress = new ProgressUpdater();
        int i = 0;
        while (i < tests.length) {
            int j = 0;
            while (j < 100) {
                protocol.append("=");
                ++j;
            }
            protocol.append("\ntest case: " + i + "\n\n");
            ToolResult given = tests[i];
            try {
                t.clear();
                JstacsTool.setPathOfFiles(path, given);
                ToolParameterSet g = given.getToolParameters();
                ToolResult generated = t.run(g, protocol, progress, 1);
                boolean eq = given.equals(generated);
                protocol.append("\nresults identical: " + eq + "\n");
                if (eq) {
                    success += 1.0;
                } else {
                    ResultSet r1 = given.getRawResult()[0];
                    ResultSet r2 = generated.getRawResult()[0];
                    if (r1.getNumberOfResults() == r2.getNumberOfResults()) {
                        int j2 = 0;
                        while (j2 < r1.getNumberOfResults()) {
                            TextResult yyy;
                            Result a = r1.getResultAt(j2);
                            Result b = r2.getResultAt(j2);
                            if (a instanceof TextResult) {
                                yyy = (TextResult)a;
                                yyy.getValue().getContent();
                            }
                            if (b instanceof TextResult) {
                                yyy = (TextResult)b;
                                yyy.getValue().getContent();
                            }
                            protocol.append(String.valueOf(j2) + "\t" + a.getName() + "\t" + b.getName() + "\t" + a.equals(b) + "\n");
                            ++j2;
                        }
                    } else {
                        protocol.append("Number of results differ.\n");
                    }
                }
            }
            catch (Exception e) {
                protocol.appendThrowable(e);
            }
            ++i;
        }
        return success / (double)tests.length;
    }

    public static void setPathOfFiles(String path, ToolResult given) throws SimpleParameter.IllegalValueException {
        ResultSet[] r = given.getRawResult();
        int j = 0;
        while (j < r.length) {
            JstacsTool.setPathOfFiles(path, r[j]);
            ++j;
        }
        JstacsTool.setPathOfFiles(path, given.getToolParameters());
    }

    public static void setPathOfFiles(String path, ResultSet r) throws SimpleParameter.IllegalValueException {
        int i = 0;
        while (i < r.getNumberOfResults()) {
            Result re = r.getResultAt(i);
            switch (re.getDatatype()) {
                case FILE: {
                    TextResult t = (TextResult)re;
                    FileParameter.FileRepresentation f = t.getValue();
                    String v = f.getFilename();
                    if (v == null) break;
                    f.setFilename(String.valueOf(path) + File.separator + v);
                    break;
                }
                case LIST: {
                    if (!(re instanceof ResultSetResult)) break;
                    JstacsTool.setPathOfFiles(path, ((ResultSetResult)re).getResultSet());
                }
            }
            ++i;
        }
    }

    public static void setPathOfFiles(String path, ParameterSet p) throws SimpleParameter.IllegalValueException {
        int i = 0;
        while (i < p.getNumberOfParameters()) {
            Parameter pa = p.getParameterAt(i);
            switch (pa.getDatatype()) {
                case PARAMETERSET: {
                    JstacsTool.setPathOfFiles(path, (ParameterSet)pa.getValue());
                    break;
                }
                case FILE: {
                    FileParameter f = (FileParameter)pa;
                    String v = f.getValue();
                    if (v == null) break;
                    f.setValue(String.valueOf(path) + File.separator + v);
                }
            }
            ++i;
        }
    }

    public static class ResultEntry {
        private Class<? extends Result> clazz;
        private String format;
        private String name;

        public ResultEntry(Class<? extends Result> clazz, String format, String name) {
            this.clazz = clazz;
            this.format = format;
            this.name = name;
        }

        public Class<? extends Result> getDeclaredClass() {
            return this.clazz;
        }

        public String getFormat() {
            return this.format;
        }

        public String getName() {
            return this.name;
        }
    }
}

