/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.tools.ui.galaxy;

import de.jstacs.DataType;
import de.jstacs.parameters.AbstractSelectionParameter;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.results.DataSetResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.StorableResult;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.galaxy.GalaxyAdaptor;
import de.jstacs.utils.Pair;
import de.jstacs.utils.graphics.PDFAdaptor;
import de.jstacs.utils.graphics.RasterizedAdaptor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

public class Galaxy {
    private JstacsTool[] tools;
    private String vmargs;
    private boolean[] configThreads;
    private boolean useDiscoverDatasets;

    public Galaxy(String vmargs, boolean configThreads, boolean useDiscoverDatasets, JstacsTool ... tools) {
        this(vmargs, new boolean[]{configThreads}, useDiscoverDatasets, tools);
    }

    public Galaxy(String vmargs, boolean[] configThreads, boolean useDiscoverDatasets, JstacsTool ... tools) {
        this.tools = tools;
        this.vmargs = vmargs;
        if (this.vmargs == null) {
            this.vmargs = "";
        } else if (this.vmargs.length() != 0) {
            this.vmargs = " " + this.vmargs;
        }
        if (configThreads == null || configThreads.length == 1) {
            this.configThreads = new boolean[tools.length];
            Arrays.fill(this.configThreads, configThreads == null ? false : configThreads[0]);
        } else if (configThreads.length == tools.length) {
            this.configThreads = (boolean[])configThreads.clone();
        } else {
            throw new IllegalArgumentException("Check the length of the configureThreads array.");
        }
        this.useDiscoverDatasets = useDiscoverDatasets;
    }

    private int getToolIndex(String shortName) {
        int i = 0;
        while (i < this.tools.length) {
            if (shortName.equals(this.tools[i].getShortName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private GalaxyAdaptor getGalaxyAdaptor(int i, String jar, String vmargs, String[] args) throws Exception {
        String name = this.tools[i].getShortName();
        GalaxyAdaptor ga = new GalaxyAdaptor(this.tools[i], "java" + vmargs + " -jar " + jar + " " + name, "jobname", new File(jar).getParentFile().getAbsolutePath(), this.useDiscoverDatasets);
        ga.setHelp(this.tools[i].getHelpText());
        ga.parse(args, this.configThreads[i]);
        return ga;
    }

    public void run(String[] args) throws Exception {
        File jarfile = new File(Galaxy.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        String jar = jarfile.getAbsolutePath();
        if ("--create".equals(args[0])) {
            if (args.length == 1) {
                int i = 0;
                while (i < this.tools.length) {
                    String name = this.tools[i].getShortName();
                    this.getGalaxyAdaptor(i, jar, this.vmargs, new String[]{"--create", String.valueOf(name) + ".xml"});
                    ++i;
                }
            } else {
                String myVMArgs;
                if (args.length == 2) {
                    myVMArgs = this.vmargs;
                } else {
                    myVMArgs = "";
                    int i = 2;
                    while (i < args.length) {
                        myVMArgs = String.valueOf(myVMArgs) + " " + args[i];
                        ++i;
                    }
                }
                this.getGalaxyAdaptor(this.getToolIndex(args[1]), jar, myVMArgs, new String[]{"--create", String.valueOf(args[1]) + ".xml"});
            }
        } else {
            ResultSet[] ress;
            String toolname = args[0];
            int idx = this.getToolIndex(toolname);
            String[] args2 = new String[args.length - 1];
            System.arraycopy(args, 1, args2, 0, args2.length);
            GalaxyAdaptor ga = this.getGalaxyAdaptor(idx, jar, "", args2);
            GalaxyAdaptor.Protocol protocol = ga.getProtocol(false);
            ProgressUpdater progress = new ProgressUpdater();
            ToolResult tr = this.tools[idx].run((ToolParameterSet)ga.parameters, protocol, progress, ga.getThreads());
            ResultSet[] resultSetArray = ress = tr == null ? new ResultSet[]{} : tr.getRawResult();
            if (ress.length > 0) {
                Pair<Result, boolean[]>[] temp = Galaxy.flatten(ress[0]);
                HashSet<String> names = new HashSet<String>();
                int i = 0;
                while (i < temp.length) {
                    String mime;
                    Result res = temp[i].getFirstElement();
                    boolean export = temp[i].getSecondElement()[0];
                    boolean includeInSummary = temp[i].getSecondElement()[1];
                    String exportExtension = null;
                    if (res instanceof TextResult && (mime = ((TextResult)res).getMime()) != null) {
                        String[] exts = mime.split("\\,");
                        exportExtension = exts[0];
                    }
                    if (res instanceof PlotGeneratorResult) {
                        String filename;
                        PlotGeneratorResult.PlotGenerator pg = ((PlotGeneratorResult)res).getValue();
                        RasterizedAdaptor rast = new RasterizedAdaptor("png");
                        pg.generatePlot(rast);
                        BufferedImage bi = rast.getImage();
                        PDFAdaptor pdf = new PDFAdaptor();
                        pg.generatePlot(pdf);
                        String temp2 = filename = res.getName().replaceAll("[\\s\\:\\/]", "_");
                        int j = 1;
                        while (names.contains(temp2)) {
                            temp2 = String.valueOf(filename) + "_" + j;
                            ++j;
                        }
                        filename = temp2;
                        names.add(filename);
                        filename = "./" + filename + ".pdf";
                        pdf.generateOutput(filename);
                        GalaxyAdaptor.FileResult link = new GalaxyAdaptor.FileResult(res.getName(), "PDF", filename);
                        GalaxyAdaptor.LinkedImageResult lir = new GalaxyAdaptor.LinkedImageResult(res.getName(), res.getComment(), bi, link);
                        res = lir;
                    }
                    ga.addResult(res, export, includeInSummary, exportExtension);
                    ++i;
                }
            }
            ga.writeOutput();
        }
    }

    @Deprecated
    private void print(ParameterSet parameters, String tabPrefix) {
        boolean isExp = parameters instanceof ExpandableParameterSet;
        ExpandableParameterSet exp = null;
        if (isExp) {
            exp = (ExpandableParameterSet)parameters;
            parameters = (ParameterSet)parameters.getParameterAt(0).getValue();
            System.out.println(String.valueOf(tabPrefix) + "This parameter can be used multiple times:");
            ParameterSet template = (ParameterSet)exp.getParameterAt(0).getValue();
            int n = exp.getNumberOfParameters();
            int k = 0;
            while (k < n) {
                ParameterSet ps2 = (ParameterSet)exp.getParameterAt(k).getValue();
                int j = 0;
                while (j < template.getNumberOfParameters()) {
                    System.out.println(String.valueOf(tabPrefix) + "\t" + (n > 1 ? "(" + (k + 1) + ") " : "") + ps2.getParameterAt(j).toString());
                    ++j;
                }
                ++k;
            }
        } else {
            int i = 0;
            while (i < parameters.getNumberOfParameters()) {
                Parameter par = parameters.getParameterAt(i);
                if (par.getDatatype() != DataType.PARAMETERSET) {
                    System.out.println(String.valueOf(tabPrefix) + par.toString());
                } else if (par instanceof AbstractSelectionParameter) {
                    System.out.println(String.valueOf(tabPrefix) + par.toString());
                    String offset = tabPrefix;
                    int l = par.getName().length();
                    int k = 0;
                    while (k <= l) {
                        offset = String.valueOf(offset) + " ";
                        ++k;
                    }
                    ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
                    int j = 0;
                    while (j < incoll.getNumberOfParameters()) {
                        ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                        if (cont.getValue().getNumberOfParameters() > 0) {
                            System.out.println(String.valueOf(offset) + "Parameters for selection \"" + cont.getName() + "\":");
                            this.print(cont.getValue(), String.valueOf(offset) + "\t");
                        } else {
                            System.out.println(String.valueOf(offset) + "No parameters for selection \"" + cont.getName() + "\"");
                        }
                        ++j;
                    }
                } else {
                    ParameterSet ps = (ParameterSet)par.getValue();
                    this.print(ps, String.valueOf(tabPrefix) + "\t");
                }
                ++i;
            }
        }
    }

    public static Pair<Result, boolean[]>[] flatten(ResultSet ress) {
        LinkedList<Pair<Result, boolean[]>> all = new LinkedList<Pair<Result, boolean[]>>();
        int i = 0;
        while (i < ress.getNumberOfResults()) {
            boolean includeInSummary;
            boolean export;
            Result res = ress.getResultAt(i);
            boolean bl = export = res instanceof GalaxyAdaptor.FileResult || res instanceof DataSetResult || res instanceof StorableResult;
            if (res instanceof TextResult) {
                export = ((TextResult)res).getExport();
            }
            if (res instanceof ListResult) {
                export = ((ListResult)res).getExport();
            }
            boolean bl2 = includeInSummary = !export;
            if (res instanceof ResultSetResult) {
                Pair<Result, boolean[]>[] temp = Galaxy.flatten(((ResultSetResult)res).getRawResult()[0]);
                boolean[] blArray = new boolean[2];
                blArray[1] = true;
                all.add(new Pair<GalaxyAdaptor.HeadResult, boolean[]>(new GalaxyAdaptor.HeadResult(res.getName(), res.getComment()), blArray));
                Collections.addAll(all, temp);
            } else {
                all.add(new Pair<Result, boolean[]>(res, new boolean[]{export, includeInSummary}));
            }
            ++i;
        }
        return all.toArray(new Pair[0]);
    }
}

