/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.interpolation;

public class RationalInterpolation {
    static double TINY = 1.0E-25;

    public static double interpolate(double d, double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray.length];
        return RationalInterpolation.interpolate(d, dArray, dArray2, null, dArray3, dArray4);
    }

    public static double interpolate(double d, double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[dArray.length];
        double[] dArray5 = new double[dArray.length];
        return RationalInterpolation.interpolate(d, dArray, dArray2, dArray3, dArray4, dArray5);
    }

    public static double interpolate(double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double[] dArray6 = dArray4;
        double[] dArray7 = dArray5;
        int n = dArray.length;
        if (dArray2.length != n || dArray6.length != n || dArray7.length != n) {
            throw new IllegalArgumentException("length of arrays do not coincide");
        }
        int n2 = 0;
        double d2 = Math.abs(d - dArray[0]);
        for (int i = 0; i < n; ++i) {
            double d3 = Math.abs(d - dArray[i]);
            if (d3 == 0.0) {
                if (dArray3 != null) {
                    dArray3[0] = 0.0;
                }
                return dArray2[i];
            }
            if (d3 < d2) {
                n2 = i;
                d2 = d3;
            }
            dArray6[i] = dArray2[i];
            dArray7[i] = dArray2[i] + TINY;
        }
        double d4 = 0.0;
        double d5 = dArray2[n2--];
        int n3 = 0;
        while (n3 + 1 < n) {
            int n4 = 0;
            while (n4 + 1 <= n - (n3 + 1)) {
                double d6 = dArray6[n4 + 1] - dArray7[n4];
                double d7 = dArray[n4 + 1 + n3] - d;
                double d8 = (dArray[n4] - d) * dArray7[n4] / d7;
                double d9 = d8 - dArray6[n4 + 1];
                if (d9 == 0.0) {
                    throw new RuntimeException();
                }
                d9 = d6 / d9;
                dArray7[n4] = dArray6[n4 + 1] * d9;
                dArray6[n4] = d8 * d9;
                ++n4;
            }
            d4 = 2 * (n2 + 1) < n - (n3 + 1) ? dArray6[n2 + 1] : dArray7[n2--];
            d5 += d4;
            ++n3;
        }
        if (dArray3 != null) {
            dArray3[0] = d4;
        }
        return d5;
    }
}

