/*
 * Decompiled with CFR 0.152.
 */
package projects.dimont.hts;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import projects.dimont.Interpolation;

public enum HTS_SequenceWeights {
    SEQUENCE_SPECIFIC_RMAX,
    NOT_HTSELEX,
    CYCLE_SPECIFIC,
    SEQUENCE_SPECIFIC_SUM,
    SEQUENCE_SPECIFIC_MAX,
    SEQUENCE_SPECIFIC_RSUM,
    SEQUENCE_SPECIFIC_RPROD,
    SEQUENCE_SPECIFIC_LOGSUM,
    CYCLE_SPECIFIC_SMOOTHED;


    static double[] compute(DataSet seqs, double[] signals, double wf, HTS_SequenceWeights type, String[] protocolString) throws Exception {
        double[] weights = new double[signals.length];
        switch (type) {
            case NOT_HTSELEX: {
                weights = Interpolation.getWeight(seqs, signals, wf, Interpolation.RANK_LOG);
                break;
            }
            case CYCLE_SPECIFIC: {
                double[] weightsPerCycle = HTS_SequenceWeights.getAllFractionsOfNonspecificSequences(seqs, signals);
                int minCycle = (int)ToolBox.min(signals);
                weightsPerCycle = HTS_SequenceWeights.getCycleSpecificWeightsFromFractions(weightsPerCycle, minCycle, protocolString);
                int n = 0;
                while (n < signals.length) {
                    weights[n] = weightsPerCycle[(int)signals[n] - minCycle];
                    ++n;
                }
                break;
            }
            case CYCLE_SPECIFIC_SMOOTHED: {
                double[] weightsPerCycle = HTS_SequenceWeights.getAllFractionsOfNonspecificSequences(seqs, signals);
                int minCycle = (int)ToolBox.min(signals);
                weightsPerCycle = HTS_SequenceWeights.getSmoothedCycleSpecificWeightsFromFractions(weightsPerCycle, minCycle, protocolString);
                int n = 0;
                while (n < signals.length) {
                    weights[n] = weightsPerCycle[(int)signals[n] - minCycle];
                    ++n;
                }
                break;
            }
            case SEQUENCE_SPECIFIC_SUM: {
                weights = HTS_SequenceWeights.getAllSequenceSpecificWeights(seqs, signals, SEQUENCE_SPECIFIC_SUM, protocolString);
                break;
            }
            case SEQUENCE_SPECIFIC_RPROD: {
                weights = HTS_SequenceWeights.getAllSequenceSpecificWeights(seqs, signals, SEQUENCE_SPECIFIC_RPROD, protocolString);
                break;
            }
            case SEQUENCE_SPECIFIC_MAX: {
                weights = HTS_SequenceWeights.getAllSequenceSpecificWeights(seqs, signals, SEQUENCE_SPECIFIC_MAX, protocolString);
                break;
            }
            case SEQUENCE_SPECIFIC_RMAX: {
                weights = HTS_SequenceWeights.getAllSequenceSpecificWeights(seqs, signals, SEQUENCE_SPECIFIC_RMAX, protocolString);
                break;
            }
            case SEQUENCE_SPECIFIC_RSUM: {
                weights = HTS_SequenceWeights.getAllSequenceSpecificWeights(seqs, signals, SEQUENCE_SPECIFIC_RSUM, protocolString);
                break;
            }
            case SEQUENCE_SPECIFIC_LOGSUM: {
                weights = HTS_SequenceWeights.getAllSequenceSpecificWeights(seqs, signals, SEQUENCE_SPECIFIC_LOGSUM, protocolString);
            }
        }
        return weights;
    }

    private static double[] getCycleSpecificWeightsFromFractions(double[] fractions, int minCycle, String[] protocolString) {
        double[] weightsPerCycle = new double[fractions.length];
        weightsPerCycle[0] = fractions[0];
        int cycle = 0;
        while (cycle < weightsPerCycle.length - 1) {
            weightsPerCycle[cycle + 1] = fractions[cycle + 1];
            if (weightsPerCycle[cycle] < weightsPerCycle[cycle + 1]) {
                weightsPerCycle[cycle + 1] = weightsPerCycle[cycle];
            }
            ++cycle;
        }
        int i = weightsPerCycle.length - 1;
        while (i >= 0) {
            weightsPerCycle[i] = 1.0 - weightsPerCycle[i] / weightsPerCycle[0];
            --i;
        }
        protocolString[0] = String.valueOf(protocolString[0]) + "Cycle weights\n";
        if (ToolBox.sum(weightsPerCycle) == 0.0) {
            weightsPerCycle[0] = 0.0;
            protocolString[0] = String.valueOf(protocolString[0]) + "cycle " + minCycle + ": " + weightsPerCycle[0] + "\n";
            i = 1;
            while (i < weightsPerCycle.length) {
                weightsPerCycle[i] = 1.0;
                protocolString[0] = String.valueOf(protocolString[0]) + "cycle " + (minCycle + i) + ": " + weightsPerCycle[i] + "\n";
                ++i;
            }
        } else {
            i = 0;
            while (i < weightsPerCycle.length) {
                int n = i;
                weightsPerCycle[n] = weightsPerCycle[n] / weightsPerCycle[weightsPerCycle.length - 1];
                protocolString[0] = String.valueOf(protocolString[0]) + "cycle " + (minCycle + i) + ": " + weightsPerCycle[i] + "\n";
                ++i;
            }
        }
        return weightsPerCycle;
    }

    private static double[] getSmoothedCycleSpecificWeightsFromFractions(double[] fractions, int minCycle, String[] protocolString) {
        double[] weightsPerCycle = new double[fractions.length];
        double maxWeight = ToolBox.max(fractions);
        int i = 0;
        while (i < weightsPerCycle.length) {
            weightsPerCycle[i] = 1.0 - fractions[i] / maxWeight;
            ++i;
        }
        maxWeight = ToolBox.max(weightsPerCycle);
        i = 0;
        while (i < weightsPerCycle.length) {
            int n = i++;
            weightsPerCycle[n] = weightsPerCycle[n] / maxWeight;
        }
        double enrichmentConstant = HTS_SequenceWeights.approximateEnrichment(weightsPerCycle, minCycle, Math.pow(10.0, -9.0));
        protocolString[0] = String.valueOf(protocolString[0]) + "Enrichment constant: " + enrichmentConstant + "\n";
        protocolString[0] = String.valueOf(protocolString[0]) + "Cycle weights\n";
        int maxCycle = minCycle + weightsPerCycle.length - 1;
        int i2 = minCycle;
        while (i2 <= maxCycle) {
            weightsPerCycle[i2 - minCycle] = Math.pow(enrichmentConstant, i2 - maxCycle);
            protocolString[0] = String.valueOf(protocolString[0]) + "cycle " + i2 + ": " + weightsPerCycle[i2 - minCycle] + "\n";
            ++i2;
        }
        return weightsPerCycle;
    }

    static double[] getAllFractionsOfNonspecificSequences(DataSet seqs, double[] signals) throws WrongAlphabetException, OperationNotSupportedException {
        Pair<Double, Integer>[] informationPerCycle = HTS_SequenceWeights.getNonspecificSequenceInformation(seqs, signals);
        double[] fractions = new double[informationPerCycle.length];
        int i = 0;
        while (i < informationPerCycle.length) {
            fractions[i] = informationPerCycle[i].getFirstElement() / (double)informationPerCycle[i].getSecondElement().intValue();
            ++i;
        }
        return fractions;
    }

    private static double[] getAllFractionsOfNonspecificSequences(Pair<Double, Integer>[] informationPerCycle) throws WrongAlphabetException, OperationNotSupportedException {
        double[] fractions = new double[informationPerCycle.length];
        int i = 0;
        while (i < informationPerCycle.length) {
            fractions[i] = informationPerCycle[i].getFirstElement() / (double)informationPerCycle[i].getSecondElement().intValue();
            ++i;
        }
        return fractions;
    }

    private static Pair<Double, Integer>[] getNonspecificSequenceInformation(DataSet seqs, double[] signals) throws WrongAlphabetException, OperationNotSupportedException {
        AlphabetContainer con = seqs.getAlphabetContainer();
        if (!con.isSimple() || !con.isDiscrete()) {
            throw new WrongAlphabetException();
        }
        Object[] data = new ComparableElement[signals.length];
        int n = 0;
        while (n < signals.length) {
            data[n] = new ComparableElement<Sequence, Integer>(seqs.getElementAt(n), (int)signals[n]);
            ++n;
        }
        Arrays.sort(data);
        int minCycle = (Integer)((ComparableElement)data[0]).getWeight();
        int maxCycle = (Integer)((ComparableElement)data[signals.length - 1]).getWeight();
        Pair[] informationPerCycle = new Pair[maxCycle - minCycle + 1];
        int cycle = minCycle;
        ArrayList<Sequence> cycleSequences = new ArrayList<Sequence>();
        int n2 = 0;
        while (n2 < signals.length) {
            if ((Integer)((ComparableElement)data[n2]).getWeight() > cycle) {
                Sequence[] cycleData = cycleSequences.toArray(new Sequence[cycleSequences.size()]);
                cycleSequences.clear();
                informationPerCycle[cycle - minCycle] = HTS_SequenceWeights.getSequenceInformationOfCycle(cycleData).getSecondElement();
                ++cycle;
            } else {
                cycleSequences.add((Sequence)((ComparableElement)data[n2]).getElement());
            }
            ++n2;
        }
        Sequence[] cycleData = cycleSequences.toArray(new Sequence[cycleSequences.size()]);
        informationPerCycle[maxCycle - minCycle] = HTS_SequenceWeights.getSequenceInformationOfCycle(cycleData).getSecondElement();
        return informationPerCycle;
    }

    private static double[] getAllSequenceSpecificWeights(DataSet seqs, double[] signals, HTS_SequenceWeights type, String[] protocolString) throws WrongAlphabetException, OperationNotSupportedException {
        AlphabetContainer con = seqs.getAlphabetContainer();
        if (!con.isSimple() || !con.isDiscrete()) {
            throw new WrongAlphabetException();
        }
        int[] dataSetIndices = ToolBox.order(signals, false);
        ComparableElement[] data = new ComparableElement[signals.length];
        int n = 0;
        while (n < signals.length) {
            data[dataSetIndices[n]] = new ComparableElement<Sequence, Integer>(seqs.getElementAt(n), (int)signals[n]);
            ++n;
        }
        int minCycle = (Integer)data[0].getWeight();
        int maxCycle = (Integer)data[signals.length - 1].getWeight();
        ArrayList<Sequence[]> dataPerCycle = new ArrayList<Sequence[]>(maxCycle - minCycle + 1);
        Pair[] informationPerCycle = new Pair[maxCycle - minCycle + 1];
        int cycle = minCycle;
        ArrayList<Sequence> cycleSequences = new ArrayList<Sequence>();
        int n2 = 0;
        while (n2 < signals.length) {
            if ((Integer)data[n2].getWeight() > cycle) {
                Sequence[] cycleData = cycleSequences.toArray(new Sequence[cycleSequences.size()]);
                dataPerCycle.add(cycleData);
                cycleSequences.clear();
                informationPerCycle[cycle - minCycle] = HTS_SequenceWeights.getSequenceInformationOfCycle(cycleData);
                ++cycle;
            } else {
                cycleSequences.add((Sequence)data[n2].getElement());
            }
            ++n2;
        }
        Sequence[] cycleData = cycleSequences.toArray(new Sequence[cycleSequences.size()]);
        dataPerCycle.add(cycleData);
        informationPerCycle[maxCycle - minCycle] = HTS_SequenceWeights.getSequenceInformationOfCycle(cycleData);
        Pair[] fractionInfo = new Pair[informationPerCycle.length];
        ArrayList<ComparableElement<String, Double>[]> specific8mers = new ArrayList<ComparableElement<String, Double>[]>(informationPerCycle.length);
        int i = 0;
        while (i < informationPerCycle.length) {
            fractionInfo[i] = (Pair)informationPerCycle[i].getSecondElement();
            specific8mers.add((ComparableElement[])informationPerCycle[i].getFirstElement());
            ++i;
        }
        double[] fractions = HTS_SequenceWeights.getAllFractionsOfNonspecificSequences(fractionInfo);
        double[] weightsPerCycle = HTS_SequenceWeights.getCycleSpecificWeightsFromFractions(fractions, minCycle, protocolString);
        ArrayList<double[]> sequenceSpecificWeightsPerCycle = HTS_SequenceWeights.getSequenceSpecificWeightsPerCycle(dataPerCycle, specific8mers, weightsPerCycle, type, protocolString);
        double[] sequenceSpecificWeights = new double[signals.length];
        int firstCycleIndex = 0;
        int i2 = 0;
        while (i2 < sequenceSpecificWeightsPerCycle.size()) {
            int j = 0;
            while (j < sequenceSpecificWeightsPerCycle.get(i2).length) {
                sequenceSpecificWeights[firstCycleIndex + j] = sequenceSpecificWeightsPerCycle.get(i2)[j];
                ++j;
            }
            firstCycleIndex += sequenceSpecificWeightsPerCycle.get(i2).length;
            ++i2;
        }
        double[] weights = new double[signals.length];
        int n3 = 0;
        while (n3 < signals.length) {
            weights[n3] = sequenceSpecificWeights[dataSetIndices[n3]];
            ++n3;
        }
        return weights;
    }

    private static Pair<ComparableElement<String, Double>[], Pair<Double, Integer>> getSequenceInformationOfCycle(Sequence[] cycleData) throws WrongAlphabetException, OperationNotSupportedException {
        Hashtable<String, Double> kmerCounts = new Hashtable<String, Double>();
        HashSet<String> kmersOfSingleSequence = new HashSet<String>();
        int k = 8;
        String[] s = new String[2];
        int n = 0;
        while (n < cycleData.length) {
            Sequence seq = cycleData[n];
            s[0] = seq.toString();
            s[1] = seq.reverseComplement().toString();
            int lastStart = seq.getLength() - k;
            kmersOfSingleSequence.clear();
            int startPosition = 0;
            while (startPosition <= lastStart) {
                String revComplKmer;
                String kmer = s[0].substring(startPosition, startPosition + k);
                String string = kmer = kmer.compareTo(revComplKmer = s[1].substring(s[0].length() - k - startPosition, s[0].length() - startPosition)) < 0 ? kmer : revComplKmer;
                if (!kmersOfSingleSequence.contains(kmer)) {
                    kmersOfSingleSequence.add(kmer);
                }
                ++startPosition;
            }
            Iterator it = kmersOfSingleSequence.iterator();
            while (it.hasNext()) {
                s[0] = (String)it.next();
                double kmerCount = kmerCounts.containsKey(s[0]) ? (Double)kmerCounts.get(s[0]) + 1.0 : 1.0;
                kmerCounts.put(s[0], kmerCount);
            }
            ++n;
        }
        int first_index = (int)Math.ceil(0.25 * (double)kmerCounts.size());
        int last_index = (int)Math.floor(0.75 * (double)kmerCounts.size());
        Object[] comparableKmerCounts = new ComparableElement[kmerCounts.size()];
        Iterator it = kmerCounts.entrySet().iterator();
        int a = 0;
        while (a < comparableKmerCounts.length) {
            Map.Entry entry = it.next();
            comparableKmerCounts[a] = new ComparableElement(entry.getKey(), (Comparable)entry.getValue());
            ++a;
        }
        Arrays.sort(comparableKmerCounts);
        double nonspecificOccurrences = 0.0;
        ComparableElement[] interestingKmers = new ComparableElement[kmerCounts.size() - last_index - 1];
        int i = first_index;
        while (i <= last_index) {
            nonspecificOccurrences += ((Double)((ComparableElement)comparableKmerCounts[i]).getWeight()).doubleValue();
            ++i;
        }
        i = last_index + 1;
        while (i < kmerCounts.size()) {
            interestingKmers[i - last_index - 1] = comparableKmerCounts[i];
            ++i;
        }
        return new Pair<ComparableElement<String, Double>[], Pair<Double, Integer>>(interestingKmers, new Pair<Double, Integer>(nonspecificOccurrences, cycleData.length));
    }

    private static ArrayList<double[]> getSequenceSpecificWeightsPerCycle(ArrayList<Sequence[]> cycleData, ArrayList<ComparableElement<String, Double>[]> topKmers, double[] cycleWeights, HTS_SequenceWeights type, String[] protocolString) throws OperationNotSupportedException {
        ArrayList<double[]> sequenceSpecificWeightsPerCycle = new ArrayList<double[]>(cycleWeights.length);
        double[] cycleWeights2 = (double[])cycleWeights.clone();
        int cycleIndex = cycleWeights.length - 1;
        while (cycleIndex >= 0) {
            double[] sequenceWeights = new double[cycleData.get(cycleIndex).length];
            if (cycleWeights2[cycleIndex] == 0.0) {
                sequenceSpecificWeightsPerCycle.add(sequenceWeights);
            } else {
                double prevWeight;
                double cycleDifference;
                double[] counter = new double[cycleData.get(cycleIndex).length];
                double[] sums = new double[cycleData.get(cycleIndex).length];
                double[] rSums = new double[cycleData.get(cycleIndex).length];
                double[] logSums = new double[cycleData.get(cycleIndex).length];
                double[] rProds = new double[cycleData.get(cycleIndex).length];
                double[] maxs = new double[cycleData.get(cycleIndex).length];
                double[] rMaxs = new double[cycleData.get(cycleIndex).length];
                double[] counts = new double[topKmers.get(cycleIndex).length];
                int i = 0;
                while (i < topKmers.get(cycleIndex).length) {
                    counts[i] = topKmers.get(cycleIndex)[i].getWeight();
                    ++i;
                }
                int[] ranks = ToolBox.rank(counts, ToolBox.TiedRanks.CONTIGUOUS);
                int maxRank = 0;
                Hashtable<String, Double> topKmerSet = new Hashtable<String, Double>(topKmers.get(cycleIndex).length, 1.0f);
                Hashtable<String, Double> topKmerSetWithRanks = new Hashtable<String, Double>(topKmers.get(cycleIndex).length, 1.0f);
                int i2 = 0;
                while (i2 < topKmers.get(cycleIndex).length) {
                    topKmerSet.put(topKmers.get(cycleIndex)[i2].getElement(), topKmers.get(cycleIndex)[i2].getWeight());
                    topKmerSetWithRanks.put(topKmers.get(cycleIndex)[i2].getElement(), Double.valueOf(ranks[i2]));
                    if (maxRank < ranks[i2]) {
                        maxRank = ranks[i2];
                    }
                    ++i2;
                }
                int k = 8;
                String[] s = new String[2];
                int n = 0;
                while (n < cycleData.get(cycleIndex).length) {
                    Sequence seq = cycleData.get(cycleIndex)[n];
                    s[0] = seq.toString();
                    s[1] = seq.reverseComplement().toString();
                    int lastStart = seq.getLength() - k;
                    double curMax = 0.0;
                    double curRMin = Double.MAX_VALUE;
                    rProds[n] = 1.0;
                    int startPosition = 0;
                    while (startPosition <= lastStart) {
                        String revComplKmer;
                        String kmer = s[0].substring(startPosition, startPosition + k);
                        String string = kmer = kmer.compareTo(revComplKmer = s[1].substring(s[0].length() - k - startPosition, s[0].length() - startPosition)) < 0 ? kmer : revComplKmer;
                        if (topKmerSet.containsKey(kmer)) {
                            int n2 = n;
                            counter[n2] = counter[n2] + 1.0;
                            double count = (Double)topKmerSet.get(kmer);
                            double rank = (Double)topKmerSetWithRanks.get(kmer);
                            int n3 = n;
                            sums[n3] = sums[n3] + count;
                            int n4 = n;
                            logSums[n4] = logSums[n4] + Math.log(count);
                            int n5 = n;
                            rSums[n5] = rSums[n5] + rank;
                            int n6 = n;
                            rProds[n6] = rProds[n6] * ((double)maxRank - rank + 1.0);
                            if (count > curMax) {
                                curMax = count;
                            }
                            if (rank < curRMin) {
                                curRMin = rank;
                            }
                        }
                        ++startPosition;
                    }
                    rProds[n] = curRMin == Double.MAX_VALUE ? 0.0 : Math.pow(rProds[n], 1.0 / counter[n]);
                    maxs[n] = curMax;
                    rMaxs[n] = curRMin == Double.MAX_VALUE ? 0.0 : (double)maxRank - curRMin + 1.0;
                    ++n;
                }
                if (cycleIndex == 0) {
                    cycleDifference = cycleWeights2[0];
                    prevWeight = 0.0;
                } else {
                    cycleDifference = cycleWeights2[cycleIndex] - cycleWeights2[cycleIndex - 1];
                    cycleDifference = Math.min(0.5, cycleDifference);
                    prevWeight = cycleWeights2[cycleIndex] - cycleDifference;
                    if (cycleDifference == 0.0) {
                        cycleDifference = Math.min(0.01, cycleWeights2[cycleIndex - 1] / 2.0);
                        int n7 = cycleIndex - 1;
                        cycleWeights2[n7] = cycleWeights2[n7] - cycleDifference;
                        int cycle = cycleIndex - 1;
                        while (cycle > 0) {
                            if (cycleWeights2[cycle - 1] > cycleWeights2[cycle]) {
                                cycleWeights2[cycle - 1] = cycleWeights2[cycle];
                            }
                            --cycle;
                        }
                        prevWeight = cycleWeights2[cycleIndex - 1];
                    }
                }
                if (type == SEQUENCE_SPECIFIC_SUM) {
                    double maxSum = ToolBox.max(sums);
                    n = 0;
                    while (n < cycleData.get(cycleIndex).length) {
                        sequenceWeights[n] = prevWeight + cycleDifference * sums[n] / maxSum;
                        ++n;
                    }
                } else if (type == SEQUENCE_SPECIFIC_MAX) {
                    double maxMax = ToolBox.max(maxs);
                    n = 0;
                    while (n < cycleData.get(cycleIndex).length) {
                        sequenceWeights[n] = prevWeight + cycleDifference * maxs[n] / maxMax;
                        ++n;
                    }
                } else if (type == SEQUENCE_SPECIFIC_RPROD) {
                    double maxRProd = ToolBox.max(rProds);
                    n = 0;
                    while (n < cycleData.get(cycleIndex).length) {
                        sequenceWeights[n] = prevWeight + cycleDifference * rProds[n] / maxRProd;
                        ++n;
                    }
                } else if (type == SEQUENCE_SPECIFIC_RSUM) {
                    double maxRSum = ToolBox.max(rSums);
                    n = 0;
                    while (n < cycleData.get(cycleIndex).length) {
                        sequenceWeights[n] = prevWeight + cycleDifference * rSums[n] / maxRSum;
                        ++n;
                    }
                } else if (type == SEQUENCE_SPECIFIC_RMAX) {
                    double maxRMax = ToolBox.max(rMaxs);
                    n = 0;
                    while (n < cycleData.get(cycleIndex).length) {
                        sequenceWeights[n] = prevWeight + cycleDifference * rMaxs[n] / maxRMax;
                        ++n;
                    }
                } else if (type == SEQUENCE_SPECIFIC_LOGSUM) {
                    double maxLogSum = ToolBox.max(logSums);
                    n = 0;
                    while (n < cycleData.get(cycleIndex).length) {
                        sequenceWeights[n] = prevWeight + cycleDifference * logSums[n] / maxLogSum;
                        ++n;
                    }
                }
                sequenceSpecificWeightsPerCycle.add(sequenceWeights);
            }
            --cycleIndex;
        }
        protocolString[0] = String.valueOf(protocolString[0]) + "-----------------------------------------\n" + "Effective cycle weights:\n";
        int i = 0;
        while (i < cycleWeights2.length) {
            protocolString[0] = String.valueOf(protocolString[0]) + cycleWeights2[i] + "\n";
            ++i;
        }
        Collections.reverse(sequenceSpecificWeightsPerCycle);
        return sequenceSpecificWeightsPerCycle;
    }

    private static double approximateEnrichment(double[] weightsPerCycle, int minCycle, double precision) {
        double new_e;
        double old_e = 1.0;
        double direction = HTS_SequenceWeights.getDirection(old_e, weightsPerCycle, minCycle);
        double stepsize = 1.0;
        while ((direction = HTS_SequenceWeights.getDirection(new_e = old_e + direction * stepsize, weightsPerCycle, minCycle)) != 0.0) {
            if (old_e < new_e && direction < 0.0 || old_e > new_e && direction > 0.0) {
                if (!(stepsize > precision)) break;
                stepsize *= 0.1;
            }
            if (old_e == new_e || new_e >= 50.0) break;
            old_e = new_e;
        }
        return new_e;
    }

    private static double getDirection(double e, double[] weightsPerCycle, int minCycle) {
        int maxCycle = minCycle + weightsPerCycle.length - 1;
        double derivation = 0.0;
        int i = minCycle;
        while (i <= maxCycle) {
            derivation += 2.0 * Math.pow(e, i - maxCycle) * (double)(i - maxCycle) * (Math.pow(e, i - maxCycle) - weightsPerCycle[i - minCycle]) / e;
            ++i;
        }
        return -Math.signum(derivation);
    }

    static double findPwmCorrectionFactor(int cycle1, int cycle2, DataSet seqs, double[] signals) throws OperationNotSupportedException, WrongAlphabetException {
        if (cycle2 < cycle1) {
            int helper = cycle1;
            cycle1 = cycle2;
            cycle2 = helper;
        }
        int minCycle = (int)ToolBox.min(signals);
        Pair<Double, Integer>[] information = HTS_SequenceWeights.getNonspecificSequenceInformation(seqs, signals);
        double[] fractions = new double[information.length];
        int i = 0;
        while (i < fractions.length) {
            fractions[i] = information[i].getFirstElement() / (double)information[i].getSecondElement().intValue();
            ++i;
        }
        double factor = fractions[cycle2 - minCycle] / fractions[cycle1 - minCycle];
        if (factor > 1.0) {
            factor = 1.0;
        }
        return factor *= (double)information[cycle2 - minCycle].getSecondElement().intValue() / (double)information[cycle1 - minCycle].getSecondElement().intValue();
    }
}

