/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.classifiers.performanceMeasures.PRCurve;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.DoubleList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;

public class Performance {
    public static void main(String[] args) throws IOException {
        String pred;
        boolean curve = false;
        GZIPInputStream stream2 = new GZIPInputStream(new FileInputStream(args[0]));
        BufferedReader preds = new BufferedReader(new InputStreamReader(stream2));
        int col = Integer.parseInt(args[2]);
        GZIPInputStream stream = new GZIPInputStream(new FileInputStream(args[1]));
        BufferedReader labels = new BufferedReader(new InputStreamReader(stream));
        String lab = labels.readLine();
        System.out.println("Compute performance for cell type: " + lab.split("\t")[col]);
        DoubleList pos = new DoubleList();
        DoubleList neg = new DoubleList();
        String chr = null;
        while ((lab = labels.readLine()) != null && (pred = preds.readLine()) != null) {
            String[] pSplit;
            if (chr == null || !lab.startsWith(chr)) {
                chr = lab.substring(0, lab.indexOf(9) + 1);
                System.out.println(chr);
            }
            String old = null;
            while (pred != null && !pred.startsWith(chr)) {
                if (old == null || !pred.startsWith(old)) {
                    old = pred.substring(0, pred.indexOf(9) + 1);
                    System.out.println("Skip " + old);
                }
                pred = preds.readLine();
            }
            if (pred == null) break;
            String[] lSplit = lab.split("\t");
            if (lSplit[0].equalsIgnoreCase((pSplit = pred.split("\t"))[0]) && lSplit[1].equalsIgnoreCase(pSplit[1])) {
                double ag = Double.parseDouble(pSplit[3]);
                switch (lSplit[col].charAt(0)) {
                    case 'B': 
                    case 'b': {
                        pos.add(ag);
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        neg.add(ag);
                    }
                }
                continue;
            }
            throw new RuntimeException("could not match:\n" + lab + "\n" + pred);
        }
        labels.close();
        preds.close();
        double[] po = pos.toArray();
        double[] ne = neg.toArray();
        Arrays.sort(po);
        Arrays.sort(ne);
        System.out.println("#positives: " + po.length + "\t" + po[0] + " .. " + po[po.length - 1]);
        System.out.println("#negatives: " + ne.length + "\t" + ne[0] + " .. " + ne[ne.length - 1]);
        System.out.println("random: " + (double)po.length / (double)(po.length + ne.length));
        System.out.println();
        System.out.println(new AucROC().compute(po, ne));
        System.out.println(new AucPR().compute(po, ne));
        ResultSet rs = new PRCurve().compute(po, ne);
        AbstractScoreBasedClassifier.DoubleTableResult dtr = (AbstractScoreBasedClassifier.DoubleTableResult)rs.getResultAt(rs.getNumberOfResults() - 1);
        double[][] c = dtr.getValue();
        double max10 = 0.0;
        double max50 = 0.0;
        BufferedWriter w = null;
        if (curve) {
            w = new BufferedWriter(new FileWriter(String.valueOf(args[0]) + ".prcurve"));
        }
        int i = 0;
        while (i < c.length) {
            if (c[i][1] >= 0.9 && c[i][0] > max10) {
                max10 = c[i][0];
            }
            if (c[i][1] >= 0.5 && c[i][0] > max50) {
                max50 = c[i][0];
            }
            if (w != null) {
                w.append(String.valueOf(c[i][0]) + "\t" + c[i][1]);
                w.newLine();
            }
            ++i;
        }
        if (w != null) {
            w.close();
        }
        System.out.println("Recall at 10% FDR: " + max10);
        System.out.println("Recall at 50% FDR: " + max50);
    }
}

