/*
 * Decompiled with CFR 0.152.
 */
package projects.encodedream.tools;

import de.jstacs.DataType;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.LinkedList;
import java.util.zip.GZIPOutputStream;
import projects.encodedream.DeriveLabels;

public class DeriveLabelTool
implements JstacsTool {
    @Override
    public ToolParameterSet getToolParameters() {
        LinkedList<Parameter> pars = new LinkedList<Parameter>();
        pars.add(new FileParameter("Conservative peaks", "NarrowPeak file containing the conservative peaks", "narrowPeak,bed", true));
        pars.add(new FileParameter("Relaxed peaks", "NarrowPeak file containing the relaxed peaks", "narrowPeak,bed", true));
        pars.add(new FileParameter("FAI of genome", "FastA index file of the genome", "fai", true));
        try {
            pars.add(new SimpleParameter(DataType.INT, "Bin width", "The width of the genomic bins considered", true, new NumberValidator<Integer>(1, 10000), 50));
            pars.add(new SimpleParameter(DataType.INT, "Region width", "The width of the genomic regions considered for overlaps", true, new NumberValidator<Integer>(1, 10000), 50));
        }
        catch (ParameterException e) {
            e.printStackTrace();
        }
        return new ToolParameterSet(this.getShortName(), pars.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        boolean bySummit = false;
        String consFile = ((FileParameter)parameters.getParameterAt(0)).getFileContents().getFilename();
        String relFile = ((FileParameter)parameters.getParameterAt(1)).getFileContents().getFilename();
        String faiFile = ((FileParameter)parameters.getParameterAt(2)).getFileContents().getFilename();
        int bin = (Integer)parameters.getParameterAt(3).getValue();
        int reg = (Integer)parameters.getParameterAt(4).getValue();
        File outfile = File.createTempFile("labels", ".temp.gz", new File("."));
        outfile.deleteOnExit();
        PrintWriter wr = new PrintWriter(new GZIPOutputStream(new FileOutputStream(outfile)));
        DeriveLabels.run(consFile, relFile, faiFile, wr, bin, reg, bySummit);
        wr.close();
        TextResult tr = new TextResult("Labels", "Labels derived from peak files", new FileParameter.FileRepresentation(outfile.getAbsolutePath()), "tsv.gz", this.getToolName(), null, true);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(tr), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "Derive labels";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "labels";
    }

    @Override
    public String getDescription() {
        return "derives labels (S: summit, B: bound, A: ambiguous, U: unbound) for genomic regions based on ChIP-seq peak files";
    }

    @Override
    public String getHelpText() {
        return "**Derive labels** computes labels for genomic regions based on ChIP-seq peak files. The input ChIP-seq peak files must be provided in narrowPeak format and may come in *conservative*, i.e., IDR-thresholded, and *relaxed* flavors. In case only a single peak file is available, both of the corresponding parameters may be set to this one peak file. The parameter for the bin width defines the resolution of genomic regions that is assigned a label, while the parameter for the region width defines the size of the regions considered. If, for instance, the bin width is set to 50 and the region width to 100, regions of 100 bp shifted by 50 bp along the genome are labeled. The labels assigned may be *S* (summit) is the current bin contains the annotated summit of a conservative peak, *B* (bound) if the current region overlaps a conservative peak by at least half the region width, *A* (ambiguous) if the current region overlaps a relaxed peak by at least 1 bp, or *U* (unbound) if it overlaps with none of the peaks. The output is provided as a gzipped file *Labels.tsv.gz* with columns chromosome, start position, and label. This output file together with a protocol of the tool run is saved to the specified output directory.";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

