/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.parameters.validation.RegExpValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import projects.gemoma.GeMoMaAnnotationFilter;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class Attribute2Table
extends GeMoMaModule {
    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String tempD) throws Exception {
        String[] split;
        String t;
        String line;
        BufferedReader r;
        String tag = parameters.getParameterForName("tag").getValue().toString();
        ExpandableParameterSet eps = (ExpandableParameterSet)parameters.getParameterForName("raw annotation").getValue();
        boolean addPrefix = (Boolean)parameters.getParameterForName("add").getValue();
        String attribute = parameters.getParameterForName("attribute").getValue().toString();
        protocol.append("\nused attribute: " + attribute + "\n\n");
        GeMoMaAnnotationFilter.Prediction current = null;
        HashMap<String, int[]> del = new HashMap<String, int[]>();
        int MAX = eps.getNumberOfParameters();
        String[] prefix = new String[MAX];
        String[] sampleInfo = new String[MAX];
        HashMap<String, ArrayList<GeMoMaAnnotationFilter.Prediction>> raw = new HashMap<String, ArrayList<GeMoMaAnnotationFilter.Prediction>>();
        int k = 0;
        while (k < MAX) {
            SimpleParameterSet sps = (SimpleParameterSet)eps.getParameterAt(k).getValue();
            String h = (String)sps.getParameterAt(0).getValue();
            prefix[k] = h == null ? "" : h;
            String pref = addPrefix ? prefix[k] : "";
            sampleInfo[k] = String.valueOf(k) + (prefix[k] == null || prefix[k].length() == 0 ? "" : " (" + prefix[k] + ")");
            protocol.append("species " + sampleInfo[k] + "\n");
            String fName = sps.getParameterAt(1).getValue().toString();
            r = new BufferedReader(new FileReader(fName));
            while ((line = r.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#' || (t = (split = line.split("\t"))[2]).equals("gene")) continue;
                if (t.equals(tag)) {
                    current = new GeMoMaAnnotationFilter.Prediction(split, MAX, k, pref, del);
                    String key = current.hash.get("ref-gene");
                    ArrayList<GeMoMaAnnotationFilter.Prediction> list = raw.get(key);
                    if (list == null) {
                        list = new ArrayList();
                        raw.put(key, list);
                    }
                    list.add(current);
                    continue;
                }
                if (current == null) {
                    r.close();
                    throw new NullPointerException("There is no gene model. Please check parameter \"tag\" and the order within your annotation file " + sampleInfo + ": " + fName);
                }
                if (split[8].contains("Parent=" + current.oldId)) {
                    if (!t.equals("CDS")) continue;
                    current.addCDS(line);
                    continue;
                }
                r.close();
                throw new IllegalArgumentException("The GFF has to be clustered, i.e., all features of a transcript must be adjacent lines:\n" + line);
            }
            r.close();
            ++k;
        }
        File out = Tools.createTempFile("Attribute", tempD);
        BufferedWriter outW = new BufferedWriter(new FileWriter(out));
        outW.append("#geneID\tchr\tstart\tend");
        int i = 0;
        while (i < sampleInfo.length) {
            outW.append("\t" + sampleInfo[i]);
            ++i;
        }
        outW.newLine();
        String fName = parameters.getParameterForName("final gene annotation file").getValue().toString();
        System.out.println("\"" + fName + "\"\t" + new File(fName).exists());
        r = new BufferedReader(new FileReader(fName));
        double[] best = new double[MAX];
        current = null;
        while ((line = r.readLine()) != null) {
            if (line.length() == 0 || line.charAt(0) == '#' || (t = (split = line.split("\t"))[2]).equals("gene")) continue;
            if (t.equals(tag)) {
                if (current != null) {
                    this.createLine(current, raw, attribute, outW, best);
                }
                current = new GeMoMaAnnotationFilter.Prediction(split, MAX, 0, "", del);
                continue;
            }
            if (current == null) {
                r.close();
                throw new NullPointerException("There is no gene model. Please check parameter \"tag\" and the order within your annotation file " + sampleInfo + ": " + fName);
            }
            if (split[8].contains("Parent=" + current.oldId)) {
                if (!t.equals("CDS")) continue;
                current.addCDS(line);
                continue;
            }
            r.close();
            throw new IllegalArgumentException("The GFF has to be clustered, i.e., all features of a transcript must be adjacent lines:\n" + line);
        }
        r.close();
        if (current != null) {
            this.createLine(current, raw, attribute, outW, best);
        }
        outW.close();
        ArrayList<TextResult> res = new ArrayList<TextResult>();
        res.add(new TextResult("best attribute", "Result", new FileParameter.FileRepresentation(out.getAbsolutePath()), "tabular", this.getToolName(), null, true));
        return new ToolResult("", "", null, new ResultSet(res), parameters, this.getToolName(), new Date());
    }

    void createLine(GeMoMaAnnotationFilter.Prediction current, HashMap<String, ArrayList<GeMoMaAnnotationFilter.Prediction>> raw, String attribute, BufferedWriter w, double[] best) throws IOException {
        Arrays.fill(best, -1000.0);
        this.set(current, raw.get(current.hash.get("ref-gene")), attribute, best);
        String alt = current.hash.get("alternative");
        if (alt != null && alt.length() > 0) {
            String[] a;
            if (alt.charAt(0) == '\"' && alt.charAt(alt.length() - 1) == '#') {
                alt = alt.substring(1, alt.length() - 1);
            }
            String[] stringArray = a = alt.split(",");
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                String alter = stringArray[n2];
                this.set(current, raw.get(alter), attribute, best);
                ++n2;
            }
        }
        w.append(String.valueOf(current.id) + "\t" + current.split[0] + "\t" + current.split[3] + "\t" + current.split[4]);
        int i = 0;
        while (i < best.length) {
            w.append("\t" + (best[i] < -100.0 ? "NA" : Double.valueOf(best[i])));
            ++i;
        }
        w.newLine();
    }

    void set(GeMoMaAnnotationFilter.Prediction current, ArrayList<GeMoMaAnnotationFilter.Prediction> p, String attribute, double[] best) {
        if (p != null) {
            for (GeMoMaAnnotationFilter.Prediction b : p) {
                if (current.compareTo(b) != 0) continue;
                int index = b.getIndex();
                double val = Double.parseDouble(b.hash.get(attribute));
                if (!(val > best[index])) continue;
                best[index] = val;
            }
        }
    }

    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getShortName(), new SimpleParameter(DataType.STRING, "tag", "the tag used to read the GeMoMa annotations", true, "mRNA"), new FileParameter("final gene annotation file", "GFF file containing the gene annotations (predicted by GeMoMa)", "gff,gff3", true, new FileExistsValidator(), true), new ParameterSetContainer("raw annotation", "", new ExpandableParameterSet(new SimpleParameterSet(new SimpleParameter(DataType.STRING, "prefix", "the prefix can be used to distinguish predictions from different input files", false, new RegExpValidator("\\w*")), new FileParameter("raw gene annotation file", "GFF file containing the gene annotations (predicted by GeMoMa)", "gff,gff3", true, new FileExistsValidator(), true)), "gene annotations", "", 1)), new SimpleParameter(DataType.BOOLEAN, "add", "add the prefix to the gene ID", true, true), new SimpleParameter(DataType.STRING, "attribute", "the attribute to be checked", true, "iAA"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public String getToolName() {
        return "Attribute2Table";
    }

    @Override
    public String getShortName() {
        return this.getToolName();
    }

    @Override
    public String getDescription() {
        return "returns a table of best attribute per predicted final annotation";
    }

    @Override
    public String getHelpText() {
        return "This tool returns a table of best attribute per predicted final annotation." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }
}

