/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class BestReciprocalHit {
    public static void main(String[] args) throws Exception {
        String[] split;
        String line;
        HashMap<String, Hit> hash1 = BestReciprocalHit.read(args[0]);
        HashMap<String, Hit> hash2 = BestReciprocalHit.read(args[1]);
        BufferedReader r = new BufferedReader(new FileReader(args[2]));
        HashSet<String> gene = new HashSet<String>();
        ArrayList<Hit> best = new ArrayList<Hit>();
        BufferedWriter w = new BufferedWriter(new FileWriter(args[3]));
        ArrayList<String[]> transcripts = new ArrayList<String[]>();
        HashMap<String, String> transcriptMap = new HashMap<String, String>();
        while ((line = r.readLine()) != null) {
            if (line.startsWith("#")) continue;
            split = line.split("\t");
            split[1] = split[1].toUpperCase();
            transcripts.add(split);
            transcriptMap.put(split[1], split[0]);
        }
        int k = 0;
        while (k < transcripts.size()) {
            Hit current;
            int i;
            split = (String[])transcripts.get(k);
            w.append(String.valueOf(split[0]) + "\t" + split[1]);
            Hit h = hash1.get(split[1]);
            double bestF1 = -1.0;
            best.clear();
            boolean pred = false;
            if (h == null) {
                i = 0;
                while (i < 10) {
                    w.append("\tNA");
                    ++i;
                }
            } else {
                w.append(h.toString());
                i = 0;
                while (i < h.matches.length) {
                    current = hash2.get(h.matches[i]);
                    if (current != null) {
                        pred = true;
                        if (bestF1 <= current.f1) {
                            if (bestF1 < current.f1) {
                                best.clear();
                            }
                            if (best.size() == 0) {
                                bestF1 = current.f1;
                            }
                            best.add(current);
                        }
                    }
                    ++i;
                }
            }
            w.append("\t" + (pred ? best.size() : -1) + "\t" + (pred ? Double.valueOf(bestF1) : "NA"));
            if (best.size() != 0 && h != null && h.f1 >= 0.0) {
                gene.clear();
                i = 0;
                while (i < best.size()) {
                    gene.add(((Hit)best.get((int)i)).id);
                    ++i;
                }
                w.append("\t" + BestReciprocalHit.toString(gene.toArray()));
                gene.clear();
                i = 0;
                while (i < best.size()) {
                    current = (Hit)best.get(i);
                    int j = 0;
                    while (j < current.matches.length) {
                        gene.add(current.matches[j]);
                        ++j;
                    }
                    ++i;
                }
                Object[] o = gene.toArray();
                w.append("\t" + BestReciprocalHit.toString(o));
                w.flush();
                gene.clear();
                int i2 = 0;
                while (i2 < o.length) {
                    gene.add((String)transcriptMap.get(o[i2]));
                    ++i2;
                }
                w.append("\t" + BestReciprocalHit.toString(gene.toArray()));
            } else {
                i = 0;
                while (i < 3) {
                    w.append("\tNA");
                    ++i;
                }
            }
            w.newLine();
            ++k;
        }
        r.close();
        w.close();
    }

    private static HashMap<String, Hit> read(String fileName) throws Exception {
        String line;
        HashMap<String, Hit> hash = new HashMap<String, Hit>();
        BufferedReader r = new BufferedReader(new FileReader(fileName));
        while ((line = r.readLine()) != null) {
            if (line.startsWith("#")) continue;
            Hit h = new Hit(line);
            if (hash.containsKey(h.id)) {
                throw new IllegalArgumentException(h.id);
            }
            hash.put(h.id, h);
        }
        r.close();
        return hash;
    }

    private static String toString(Object[] a) {
        int iMax = a.length - 1;
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < a.length) {
            b.append(String.valueOf(a[i]));
            if (i < iMax) {
                b.append(", ");
            }
            ++i;
        }
        return b.toString();
    }

    static class Hit {
        String geneID;
        String id;
        String line;
        double f1;
        String[] matches;

        Hit(String line) {
            this.line = line;
            String[] split = line.split("\t");
            this.id = split[1];
            this.geneID = split[0];
            this.f1 = split[split.length - 2].equals("NA") ? Double.NaN : Double.parseDouble(split[split.length - 2]);
            this.matches = split[split.length - 1].toUpperCase().split(";");
            int i = 0;
            while (i < this.matches.length) {
                this.matches[i] = this.matches[i].split(",")[0];
                ++i;
            }
        }

        public String toString() {
            int idx = this.line.indexOf(9);
            idx = this.line.indexOf(9, idx + 1);
            return this.line.substring(idx);
        }
    }
}

