/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;

public class CombineCoverageFiles {
    public static void main(String[] args) throws IOException, CloneNotSupportedException {
        String line;
        System.out.println("files: " + (args.length - 1));
        BufferedWriter w = new BufferedWriter(new FileWriter(args[0]));
        BufferedReader[] r = new BufferedReader[args.length - 1];
        BedEntry[] bed = new BedEntry[args.length - 1];
        int i = 0;
        while (i < r.length) {
            System.out.println(String.valueOf(i) + "\t" + args[i + 1]);
            r[i] = new BufferedReader(new FileReader(args[i + 1]));
            line = r[i].readLine();
            if (i == 0) {
                w.append(line);
                w.newLine();
            }
            bed[i] = new BedEntry(r[i].readLine());
            ++i;
        }
        BedEntry current = null;
        boolean[] sameStart = new boolean[r.length];
        int same = 0;
        do {
            BedEntry next = null;
            same = 0;
            Arrays.fill(sameStart, false);
            int i2 = 0;
            while (i2 < bed.length) {
                if (bed[i2] != null) {
                    if (next == null) {
                        next = bed[i2];
                        sameStart[i2] = true;
                        ++same;
                    } else {
                        int comp = next.compareTo(bed[i2]);
                        if (comp >= 0) {
                            if (comp > 0) {
                                Arrays.fill(sameStart, false);
                                next = bed[i2];
                                same = 0;
                            }
                            sameStart[i2] = true;
                            ++same;
                        }
                    }
                }
                ++i2;
            }
            if (same <= 0) continue;
            BedEntry now = next.clone();
            boolean first = true;
            int i3 = 0;
            while (i3 < bed.length) {
                if (sameStart[i3]) {
                    if (!first) {
                        if (bed[i3].end < now.end) {
                            now.end = bed[i3].end;
                        }
                        now.cov += bed[i3].cov;
                    } else {
                        first = false;
                    }
                } else if (bed[i3] != null && bed[i3].chr.equals(now.chr) && bed[i3].start < now.end) {
                    now.end = bed[i3].start;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < sameStart.length) {
                if (sameStart[i3]) {
                    if (bed[i3].end == now.end) {
                        line = r[i3].readLine();
                        bed[i3] = line != null ? new BedEntry(line) : null;
                    } else {
                        bed[i3].start = now.end;
                    }
                }
                ++i3;
            }
            if (current != null) {
                if (current.chr.equals(now.chr) && current.end == now.start && current.cov == now.cov) {
                    current.end = now.end;
                    continue;
                }
                current.write(w);
                current = now;
                continue;
            }
            current = now;
        } while (same > 0);
        if (current != null) {
            current.write(w);
        }
        w.close();
    }

    static class BedEntry
    implements Comparable<BedEntry>,
    Cloneable {
        String chr;
        int start;
        int end;
        int cov;

        BedEntry(String line) {
            String[] split = line.split("\t");
            this.chr = split[0];
            this.start = Integer.parseInt(split[1]);
            this.end = Integer.parseInt(split[2]);
            this.cov = Integer.parseInt(split[3]);
        }

        public BedEntry clone() throws CloneNotSupportedException {
            return (BedEntry)super.clone();
        }

        @Override
        public int compareTo(BedEntry o) {
            int diff = this.chr.compareTo(o.chr);
            if (diff == 0) {
                diff = Integer.compare(this.start, o.start);
            }
            return diff;
        }

        public void write(BufferedWriter w) throws IOException {
            w.write(String.valueOf(this.chr) + "\t" + this.start + "\t" + this.end + "\t" + this.cov);
            w.newLine();
        }
    }
}

