/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.io.FileManager;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import projects.gemoma.CombineIntronFiles;
import projects.gemoma.GeMoMa;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class DenoiseIntrons
extends GeMoMaModule {
    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getShortName(), new ParameterSetContainer("introns", "", new ExpandableParameterSet(new SimpleParameterSet(new FileParameter("introns", "Introns (GFF), which might be obtained from RNA-seq", "gff,gff3", true, new FileExistsValidator(), true)), "introns", "", 1)), new ParameterSetContainer("coverage", "", new ExpandableParameterSet(new SimpleParameterSet(new SelectionParameter(DataType.PARAMETERSET, new String[]{"UNSTRANDED", "STRANDED"}, new Object[]{new SimpleParameterSet(new FileParameter("coverage_unstranded", "The coverage file contains the unstranded coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator())), new SimpleParameterSet(new FileParameter("coverage_forward", "The coverage file contains the forward coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator()), new FileParameter("coverage_reverse", "The coverage file contains the reverse coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator()))}, "coverage", "experimental coverage (RNA-seq)", true)), "coverage", "", 1)), new SimpleParameter(DataType.INT, "maximum intron length", "The maximum length of an intron", true, 15000), new SimpleParameter(DataType.DOUBLE, "minimum expression", "The threshold for removing introns", true, new NumberValidator<Double>(0.0, 1.0), 0.01), new SimpleParameter(DataType.INT, "context", "The context upstream a donor and donwstream an acceptor site that is used to determine the expression of the region", true, new NumberValidator<Integer>(0, 100), 10));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        String line;
        File combined;
        int context = (Integer)parameters.getParameterForName("context").getValue();
        double min = (Double)parameters.getParameterForName("minimum expression").getValue();
        int maxIntron = (Integer)parameters.getParameterForName("maximum intron length").getValue();
        HashMap<String, int[][]>[] coverage = GeMoMa.readCoverage((ExpandableParameterSet)parameters.getParameterForName("coverage").getValue(), protocol, false, false);
        ExpandableParameterSet introns = (ExpandableParameterSet)parameters.getParameterForName("introns").getValue();
        ArrayList<String> fName = new ArrayList<String>();
        int i = 0;
        while (i < introns.getNumberOfParameters()) {
            Parameter y = ((ParameterSet)introns.getParameterAt(i).getValue()).getParameterAt(0);
            if (y.isSet()) {
                fName.add(y.getValue().toString());
            }
            ++i;
        }
        if (fName.size() == 1) {
            combined = new File((String)fName.get(0));
        } else {
            combined = Tools.createTempFile("combined-introns", temp);
            String[] in = fName.toArray(new String[0]);
            CombineIntronFiles.combine(protocol, combined, in);
        }
        protocol.append("\nstart denoising\n");
        BufferedReader r = new BufferedReader(new FileReader(combined));
        File denoise = Tools.createTempFile("denoise", temp);
        BufferedWriter w = new BufferedWriter(new FileWriter(denoise));
        int del = 0;
        int all = 0;
        int oldStart = -1;
        int oldEnd = -1;
        int oldIdx = -9999;
        String oldChr = null;
        int[][][] cov = null;
        int[][][] single = new int[1][][];
        int[][][] both = new int[2][][];
        double e1 = -100.0;
        double i1 = -100.0;
        double i2 = -100.0;
        double e2 = -100.0;
        boolean first = true;
        while ((line = r.readLine()) != null) {
            boolean same;
            if (line.equalsIgnoreCase("##FASTA")) break;
            if (line.length() == 0 || line.startsWith("#")) {
                w.append(line);
                w.newLine();
                continue;
            }
            if (first) {
                w.append("#SOFTWARE INFO: " + this.getShortName() + " " + this.getToolVersion() + "; ");
                String info = JstacsTool.getSimpleParameterInfo(parameters);
                if (info != null) {
                    w.append("SIMPLE PARAMETERS: " + info);
                }
                w.newLine();
                first = false;
            }
            Intron i3 = new Intron(line);
            int idx = i3.getIndex();
            boolean bl = same = i3.chr.equals(oldChr) && idx == oldIdx;
            if (!same) {
                if (idx >= 0) {
                    single[0] = coverage[idx].get(i3.chr);
                    cov = single;
                } else {
                    both[0] = coverage[0].get(i3.chr);
                    both[1] = coverage[1].get(i3.chr);
                    cov = both;
                }
            }
            if (!same || i3.start != oldStart) {
                e1 = DenoiseIntrons.getAvg(i3.start - context, i3.start, cov);
            }
            if (!same || i3.end != oldEnd) {
                e2 = DenoiseIntrons.getAvg(i3.end, i3.end + context, cov);
            }
            if (i3.end - i3.start < maxIntron && (double)i3.reads / Math.max(e1, e2) >= min) {
                w.append(i3.toString());
                w.newLine();
            } else {
                ++del;
            }
            ++all;
            oldChr = i3.chr;
            oldStart = i3.start;
            oldEnd = i3.end;
            oldIdx = idx;
        }
        r.close();
        w.close();
        protocol.append("removed introns: " + del + "/" + all + " = " + (double)del / (double)all + "\n");
        return new ToolResult("", "", null, new ResultSet(new TextResult("denoised introns", "Result", new FileParameter.FileRepresentation(denoise.getAbsolutePath()), "gff", this.getToolName(), null, true)), parameters, this.getToolName(), new Date());
    }

    /*
     * Unable to fully structure code
     */
    static double getAvg(int s, int e, int[][][] cov) {
        sum = 0.0;
        x = 0;
        while (x < cov.length) {
            c = 0.0;
            p = s;
            idx = Arrays.binarySearch(cov[x], new int[]{p}, GeMoMa.IntArrayComparator.comparator[2]);
            if (idx < 0) {
                idx = -(idx + 1);
                idx = Math.max(0, idx - 1);
            }
            inter = cov[x][idx];
            stop = 0;
            ** GOTO lbl24
            while (++idx < cov[x].length) {
                inter = cov[x][idx];
                while (p <= inter[1]) {
                    if (inter[0] <= p && p <= inter[1]) {
                        h = Math.min(inter[1], e) + 1;
                        a = h - p;
                        c += (double)(inter[2] * a);
                        p = h;
                    } else {
                        p = Math.min(inter[0], e + 1);
                    }
                    ++stop;
lbl24:
                    // 2 sources

                    if (p < e && stop < 20) continue;
                }
            }
            sum += c / (double)(e - s);
            ++x;
        }
        return sum / (double)cov.length;
    }

    @Override
    public String getToolName() {
        return "DenoiseIntrons";
    }

    @Override
    public String getShortName() {
        return this.getToolName();
    }

    @Override
    public String getDescription() {
        return "removes spurious introns";
    }

    @Override
    public String getHelpText() {
        return "This module allows to analyze introns extracted by **ERE**. Introns with a large intron size or a low relative expression are possibly artefacts and will be removed. The result of this module can be used in the module **GeMoMa**, **AnnotationEvidence**, and **AnnotationFinalizer**." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return new JstacsTool.ResultEntry[]{new JstacsTool.ResultEntry(TextResult.class, "gff", "denoised introns")};
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        try {
            return new ToolResult[]{new ToolResult(FileManager.readFile(String.valueOf(path) + File.separator + "tests/gemoma/xml/denoise-test.xml"))};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static class Intron {
        String[] split;
        String chr;
        char strand;
        int start;
        int end;
        int reads;

        public Intron(String line) {
            this.split = line.split("\t");
            this.chr = this.split[0];
            this.start = Integer.parseInt(this.split[3]);
            this.end = Integer.parseInt(this.split[4]);
            this.reads = Integer.parseInt(this.split[5]);
            this.strand = this.split[6].charAt(0);
        }

        public int getIndex() {
            switch (this.strand) {
                case '+': {
                    return 0;
                }
                case '-': {
                    return 1;
                }
            }
            return -1;
        }

        public String toString() {
            String res = "";
            int i = 0;
            while (i < this.split.length) {
                res = String.valueOf(res) + (i == 0 ? "" : "\t") + this.split[i];
                ++i;
            }
            return res;
        }
    }
}

