/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma.JunitTest;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ExtractFromAnnotation {
    static int in = 0;
    static boolean stranded = true;

    public static void extract(ArrayList<String[]> lines, HashMap<String, HashMap<String, int[]>> combinedIntrons, HashMap<String, HashMap<Integer, int[]>> combinedCov) {
        if (lines.size() == 0) {
            return;
        }
        Collections.sort(lines, FeatureComparator.def);
        HashMap<String, Object> currentIntrons = null;
        HashMap<Integer, Object> currentCov = null;
        String lastType = null;
        String old = null;
        int v = -100;
        int i = 0;
        while (i < lines.size()) {
            int[] a;
            String[] split = lines.get(i);
            int st = Integer.parseInt(split[3]);
            int en = Integer.parseInt(split[4]);
            String k = stranded ? String.valueOf(split[0]) + split[6] : split[0];
            if (!k.equals(old)) {
                old = k;
                currentCov = combinedCov.get(old);
                if (currentCov == null) {
                    currentCov = new HashMap();
                    combinedCov.put(old, currentCov);
                }
                if ((currentIntrons = combinedIntrons.get(split[0])) == null) {
                    currentIntrons = new HashMap();
                    combinedIntrons.put(split[0], currentIntrons);
                }
            }
            int j = st;
            while (j <= en) {
                a = currentCov.get(j);
                if (a == null) {
                    a = new int[1];
                    currentCov.put(j, a);
                }
                a[0] = a[0] + 1;
                ++j;
            }
            if (split[2].equals(lastType)) {
                String key = split[6].charAt(0) == '+' ? String.valueOf(v) + "\t" + st + ";" : String.valueOf(en + 1) + "\t" + v + ";";
                key = stranded ? String.valueOf(key) + split[6] : String.valueOf(key) + ".";
                a = (int[])currentIntrons.get(key);
                if (a == null) {
                    a = new int[1];
                    currentIntrons.put(key, a);
                }
                a[0] = a[0] + 1;
            }
            v = split[6].charAt(0) == '+' ? en + 1 : st;
            lastType = split[2];
            ++i;
        }
        lines.clear();
    }

    public static void main(String[] args) throws IOException {
        String line;
        HashMap<String, HashMap<String, int[]>> combinedIntrons = new HashMap<String, HashMap<String, int[]>>();
        HashMap<String, HashMap<Integer, int[]>> combinedCov = new HashMap<String, HashMap<Integer, int[]>>();
        BufferedReader r = new BufferedReader(new FileReader(args[0]));
        String type = args[1];
        ArrayList<String[]> sameParent = new ArrayList<String[]>();
        String lastParent = null;
        while ((line = r.readLine()) != null) {
            String[] split;
            if (line.equalsIgnoreCase("##FASTA")) break;
            if (line.length() == 0 || line.startsWith("#") || !(split = line.split("\t"))[2].endsWith(type)) continue;
            int idx = split[8].indexOf("Parent=");
            if (idx < 0) {
                throw new RuntimeException("unknown parent");
            }
            if (lastParent == null) {
                lastParent = split[8].substring(idx, split[8].indexOf(59, idx) + 1);
            }
            if (!split[8].contains(lastParent)) {
                System.out.println(lastParent);
                ExtractFromAnnotation.extract(sameParent, combinedIntrons, combinedCov);
                lastParent = split[8].substring(idx, split[8].indexOf(59, idx) + 1);
            }
            sameParent.add(split);
        }
        ExtractFromAnnotation.extract(sameParent, combinedIntrons, combinedCov);
        r.close();
        BufferedWriter w = new BufferedWriter(new FileWriter(args[2]));
        HashMap<Integer, int[]> intronL = new HashMap<Integer, int[]>();
        Object[] chr = combinedIntrons.keySet().toArray(new String[0]);
        Arrays.sort(chr);
        int i = 0;
        while (i < chr.length) {
            for (Map.Entry<String, int[]> e : combinedIntrons.get(chr[i]).entrySet()) {
                w.write(String.valueOf(chr[i]) + "\tAnnnotation\tintron\t" + e.getKey().replaceAll(";", "\t" + e.getValue()[0] + "\t") + "\t.\t.");
                w.newLine();
                String h = e.getKey();
                h = h.substring(0, h.indexOf(59));
                int idx = h.indexOf(9);
                int l = Integer.parseInt(h.substring(idx + 1)) - Integer.parseInt(h.substring(0, idx));
                int[] stat = (int[])intronL.get(l);
                if (stat == null) {
                    stat = new int[1];
                    intronL.put(l, stat);
                }
                stat[0] = stat[0] + 1;
            }
            ++i;
        }
        w.close();
        System.out.println();
        System.out.println(stranded);
        System.out.println(Arrays.toString(combinedCov.keySet().toArray(new String[0])));
        if (stranded) {
            ExtractFromAnnotation.write(String.valueOf(args[3]) + "-fwd", combinedCov, '+');
            ExtractFromAnnotation.write(String.valueOf(args[3]) + "-rev", combinedCov, '-');
        } else {
            ExtractFromAnnotation.write(args[3], combinedCov, new char[0]);
        }
    }

    static void write(String fName, HashMap<String, HashMap<Integer, int[]>> combinedCov, char ... f) throws IOException {
        int i;
        BufferedWriter w = new BufferedWriter(new FileWriter(fName));
        Object[] chr = combinedCov.keySet().toArray(new String[0]);
        if (f.length > 0) {
            ArrayList<Object> filtered = new ArrayList<Object>();
            i = 0;
            while (i < chr.length) {
                if (((String)chr[i]).charAt(((String)chr[i]).length() - 1) == f[0]) {
                    filtered.add(chr[i]);
                }
                ++i;
            }
            chr = filtered.toArray(new String[0]);
        }
        Arrays.sort(chr);
        int anz = 0;
        i = 0;
        while (i < chr.length) {
            Object chrom = chr[i];
            if (f.length > 0) {
                chrom = ((String)chrom).substring(0, ((String)chrom).length() - 1);
            }
            HashMap<Integer, int[]> currentCov = combinedCov.get(chr[i]);
            Object[] keys = currentCov.keySet().toArray(new Integer[0]);
            Arrays.sort(keys);
            int start = -1;
            int last = -1;
            int cov = -1;
            int j = 0;
            while (j < keys.length) {
                int[] c = currentCov.get(keys[j]);
                if (last + 1 == (Integer)keys[j] && cov == c[0]) {
                    ++last;
                } else {
                    if (start > 0) {
                        w.write(String.valueOf(chrom) + "\t" + start + "\t" + (last + 1) + "\t" + cov);
                        w.newLine();
                        ++anz;
                    }
                    start = last = ((Integer)keys[j]).intValue();
                    cov = c[0];
                }
                ++j;
            }
            if (start > 0) {
                w.write(String.valueOf(chrom) + "\t" + start + "\t" + (last + 1) + "\t" + cov);
                w.newLine();
                ++anz;
            }
            ++i;
        }
        w.close();
        System.out.println("wrote " + Arrays.toString(f) + ":\t " + anz);
    }

    static class FeatureComparator
    implements Comparator<String[]> {
        static FeatureComparator def = new FeatureComparator();

        FeatureComparator() {
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            int d = 0;
            int i = 3;
            while (d == 0 && i <= 4) {
                int i1 = Integer.parseInt(o1[i]);
                int i2 = Integer.parseInt(o2[i]);
                d = Integer.compare(i1, i2);
                ++i;
            }
            return o1[6].charAt(0) == '+' ? d : -d;
        }
    }
}

