/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma.JunitTest;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import projects.gemoma.ExtractRNAseqEvidence;
import projects.gemoma.GeMoMa;
import projects.gemoma.JunitTest.GeMoMaTest;
import projects.gemoma.Tools;

public class GeMoMaCLITest {
    static int start;
    static int end;
    static String in;
    static String out;

    static {
        in = "projects/gemoma/JunitTest/given/";
        out = "projects/gemoma/JunitTest/results";
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        end = 0;
        start = 0;
        File dir = new File(String.valueOf(out) + "-" + System.currentTimeMillis() + File.separator);
        dir.mkdirs();
        out = String.valueOf(dir.getAbsolutePath()) + File.separator;
        System.out.println(out);
        System.out.println();
        System.out.println("start: " + new Date());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (end == start) {
            System.out.println("all tests successful -> delete all files");
            File dir = new File(out);
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
            dir.deleteOnExit();
        }
        System.out.println("end: " + new Date());
    }

    @Before
    public void setUp() throws Exception {
        GeMoMaTest.setUp();
    }

    @After
    public void tearDown() throws Exception {
        GeMoMaTest.tearDown();
    }

    static void cliCheck(ArrayList<String> args, String[] given, String[] newResults) throws Exception {
        ++start;
        Assert.assertTrue((String)"Different number of results", (given.length == newResults.length ? 1 : 0) != 0);
        args.add(0, "CLI");
        args.add("outdir=" + out);
        GeMoMa.main(args.toArray(new String[args.size()]));
        int i = 0;
        while (i < given.length) {
            GeMoMaTest.assertFile(null, String.valueOf(in) + given[i], String.valueOf(out) + newResults[i]);
            ++i;
        }
        ++end;
    }

    public void testExtractor() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Extractor");
        list.add("a=" + in + "Arabidopsis_lyrata.v.1.0.31.chr.gff3");
        list.add("g=" + in + "Arabidopsis_lyrata.v.1.0.31.dna.genome.fa");
        list.add("r=true");
        list.add("f=false");
        list.add("Ambiguity=" + (Object)((Object)Tools.Ambiguity.AMBIGUOUS));
        list.add("p=true");
        String[] given = new String[]{"cds-parts.fasta", "assignment.tabular", "proteins.fasta"};
        GeMoMaCLITest.cliCheck(list, given, given);
    }

    public void testERE() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ERE");
        list.add("s=" + (Object)((Object)ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED));
        list.add("m=" + in + "RNAseq.bam");
        list.add("c=true");
        String[] given = new String[]{"coverage.bedgraph", "introns.gff"};
        GeMoMaCLITest.cliCheck(list, given, given);
    }

    @Test
    public void testGeMoMa() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("GeMoMa");
        boolean simple = true;
        list.add("s=" + in + "tblastn.tabular");
        list.add("t=" + in + "TAIR10_chr_all.fas");
        list.add("a=" + in + "assignment.tabular");
        list.add("c=" + in + "cds-parts.fasta");
        list.add("q=" + in + "proteins.fasta");
        String[] given = new String[]{"predicted_annotation.gff"};
        GeMoMaCLITest.cliCheck(list, given, given);
    }

    public void testGAF() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("GAF");
        list.add("g=" + in + "predicted_annotation.gff");
        list.add("f=(evidence>1 || pAA>=0.7)");
        String[] given = new String[]{"filtered_predictions.gff"};
        GeMoMaCLITest.cliCheck(list, given, given);
    }
}

