/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.parameters.Parameter;
import de.jstacs.tools.Protocol;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class Tools {
    public static final String GeMoMa_TEMP = "GeMoMa_temp" + File.separator;
    public static Random r = new Random();
    public static HashMap<String, String[]> c = new HashMap();
    private static HashMap<Character, int[]> help;

    static {
        c.put("A", new String[]{"A"});
        c.put("C", new String[]{"C"});
        c.put("G", new String[]{"G"});
        c.put("T", new String[]{"T"});
        c.put("N", new String[]{"A", "C", "G", "T"});
        c.put("Y", new String[]{"C", "T"});
        c.put("R", new String[]{"A", "G"});
        c.put("W", new String[]{"A", "T"});
        c.put("S", new String[]{"C", "G"});
        c.put("K", new String[]{"G", "T"});
        c.put("M", new String[]{"A", "C"});
        c.put("B", new String[]{"C", "G", "T"});
        c.put("D", new String[]{"A", "G", "T"});
        c.put("H", new String[]{"A", "C", "T"});
        c.put("V", new String[]{"A", "C", "G"});
        help = new HashMap();
    }

    public static InputStream getInputStream(Parameter parameter, String alternative) throws FileNotFoundException {
        InputStream in = parameter != null && parameter.isSet() ? new FileInputStream(parameter.getValue().toString()) : Tools.class.getClassLoader().getResourceAsStream(alternative);
        return in;
    }

    public static File createTempFile(String infix) throws IOException {
        return Tools.createTempFile(infix, GeMoMa_TEMP);
    }

    public static File createTempFile(String infix, String temp) throws IOException {
        File d = new File(temp);
        if (!d.exists()) {
            d.mkdirs();
        }
        File f = File.createTempFile("GeMoMa-" + infix + "-", ".temp", d);
        f.deleteOnExit();
        return f;
    }

    public static File[] externalSort(String input, int size, int files, Protocol protocol, boolean cdsParts) throws Exception {
        return Tools.externalSort(input, size, files, protocol, cdsParts, GeMoMa_TEMP);
    }

    public static File[] externalSort(String input, int size, int files, Protocol protocol, boolean cdsParts, String temp) throws Exception {
        int i;
        protocol.append("sorting the search results\n");
        BufferedReader r = new BufferedReader(new FileReader(input));
        ArrayList<File> f = new ArrayList<File>();
        Object[] line = new String[size];
        int anz = 0;
        int a = 0;
        int shortCut = 0;
        do {
            a = 0;
            while (a < size && (line[a] = r.readLine()) != null) {
                ++a;
            }
            Arrays.sort(line, 0, a);
            f.add(Tools.createTempFile("sort-" + anz, temp));
            BufferedWriter w = new BufferedWriter(new FileWriter((File)f.get(anz)));
            i = 0;
            while (i < a) {
                w.append((CharSequence)line[i]);
                w.newLine();
                ++i;
            }
            w.close();
            ++anz;
        } while (a == size);
        r.close();
        protocol.append("files:\t" + anz + "\n");
        line = new String[anz];
        BufferedReader[] parts = new BufferedReader[anz];
        i = 0;
        while (i < anz) {
            parts[i] = new BufferedReader(new FileReader((File)f.get(i)));
            line[i] = parts[i].readLine();
            ++i;
        }
        File[] sorted = new File[files];
        BufferedWriter[] w = new BufferedWriter[files];
        int s = 0;
        while (s < files) {
            sorted[s] = Tools.createTempFile("sorted", temp);
            w[s] = new BufferedWriter(new FileWriter(sorted[s]));
            ++s;
        }
        s = -1;
        String old = null;
        int flip = 0;
        while (true) {
            int best = -1;
            int i2 = 0;
            while (i2 < anz) {
                if (line[i2] != null) {
                    if (best == -1) {
                        best = i2;
                    } else if (((String)line[i2]).compareTo((String)line[best]) < 0) {
                        best = i2;
                    }
                }
                ++i2;
            }
            if (best < 0) break;
            String start = ((String)line[best]).substring(0, ((String)line[best]).indexOf(9) + 1);
            if (old == null || !start.startsWith(old)) {
                if (cdsParts) {
                    int idx = start.lastIndexOf(95);
                    if (idx < 0) {
                        throw new IllegalArgumentException("You selected cdsParts=true, but the ID (" + start + ")seems to be no CDS part.");
                    }
                    old = start.substring(0, idx + 1);
                } else {
                    old = start;
                }
                if (++s == sorted.length) {
                    ++flip;
                    s = 0;
                }
            }
            int b = 0;
            do {
                w[s].append((CharSequence)line[best]);
                w[s].newLine();
                ++b;
            } while ((line[best] = parts[best].readLine()) != null && ((String)line[best]).startsWith(start));
            shortCut += b - 1;
        }
        int i3 = 0;
        while (i3 < anz) {
            parts[i3].close();
            ++i3;
        }
        i3 = 0;
        while (i3 < files) {
            w[i3].close();
            ++i3;
        }
        if (flip < 1) {
            File[] small = new File[s + 1];
            System.arraycopy(sorted, 0, small, 0, small.length);
            sorted = small;
        }
        protocol.append("shortCuts:\t" + shortCut + "\n");
        return sorted;
    }

    public static void getMaximalExtension(CharSequence chr, boolean forward, boolean end, int direction, int startPos, char c1, char c2, StringBuffer seq, StringBuffer translated, String backup, int upstream, int downstream, int MAX_INTRON_LENGTH, HashMap<String, Character> code) {
        CharSequence add;
        int s = startPos;
        int e = -1;
        int i = 0;
        if (translated != null) {
            translated.delete(0, translated.length());
            seq.delete(0, seq.length());
            if (direction == 1) {
                s = Math.max(startPos - upstream, 0);
                add = chr.subSequence(s, startPos);
            } else {
                s = Math.min(startPos + upstream, chr.length());
                add = chr.subSequence(startPos, s);
            }
            if (!forward) {
                add = Tools.rc(add);
            }
            Tools.insert(end, seq, add);
            int l = add.length();
            while (l < upstream) {
                Tools.insert(end, seq, "N");
                ++l;
            }
        }
        char c = '!';
        CharSequence codon = null;
        if (direction == -1) {
            startPos -= 3;
        }
        int problem = 0;
        boolean onlyStop = c1 == c2 && c1 == '*';
        boolean fromBackup = true;
        while (3 * i < MAX_INTRON_LENGTH && startPos >= 0 && startPos + 3 <= chr.length() && (fromBackup && onlyStop || c != c1 && c != c2)) {
            codon = chr.subSequence(startPos, startPos + 3);
            if (!forward) {
                codon = Tools.rc(codon);
            }
            boolean bl = fromBackup = backup != null && i < backup.length();
            if (fromBackup) {
                c = backup.charAt(end ? i : backup.length() - 1 - i);
                problem = 0;
            } else {
                try {
                    c = Tools.translate(codon, code, Ambiguity.EXCEPTION);
                    problem = 0;
                }
                catch (Exception ex) {
                    if (++problem == 3) break;
                    c = 'X';
                }
            }
            if (seq != null) {
                Tools.insert(end, seq, codon);
                Tools.insert(end, translated, "" + c);
            }
            startPos += direction * 3;
            ++i;
        }
        e = direction == -1 ? startPos + 3 : startPos;
        startPos = e;
        if (seq != null) {
            if (direction == 1) {
                e = Math.min(startPos + downstream, chr.length());
                add = chr.subSequence(startPos, e);
            } else {
                e = Math.max(startPos - downstream, 0);
                add = chr.subSequence(e, startPos);
            }
            if (!forward) {
                add = Tools.rc(add);
            }
            Tools.insert(end, seq, add);
            int l = add.length();
            while (l < downstream) {
                Tools.insert(end, seq, "N");
                ++l;
            }
        }
    }

    static void insert(boolean end, StringBuffer sb, CharSequence s) {
        if (end) {
            sb.append(s);
        } else {
            sb.insert(0, s);
        }
    }

    public static HashMap<String, String> getSelection(String fName, int maxSize, Protocol protocol) throws IOException {
        String line;
        if (fName == null) {
            return null;
        }
        HashMap<String, String> selected = new HashMap<String, String>();
        BufferedReader r = new BufferedReader(new FileReader(fName));
        while ((line = r.readLine()) != null && (maxSize < 0 || selected.size() < maxSize)) {
            int idx = line.indexOf(9);
            int second = idx + 1;
            if (idx < 0) {
                second = idx = line.length();
            }
            selected.put(line.substring(0, idx), line.substring(second));
        }
        if (maxSize >= 0) {
            protocol.appendWarning("Only used the first " + maxSize + " lines of selected gene IDs.");
        }
        r.close();
        return selected;
    }

    public static HashMap<String, Character> getCode(String fName) throws Exception {
        return Tools.getCode(new FileInputStream(fName));
    }

    public static HashMap<String, Character> getCode(InputStream input) throws Exception {
        String line;
        HashMap<String, Character> annot = new HashMap<String, Character>();
        BufferedReader r = new BufferedReader(new InputStreamReader(input));
        while ((line = r.readLine()) != null) {
            String[] triplets;
            char code = line.charAt(0);
            line = line.substring(2);
            String[] stringArray = triplets = line.split(",");
            int n = triplets.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                Character c = annot.get(t = t.trim());
                if (c != null) {
                    throw new IllegalArgumentException(String.valueOf(t) + ": " + line);
                }
                annot.put(t, Character.valueOf(code));
                ++n2;
            }
        }
        r.close();
        return annot;
    }

    public static char[] rc(char[] in) {
        char[] out = new char[in.length];
        int i = 0;
        while (i < in.length) {
            switch (in[i]) {
                case 'A': 
                case 'a': {
                    out[in.length - 1 - i] = 84;
                    break;
                }
                case 'C': 
                case 'c': {
                    out[in.length - 1 - i] = 71;
                    break;
                }
                case 'G': 
                case 'g': {
                    out[in.length - 1 - i] = 67;
                    break;
                }
                case 'T': 
                case 't': {
                    out[in.length - 1 - i] = 65;
                    break;
                }
                case 'N': 
                case 'n': {
                    out[in.length - 1 - i] = 78;
                    break;
                }
                case 'Y': 
                case 'y': {
                    out[in.length - 1 - i] = 82;
                    break;
                }
                case 'R': 
                case 'r': {
                    out[in.length - 1 - i] = 89;
                    break;
                }
                case 'W': 
                case 'w': {
                    out[in.length - 1 - i] = 87;
                    break;
                }
                case 'S': 
                case 's': {
                    out[in.length - 1 - i] = 83;
                    break;
                }
                case 'K': 
                case 'k': {
                    out[in.length - 1 - i] = 77;
                    break;
                }
                case 'M': 
                case 'm': {
                    out[in.length - 1 - i] = 75;
                    break;
                }
                case 'V': 
                case 'v': {
                    out[in.length - 1 - i] = 84;
                    break;
                }
                case 'H': 
                case 'h': {
                    out[in.length - 1 - i] = 71;
                    break;
                }
                case 'D': 
                case 'd': {
                    out[in.length - 1 - i] = 67;
                    break;
                }
                case 'B': 
                case 'b': {
                    out[in.length - 1 - i] = 65;
                    break;
                }
                case '-': {
                    out[in.length - 1 - i] = 45;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown character: '" + in[i] + "' at " + i);
                }
            }
            ++i;
        }
        return out;
    }

    public static String rc(CharSequence in) {
        char[] out = new char[in.length()];
        int i = 0;
        while (i < in.length()) {
            switch (in.charAt(i)) {
                case 'A': 
                case 'a': {
                    out[in.length() - 1 - i] = 84;
                    break;
                }
                case 'C': 
                case 'c': {
                    out[in.length() - 1 - i] = 71;
                    break;
                }
                case 'G': 
                case 'g': {
                    out[in.length() - 1 - i] = 67;
                    break;
                }
                case 'T': 
                case 't': {
                    out[in.length() - 1 - i] = 65;
                    break;
                }
                case 'N': 
                case 'n': {
                    out[in.length() - 1 - i] = 78;
                    break;
                }
                case 'Y': 
                case 'y': {
                    out[in.length() - 1 - i] = 82;
                    break;
                }
                case 'R': 
                case 'r': {
                    out[in.length() - 1 - i] = 89;
                    break;
                }
                case 'W': 
                case 'w': {
                    out[in.length() - 1 - i] = 87;
                    break;
                }
                case 'S': 
                case 's': {
                    out[in.length() - 1 - i] = 83;
                    break;
                }
                case 'K': 
                case 'k': {
                    out[in.length() - 1 - i] = 77;
                    break;
                }
                case 'M': 
                case 'm': {
                    out[in.length() - 1 - i] = 75;
                    break;
                }
                case 'V': 
                case 'v': {
                    out[in.length() - 1 - i] = 84;
                    break;
                }
                case 'H': 
                case 'h': {
                    out[in.length() - 1 - i] = 71;
                    break;
                }
                case 'D': 
                case 'd': {
                    out[in.length() - 1 - i] = 67;
                    break;
                }
                case 'B': 
                case 'b': {
                    out[in.length() - 1 - i] = 65;
                    break;
                }
                case '-': {
                    out[in.length() - 1 - i] = 45;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown character: '" + in.charAt(i) + "'");
                }
            }
            ++i;
        }
        return new String(out);
    }

    public static char translate(CharSequence triplett, HashMap<String, Character> code, Ambiguity ambiguity) {
        Character as = code.get(triplett);
        if (as == null) {
            String[][] current = new String[3][];
            int anz = 0;
            int i = 0;
            while (i < 3) {
                current[i] = c.get(triplett.subSequence(i, i + 1));
                if (current[i] == null) {
                    throw new IllegalArgumentException("Check nucleotide: " + triplett.subSequence(i, i + 1));
                }
                anz = Math.max(anz, current[i].length);
                ++i;
            }
            if (anz == 1) {
                as = code.get(String.valueOf(current[0][0]) + current[1][0] + current[2][0]);
            } else {
                help.clear();
                anz = 0;
                i = 0;
                while (i < current[0].length) {
                    int j = 0;
                    while (j < current[1].length) {
                        int k = 0;
                        while (k < current[2].length) {
                            as = code.get(String.valueOf(current[0][i]) + current[1][j] + current[2][k]);
                            int[] count = help.get(as);
                            if (count == null) {
                                help.put(as, new int[]{1});
                            } else {
                                count[0] = count[0] + 1;
                            }
                            ++anz;
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (help.size() > 1) {
                    switch (ambiguity) {
                        case AMBIGUOUS: {
                            as = Character.valueOf('X');
                            break;
                        }
                        case RANDOM: {
                            int idx = r.nextInt(anz);
                            int v = 0;
                            Iterator<Map.Entry<Character, int[]>> it = help.entrySet().iterator();
                            Map.Entry<Character, int[]> e = null;
                            while (it.hasNext() && v <= idx) {
                                e = it.next();
                                v += e.getValue()[0];
                            }
                            as = (Character)e.getKey();
                            as = Character.valueOf(Character.toLowerCase(as.charValue()));
                            break;
                        }
                        case EXCEPTION: {
                            throw new IllegalArgumentException(triplett.toString());
                        }
                    }
                }
            }
        }
        return as.charValue();
    }

    public static boolean getUnambigious(StringBuffer seq) {
        boolean changed = false;
        int i = 0;
        while (i < seq.length()) {
            String base = seq.substring(i, i + 1).toUpperCase();
            String[] possibilities = c.get(base);
            if (possibilities.length > 1) {
                seq.replace(i, i + 1, possibilities[r.nextInt(possibilities.length)]);
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    public static String translate(int offset, String seq, HashMap<String, Character> code, boolean check, Ambiguity ambiguity) throws IllegalArgumentException {
        StringBuffer aaSeqBuff = new StringBuffer();
        boolean last = false;
        int j = offset;
        while (j + 3 <= seq.length()) {
            char as = Tools.translate(seq.substring(j, j + 3), code, ambiguity);
            if (check) {
                if (as == '*') {
                    last = true;
                } else if (last) {
                    throw new IllegalArgumentException();
                }
            }
            aaSeqBuff.append(as);
            j += 3;
        }
        return aaSeqBuff.toString();
    }

    public static HashMap<String, String[]> getAlias(String fName, int oldNameIdx, int newNameIdx, int countIdx) throws Exception {
        HashMap<String, String[]> res = new HashMap<String, String[]>();
        Tools.getAlias(res, fName, null, oldNameIdx, newNameIdx, countIdx);
        return res;
    }

    public static void getAlias(HashMap<String, String[]> res, String fName, String prefix, int oldNameIdx, int newNameIdx, int countIdx) throws Exception {
        String line;
        if (fName == null || !new File(fName).exists()) {
            return;
        }
        prefix = prefix == null ? "" : String.valueOf(prefix.toUpperCase()) + "_";
        BufferedReader r = new BufferedReader(new FileReader(fName));
        while ((line = r.readLine()) != null) {
            String[] stringArray;
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            String[] split = line.split("\t");
            split[newNameIdx] = split[newNameIdx].toUpperCase();
            String string = String.valueOf(prefix) + split[oldNameIdx].toUpperCase();
            if (countIdx < 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = String.valueOf(prefix) + split[newNameIdx];
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = String.valueOf(prefix) + split[newNameIdx];
                stringArray = stringArray3;
                stringArray3[1] = String.valueOf(split[countIdx].split(",").length);
            }
            res.put(string, stringArray);
        }
        r.close();
    }

    public static BufferedReader openGzOrPlain(String fName) throws IOException {
        InputStream ins = new FileInputStream(fName);
        try {
            GZIPInputStream gz = new GZIPInputStream(ins);
            ins = gz;
        }
        catch (EOFException | ZipException ze) {
            ((InputStream)ins).close();
            ins = new FileInputStream(fName);
        }
        return new BufferedReader(new InputStreamReader(ins));
    }

    public static HashMap<String, String> getFasta(String fName, int initSize) throws Exception {
        return Tools.getFasta(fName, initSize, "([^_^\t^,^;^=^\"]+)|([^\t^,^;^=^\"]+_\\d+)");
    }

    public static HashMap<String, String> getFasta(String fName, int initSize, String seqIdRegex) throws Exception {
        return Tools.getFasta(fName, initSize, "\\s.*", "", seqIdRegex);
    }

    public static HashMap<String, String> getFasta(String fName, int initSize, String regex, String replace, String seqIDRegex) throws Exception {
        HashMap<String, String> seqs = new HashMap<String, String>(initSize);
        if (fName != null) {
            String line;
            BufferedReader r = Tools.openGzOrPlain(fName);
            StringBuffer seq = new StringBuffer();
            String comment = null;
            while ((line = r.readLine()) != null) {
                if (line.startsWith(">")) {
                    if (comment != null) {
                        Tools.add(seqs, comment, seq);
                    }
                    seq.delete(0, seq.length());
                    comment = line.substring(1);
                    if (regex != null) {
                        comment = comment.replaceAll(regex, replace);
                    }
                    if (comment.matches(seqIDRegex)) continue;
                    throw new IllegalArgumentException("Sequence ID (" + comment + ") in fasta comment line (" + line + ") does not match the regular expression for sequence IDs (" + seqIDRegex + ")");
                }
                seq.append(line.trim().toUpperCase());
            }
            Tools.add(seqs, comment, seq);
            r.close();
        }
        return seqs;
    }

    private static void add(HashMap<String, String> seqs, String comment, StringBuffer seq) {
        String old = seqs.get(comment);
        String newSeq = seq.toString();
        if (old == null) {
            seqs.put(comment, newSeq);
        } else if (old.equals(newSeq)) {
            System.err.println("WARNING: duplicated sequence ignored: " + comment);
        } else {
            throw new IllegalArgumentException("At least two sequences with the same ID but different sequence: " + comment);
        }
    }

    public static String prepareFilter(String filter) {
        filter = filter == null ? "" : filter.trim();
        filter = filter.replaceAll(" or ", " || ");
        filter = filter.replaceAll(" and ", " && ");
        return filter;
    }

    public static String eval(ScriptEngine engine, String expression, HashMap<String, String> hash) throws ScriptException {
        Bindings b = engine.createBindings();
        for (Map.Entry<String, String> e : hash.entrySet()) {
            String key = e.getKey();
            if (expression.indexOf(key) < 0) continue;
            String val = e.getValue();
            b.put(key, (Object)(val.equals("NA") ? "NaN" : val));
        }
        return engine.eval(expression, b).toString();
    }

    public static boolean filter(ScriptEngine engine, String filter, HashMap<String, String> hash) throws ScriptException {
        if (hash == null) {
            return false;
        }
        if (filter.length() == 0) {
            return true;
        }
        String s = Tools.eval(engine, filter, hash);
        Boolean bool = Boolean.parseBoolean(s);
        return bool;
    }

    public static enum Ambiguity {
        EXCEPTION,
        AMBIGUOUS,
        RANDOM;

    }
}

