/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import projects.gemoma.GeMoMa;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class TranscribedCluster
extends GeMoMaModule {
    private static HashMap<String, int[][][]>[] spliceSites;
    private static HashMap<String, int[][]>[] coverage;
    private static int tc;
    static char[] strand;
    private static final String defResult = "transcribedCluster";

    static {
        tc = 0;
        strand = new char[]{'?', '+', '-'};
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        GeMoMa.seqs = Tools.getFasta(parameters.getParameterForName("genome").getValue().toString(), 20, ".*");
        ExpandableParameterSet eps = (ExpandableParameterSet)((ParameterSetContainer)parameters.getParameterAt(1)).getValue();
        ArrayList<String> fName = new ArrayList<String>();
        int i = 0;
        while (i < eps.getNumberOfParameters()) {
            Parameter y = ((ParameterSet)eps.getParameterAt(i).getValue()).getParameterAt(0);
            if (y.isSet()) {
                fName.add(y.getValue().toString());
            }
            ++i;
        }
        spliceSites = fName.size() > 0 ? GeMoMa.readIntrons((Integer)parameters.getParameterForName("reads").getValue(), protocol, false, GeMoMa.seqs, null, fName.toArray(new String[fName.size()])) : null;
        coverage = GeMoMa.readCoverage((ExpandableParameterSet)((ParameterSetContainer)parameters.getParameterAt(3)).getValue(), protocol, false, true);
        int minGap = (Integer)parameters.getParameterForName("minimal gap").getValue();
        Object[] chr = GeMoMa.seqs.keySet().toArray(new String[GeMoMa.seqs.size()]);
        Arrays.sort(chr);
        File file = Tools.createTempFile("TranscribedCluster", temp);
        BufferedWriter w = new BufferedWriter(new FileWriter(file));
        w.append("##gff-version 3");
        w.newLine();
        Object[] objectArray = chr;
        int n = chr.length;
        int n2 = 0;
        while (n2 < n) {
            int[][] cov;
            Object c = objectArray[n2];
            if (coverage[0] == coverage[1]) {
                cov = coverage != null && coverage[0] != null ? coverage[0].get(c) : null;
                TranscribedCluster.identify(protocol, (String)c, -1, cov, minGap, w);
            } else {
                cov = coverage != null && coverage[0] != null ? coverage[0].get(c) : null;
                TranscribedCluster.identify(protocol, (String)c, 0, cov, minGap, w);
                cov = coverage != null && coverage[1] != null ? coverage[1].get(c) : null;
                TranscribedCluster.identify(protocol, (String)c, 1, cov, minGap, w);
            }
            ++n2;
        }
        w.close();
        TextResult t = new TextResult(defResult, "Result", new FileParameter.FileRepresentation(file.getAbsolutePath()), "gff", this.getToolName(), null, true);
        return new ToolResult("", "", null, new ResultSet(t), parameters, this.getToolName(), new Date());
    }

    private static void identify(Protocol p, String chr, int str, int[][] cov, int minGap, BufferedWriter w) throws IOException {
        int start = -100;
        int end = -100;
        int max = -100;
        int s = str == -1 ? -2 : str;
        int[][][] donor = null;
        int[][][] acceptor = null;
        if (spliceSites != null) {
            donor = spliceSites[0].get(chr);
            acceptor = spliceSites[1].get(chr);
        }
        int f = 0;
        int r = 0;
        if (cov != null) {
            int c = 0;
            while (c < cov.length) {
                if (end + 1 + minGap >= cov[c][0]) {
                    if (end < cov[c][1]) {
                        int old;
                        end = cov[c][1];
                        if (str <= 0) {
                            old = f;
                            if (donor != null && donor[0] != null) {
                                while (f < donor[0][0].length && donor[0][0][f] <= end) {
                                    p.append(String.valueOf(chr) + ": " + donor[0][0][f] + " -> " + donor[0][1][f] + "\n");
                                    if (end < donor[0][1][f]) {
                                        end = donor[0][1][f];
                                    }
                                    ++f;
                                }
                            }
                            if (old < f & str == -1) {
                                s = s == 0 || s == -2 ? 0 : -1;
                            }
                        }
                        if (str != 0) {
                            old = r;
                            if (acceptor != null && acceptor[0] != null) {
                                while (r < acceptor[1][1].length && acceptor[1][1][r] <= end) {
                                    p.append(String.valueOf(chr) + ": " + acceptor[1][0][r] + " <- " + acceptor[1][1][r] + "\n");
                                    if (end < acceptor[1][0][r]) {
                                        end = acceptor[1][0][r];
                                    }
                                    ++r;
                                }
                            }
                            if (old < r & str == -1) {
                                s = s == 1 || s == -2 ? 1 : -1;
                            }
                        }
                    }
                    if (max < cov[c][2]) {
                        max = cov[c][2];
                    }
                } else {
                    if (end > 0) {
                        p.append("=> " + chr + "\t" + start + "\t" + end + "\t" + strand[Math.max(0, s + 1)] + "\t" + max + "\n");
                        w.append(String.valueOf(chr) + "\tRNAseq\ttranscribed_cluster\t" + start + "\t" + end + "\t" + max + "\t" + strand[Math.max(0, s + 1)] + "\t.\tID=tc" + tc++);
                        w.newLine();
                    }
                    start = cov[c][0];
                    end = cov[c][1];
                    max = cov[c][2];
                    s = str == -1 ? -2 : str;
                }
                ++c;
            }
            p.append("=> " + chr + "\t" + start + "\t" + end + "\t" + strand[Math.max(0, s + 1)] + "\t" + max + "\n");
            w.append(String.valueOf(chr) + "\tRNAseq\ttranscribed_cluster\t" + start + "\t" + end + "\t" + max + "\t" + strand[Math.max(0, s + 1)] + "\t.\tID=tc" + tc++);
            w.newLine();
        }
    }

    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getShortName(), new FileParameter("genome", "The genome file (FASTA), i.e., the target sequences in the blast run. Should be in IUPAC code", "fasta", true), new ParameterSetContainer("introns", "", new ExpandableParameterSet(new SimpleParameterSet(new FileParameter("introns file", "Introns (GFF), which might be obtained from RNA-seq", "gff", false)), "introns", "", 1)), new SimpleParameter(DataType.INT, "reads", "if introns are given by a GFF, only use those which have at least this number of supporting split reads", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 1), new ParameterSetContainer("coverage", "", new ExpandableParameterSet(new SimpleParameterSet(new SelectionParameter(DataType.PARAMETERSET, new String[]{"UNSTRANDED", "STRANDED"}, new Object[]{new SimpleParameterSet(new FileParameter("coverage_unstranded", "The coverage file contains the unstranded coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true)), new SimpleParameterSet(new FileParameter("coverage_forward", "The coverage file contains the forward coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true), new FileParameter("coverage_reverse", "The coverage file contains the reverse coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true))}, "coverage file", "experimental coverage (RNA-seq)", true)), "coverage", "", 1)), new SimpleParameter(DataType.INT, "minimal gap", "the minimal gap between two transcribed clusters, otherwise these will be merged", true, new NumberValidator<Integer>(0, Integer.MAX_VALUE), 50));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public String getToolName() {
        return "Transcribed Cluster";
    }

    @Override
    public String getShortName() {
        return "TranscribedCluster";
    }

    @Override
    public String getDescription() {
        return "computes the transcribed clusters from RNA-seq evidence";
    }

    @Override
    public String getHelpText() {
        return "**What it does**\n\nThis tool computes ... .\n\n" + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return new JstacsTool.ResultEntry[]{new JstacsTool.ResultEntry(TextResult.class, "gff", defResult)};
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }
}

