/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoseq;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import projects.gemoma.ExtractRNAseqEvidence;
import projects.gemoseq.Region;

public class BAMReader
implements Iterator<Region> {
    private Iterator<SAMRecord> recIt;
    private SamReader reader;
    private SAMRecord curr;
    private int maxIntronLength;
    private double maxcov;
    private double sample;
    private Region revRegion;
    private ExtractRNAseqEvidence.Stranded stranded;
    private int maxRegionLength;
    private int maxGapFilled;
    private int minQuality;
    private boolean longReads;

    public BAMReader(int maxIntronLength, String bam, double maxcov, double sample, ExtractRNAseqEvidence.Stranded stranded, int minQuality, int maxRegionLength, int maxGapFilled, boolean longReads) {
        SamReaderFactory srf = SamReaderFactory.makeDefault();
        srf.validationStringency(ValidationStringency.SILENT);
        this.reader = srf.open(new File(bam));
        this.recIt = this.reader.iterator();
        this.maxIntronLength = maxIntronLength;
        this.maxcov = maxcov;
        this.sample = sample;
        this.revRegion = null;
        this.stranded = stranded;
        this.minQuality = minQuality;
        this.maxRegionLength = maxRegionLength;
        this.maxGapFilled = maxGapFilled;
        this.longReads = longReads;
    }

    public int getSequenceLength(String chrom) {
        SAMSequenceDictionary dict = this.reader.getFileHeader().getSequenceDictionary();
        return dict.getSequence(chrom).getSequenceLength();
    }

    @Override
    public boolean hasNext() {
        return this.recIt.hasNext() || this.revRegion != null;
    }

    @Override
    public Region next() {
        if (this.revRegion != null) {
            Region temp = this.revRegion;
            this.revRegion = null;
            return temp;
        }
        Region region = new Region(this.maxcov, this.sample, this.stranded == ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED ? (char)'.' : '+');
        Region revTemp = new Region(this.maxcov, this.sample, this.stranded == ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED ? (char)'.' : '-');
        if (this.curr != null) {
            this.add(region, revTemp, this.curr);
        }
        while (this.recIt.hasNext()) {
            this.curr = this.recIt.next();
            if (this.curr.getReadLength() + this.maxIntronLength < this.curr.getAlignmentEnd() - this.curr.getAlignmentStart()) {
                this.curr = null;
                continue;
            }
            if (this.curr.getMappingQuality() < this.minQuality) {
                this.curr = null;
                continue;
            }
            if (region.getReferenceIndex() != null && !this.curr.getReferenceIndex().equals(region.getReferenceIndex()) || revTemp.getReferenceIndex() != null && !this.curr.getReferenceIndex().equals(revTemp.getReferenceIndex())) {
                return this.join(region, revTemp);
            }
            int maxEnd = Math.max(region.getRegionEnd() == null ? -1 : region.getRegionEnd(), revTemp.getRegionEnd() == null ? -1 : revTemp.getRegionEnd());
            if (maxEnd > -1 && maxEnd < this.curr.getAlignmentStart()) {
                boolean filled = false;
                if (maxEnd - Math.min(region.getRegionStart() == null ? maxEnd : region.getRegionStart(), revTemp.getRegionStart() == null ? maxEnd : revTemp.getRegionStart()) < this.maxRegionLength) {
                    SAMRecord[] dummies;
                    if (this.isFwd(this.curr) && region.getRegionEnd() != null && region.getRegionEnd() + this.maxGapFilled >= this.curr.getAlignmentStart()) {
                        dummies = this.getDummyPair(this.curr, region.getRegionEnd() - 1, this.curr.getAlignmentStart() + 1);
                        this.add(region, revTemp, dummies[0]);
                        this.add(region, revTemp, dummies[1]);
                        filled = true;
                    }
                    if (!this.isFwd(this.curr) && revTemp.getRegionEnd() != null && revTemp.getRegionEnd() + this.maxGapFilled >= this.curr.getAlignmentStart()) {
                        dummies = this.getDummyPair(this.curr, revTemp.getRegionEnd() - 1, this.curr.getAlignmentStart() + 1);
                        this.add(region, revTemp, dummies[0]);
                        this.add(region, revTemp, dummies[1]);
                        filled = true;
                    }
                }
                if (!filled) {
                    return this.join(region, revTemp);
                }
            }
            this.add(region, revTemp, this.curr);
        }
        return this.join(region, revTemp);
    }

    private static final SAMRecord getDummy(SAMRecord curr, int start, int end) {
        SAMRecord dummy = new SAMRecord(curr.getHeader());
        dummy.setAlignmentStart(start);
        dummy.setMappingQuality(255);
        dummy.setReferenceIndex(curr.getReferenceIndex());
        dummy.setReferenceName(curr.getReferenceName());
        dummy.setReadName("dummy");
        LinkedList<CigarElement> cili = new LinkedList<CigarElement>();
        cili.add(new CigarElement(end - start + 1, CigarOperator.M));
        dummy.setCigar(new Cigar(cili));
        dummy.setReadPairedFlag(true);
        dummy.setProperPairFlag(true);
        dummy.setMateReferenceIndex(dummy.getReferenceIndex());
        dummy.setMateReferenceName(dummy.getReferenceName());
        return dummy;
    }

    private SAMRecord[] getDummyPair(SAMRecord curr, int start, int end) {
        SAMRecord dummy1 = BAMReader.getDummy(curr, start, end);
        SAMRecord dummy2 = BAMReader.getDummy(curr, start, end);
        dummy1.setFirstOfPairFlag(true);
        dummy2.setSecondOfPairFlag(true);
        if (this.stranded == ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED) {
            dummy1.setReadNegativeStrandFlag(false);
            dummy2.setReadNegativeStrandFlag(true);
        } else if (curr.getReadPairedFlag()) {
            if (curr.getFirstOfPairFlag()) {
                dummy1.setReadNegativeStrandFlag(curr.getReadNegativeStrandFlag());
                dummy1.setMateNegativeStrandFlag(curr.getMateNegativeStrandFlag());
                dummy2.setReadNegativeStrandFlag(curr.getMateNegativeStrandFlag());
                dummy2.setMateNegativeStrandFlag(curr.getReadNegativeStrandFlag());
            } else {
                dummy1.setReadNegativeStrandFlag(curr.getMateNegativeStrandFlag());
                dummy1.setMateNegativeStrandFlag(curr.getReadNegativeStrandFlag());
                dummy2.setReadNegativeStrandFlag(curr.getReadNegativeStrandFlag());
                dummy2.setMateNegativeStrandFlag(curr.getMateNegativeStrandFlag());
            }
        }
        return new SAMRecord[]{dummy1, dummy2};
    }

    private Region join(Region region, Region revTemp) {
        double jacc;
        if (region.getReferenceIndex() == null) {
            return revTemp;
        }
        if (revTemp.getReferenceIndex() == null) {
            return region;
        }
        if (!this.longReads) {
            if (revTemp.getTheoreticalNumberOfReads() < 10) {
                return region;
            }
            if (region.getTheoreticalNumberOfReads() < 10) {
                return revTemp;
            }
        }
        if (revTemp.getTheoreticalNumberOfReads() * 50 < region.getTheoreticalNumberOfReads() && (jacc = this.jaccard(region, revTemp)) > 0.5) {
            region.join(revTemp);
            return region;
        }
        if (region.getTheoreticalNumberOfReads() * 50 < revTemp.getTheoreticalNumberOfReads() && (jacc = this.jaccard(region, revTemp)) > 0.5) {
            revTemp.join(region);
            return revTemp;
        }
        this.revRegion = revTemp;
        region.setRevRegion(this.revRegion);
        this.revRegion.setRevRegion(region);
        return region;
    }

    private double cor(Region region, Region revTemp) {
        int[] covFwd = region.getCoverageByBlocks();
        int[] covRev = revTemp.getCoverageByBlocks();
        int regionStart = region.getRegionStart();
        int regionStartRev = revTemp.getRegionStart();
        int globalStart = Math.min(regionStart, regionStartRev);
        int globalEnd = Math.max(regionStart + covFwd.length, regionStartRev + covRev.length);
        double ex = 0.0;
        double ey = 0.0;
        double exy = 0.0;
        double ex2 = 0.0;
        double ey2 = 0.0;
        double n = globalEnd - globalStart;
        int i = globalStart;
        while (i < globalEnd) {
            double v1 = i < regionStart || i >= regionStart + covFwd.length ? 0.0 : (double)covFwd[i - regionStart];
            double v2 = i < regionStartRev || i >= regionStartRev + covRev.length ? 0.0 : (double)covRev[i - regionStartRev];
            ex += v1;
            ey += v2;
            exy += v1 * v2;
            ex2 += v1 * v1;
            ey2 += v2 * v2;
            ++i;
        }
        double cov = (exy /= n) - (ex /= n) * (ey /= n);
        double v1 = (ex2 /= n) - ex * ex;
        double v2 = (ey2 /= n) - ey * ey;
        if (v1 == 0.0 || v2 == 0.0) {
            return 0.0;
        }
        return cov / Math.sqrt(v1 * v2);
    }

    private static double getThreshold(int[] vals) {
        double sum = 0.0;
        double n = 0.0;
        int i = 0;
        while (i < vals.length) {
            if (vals[i] > 0) {
                sum += (double)vals[i];
                n += 1.0;
            }
            ++i;
        }
        return sum / n * 0.1;
    }

    private double jaccard(Region region, Region revTemp) {
        int[] covFwd = region.getCoverageByBlocks();
        int[] covRev = revTemp.getCoverageByBlocks();
        double t1 = BAMReader.getThreshold(covFwd);
        double t2 = BAMReader.getThreshold(covRev);
        int regionStart = region.getRegionStart();
        int regionStartRev = revTemp.getRegionStart();
        int globalStart = Math.min(regionStart, regionStartRev);
        int globalEnd = Math.max(regionStart + covFwd.length, regionStartRev + covRev.length);
        double inter = 0.0;
        double union1 = 0.0;
        double union2 = 0.0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        int i = globalStart;
        while (i < globalEnd) {
            double v1 = i < regionStart || i >= regionStart + covFwd.length ? 0.0 : (double)covFwd[i - regionStart];
            double v2 = i < regionStartRev || i >= regionStartRev + covRev.length ? 0.0 : (double)covRev[i - regionStartRev];
            sum1 += v1;
            sum2 += v2;
            if (v1 > t1 && v2 > t2) {
                inter += 1.0;
            }
            if (v1 > t1) {
                union1 += 1.0;
            }
            if (v2 > t2) {
                union2 += 1.0;
            }
            ++i;
        }
        double union = sum1 > sum2 ? union2 : union1;
        return inter / union;
    }

    private boolean isFwd(SAMRecord sr) {
        if (this.stranded == ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED) {
            return true;
        }
        if (this.stranded == ExtractRNAseqEvidence.Stranded.FR_FIRST_STRAND) {
            return sr.getReadPairedFlag() && sr.getFirstOfPairFlag() && sr.getReadNegativeStrandFlag() || sr.getReadPairedFlag() && sr.getSecondOfPairFlag() && sr.getMateNegativeStrandFlag() || (!sr.getReadPairedFlag() || !sr.getProperPairFlag()) && sr.getReadNegativeStrandFlag();
        }
        return !(sr.getReadPairedFlag() && sr.getFirstOfPairFlag() && sr.getReadNegativeStrandFlag() || sr.getReadPairedFlag() && sr.getSecondOfPairFlag() && sr.getMateNegativeStrandFlag()) && (sr.getReadPairedFlag() && sr.getProperPairFlag() || !sr.getReadNegativeStrandFlag());
    }

    private void add(Region region, Region revTemp, SAMRecord sr) {
        if (this.isFwd(sr)) {
            region.addRead(sr);
        } else {
            revTemp.addRead(sr);
        }
    }
}

