/*
 * Decompiled with CFR 0.152.
 */
package projects.methyl;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.utils.NiceScale;
import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.ToolBox;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Locale;

public class MLogoPlotter
extends SeqLogoPlotter {
    private static String[] viridis_a = new String[]{"#000004", "#010107", "#02020B", "#030311", "#050417", "#07061C", "#090721", "#0C0926", "#0F0B2C", "#120D32", "#150E37", "#180F3E", "#1C1044", "#1F114A", "#221150", "#261257", "#2A115D", "#2F1163", "#331068", "#38106C", "#3C0F71", "#400F74", "#451077", "#491078", "#4E117B", "#51127C", "#56147D", "#5A167E", "#5D177F", "#611980", "#661A80", "#6A1C81", "#6D1D81", "#721F81", "#762181", "#792282", "#7D2482", "#822581", "#862781", "#8A2981", "#8E2A81", "#922B80", "#962C80", "#9B2E7F", "#9F2F7F", "#A3307E", "#A7317D", "#AB337C", "#AF357B", "#B3367A", "#B83779", "#BC3978", "#C03A76", "#C43C75", "#C83E73", "#CD4071", "#D0416F", "#D5446D", "#D8456C", "#DC4869", "#DF4B68", "#E34E65", "#E65163", "#E95562", "#EC5860", "#EE5C5E", "#F1605D", "#F2655C", "#F4695C", "#F66D5C", "#F7735C", "#F9785D", "#F97C5D", "#FA815F", "#FB8661", "#FC8A62", "#FC9065", "#FD9567", "#FD9A6A", "#FE9E6C", "#FEA36F", "#FEA873", "#FEAC76", "#FEB27A", "#FEB67D", "#FEBB81", "#FEC085", "#FEC488", "#FEC98D", "#FECD90", "#FED395", "#FED799", "#FDDC9E", "#FDE1A2", "#FDE5A7", "#FDEBAB", "#FCEFB1", "#FCF4B6", "#FCF8BA", "#FCFDBF"};

    public static void plotMLogo(Graphics2D g, int x, int yp, int w, int he, double[][] ps, double[] CpG, double[] MpH, String[] labels, String labX, String labY) {
        Rectangle2D rect;
        int h = he / 2;
        int y = yp - h;
        g = (Graphics2D)g.create();
        g.setColor(Color.WHITE);
        g.fillRect(x, yp - he, w, he);
        Font font = new Font(g.getFont().getName(), 0, h / 14);
        g.setFont(font);
        if (labels == null) {
            labels = new String[ps.length];
            int i = 0;
            while (i < ps.length) {
                labels[i] = String.valueOf(i + 1);
                ++i;
            }
        }
        double wl = (double)h * 0.2;
        double w2 = ((double)w - wl * 1.5) / (double)ps.length;
        double x2 = wl * 0.9;
        double h2 = (double)h * 0.75;
        double y2 = (double)y - (double)h * 0.1;
        double y3 = (double)y - (double)h * 0.8;
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke((float)h / 100.0f));
        g.drawLine(x + (int)(x2 * 0.94), (int)y2, x + (int)(x2 * 0.94), (int)(y2 - h2));
        String[] labs = new String[]{"0", "0.5", "1", "1.5", "2"};
        int i = 0;
        while (i <= 4) {
            g.drawLine(x + (int)(x2 * 0.7), (int)(y2 - (double)i * h2 / 4.0), x + (int)(x2 * 0.94), (int)(y2 - (double)i * h2 / 4.0));
            rect = g.getFontMetrics().getStringBounds(labs[i], g);
            g.rotate(-1.5707963267948966);
            g.drawString(labs[i], -((int)(y2 - (double)i * h2 / 4.0 + rect.getCenterX())), x + (int)(x2 * 0.6));
            g.rotate(1.5707963267948966);
            ++i;
        }
        AffineTransform back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY, g);
        g.drawString(labY, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)x + rect.getWidth() / 2.0));
        g.setTransform(back);
        x2 = wl;
        rect = g.getFontMetrics().getStringBounds(labX, g);
        g.drawString(labX, x + (int)(x2 + w2 * (double)ps.length / 2.0 - rect.getCenterX()), (int)((double)y - 0.3 * rect.getHeight() + (double)h));
        int i2 = 0;
        while (i2 < ps.length) {
            MLogoPlotter.plotLogo(g, (double)x + x2, y2, w2, h2, ps[i2]);
            g.setColor(Color.BLACK);
            g.drawLine((int)(x2 + w2 / 2.0), (int)(y3 + 0.1 * (double)h + (double)h), (int)(x2 + w2 / 2.0), (int)(y3 + 0.1 * (double)h + 0.05 * (double)h + (double)h));
            g.rotate(-1.5707963267948966);
            rect = g.getFontMetrics().getStringBounds(labels[i2], g);
            g.drawString(labels[i2], -((float)(y3 + 0.2 * (double)h + rect.getWidth() + (double)h)), (float)x + (float)(x2 + w2 / 2.0 - rect.getCenterY()));
            g.rotate(1.5707963267948966);
            x2 += w2;
            ++i2;
        }
        y2 = y3 + 0.1 * (double)h;
        x2 = wl * 0.9;
        MLogoPlotter.drawSens(g, x, wl, y2, h2, h, w, w2, CpG, MpH);
        g.drawLine((int)(wl + w2 / 2.0), (int)(y3 + 0.1 * (double)h + (double)h), x + (int)(wl + w2 * ((double)ps.length - 0.5)), (int)(y3 + 0.1 * (double)h + (double)h));
    }

    private static void drawSens(Graphics2D g, int x, double wl, double y2, double h2, int h, int w, double w2, double[] CpG, double[] MpH) {
        MLogoPlotter.drawRects(g, x, wl, y2, h2, h, w2, CpG, true);
        MLogoPlotter.drawRects(g, x, wl, y2, h2, h, w2, MpH, false);
    }

    private static void drawRects(Graphics2D g, int x, double wl, double y2, double h2, int h, double w2, double[] vals, boolean CpG) {
        int yoff = (int)(y2 + (double)h - w2);
        if (CpG) {
            yoff = (int)(y2 + (double)h - w2 - w2);
        }
        int[] xpoints1 = new int[vals.length];
        int i = 0;
        while (i < vals.length) {
            xpoints1[i] = x + (int)(wl + w2 * ((double)i + 0.5));
            ++i;
        }
        double h3 = w2;
        double min = ToolBox.min(vals);
        if (CpG) {
            min = 0.0;
        }
        double max = ToolBox.max(vals);
        Color back = g.getColor();
        int i2 = 0;
        while (i2 < vals.length - 1) {
            if (CpG) {
                float val = (float)((max - vals[i2]) / (max - min) * 0.6 + 0.3);
                Color c = new Color(val, val, val);
                g.setColor(c);
            } else {
                double val = (vals[i2] - min) / (max - min);
                int idx = (int)(val * (double)(viridis_a.length - 1));
                Color c = Color.decode(viridis_a[idx]);
                g.setColor(c);
            }
            g.fillRect(xpoints1[i2], yoff, xpoints1[i2 + 1] - xpoints1[i2], (int)h3);
            ++i2;
        }
        g.setColor(back);
        String lab2 = "";
        lab2 = CpG ? "CpG" : "MH";
        Rectangle2D rect = g.getFontMetrics().getStringBounds(lab2, g);
        g.drawString(lab2, x + (int)(wl - rect.getCenterX() - w2 / 2.0), yoff + (int)(h3 / 2.0 - rect.getCenterY()));
        int wstep = (int)(w2 * (double)(vals.length - 3) / 2.0 / 100.0);
        int hstep = (int)(w2 / 3.0 * 2.0);
        int xoff = 0;
        xoff = CpG ? xpoints1[0] : xpoints1[xpoints1.length - 1] - wstep * 100;
        yoff = (int)(y2 + (double)h + 1.7 * h3);
        int xcurr = xoff;
        back = g.getColor();
        int i3 = 0;
        while (i3 < 100) {
            if (CpG) {
                float val = (float)((100.0 - (double)i3) / 100.0 * 0.6 + 0.3);
                Color c = new Color(val, val, val);
                g.setColor(c);
            } else {
                Color c = Color.decode(viridis_a[i3]);
                g.setColor(c);
            }
            g.fillRect(xcurr, yoff, wstep, hstep);
            xcurr += wstep;
            ++i3;
        }
        g.setColor(back);
        NiceScale scale = new NiceScale(min, max);
        scale.setMaxTicks(5.0);
        double niceMin = scale.getNiceMin();
        double niceMax = scale.getNiceMax();
        double ticks = scale.getTickSpacing();
        double pScale = (double)(xcurr - xoff) / (max - min);
        String tickString = String.valueOf(ticks);
        if (Math.abs(ticks) > 1.0E-4 && tickString.matches("[0-9]+\\\\.[0-9]*[1-9]0000+[0-9]$")) {
            tickString = tickString.replaceFirst("0000+[0-9]$", "");
        }
        int signif = tickString.replaceFirst("^.*\\.", "").length();
        DecimalFormat dc = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        dc.setMaximumFractionDigits(signif);
        dc.setMinimumFractionDigits(signif);
        double p = niceMin;
        while (p <= niceMax) {
            if (p >= min && p <= max) {
                int pos = xoff + (int)((p - min) * pScale);
                g.drawLine(pos, yoff + hstep, pos, yoff + hstep + hstep / 2);
                String lab = dc.format(p);
                if (lab.matches("^-0\\.?0*$")) {
                    lab = lab.substring(1);
                }
                rect = g.getFontMetrics().getStringBounds(lab, g);
                g.drawString(lab, (int)((double)pos - rect.getCenterX()), (int)((double)yoff + 1.5 * (double)hstep + rect.getHeight()));
            }
            p += ticks;
        }
        g.drawLine(xoff, yoff + hstep, xcurr, yoff + hstep);
        String lab = "";
        lab = CpG ? "CpG" : "Methylation sensitivity (MH)";
        rect = g.getFontMetrics().getStringBounds(lab, g);
        g.drawString(lab, (int)((double)(xoff + xcurr) / 2.0 - rect.getCenterX()), (int)((double)yoff + 2.5 * (double)hstep + rect.getHeight()));
    }

    private static void drawAxis(Graphics2D g, int x, double x2, double y2, double h2, int h, int w, double w2, double[] vals, boolean left) {
        Graphics2D g2;
        Rectangle2D rect;
        double min = ToolBox.min(vals);
        double max = ToolBox.max(vals);
        NiceScale scale = new NiceScale(min, max);
        scale.setMaxTicks(4.0);
        double niceMin = scale.getNiceMin();
        double niceMax = scale.getNiceMax();
        double ticks = scale.getTickSpacing();
        if (niceMin < min) {
            min = niceMin;
        }
        if (niceMax > max) {
            max = niceMax;
        }
        int niceYoff = (int)y2 + h;
        double niceYstep = h2 / (max - min);
        Integer lastEnd = null;
        double i = niceMin;
        while (i <= niceMax) {
            int currStart;
            double xoff = 0.0;
            if (!left) {
                xoff = w2 * ((double)vals.length + 0.5) + 0.24 * x2;
            }
            g.drawLine(x + (int)(x2 * 0.7 + xoff), (int)((double)niceYoff - (i - min) * niceYstep), x + (int)(x2 * 0.94 + xoff), (int)((double)niceYoff - (i - min) * niceYstep));
            String lab = String.valueOf(i);
            if (Math.abs(ticks) > 1.0E-4 && lab.matches("[0-9]+\\.[0-9]*[1-9]0000+[0-9]$")) {
                lab = lab.replaceFirst("0000+[0-9]$", "");
            }
            g.rotate(-1.5707963267948966);
            rect = g.getFontMetrics().getStringBounds(lab, g);
            if (left) {
                currStart = -((int)((double)niceYoff - (i - min) * niceYstep + rect.getCenterX() * 1.25));
                if (lastEnd == null || currStart > lastEnd) {
                    g.drawString(lab, -((int)((double)niceYoff - (i - min) * niceYstep + rect.getCenterX())), x + (int)(x2 * 0.6));
                    lastEnd = -((int)((double)niceYoff - (i - min) * niceYstep - rect.getCenterX() * 1.25));
                }
            } else {
                currStart = -((int)((double)niceYoff - (i - min) * niceYstep + rect.getCenterX() * 1.25));
                if (lastEnd == null || currStart > lastEnd) {
                    g.drawString(lab, -((int)((double)niceYoff - (i - min) * niceYstep + rect.getCenterX())), x + (int)(x2 * 1.0 + rect.getHeight() + xoff));
                    lastEnd = -((int)((double)niceYoff - (i - min) * niceYstep - rect.getCenterX() * 1.25));
                }
            }
            g.rotate(1.5707963267948966);
            i += ticks;
        }
        if (!left && min <= 0.0 && max >= 0.0) {
            Graphics2D gc = (Graphics2D)g.create();
            BasicStroke dashed = new BasicStroke(3.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
            gc.setStroke(dashed);
            gc.drawLine(x + (int)(x2 * 0.94), (int)((double)niceYoff - (0.0 - min) * niceYstep), x + (int)(x2 * 0.94 + w2 * ((double)vals.length + 0.5)), (int)((double)niceYoff - (0.0 - min) * niceYstep));
            gc.dispose();
        }
        double wl = (double)h * 0.4;
        int[] xpoints = new int[vals.length - 1];
        int[] ypoints = new int[vals.length - 1];
        int i2 = 0;
        while (i2 < vals.length - 1) {
            xpoints[i2] = x + (int)(wl + w2 * ((double)i2 + 0.5));
            ypoints[i2] = (int)((double)niceYoff - (vals[i2] - min) * niceYstep);
            ++i2;
        }
        if (left) {
            g2 = (Graphics2D)g.create();
            g2.drawLine(x + (int)(x2 * 0.94), (int)y2 + h, x + (int)(x2 * 0.94), (int)(y2 - h2 + (double)h));
            g2.rotate(-1.5707963267948966);
            rect = g2.getFontMetrics().getStringBounds("CpG", g);
            g2.drawString("CpG", -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX() + (double)h)), (int)((double)x + rect.getWidth() / 2.0));
            g2.dispose();
        } else {
            g2 = (Graphics2D)g.create();
            g2.drawLine(x + (int)(x2 * 0.94 + w2 * ((double)vals.length + 0.5)), (int)y2 + h, x + (int)(x2 * 0.94 + w2 * ((double)vals.length + 0.5)), (int)(y2 - h2 + (double)h));
            g2.rotate(-1.5707963267948966);
            String lab = "Methylation sensitivity";
            Rectangle2D rect2 = g2.getFontMetrics().getStringBounds(lab, g);
            g2.drawString(lab, -((int)(y2 - 2.0 * h2 / 4.0 + rect2.getCenterX() + (double)h)), (int)((double)(x + w) - rect2.getHeight()));
            g2.dispose();
        }
        Stroke back = g.getStroke();
        BasicStroke temp = new BasicStroke(((BasicStroke)back).getLineWidth() * 1.5f, 0, 2);
        g.setStroke(temp);
        g.drawPolyline(xpoints, ypoints, vals.length - 1);
        g.setStroke(back);
    }

    public static class MLogoPlotGenerator
    implements PlotGeneratorResult.PlotGenerator {
        private double[][] pwm;
        private double[] CpG;
        private double[] MpH;
        private int height;

        public MLogoPlotGenerator(double[][] pwm, double[] CpG, double[] MpH, int height) {
            this.pwm = pwm;
            this.CpG = CpG;
            this.MpH = MpH;
            this.height = height;
        }

        public MLogoPlotGenerator(StringBuffer xml) throws NonParsableException {
            this.pwm = (double[][])XMLParser.extractObjectForTags(xml, "pwm");
            this.CpG = (double[])XMLParser.extractObjectForTags(xml, "CpG");
            this.MpH = (double[])XMLParser.extractObjectForTags(xml, "MpH");
            this.height = (Integer)XMLParser.extractObjectForTags(xml, "height");
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer xml = new StringBuffer();
            XMLParser.appendObjectWithTags(xml, this.pwm, "pwm");
            XMLParser.appendObjectWithTags(xml, this.CpG, "CpG");
            XMLParser.appendObjectWithTags(xml, this.MpH, "MpH");
            XMLParser.appendObjectWithTags(xml, this.height, "height");
            return xml;
        }

        @Override
        public void generatePlot(GraphicsAdaptor ga) throws Exception {
            int width = SeqLogoPlotter.getWidth(this.height / 2, this.pwm);
            MLogoPlotter.plotMLogo(ga.getGraphics(width, this.height), 0, this.height, width, this.height, this.pwm, this.CpG, this.MpH, null, "", "");
        }
    }
}

