/*
 * Decompiled with CFR 0.152.
 */
package projects.methyl;

import de.jstacs.DataType;
import de.jstacs.Storable;
import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.NegativeDifferentiableFunction;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.termination.CombinedCondition;
import de.jstacs.algorithms.optimization.termination.IterationCondition;
import de.jstacs.algorithms.optimization.termination.MultipleIterationsCondition;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LogGenDisMixFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.data.alphabets.GenericComplementableDiscreteAlphabet;
import de.jstacs.data.sequences.ArbitraryFloatSequence;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscovererToolbox;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.StorableResult;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.MarkovModelDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.UniformHomogeneousDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.localMixture.LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.Pair;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.ToolBox;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import javax.naming.OperationNotSupportedException;
import projects.dimont.AbstractSingleMotifChIPper;
import projects.dimont.HeuristicOneDataSetLogGenDisMixFunction;
import projects.dimont.Interpolation;
import projects.dimont.ThresholdedStrandChIPper;

public class MethylSlimDimontTool
implements JstacsTool {
    private static final double ALPHA = 0.001;
    private static Random r = new Random(1123L);

    @Override
    public ToolParameterSet getToolParameters() {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        try {
            parameters.add(new SimpleParameter(DataType.STRING, "Alphabet", "Characters of the alphabet as a string of unseparated characters, first listing the symbols in forward orientation and then their complement in the same order. For instance, a methylation-aware alphabet would be specified as ACGTMH,TGCAHM and a standard DNA alphabet as ACGT,TGCA", true, "ACGTMH,TGCAHM"));
            parameters.add(new FileParameter("Input file", "The file name of the file containing the input sequences in annotated FastA format as generated by the Data Extractor tool", "fasta,fa,fas", true));
            FileParameter bgFile = new FileParameter("Background file", "The file name of the file containing background sequences in annotated FastA format.", "fasta,fa,fas", false);
            SelectionParameter sp = new SelectionParameter(DataType.PARAMETERSET, new String[]{"background file", "shuffled input", "none"}, new ParameterSet[]{new SimpleParameterSet(bgFile), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0])}, "Background sample", "Background sample containing negative examples, may be di-nucleotide shuffled input sequences", true);
            sp.setDefault("shuffled input");
            parameters.add(sp);
            parameters.add(new SimpleParameter(DataType.STRING, "Position tag", "The tag for the position information in the FastA-annotation of the input file", true, "peak"));
            parameters.add(new SimpleParameter(DataType.STRING, "Value tag", "The tag for the value information in the FastA-annotation of the input file", true, "signal"));
            parameters.add(new SimpleParameter(DataType.DOUBLE, "Standard deviation", "The standard deviation of the position distribution centered at the position specified by the position tag", true, new NumberValidator<Double>(1.0, 10000.0), 75.0));
            parameters.add(new SimpleParameter(DataType.DOUBLE, "Weighting factor", "The value for weighting the data, between 0 and 1", true, new NumberValidator<Double>(0.0, 1.0), 0.2));
            parameters.add(new SimpleParameter(DataType.INT, "Starts", "The number of pre-optimization runs.", true, new NumberValidator<Integer>(1, 100), 20));
            parameters.add(new SimpleParameter(DataType.INT, "Initial motif width", "The motif width that is used initially, may be adjusted during optimization.", true, new NumberValidator<Integer>(1, 50), 20));
            SelectionParameter modelType = new SelectionParameter(DataType.PARAMETERSET, new String[]{"LSlim model", "Markov model"}, new ParameterSet[]{new SimpleParameterSet(new SimpleParameter(DataType.INT, "Maximum distance", "The maximum distance considered in the LSlim model", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 5)), new SimpleParameterSet(new SimpleParameter(DataType.INT, "Order", "The order of the Markov model", true, new NumberValidator<Integer>(0, 5), 0))}, "Model type", "The type of the motif model; a PWM model corresponds to a Markov model of order 0.", true);
            parameters.add(modelType);
            parameters.add(new SimpleParameter(DataType.INT, "Markov order of background model", "The Markov order of the model for the background sequence and the background sequence, -1 defines uniform distribution.", true, new NumberValidator<Integer>(-1, 5), -1));
            parameters.add(new SimpleParameter(DataType.DOUBLE, "Equivalent sample size", "Reflects the strength of the prior on the model parameters.", true, new NumberValidator<Double>(0.0, Double.POSITIVE_INFINITY), 4.0));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Delete BSs from profile", "A switch for deleting binding site positions of discovered motifs from the profile before searching for futher motifs.", true, true));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Adjust for shifts", "Adjust for shifts of the motif.", true, true));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return new ToolParameterSet(this.getShortName(), parameters);
    }

    public AlphabetContainer getAlphabet(SimpleParameter par) throws IllegalArgumentException, DoubleSymbolException {
        Object[] symsr;
        String chars = (String)par.getValue();
        String[] fr = chars.split(",");
        Object[] syms = fr[0].split("");
        if (syms.length != (symsr = fr[1].split("")).length) {
            throw new IllegalArgumentException("Not the same number of reverse complementary symbols as original symbols: " + Arrays.toString(syms) + " <-> " + Arrays.toString(symsr));
        }
        int[] compl = new int[syms.length];
        int i = 0;
        while (i < symsr.length) {
            int j = 0;
            while (j < syms.length) {
                if (((String)symsr[i]).equals(syms[j])) {
                    compl[i] = j;
                }
                ++j;
            }
            ++i;
        }
        return new AlphabetContainer((Alphabet)new GenericComplementableDiscreteAlphabet(true, (String[])syms, compl));
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        int i;
        progress.setLast(1.0);
        progress.setCurrent(0.0);
        AlphabetContainer con = this.getAlphabet((SimpleParameter)parameters.getParameterAt(0));
        DataSet fgData = new DataSet(con, new SparseStringExtractor(new StringReader(((FileParameter)parameters.getParameterAt(1)).getFileContents().getContent()), '>', "", (SequenceAnnotationParser)new SplitSequenceAnnotationParser(":", ";")));
        DataSet bgData = null;
        int bgSample = ((SelectionParameter)parameters.getParameterAt(2)).getSelected();
        bgData = bgSample == 0 ? new DataSet(con, new SparseStringExtractor(new StringReader(((FileParameter)((ParameterSet)((SelectionParameter)parameters.getParameterAt(2)).getValue()).getParameterAt(0)).getFileContents().getContent()), '>', "", (SequenceAnnotationParser)new SplitSequenceAnnotationParser(":", ";"))) : (bgSample == 1 ? this.shuffle(fgData) : null);
        String position = parameters.getParameterAt(3).getValue().toString();
        String value = parameters.getParameterAt(4).getValue().toString();
        double sd = (Double)parameters.getParameterAt(5).getValue();
        double wf = (Double)parameters.getParameterAt(6).getValue();
        int restarts = (Integer)parameters.getParameterAt(7).getValue();
        int motifLength = (Integer)parameters.getParameterAt(8).getValue();
        int modelType = ((SelectionParameter)parameters.getParameterAt(9)).getSelected();
        int ordDist = (Integer)((ParameterSet)((SelectionParameter)parameters.getParameterAt(9)).getValue()).getParameterAt(0).getValue();
        int bgOrder = (Integer)parameters.getParameterAt(10).getValue();
        double ess = (Double)parameters.getParameterAt(11).getValue();
        boolean delete = (Boolean)parameters.getParameterAt(12).getValue();
        boolean modify = (Boolean)parameters.getParameterAt(13).getValue();
        double filterThreshold = 0.3;
        double filterThresholdEnd = 0.3;
        boolean free = false;
        DataSet[] data = new DataSet[]{fgData};
        Sequence[] annotated = new Sequence[data[0].getNumberOfElements() + (bgData == null ? 0 : bgData.getNumberOfElements())];
        double[][] weights = new double[2][];
        double[] raw = new double[data[0].getNumberOfElements()];
        double[] mean = new double[annotated.length];
        Arrays.fill(mean, Double.NaN);
        int j = 0;
        while (j < raw.length) {
            annotated[j] = data[0].getElementAt(j);
            SequenceAnnotation[] seqAn = annotated[j].getAnnotation();
            mean[j] = Double.NaN;
            i = 0;
            while (i < seqAn.length) {
                if (seqAn[i].getType().equals(value)) {
                    raw[j] = Double.parseDouble(seqAn[i].getIdentifier());
                } else if (seqAn[i].getType().equals(position)) {
                    mean[j] = Double.parseDouble(seqAn[i].getIdentifier());
                }
                ++i;
            }
            ++j;
        }
        if (bgData != null) {
            j = 0;
            while (j < bgData.getNumberOfElements()) {
                Sequence s;
                annotated[raw.length + j] = s = bgData.getElementAt(j);
                mean[raw.length + j] = (double)s.getLength() / 2.0;
                ++j;
            }
        }
        double[] w = Interpolation.getWeight(data[0], raw, wf, Interpolation.RANK_LOG);
        if (bgData == null) {
            weights[0] = w;
        } else {
            weights[0] = new double[w.length + bgData.getNumberOfElements()];
            System.arraycopy(w, 0, weights[0], 0, w.length);
        }
        weights[1] = Interpolation.getBgWeight(weights[0]);
        if (bgData != null) {
            double fac2 = (double)fgData.getNumberOfElements() / (double)bgData.getNumberOfElements();
            int i2 = w.length;
            while (i2 < weights.length) {
                double[] dArray = weights[1];
                int n = i2++;
                dArray[n] = dArray[n] * fac2;
            }
        }
        boolean[][] allowed = new boolean[annotated.length][];
        i = 0;
        while (i < annotated.length) {
            allowed[i] = new boolean[annotated[i].getLength()];
            Arrays.fill(allowed[i], true);
            ++i;
        }
        data[0] = MethylSlimDimontTool.annotate(annotated, weights, mean, sd, allowed, fgData.getNumberOfElements());
        DataSet completeData = data[0];
        double[][] completeWeight = new double[][]{weights[0], weights[1]};
        AbstractDifferentiableStatisticalModel motif = null;
        motif = modelType == 1 ? new MarkovModelDiffSM(con, motifLength, ess, true, ordDist, null) : new LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder(con, motifLength, 1, ordDist, ess, 0.9, LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder.PriorType.BDeu);
        ThresholdedStrandChIPper fg = new ThresholdedStrandChIPper(1, 0.5, motif);
        fg.initializeFunctionRandomly(false);
        double fac = (1.0 - wf) / wf;
        DifferentiableStatisticalModel bg = MethylSlimDimontTool.getBgSF(con, bgOrder, ess * fac, data[0].getAverageElementLength());
        bg.initializeFunction(0, false, data, weights);
        DifferentiableSequenceScore[] score = new DifferentiableStatisticalModel[]{fg, bg};
        double[] beta = LearningPrinciple.getBeta(LearningPrinciple.MSP);
        LearningPrinciple initKey = beta[0] > 0.0 ? LearningPrinciple.MCL : LearningPrinciple.ML;
        HeuristicOneDataSetLogGenDisMixFunction initObjective = new HeuristicOneDataSetLogGenDisMixFunction(threads, score, completeData, (double[][])completeWeight.clone(), (LogPrior)new CompositeLogPrior(), LearningPrinciple.getBeta(initKey), true, free);
        HeuristicOneDataSetLogGenDisMixFunction objective = new HeuristicOneDataSetLogGenDisMixFunction(threads, score, data[0], (double[][])weights, (LogPrior)new CompositeLogPrior(), beta, true, free);
        NegativeDifferentiableFunction neg = new NegativeDifferentiableFunction(objective);
        double eps = 1.0E-4;
        CombinedCondition stop = new CombinedCondition(2, new MultipleIterationsCondition(5, new SmallDifferenceOfFunctionEvaluationsCondition(eps)), new IterationCondition(100));
        ConstantStartDistance start = new ConstantStartDistance(1.0);
        Object params = null;
        double[][] pwm = null;
        double[] entropy = new double[motifLength];
        double[] kl = new double[motifLength];
        byte algo = 18;
        GenDisMixClassifierParameterSet genDisMixParams = new GenDisMixClassifierParameterSet(con, 0, algo, eps, eps * 0.1, 1.0, free, OptimizableFunction.KindOfParameter.PLUGIN, true, threads);
        objective.reset(score);
        DataSet smallData = null;
        Object smallWeight = new double[2][];
        double[] p = null;
        Pair<DataSet, double[][]> small = MethylSlimDimontTool.getSmallDataSets(completeWeight, annotated, 0.3, 1000);
        smallData = small.getFirstElement();
        smallWeight = small.getSecondElement();
        initObjective.setDataAndWeights(new DataSet[]{smallData}, (double[][])smallWeight);
        initObjective.reset(score);
        double percentKmers = 1.0;
        Object[] sortedPars = new ComparableElement[restarts];
        int numKmers = 0;
        if (percentKmers > 0.0) {
            int k = 7;
            ComparableElement<String, Double>[] array = MethylSlimDimontTool.getKmereSequenceStatistic(Math.max(50, (int)Math.ceil(percentKmers * (double)restarts)), k, smallData, smallWeight[0]);
            Object[] array2 = new ComparableElement[array.length];
            int a = 4;
            double d = 0.1 / (double)(a - 1);
            d = (1.0 - (double)a * d) / ((double)a * d);
            double h = d * motif.getESS();
            int z = 0;
            while (z < array.length) {
                Pair<DataSet, double[]> temp = MethylSlimDimontTool.getInitData(smallData, smallWeight, Sequence.create(con, array[z].getElement()), motifLength);
                ((AbstractSingleMotifChIPper)score[0]).initializeMotif(0, temp.getFirstElement(), temp.getSecondElement());
                p = objective.getParameters(OptimizableFunction.KindOfParameter.PLUGIN);
                initObjective.reset(score);
                initObjective.resetHeuristics();
                double val = initObjective.evaluateFunction(p);
                array2[z] = new ComparableElement<double[], Double>(p, val);
                ++z;
            }
            Arrays.sort(array2);
            numKmers = Math.min(array2.length, (int)Math.ceil((double)restarts * percentKmers));
            z = 0;
            while (z < numKmers) {
                sortedPars[z] = array2[array2.length - 1 - z];
                ++z;
            }
        }
        if (numKmers != sortedPars.length) {
            MutableMotifDiscovererToolbox.InitMethodForDiffSM[] initMeth = new MutableMotifDiscovererToolbox.InitMethodForDiffSM[]{MutableMotifDiscovererToolbox.InitMethodForDiffSM.PLUG_IN, MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING};
            ComparableElement<double[], Double>[] sortedPars2 = MutableMotifDiscovererToolbox.getSortedInitialParameters(score, initMeth, initObjective, Math.max(100, restarts), SafeOutputStream.getSafeOutputStream(null), 0);
            int z = 0;
            while (z < sortedPars.length - numKmers) {
                sortedPars[numKmers + z] = sortedPars2[sortedPars2.length - 1 - z];
                ++z;
            }
            Arrays.sort(sortedPars);
        }
        progress.setCurrent(0.05);
        CombinedCondition stop2 = new CombinedCondition(2, new MultipleIterationsCondition(5, new SmallDifferenceOfFunctionEvaluationsCondition(eps)), new IterationCondition(25));
        Object[] preOpt = new ComparableElement[restarts];
        int r = 0;
        while (r < restarts) {
            data[0] = smallData;
            weights = smallWeight;
            objective.setDataAndWeights(data, weights);
            objective.resetHeuristics();
            protocol.append("-----------------------------------------\npre-optimization " + r + "\n");
            start.reset();
            p = (double[])((ComparableElement)sortedPars[sortedPars.length - 1 - r]).getElement();
            objective.setParams(p);
            Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, null);
            data[0] = completeData;
            weights = completeWeight;
            objective.setDataAndWeights(data, weights);
            preOpt[r] = new ComparableElement<double[], Double>(p, objective.evaluateFunction(p));
            protocol.append("model: " + ((AbstractSingleMotifChIPper)score[0]).getFunction(0) + "\n");
            protocol.append("score: " + ((ComparableElement)preOpt[r]).getWeight() + "\n");
            ((AbstractSingleMotifChIPper)score[0]).resetPositions();
            progress.setCurrent(0.05 + ((double)r + 1.0) / (double)restarts * 0.2);
            ++r;
        }
        protocol.append("-----------------------------------------\n");
        progress.setCurrent(0.25);
        Arrays.sort(preOpt);
        ArrayList<ComparableElement<double[], Double>> list = MethylSlimDimontTool.filter2((AbstractSingleMotifChIPper)score[0], preOpt, smallData, filterThreshold, motifLength, protocol);
        MutableMotifDiscoverer[] best = new MutableMotifDiscoverer[list.size()];
        Storable[] storables = new Storable[best.length];
        double[] opts = new double[best.length];
        Pair[] pairs = new Pair[best.length];
        int m = 0;
        while (m < best.length) {
            Pair<double[][][], int[][]> pair;
            protocol.append("+++++++++++++++++++++++++++++++++++++++++++++++++++\n\nfinalOpt " + m + " -----------------------------------------\n");
            best[m] = (MutableMotifDiscoverer)((Object)score[0]);
            int j2 = 0;
            while (j2 < best[m].getNumberOfMotifs()) {
                if (best[m].getMotifLength(j2) != motifLength) {
                    best[m].modifyMotif(j2, 0, motifLength - best[m].getMotifLength(j2));
                }
                ++j2;
            }
            ((AbstractSingleMotifChIPper)score[0]).reset();
            ((AbstractSingleMotifChIPper)score[0]).resetPositions();
            objective.reset(score);
            objective.resetHeuristics();
            start.reset();
            p = list.get(m).getElement();
            objective.setParams(p);
            data[0] = MethylSlimDimontTool.annotate(annotated, weights, mean, sd, allowed, fgData.getNumberOfElements());
            objective.setDataAndWeights(data, weights);
            Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, SafeOutputStream.getSafeOutputStream(null));
            progress.setCurrent(0.25 + 0.7 * (((double)m + 0.5) / (double)best.length));
            double[] sds = new double[1];
            MethylSlimDimontTool.heuristic((MutableMotifDiscoverer)((Object)score[0]), completeData, completeWeight, objective, mean, sds, protocol, modify);
            ((AbstractSingleMotifChIPper)score[0]).reset();
            double newSd = Math.sqrt(sds[0] * sd);
            if (Double.isNaN(newSd) || Double.isInfinite(newSd) || newSd <= 0.0) {
                protocol.append("Did not adjust sd to " + newSd + " using " + sds[0] + " and " + sd + "\n");
                newSd = sd;
            }
            data[0] = MethylSlimDimontTool.annotate(annotated, weights, mean, newSd, allowed, fgData.getNumberOfElements());
            objective.setDataAndWeights(data, weights);
            ((AbstractSingleMotifChIPper)score[0]).resetPositions();
            objective.reset(score);
            p = objective.getParameters(OptimizableFunction.KindOfParameter.LAST);
            objective.setParams(p);
            Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, SafeOutputStream.getSafeOutputStream(null));
            protocol.append("model: " + ((AbstractSingleMotifChIPper)score[0]).getFunction(0) + "\n");
            best[m] = (MutableMotifDiscoverer)((Object)score[0]).clone();
            opts[m] = objective.evaluateFunction(p);
            GenDisMixClassifier cl = new GenDisMixClassifier(genDisMixParams, (LogPrior)new CompositeLogPrior(), opts[m], LearningPrinciple.getBeta(LearningPrinciple.MSP), (DifferentiableStatisticalModel[])score);
            cl.setClassWeights(false, objective.getClassParams(p));
            storables[m] = cl;
            SignificantMotifOccurrencesFinder smof = new SignificantMotifOccurrencesFinder(best[m], completeData, completeWeight[1], 0.001);
            pairs[m] = pair = smof.getPWMAndPositions(0, completeData, completeWeight[0], 0, 0);
            if (delete && m + 1 < best.length) {
                MethylSlimDimontTool.delete(pair.getSecondElement(), allowed, motifLength);
            }
            progress.setCurrent(0.25 + 0.7 * (((double)m + 1.0) / (double)best.length));
            ++m;
        }
        int[] o = ToolBox.rank(opts, ToolBox.TiedRanks.IN_ORDER);
        int[] index = new int[o.length];
        int i3 = 0;
        while (i3 < o.length) {
            index[o[i3]] = i3;
            ++i3;
        }
        boolean[] use = MethylSlimDimontTool.postFilter(best, index, smallData, filterThresholdEnd, motifLength);
        LinkedList<ResultSetResult> results = new LinkedList<ResultSetResult>();
        int m2 = 0;
        int n = 0;
        while (m2 < best.length) {
            if (use[m2]) {
                LinkedList<Result> result = new LinkedList<Result>();
                result.add(new StorableResult("SlimDimont " + (n + 1), "The SlimDimont classifier", storables[index[m2]]));
                LinkedList<Sequence> bs = new LinkedList<Sequence>();
                DoubleList bsWeights = new DoubleList();
                result.add(MethylSlimDimontTool.getListResult(fgData, completeWeight[0], pairs[index[m2]], ((ThresholdedStrandChIPper)((GenDisMixClassifier)storables[index[m2]]).getDifferentiableSequenceScore(0)).getMotifLength(0), n, ((ThresholdedStrandChIPper)((GenDisMixClassifier)storables[index[m2]]).getDifferentiableSequenceScore(0)).getMotifModel(), bs, bsWeights, value));
                pwm = ((double[][][])pairs[index[m2]].getFirstElement())[0];
                if (!Double.isNaN(pwm[0][0])) {
                    try {
                        result.add(new PlotGeneratorResult("Motif " + (n + 1), "Sequence logo of motif " + (n + 1), new SeqLogoPlotter.SeqLogoPlotGenerator(pwm, 1000), true));
                        result.add(new PlotGeneratorResult("Motif " + (n + 1) + " (rc)", "Sequence logo of the reverse complement of motif " + (n + 1), new SeqLogoPlotter.SeqLogoPlotGenerator(PFMComparator.getReverseComplement((ComplementableDiscreteAlphabet)con.getAlphabetAt(0), pwm), 750), true));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ResultSetResult rsr = new ResultSetResult("Motif " + (n + 1), "The Dimont results for motif " + (n + 1), null, new ResultSet(result));
                results.add(rsr);
                ++n;
            }
            ++m2;
        }
        initObjective.stopThreads();
        objective.stopThreads();
        progress.setCurrent(1.0);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(results), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    private DataSet shuffle(DataSet fgData) throws Exception {
        Sequence[] seqs = new Sequence[fgData.getNumberOfElements()];
        int i = 0;
        while (i < seqs.length) {
            seqs[i] = MethylSlimDimontTool.shuffle(fgData.getElementAt(i), 2);
            ++i;
        }
        return new DataSet("", seqs);
    }

    public static Sequence shuffle(Sequence original, int k) throws Exception {
        int n = original.getLength();
        int[] shuffle = new int[n];
        int[] help = (int[])shuffle.clone();
        int i = 0;
        while (i < n) {
            shuffle[i] = original.discreteVal(i);
            ++i;
        }
        int anz = 0;
        int i2 = 0;
        while (i2 < shuffle.length) {
            int a = r.nextInt(n - 4 * (k + 1));
            int b = a + 1 + r.nextInt(n - 3 * (k + 1) - a);
            int c = b + 1 + r.nextInt(n - 2 * (k + 1) - b);
            int d = c + 1 + r.nextInt(n - k + 1 - c);
            int j = 0;
            while (j < k - 1 && shuffle[a + j] == shuffle[c + j]) {
                ++j;
            }
            boolean matches = j == k - 1;
            j = 0;
            while (matches && j < k - 1 && shuffle[b + j] == shuffle[d + j]) {
                ++j;
            }
            if (matches &= j == k - 1) {
                ++anz;
                Arrays.fill(help, 0);
                System.arraycopy(shuffle, 0, help, 0, a);
                System.arraycopy(shuffle, c, help, a, d - c);
                System.arraycopy(shuffle, b, help, a + d - c, c - b);
                System.arraycopy(shuffle, a, help, a + d - b, b - a);
                System.arraycopy(shuffle, d, help, d, n - d);
                System.arraycopy(help, 0, shuffle, 0, n);
            }
            ++i2;
        }
        IntSequence seq = new IntSequence(original.getAlphabetContainer(), shuffle);
        return seq;
    }

    public static ListResult getListResult(DataSet data, double[] weights, Pair<double[][][], int[][]> pair, int motifLength, int motifIndex, DifferentiableStatisticalModel model, LinkedList<Sequence> bs, DoubleList bsWeights, String valueKey) throws Exception {
        SplitSequenceAnnotationParser pars = new SplitSequenceAnnotationParser(":", ";");
        LinkedList<ResultSet> set = new LinkedList<ResultSet>();
        int[][] pos = pair.getSecondElement();
        double[][] pvals = pair.getFirstElement()[1];
        int i = 0;
        while (i < data.getNumberOfElements()) {
            int j = 0;
            while (j < pos[i].length) {
                Sequence sub;
                int curr = pos[i][j];
                boolean rc = false;
                if (curr < 0) {
                    curr = -curr - 1;
                    rc = true;
                }
                Sequence sub2 = sub = data.getElementAt(i).getSubSequence(curr, motifLength);
                if (rc) {
                    sub2 = sub.reverseComplement();
                }
                double score = model.getLogScoreFor(sub2);
                ResultSet rs = new ResultSet(new Result[][]{{new NumericalResult("Sequence index", "The index of the sequence", i + 1), new NumericalResult("Position", "The starting position of the motif within the sequence", curr + 1), new CategoricalResult("Strand", "The strand of the predicted BS", rc ? "-" : "+"), new NumericalResult("p-value", "The p-value of the predicted BS", pvals[i][j]), new NumericalResult("-log10(p-value)", "The negative logarithm of the p-value of the predicted BS", -Math.log10(pvals[i][j])), new NumericalResult("Score", "The model score of the predicted BS", score), new CategoricalResult("Binding site", "The binding site as in the sequence", sub.toString()), new CategoricalResult("Adjusted binding site", "The binding site in predicted orientation", sub2.toString()), new CategoricalResult("Signal", "The signal of the sequence annotation", data.getElementAt(i).getSequenceAnnotationByType(valueKey, 0).getIdentifier()), new CategoricalResult("Sequence annotation", "The annotation of the original sequence", pars.parseAnnotationToComment(' ', data.getElementAt(i).getAnnotation()).substring(1))}});
                set.add(rs);
                bs.add(sub2);
                bsWeights.add(-Math.log10(pvals[i][j]));
                ++j;
            }
            ++i;
        }
        ListResult lr = new ListResult("Predictions for motif " + (motifIndex + 1), "", null, set.toArray(new ResultSet[0]));
        return lr;
    }

    private static void delete(int[][] positions, boolean[][] allowed, int length) {
        int i = 0;
        while (i < positions.length) {
            int j = 0;
            while (j < positions[i].length) {
                int pos = positions[i][j];
                if (pos < 0) {
                    pos = -pos - 1;
                }
                Arrays.fill(allowed[i], Math.max(0, pos - length / 2), Math.min(allowed[i].length, pos + length / 2), false);
                ++j;
            }
            ++i;
        }
    }

    private static Pair<DataSet, double[][]> getSmallDataSets(double[][] completeWeight, Sequence[] data, double percent, int maxN) throws EmptyDataSetException, WrongAlphabetException {
        int[] ofg = ToolBox.order(completeWeight[0], false);
        int[] obg = ToolBox.order(completeWeight[1], false);
        boolean[] used = new boolean[completeWeight[0].length];
        double[] sums = new double[]{ToolBox.sum(completeWeight[0]), ToolBox.sum(completeWeight[1])};
        double[] currSums = new double[2];
        int idxFg = ofg.length;
        int idxBg = obg.length;
        int totN = 0;
        int nfg = 0;
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        DoubleList w = new DoubleList();
        while (totN < maxN && currSums[0] + completeWeight[0][ofg[idxFg - 1]] < sums[0] * percent) {
            currSums[0] = currSums[0] + completeWeight[0][ofg[idxFg - 1]];
            if (!used[ofg[idxFg - 1]]) {
                seqs.add(data[ofg[idxFg - 1]]);
                w.add(completeWeight[0][ofg[idxFg - 1]]);
                used[ofg[idxFg - 1]] = true;
                ++totN;
                ++nfg;
            }
            --idxFg;
            double tempPerc = currSums[0] / sums[0];
            while (totN < maxN && currSums[1] + completeWeight[1][obg[idxBg - 1]] < sums[1] * tempPerc) {
                currSums[1] = currSums[1] + completeWeight[1][obg[idxBg - 1]];
                if (!used[obg[idxBg - 1]]) {
                    seqs.add(data[obg[idxBg - 1]]);
                    w.add(completeWeight[0][obg[idxBg - 1]]);
                    used[obg[idxBg - 1]] = true;
                    ++totN;
                }
                --idxBg;
            }
        }
        double[] rw = w.toArray();
        return new Pair<DataSet, double[][]>(new DataSet("", seqs.toArray(new Sequence[0])), new double[][]{rw, Interpolation.getBgWeight(rw)});
    }

    static DataSet annotate(Sequence[] annotated, double[][] weights, double[] mean, double sd, boolean[][] allowed, int fg) throws WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException {
        AlphabetContainer ref = new AlphabetContainer((Alphabet)new ContinuousAlphabet());
        float[][] histogram = new float[annotated.length][];
        int j = 0;
        while (j < weights[0].length) {
            histogram[j] = new float[annotated[j].getLength()];
            if (j >= fg) {
                float sum = 0.0f;
                int i = 0;
                while (i < histogram[j].length) {
                    if (allowed[j][i]) {
                        histogram[j][i] = 1.0f;
                        sum += 1.0f;
                    }
                    ++i;
                }
                i = 0;
                while (i < histogram[j].length) {
                    float[] fArray = histogram[j];
                    int n = i++;
                    fArray[n] = fArray[n] / sum;
                }
            } else {
                float max = 0.0f;
                float sum = 0.0f;
                int i = 0;
                while (i < histogram[j].length) {
                    if (allowed[j][i]) {
                        histogram[j][i] = (float)(((double)i - mean[j]) / sd);
                        histogram[j][i] = (float)Math.exp(-0.5 * (double)histogram[j][i] * (double)histogram[j][i]);
                        sum += histogram[j][i];
                    }
                    ++i;
                }
                i = 0;
                while (i < histogram[j].length) {
                    float[] fArray = histogram[j];
                    int n = i;
                    fArray[n] = fArray[n] / sum;
                    if (histogram[j][i] > max) {
                        max = histogram[j][i];
                    }
                    ++i;
                }
                float[] histBg = (float[])histogram[j].clone();
                sum = 0.0f;
                int i2 = 0;
                while (i2 < histBg.length) {
                    if (allowed[j][i2]) {
                        histBg[i2] = fg < weights[0].length ? 1.0f : max - histBg[i2];
                        sum += histBg[i2];
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < histBg.length) {
                    int n = i2++;
                    histBg[n] = histBg[n] / sum;
                }
                i2 = 0;
                while (i2 < histogram[j].length) {
                    histogram[j][i2] = (float)(weights[0][j] * (double)histogram[j][i2] + weights[1][j] * (double)histBg[i2]);
                    ++i2;
                }
            }
            annotated[j] = annotated[j].annotate(false, new ReferenceSequenceAnnotation("reads", new ArbitraryFloatSequence(ref, histogram[j]), new Result[0]));
            ++j;
        }
        return new DataSet("", annotated);
    }

    private static Pair<DataSet, double[]> getInitData(DataSet completeData, double[][] completeWeight, Sequence kmer, int length) throws Exception {
        int off = (length - kmer.getLength()) / 2;
        int evCorr = (length - kmer.getLength()) % 2 == 0 ? 0 : 1;
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        DoubleList ws = new DoubleList();
        int i = 0;
        while (i < completeData.getNumberOfElements()) {
            Sequence seq = completeData.getElementAt(i);
            int j = off;
            while (j < seq.getLength() - off - kmer.getLength()) {
                int dist = MethylSlimDimontTool.getHammingDistance(kmer, seq, j);
                if (dist < 3 && dist > -4 && (dist >= 0 || j - off - evCorr >= 0)) {
                    if (dist >= 0) {
                        seqs.add(seq.getSubSequence(j - off, length));
                    } else {
                        seqs.add(seq.getSubSequence(j - off - evCorr, length).reverseComplement());
                    }
                    if (dist < 0) {
                        dist = -(dist + 1);
                    }
                    ws.add(completeWeight[0][i] / Math.pow(4.0, dist));
                }
                ++j;
            }
            ++i;
        }
        return new Pair<DataSet, double[]>(new DataSet("", seqs), ws.toArray());
    }

    private static int getHammingDistance(Sequence kmer, Sequence seq, int start) throws WrongAlphabetException, OperationNotSupportedException {
        int distrc;
        int distfwd = kmer.getHammingDistance(seq.getSubSequence(start, kmer.getLength()));
        if (distfwd <= (distrc = kmer.getHammingDistance(seq.getSubSequence(start, kmer.getLength()).reverseComplement()))) {
            return distfwd;
        }
        return -distrc - 1;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean heuristic(MutableMotifDiscoverer best, DataSet completeData, double[][] completeWeight, LogGenDisMixFunction objective, double[] mean, double[] sds, Protocol protocol, boolean modify) throws Exception {
        smof = new SignificantMotifOccurrencesFinder(best, completeData, completeWeight[1], 0.001);
        modified = false;
        log2 = Math.log(2.0);
        im = 0;
        while (im < best.getNumberOfMotifs()) {
            add = 5;
            if (completeData.getAverageElementLength() - (double)best.getMotifLength(im) < 20.0) {
                add = (int)((completeData.getAverageElementLength() - (double)best.getMotifLength(im)) / 4.0);
            }
            bs = new LinkedList<Sequence>();
            bsWeights = new DoubleList();
            bsScores = new DoubleList();
            pair = smof.getPWMAndPosDist(im, completeData, completeWeight[0], mean, add, add, bs, bsWeights, bsScores);
            pwm = pair.getFirstElement();
            sds[im] = pair.getSecondElement()[0];
            entropy = new double[pwm.length];
            kl = new double[pwm.length];
            bgDistr = MethylSlimDimontTool.getCounts(completeData, completeWeight[1]);
            PFMComparator.normalize(bgDistr);
            i = 0;
            while (i < pwm.length) {
                kl[i] = 0.0;
                entropy[i] = Math.log(pwm[i].length) / log2;
                j = 0;
                while (j < pwm[i].length) {
                    if (pwm[i][j] > 0.0) {
                        v0 = i;
                        entropy[v0] = entropy[v0] + pwm[i][j] * Math.log(pwm[i][j]) / log2;
                        v1 = i;
                        kl[v1] = kl[v1] + pwm[i][j] * Math.log(pwm[i][j] / bgDistr[j]);
                    }
                    ++j;
                }
                ++i;
            }
            if (bs.size() == 0) {
                return false;
            }
            bsDs = new DataSet("", bs);
            mi = MethylSlimDimontTool.getMaxMI(bsDs, bsWeights.toArray(), bsScores.toArray());
            maxOrder = 0;
            chipper = (ThresholdedStrandChIPper)best;
            motifModel = chipper.getMotifModel();
            if (motifModel instanceof MarkovModelDiffSM) {
                maxOrder = ((MarkovModelDiffSM)motifModel).getOrder();
            } else if (motifModel instanceof LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder) {
                maxOrder = ((LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder)motifModel).getDistance() + ((LimitedSparseLocalInhomogeneousMixtureDiffSM_higherOrder)motifModel).getOrder() - 1;
            }
            i = 0;
            while (i < mi.length) {
                j = Math.max(0, i - maxOrder);
                while (j < Math.min(mi[i].length, i + maxOrder + 1)) {
                    if (i != j && mi[i][j] > kl[i]) {
                        kl[i] = mi[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            left = -add;
            right = add;
            thresh = 0.2;
            if (modify) ** GOTO lbl62
            return false;
lbl-1000:
            // 1 sources

            {
                ++left;
lbl62:
                // 2 sources

                ** while (left + add < kl.length && kl[left + add] < thresh)
            }
lbl63:
            // 2 sources

            while (right - add > -kl.length && kl[kl.length - 1 + right - add] < thresh) {
                --right;
            }
            protocol.append("left: " + left + ", right: " + right + "\n");
            if (left <= 0 && right < 0) {
                left = left <= right ? right : (right = (left + right) / 2);
            } else if (right >= 0 && left > 0) {
                if (right >= left) {
                    right = left;
                } else {
                    left = right = (left + right) / 2;
                }
            } else {
                right = 0;
                left = 0;
            }
            protocol.append("left: " + left + ", right: " + right + "\n");
            if (left + add == kl.length || right - add == -kl.length) {
                protocol.append("tried to remove the complete motif: no modifications\n");
            } else {
                normOld = ((DifferentiableStatisticalModel)best).getLogNormalizationConstant();
                if (left != 0 || right != 0) {
                    if (best.modifyMotif(im, left, right)) {
                        w = normOld - ((DifferentiableStatisticalModel)best).getLogNormalizationConstant();
                        objective.addTermToClassParameter(0, w);
                    }
                    protocol.append("modified motif\n");
                    modified = true;
                } else {
                    protocol.append("no modifications for the motif\n");
                }
            }
            ++im;
        }
        return modified;
    }

    private static double[][] getMaxMI(DataSet bsDs, double[] weights, double[] scores) {
        Object[] els = new ComparableElement[bsDs.getNumberOfElements()];
        int i = 0;
        while (i < bsDs.getNumberOfElements()) {
            els[i] = new ComparableElement<Pair<Sequence, Double>, Double>(new Pair<Sequence, Double>(bsDs.getElementAt(i), weights[i]), scores[i]);
            ++i;
        }
        Arrays.sort(els);
        int al = (int)bsDs.getAlphabetContainer().getAlphabetAt(0).length();
        double[][] stat = new double[bsDs.getElementLength()][bsDs.getElementLength()];
        double[][] mis = new double[bsDs.getElementLength()][bsDs.getElementLength()];
        double[][][][] counts = new double[bsDs.getElementLength()][bsDs.getElementLength()][al][al];
        double log2 = Math.log(2.0);
        double sum = 0.0;
        int i2 = els.length - 1;
        while (i2 >= 0) {
            int k;
            Sequence seq = (Sequence)((Pair)((ComparableElement)els[i2]).getElement()).getFirstElement();
            double weight = (Double)((Pair)((ComparableElement)els[i2]).getElement()).getSecondElement();
            int j = 0;
            while (j < seq.getLength()) {
                k = 0;
                while (k < seq.getLength()) {
                    double[] dArray = counts[j][k][seq.discreteVal(j)];
                    int n = seq.discreteVal(k);
                    dArray[n] = dArray[n] + weight;
                    ++k;
                }
                ++j;
            }
            sum += weight;
            j = 0;
            while (j < counts.length) {
                k = 0;
                while (k < counts[j].length) {
                    double mi = 0.0;
                    int a = 0;
                    while (a < counts[j][k].length) {
                        int b = 0;
                        while (b < counts[j][k][a].length) {
                            if (counts[j][k][a][b] > 0.0) {
                                mi += counts[j][k][a][b] * Math.log(sum * counts[j][k][a][b] / (counts[j][j][a][a] * counts[k][k][b][b])) / log2;
                            }
                            ++b;
                        }
                        ++a;
                    }
                    if (mi > stat[j][k]) {
                        stat[j][k] = mi;
                        mis[j][k] = mi / sum;
                    }
                    ++k;
                }
                ++j;
            }
            --i2;
        }
        return mis;
    }

    private static double[] getCounts(DataSet completeData, double[] ds) {
        double[] counts = new double[(int)completeData.getAlphabetContainer().getAlphabetLengthAt(0)];
        int i = 0;
        while (i < completeData.getNumberOfElements()) {
            Sequence seq = completeData.getElementAt(i);
            Sequence ref = ((ReferenceSequenceAnnotation)seq.getSequenceAnnotationByTypeAndIdentifier("reference", "reads")).getReferenceSequence();
            int j = 0;
            while (j < seq.getLength()) {
                int n = seq.discreteVal(j);
                counts[n] = counts[n] + ds[i] * ref.continuousVal(j);
                ++j;
            }
            ++i;
        }
        return counts;
    }

    private static DifferentiableStatisticalModel getBgSF(AlphabetContainer con, int order, double ess, double length) throws Exception {
        if (order >= 0) {
            return new HomogeneousMMDiffSM(con, order, ess, (int)Math.round(length));
        }
        return new UniformHomogeneousDiffSM(con, ess);
    }

    private static ArrayList<ComparableElement<double[], Double>> filter2(AbstractSingleMotifChIPper chipper, ComparableElement<double[], Double>[] pars, DataSet fg, double t, int length, Protocol protocol) throws Exception {
        int k;
        double[][] profile;
        ArrayList<ComparableElement<double[], Double>> list = new ArrayList<ComparableElement<double[], Double>>(10);
        ArrayList<double[][]> profiles = new ArrayList<double[][]>();
        int i = pars.length - 1;
        while (i >= 0) {
            block6: {
                chipper.setParameters(pars[i].getElement(), 2);
                profile = new double[fg.getNumberOfElements()][];
                k = 0;
                while (k < profile.length) {
                    profile[k] = chipper.getProfileOfScoresFor(0, 0, fg.getElementAt(k), 0, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
                    ++k;
                }
                int j = 0;
                while (j < profiles.size()) {
                    double corr = MethylSlimDimontTool.getCorrelation((double[][])profiles.get(j), profile, length);
                    if (!(corr > t)) {
                        ++j;
                        continue;
                    }
                    break block6;
                }
                profiles.add(profile);
                list.add(pars[i]);
            }
            --i;
        }
        if (list.size() == 0) {
            i = pars.length - 1;
            profile = new double[fg.getNumberOfElements()][];
            k = 0;
            while (k < profile.length) {
                profile[k] = chipper.getProfileOfScoresFor(0, 0, fg.getElementAt(k), 0, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
                ++k;
            }
            profiles.add(profile);
            list.add(pars[i]);
            chipper.setParameters(pars[i].getElement(), 2);
        }
        protocol.append("number of motifs: " + list.size() + "\n");
        return list;
    }

    private static boolean[] postFilter(MutableMotifDiscoverer[] disc, int[] order, DataSet fg, double t, int length) throws Exception {
        ArrayList<double[][]> profiles = new ArrayList<double[][]>();
        boolean[] use = new boolean[disc.length];
        int i = 0;
        while (i < order.length) {
            block4: {
                double[][] profile = new double[fg.getNumberOfElements()][];
                int k = 0;
                while (k < profile.length) {
                    profile[k] = disc[order[i]].getProfileOfScoresFor(0, 0, fg.getElementAt(k), 0, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
                    ++k;
                }
                int j = 0;
                while (j < profiles.size()) {
                    double corr = MethylSlimDimontTool.getCorrelation((double[][])profiles.get(j), profile, length);
                    if (!(corr > t)) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                profiles.add(profile);
                use[i] = true;
            }
            ++i;
        }
        return use;
    }

    private static double getCorrelation(double[][] ds, double[][] profile, int length) throws Exception {
        double max = Double.NEGATIVE_INFINITY;
        int off = 0;
        while (off < length) {
            double currCorr1 = 0.0;
            double currCorr2 = 0.0;
            int i = 0;
            while (i < ds.length) {
                double p1 = ToolBox.pearsonCorrelation(ds[i], profile[i], 0, off);
                double p2 = ToolBox.pearsonCorrelation(ds[i], profile[i], off, 0);
                currCorr1 += p1;
                currCorr2 += p2;
                ++i;
            }
            if (currCorr1 > max) {
                max = currCorr1;
            }
            if (currCorr2 > max) {
                max = currCorr2;
            }
            ++off;
        }
        return max / (double)ds.length;
    }

    public static String getConsensus(AlphabetContainer con, double[][] pfm) {
        String c = "";
        int l = 0;
        while (l < pfm.length) {
            int m = pfm[l][0] > pfm[l][1] ? 0 : 1;
            int s = 1 - m;
            int p = 2;
            while (p < pfm[l].length) {
                if (pfm[l][m] < pfm[l][p]) {
                    s = m;
                    m = p;
                } else if (pfm[l][s] < pfm[l][p]) {
                    s = p;
                }
                ++p;
            }
            c = pfm[l][m] > 0.4 ? (pfm[l][m] - pfm[l][s] > 0.1 ? String.valueOf(c) + con.getSymbol(l, m) : String.valueOf(c) + con.getSymbol(l, m).toLowerCase()) : String.valueOf(c) + "N";
            ++l;
        }
        return c;
    }

    public static ComparableElement<String, Double>[] getKmereSequenceStatistic(int numWanted, int k, DataSet data, double[] weights) throws Exception {
        AlphabetContainer con = data.getAlphabetContainer();
        if (!con.isSimple() || !con.isDiscrete()) {
            throw new WrongAlphabetException();
        }
        Hashtable<String, double[]> res = new Hashtable<String, double[]>();
        HashSet<String> used = new HashSet<String>();
        String[] s = new String[2];
        int n = 0;
        while (n < weights.length) {
            Sequence seq = data.getElementAt(n);
            s[0] = seq.toString();
            s[1] = seq.reverseComplement().toString();
            int m = seq.getLength() - k + 1;
            used.clear();
            int l = 0;
            while (l < m) {
                String h1;
                String h0 = s[0].substring(l, l + k);
                String string = h0 = h0.compareTo(h1 = s[1].substring(s[0].length() - k - l, s[0].length() - l)) < 0 ? h0 : h1;
                if (!used.contains(h0)) {
                    used.add(h0);
                }
                ++l;
            }
            Iterator it = used.iterator();
            while (it.hasNext()) {
                s[0] = (String)it.next();
                if (res.containsKey(s[0])) {
                    double[] h = (double[])res.get(s[0]);
                    h[0] = h[0] + weights[n];
                    h[1] = h[1] + (1.0 - weights[n]);
                    continue;
                }
                res.put(s[0], new double[]{weights[n], 1.0 - weights[n]});
            }
            ++n;
        }
        double sumFg = ToolBox.sum(weights);
        Object[] array = new ComparableElement[res.size()];
        Iterator it = res.entrySet().iterator();
        int a = 0;
        while (a < array.length) {
            Map.Entry e = it.next();
            double[] val = (double[])e.getValue();
            array[a] = new ComparableElement<String, Double>((String)e.getKey(), Math.log(val[0] + 1.0) * (val[0] + 1.0) / (val[1] + 1.0));
            ++a;
        }
        Arrays.sort(array);
        if (numWanted > array.length) {
            numWanted = array.length;
        }
        ComparableElement[] resArray = new ComparableElement[numWanted];
        Sequence[] prevs = new Sequence[numWanted];
        int j = resArray.length - 1;
        int i = array.length - 1;
        while (i >= 0) {
            block12: {
                String curr = (String)((ComparableElement)array[i]).getElement();
                Sequence currs = Sequence.create(con, curr);
                int a2 = resArray.length - 1;
                while (a2 > j) {
                    Sequence prev = prevs[a2];
                    if (MethylSlimDimontTool.getMinimumHammingDistance(currs, prev) >= 2) {
                        --a2;
                        continue;
                    }
                    break block12;
                }
                resArray[j] = array[i];
                prevs[j] = currs;
                if (--j < 0) break;
            }
            --i;
        }
        if (j >= 0) {
            ComparableElement[] help = new ComparableElement[numWanted - (j + 1)];
            System.arraycopy(resArray, j + 1, help, 0, help.length);
            resArray = help;
        }
        return resArray;
    }

    private static int getMinimumHammingDistance(Sequence curr, Sequence seq2) throws Exception {
        int d2;
        int d1;
        Sequence sub2;
        Sequence subRc;
        Sequence sub1;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i <= curr.getLength() / 3) {
            sub1 = curr.getSubSequence(i);
            subRc = curr.reverseComplement().getSubSequence(i);
            sub2 = seq2.getSubSequence(0, seq2.getLength() - i);
            d1 = sub1.getHammingDistance(sub2);
            d2 = subRc.getHammingDistance(sub2);
            if (d1 < min) {
                min = d1;
            }
            if (d2 < min) {
                min = d2;
            }
            ++i;
        }
        i = 1;
        while (i <= curr.getLength() / 3) {
            sub1 = curr.getSubSequence(0, curr.getLength() - i);
            subRc = curr.reverseComplement().getSubSequence(0, curr.getLength() - i);
            sub2 = seq2.getSubSequence(i);
            d1 = sub1.getHammingDistance(sub2);
            d2 = subRc.getHammingDistance(sub2);
            if (d1 < min) {
                min = d1;
            }
            if (d2 < min) {
                min = d2;
            }
            ++i;
        }
        return min;
    }

    @Override
    public String getToolName() {
        return "Methyl SlimDimont";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "slimdimont";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getHelpText() {
        return "**" + this.getToolName() + "** is a tool for de-novo motif discovery from DNA sequences including extended, e.g., methylation-aware alphabets.\n" + "\n" + "Input sequences must be supplied in an annotated FastA format as generated by the Data Extractor tool.\n" + "Input sequences may also obtained from other sources. In this case, the annotation of each sequence needs to provide a value that reflects the confidence that this sequence is bound by the factor of interest.\n" + "Such confidences may be peak statistics (e.g., number of fragments under a peak) for ChIP data or signal intensities for PBM data. In addition, you need to provide an anchor position within the sequence. \n" + "In case of ChIP data, this anchor position could for instance be the peak summit.\n" + "An annotated FastA file for ChIP-seq data comprising sequences of length 100 centered around the peak summit could look like::\n" + "\t\n" + "\t> peak: 50; signal: 515\n" + "\tggccatgtgtatttttttaaatttccac...\n" + "\t> peak: 50; signal: 199\n" + "\tGGTCCCCTGGGAGGATGGGGACGTGCTG...\n" + "\t...\n" + "\n" + "where the anchor point is given as 50 for the first two sequences, and the confidence amounts to 515 and 199, respectively.\n" + "The FastA comment may contain additional annotations of the format ``key1 : value1; key2: value2;...``.\n" + "\n" + "Accordingly, you would need to set the parameter \"Position tag\" to ``peak`` and the parameter \"Value tag\" to ``signal`` for the input file (default values).\n" + "The parameter Alphabet specifies the symbols of the (extended) alphabet and their complementary symbols. Default is standard DNA alphabet.\n" + "\n" + "For the standard deviation of the position prior, the initial motif length and the number of pre-optimization runs, we provide default values that worked well in our studies on ChIP and PBM data. \n" + "However, you may want adjust these parameters to meet your prior information.\n" + "\n" + "The parameter \"Markov order of the motif model\" sets the order of the inhomogeneous Markov model used for modeling the motif. If this parameter is set to ``0``, you obtain a position weight matrix (PWM) model. \n" + "If it is set to ``1``, you obtain a weight array matrix (WAM) model. You can set the order of the motif model to at most ``3``.\n" + "\n" + "The parameter \"Markov order of the background model\" sets the order of the homogeneous Markov model used for modeling positions not covered by a motif. \n" + "If this parameter is set to ``-1``, you obtain a uniform distribution, which worked well for ChIP data. For PBM data, orders of up to ``4`` resulted in an increased prediction performance in our case studies. The maximum allowed value is ``5``.\n" + "\n" + "The parameter \"Weighting factor\" defines the proportion of sequences that you expect to be bound by the targeted factor with high confidence. For ChIP data, the default value of ``0.2`` typically works well. \n" + "For PBM data, containing a large number of unspecific probes, this parameter should be set to a lower value, e.g. ``0.01``.\n" + "\n" + "The \"Equivalent sample size\" reflects the strength of the influence of the prior on the model parameters, where higher values smooth out the parameters to a greater extent.\n" + "\n" + "The parameter \"Delete BSs from profile\" defines if BSs of already discovered motifs should be deleted, i.e., \"blanked out\", from the sequence before searching for futher motifs.\n" + "\n" + "You can also install this web-application within your local Galaxy server. Instructions can be found at the Dimont_ page of Jstacs. \n" + "There you can also download a command line version of Dimont.\n" + "\n" + "If you experience problems using " + this.getToolName() + ", please contact_ us.\n" + "\n" + ".. _contact: mailto:grau@informatik.uni-halle.de";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return new String[]{"@article{grau13a-general,\n\tAuthor = {Grau, Jan and Posch, Stefan and Grosse, Ivo and Keilwagen, Jens},\n\tJournal = {Nucleic Acids Research},\n\tNumber = {21},\n\tPages = {e197},\n\tTitle = {A general approach for discriminative de novo motif discovery from high-throughput data},\n\tVolume = {41},\n\tYear = {2013}}", "@article{keilwagen15varying,\n\tAuthor = {Keilwagen, Jens and Grau, Jan},\n\tJournal = {Nucleic Acids Research},\n\tMonth = {10},\n\tNumber = {18},\n\tPages = {e119-e119},\n\tTitle = {{Varying levels of complexity in transcription factor binding motifs}},\n\tVolume = {43},\n\tYear = {2015}}"};
    }
}

