/*
 * Decompiled with CFR 0.152.
 */
package projects.ms;

import projects.ms.Peak;

public class DiffPseudoPeak
extends Peak {
    private Peak p1;
    private Peak p2;

    public DiffPseudoPeak(Peak p1, Peak p2) {
        super(Math.abs(p1.getMz() - p2.getMz()), Math.sqrt(p1.getIntensity() * p2.getIntensity()));
        this.p1 = p1;
        this.p2 = p2;
    }

    @Override
    public String toString() {
        return "(" + this.getMz() + ";" + this.getIntensity() + ";" + (Object)((Object)this.getType()) + "<-" + this.p1.getMz() + "," + this.p2.getMz() + ")";
    }

    @Override
    public Peak.PeakType getType() {
        return Peak.PeakType.DIFF;
    }

    public Peak[] getOriginals() {
        return new Peak[]{this.p1, this.p2};
    }

    public double getMean() {
        return (this.p1.getMz() + this.p2.getMz()) / 2.0;
    }
}

