/*
 * Decompiled with CFR 0.152.
 */
package projects.ms;

import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import projects.ms.Peak;
import projects.ms.Spectrum;

public class KDE {
    private static final double NORM = -0.5 * Math.log(Math.PI * 2);
    private int num;
    private double ppm;
    private Gaussian[] means;

    public KDE(double ppm, double min, double max) {
        this.ppm = ppm;
        System.out.println("ppm: " + ppm + ", min:" + min + ", max: " + max);
        double step = min * ppm * 1.0E-6 * 10.0;
        System.out.println("step: " + step);
        this.num = (int)Math.ceil((max - min) / step);
        System.out.println("num: " + this.num);
        this.means = new Gaussian[this.num];
        double curr = min + step / 2.0;
        int i = 0;
        while (i < this.means.length) {
            this.means[i] = new Gaussian(curr);
            curr += step;
            ++i;
        }
    }

    public static double[] peaksFromSpectra(List<Spectrum> list) {
        HashSet<Peak.PeakType> ori = new HashSet<Peak.PeakType>();
        ori.add(Peak.PeakType.ORIGINAL);
        return list.stream().map(e -> e.getPeaksOfType(ori)).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll).stream().mapToDouble(p -> p.getMz()).sorted().toArray();
    }

    public void init(double[] peaks) {
        int j;
        int[] counts = new int[this.means.length];
        double[] temp = new double[this.means.length];
        int i = 0;
        while (i < peaks.length) {
            int assign;
            j = 0;
            while (j < this.means.length) {
                temp[j] = this.means[j].ll(peaks[i]);
                ++j;
            }
            int n = assign = ToolBox.getMaxIndex(temp);
            counts[n] = counts[n] + 1;
            ++i;
        }
        ArrayList<Gaussian> remain = new ArrayList<Gaussian>();
        j = 0;
        while (j < this.means.length) {
            if (counts[j] >= 4) {
                remain.add(this.means[j]);
            }
            ++j;
        }
        System.out.println("remain: " + remain.size());
        this.means = remain.toArray(new Gaussian[0]);
    }

    public void fit(double[] peaks) {
        double[] gammas = new double[this.means.length];
        double ll = Double.NEGATIVE_INFINITY;
        double llTemp = Double.NEGATIVE_INFINITY;
        double[] newMeans = new double[this.means.length];
        double[] sums = new double[this.means.length];
        do {
            ll = llTemp;
            llTemp = 0.0;
            Arrays.fill(newMeans, 0.0);
            Arrays.fill(sums, 0.0);
            int i = 0;
            while (i < peaks.length) {
                int j = 0;
                while (j < this.means.length) {
                    gammas[j] = this.means[j].ll(peaks[i]);
                    ++j;
                }
                llTemp += Normalisation.logSumNormalisation(gammas);
                j = 0;
                while (j < this.means.length) {
                    int n = j;
                    newMeans[n] = newMeans[n] + gammas[j] * peaks[i];
                    int n2 = j;
                    sums[n2] = sums[n2] + gammas[j];
                    ++j;
                }
                ++i;
            }
            int j = 0;
            while (j < this.means.length) {
                this.means[j].setMean(newMeans[j] / sums[j]);
                ++j;
            }
            System.out.println(llTemp /= (double)peaks.length);
        } while (llTemp - ll > 0.1);
    }

    public int[] assign(double[] peaks) {
        int[] assign = new int[peaks.length];
        double[] temp = new double[this.means.length];
        int i = 0;
        while (i < peaks.length) {
            int j = 0;
            while (j < this.means.length) {
                temp[j] = this.means[j].ll(peaks[i]);
                ++j;
            }
            assign[i] = ToolBox.getMaxIndex(temp);
            ++i;
        }
        return assign;
    }

    private class Gaussian {
        private double mean;
        private double logSd;
        private double var;

        public Gaussian(double mean) {
            this.setMean(mean);
        }

        public void setMean(double mean) {
            this.mean = mean;
            this.var = mean * KDE.this.ppm * 1.0E-6;
            this.logSd = Math.log(this.var);
            this.var *= this.var;
        }

        public double ll(double peak) {
            double diff = peak - this.mean;
            double val = NORM - this.logSd - 0.5 * diff * diff / this.var;
            return val;
        }
    }
}

