/*
 * Decompiled with CFR 0.152.
 */
package projects.ms;

import java.util.Comparator;

public class Peak
implements Cloneable,
Comparable<Peak> {
    public static final Comparator<Peak> INTENS_REV = new Comparator<Peak>(){

        @Override
        public int compare(Peak o1, Peak o2) {
            return Double.compare(o2.getIntensity(), o1.getIntensity());
        }
    };
    private double mz;
    private double intensity;

    public Peak(double mz, double intensity) {
        this.mz = mz;
        this.intensity = intensity;
    }

    public Peak clone() throws CloneNotSupportedException {
        Peak clone = (Peak)super.clone();
        return clone;
    }

    public String toString() {
        return "(" + this.getMz() + ";" + this.getIntensity() + ";" + (Object)((Object)this.getType()) + ")";
    }

    public double getMz() {
        return this.mz;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public void setIntensity(double intensity) {
        this.intensity = intensity;
    }

    public PeakType getType() {
        return PeakType.ORIGINAL;
    }

    @Override
    public int compareTo(Peak o) {
        return Double.compare(this.mz, o.mz);
    }

    public static enum PeakType {
        ORIGINAL,
        PRECURSOR,
        DIFF;


        public String getCode() {
            if (this == ORIGINAL) {
                return "O";
            }
            if (this == PRECURSOR) {
                return "P";
            }
            if (this == DIFF) {
                return "D";
            }
            return null;
        }
    }
}

