/*
 * Decompiled with CFR 0.152.
 */
package projects.ms;

import de.jstacs.utils.IntList;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import projects.ms.Deviation;
import projects.ms.DiffPseudoPeak;
import projects.ms.Peak;
import projects.ms.PrecursorPseudoPeak;

public class Spectrum
implements Cloneable {
    private String name;
    private Peak precursor;
    private String precursorType;
    private IonMode ionMode;
    private double retentionTime;
    private String formula;
    private String ontology;
    private String inchiKey;
    private String smiles;
    private HashMap<String, String> comments = new HashMap();
    private ArrayList<Peak> peaks;
    private double maxPeak = 0.0;

    private Spectrum() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NAME: " + this.name + "\n");
        sb.append("PRECURSORMZ: " + this.precursor.getMz() + "\n");
        sb.append("PRECURSORTYPE: " + this.precursorType + "\n");
        sb.append("IONMODE: " + (Object)((Object)this.ionMode) + "\n");
        sb.append("RETENTIONTIME: " + this.retentionTime + "\n");
        sb.append("FORMULA: " + this.formula + "\n");
        sb.append("ONTOLOGY: " + this.ontology + "\n");
        sb.append("INCHIKEY: " + this.inchiKey + "\n");
        sb.append("SMILES: " + this.smiles + "\n");
        sb.append("COMMENT: " + this.comments.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "=" + (String)e.getValue()).collect(Collectors.joining("|")) + "\n");
        sb.append("Num Peaks: " + this.getNumberOfPeaks() + "\n");
        for (Peak p : this.peaks) {
            sb.append(String.valueOf(p.getMz()) + "\t" + p.getIntensity() + "\t" + (Object)((Object)p.getType()) + "\n");
        }
        return sb.toString();
    }

    public String getComment(String key) {
        return this.comments.get(key);
    }

    public Spectrum clone() throws CloneNotSupportedException {
        Spectrum clone = (Spectrum)super.clone();
        clone.comments = (HashMap)this.comments.clone();
        clone.peaks = new ArrayList();
        for (Peak p : this.peaks) {
            clone.peaks.add(p);
        }
        return clone;
    }

    /*
     * Unable to fully structure code
     */
    public static List<Spectrum> parse(String path) throws IOException {
        reader = new BufferedReader(new FileReader(path));
        specs = new ArrayList<Spectrum>();
        str = new String();
        ** GOTO lbl11
        {
            str = reader.readLine();
            do {
                if (str != null && str.trim().length() == 0) continue block0;
                s = Spectrum.parseNext(str, reader);
                specs.add(s);
lbl11:
                // 2 sources

            } while ((str = reader.readLine()) != null);
        }
        reader.close();
        return specs;
    }

    private static String[] split(String str) {
        int idx = str.indexOf(":");
        if (idx < 0) {
            return new String[]{str};
        }
        return new String[]{str.substring(0, idx), str.substring(idx + 1)};
    }

    public static Spectrum parseNext(String str, BufferedReader reader) throws IOException {
        Spectrum s = new Spectrum();
        boolean startPeaks = false;
        do {
            String[] parts = Spectrum.split(str);
            if (startPeaks) {
                String[] mzi = str.split("\\s+");
                double mz = Double.parseDouble(mzi[0]);
                double in = Double.parseDouble(mzi[1]);
                Peak p = new Peak(mz, in);
                s.peaks.add(p);
                if (!(in > s.maxPeak)) continue;
                s.maxPeak = in;
                continue;
            }
            if (parts.length <= 1) continue;
            String key = parts[0].trim();
            String value = parts[1].trim();
            if ("NAME".equalsIgnoreCase(key)) {
                s.name = value;
                continue;
            }
            if ("PRECURSORMZ".equalsIgnoreCase(key)) {
                s.precursor = new Peak(Double.parseDouble(value), -1.0);
                continue;
            }
            if ("PRECURSORTYPE".equalsIgnoreCase(key)) {
                s.precursorType = value;
                continue;
            }
            if ("IONMODE".equals(key)) {
                s.ionMode = IonMode.valueOf(value);
                continue;
            }
            if ("RETENTIONTIME".equalsIgnoreCase(key)) {
                s.retentionTime = Double.parseDouble(value);
                continue;
            }
            if ("FORMULA".equalsIgnoreCase(key)) {
                s.formula = value;
                continue;
            }
            if ("ONTOLOGY".equalsIgnoreCase(key)) {
                s.ontology = value;
                continue;
            }
            if ("INCHIKEY".equalsIgnoreCase(key)) {
                s.inchiKey = value;
                continue;
            }
            if ("SMILES".equalsIgnoreCase(key)) {
                s.smiles = value;
                continue;
            }
            if ("COMMENT".equalsIgnoreCase(key)) {
                String[] kvs;
                String[] stringArray = kvs = value.split("\\|");
                int n = kvs.length;
                int n2 = 0;
                while (n2 < n) {
                    String kv = stringArray[n2];
                    if (kv.trim().length() > 0) {
                        String[] kv2 = kv.split("=");
                        s.comments.put(kv2[0], kv2[1]);
                    }
                    ++n2;
                }
            } else {
                if ("Num Peaks".equalsIgnoreCase(key)) {
                    s.peaks = new ArrayList(Integer.parseInt(value));
                    startPeaks = true;
                    continue;
                }
                throw new IllegalArgumentException("unknown key " + key);
            }
        } while ((str = reader.readLine()) != null && str.trim().length() > 0);
        Collections.sort(s.peaks);
        return s;
    }

    public String getName() {
        return this.name;
    }

    public Peak getPrecursor() {
        return this.precursor;
    }

    public String getPrecursorType() {
        return this.precursorType;
    }

    public IonMode getIonMode() {
        return this.ionMode;
    }

    public double getRetentionTime() {
        return this.retentionTime;
    }

    public String getFormula() {
        return this.formula;
    }

    public String getOntology() {
        return this.ontology;
    }

    public String getInchiKey() {
        return this.inchiKey;
    }

    public String getSmiles() {
        return this.smiles;
    }

    public HashMap<String, String> getComments() {
        return this.comments;
    }

    public int getNumberOfPeaks() {
        return this.peaks.size();
    }

    public Peak getPeakAt(int idx) {
        return this.peaks.get(idx);
    }

    public double getMaxIntensity() {
        double max = 0.0;
        for (Peak p : this.peaks) {
            if (!(p.getIntensity() > max)) continue;
            max = p.getIntensity();
        }
        return max;
    }

    public void normalize(boolean sqrt) {
        double max = this.getMaxIntensity();
        if (sqrt) {
            max = Math.sqrt(max);
        }
        for (Peak p : this.peaks) {
            if (sqrt) {
                p.setIntensity(Math.sqrt(p.getIntensity()) / max);
                continue;
            }
            p.setIntensity(p.getIntensity() / max);
        }
    }

    public void filter(double minAbundance) {
        this.peaks = this.peaks.stream().filter(e -> e.getIntensity() >= minAbundance).collect(Collectors.toCollection(ArrayList::new));
    }

    public void addPseudoPeaks(Deviation d) {
        ArrayList<Peak> precursors = new ArrayList<Peak>(this.peaks.size());
        int i = 0;
        while (i < this.peaks.size()) {
            Peak p = this.peaks.get(i);
            if (p.getType() != Peak.PeakType.ORIGINAL) {
                throw new RuntimeException();
            }
            precursors.add(new PrecursorPseudoPeak(p, this.precursor));
            ++i;
        }
        ArrayList<Peak> diffs = new ArrayList<Peak>(this.peaks.size() * (this.peaks.size() - 1) / 2);
        int i2 = 0;
        while (i2 < this.peaks.size()) {
            int j = i2 + 1;
            while (j < this.peaks.size()) {
                diffs.add(new DiffPseudoPeak(this.peaks.get(i2), this.peaks.get(j)));
                ++j;
            }
            ++i2;
        }
        TreeSet<Peak> precursorsT = Spectrum.removeRedundant(precursors, d);
        TreeSet<Peak> diffsT = Spectrum.removeRedundant(diffs, d);
        Spectrum.addConditional(this.peaks, precursorsT, d, 1.0);
        Spectrum.addConditional(this.peaks, diffsT, d, 1.0);
    }

    private static TreeSet<Peak> removeRedundant(ArrayList<Peak> addSet, Deviation d) {
        TreeSet<Peak> res = new TreeSet<Peak>();
        if (addSet.size() == 0) {
            return res;
        }
        Collections.sort(addSet, Peak.INTENS_REV);
        res.add(addSet.get(0));
        int i = 1;
        while (i < addSet.size()) {
            Peak higher;
            Peak p = addSet.get(i);
            Peak lower = res.lower(p);
            if (!(lower != null && d.isWithinDeviation(p, lower) || (higher = res.higher(p)) != null && d.isWithinDeviation(p, higher))) {
                res.add(p);
            }
            ++i;
        }
        return res;
    }

    private static void addConditional(ArrayList<Peak> peaks, TreeSet<Peak> addSet, Deviation d, double min) {
        LinkedList<Peak> toAdd = new LinkedList<Peak>();
        for (Peak p : addSet) {
            if (!(p.getMz() >= min) && !d.isWithinDeviation(p, min)) continue;
            int ip = Collections.binarySearch(peaks, p);
            if (ip < 0) {
                ip = -(ip + 1);
            }
            if (ip != peaks.size() && d.isWithinDeviation(p, peaks.get(ip)) || ip != 0 && d.isWithinDeviation(p, peaks.get(ip - 1))) continue;
            toAdd.add(p);
        }
        peaks.addAll(toAdd);
        toAdd.clear();
        Collections.sort(peaks);
    }

    public IntList getIndicesOfType(Set<Peak.PeakType> types) {
        IntList idxs = new IntList();
        int i = 0;
        while (i < this.peaks.size()) {
            if (types.contains((Object)this.peaks.get(i).getType())) {
                idxs.add(i);
            }
            ++i;
        }
        return idxs;
    }

    public ArrayList<Peak> getPeaksOfType(Set<Peak.PeakType> types) {
        ArrayList<Peak> idxs = new ArrayList<Peak>();
        int i = 0;
        while (i < this.peaks.size()) {
            if (types.contains((Object)this.peaks.get(i).getType())) {
                idxs.add(this.peaks.get(i));
            }
            ++i;
        }
        return idxs;
    }

    public void topN(int topN) {
        int num = this.getNumberOfPeaks();
        if (num <= topN) {
            return;
        }
        double[] intens = this.peaks.stream().mapToDouble(p -> p.getIntensity()).toArray();
        Arrays.sort(intens);
        double t = intens[intens.length - topN];
        this.peaks = this.peaks.stream().filter(e -> e.getIntensity() > t).collect(Collectors.toCollection(ArrayList::new));
    }

    public static enum IonMode {
        Positive,
        Negative;

    }
}

