/*
 * Decompiled with CFR 0.152.
 */
package projects.slim;

import de.jstacs.data.DataSet;
import de.jstacs.io.FileManager;
import de.jstacs.tools.ui.galaxy.GalaxyAdaptor;
import de.jstacs.utils.Pair;
import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import de.jstacs.utils.graphics.GraphicsAdaptorFactory;
import de.jstacs.utils.graphics.RasterizedAdaptor;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import projects.dimont.DimontWeb;
import projects.slim.DependencyLogoWebParameterSet;

public class DependencyLogoWeb {
    public static void main(String[] args) throws Exception {
        GalaxyAdaptor.Protocol prot;
        GalaxyAdaptor.LinkedImageResult res;
        DependencyLogoWebParameterSet params = new DependencyLogoWebParameterSet();
        boolean[] lines = new boolean[params.getNumberOfParameters()];
        GalaxyAdaptor ga = new GalaxyAdaptor(params, null, lines, "Dependency logo", " Plot dependency logos from a tabular file", "0.1", "java -Xms256M -Xmx2G -Djava.awt.headless=true -jar " + System.getProperty("user.dir") + System.getProperty("file.separator") + "DependencyLogoWeb.jar", "jobname", true);
        ga.setHelp(FileManager.readInputStream(DimontWeb.class.getClassLoader().getResourceAsStream("projects/slim/helpLogo.txt")).toString());
        if (!ga.parse(args, false)) {
            System.exit(1);
        }
        if ((res = DependencyLogoWeb.run(params, "./dependency_logo", prot = ga.getProtocol(false))) != null) {
            ga.addResult(res, true, true, res.getLink().getExtension());
        }
        ga.writeOutput();
    }

    public static GalaxyAdaptor.LinkedImageResult run(DependencyLogoWebParameterSet params, String pdfPath, GalaxyAdaptor.Protocol prot) throws Exception {
        Pair<DataSet, double[]> pair = params.getData();
        GraphicsAdaptorFactory.OutputFormat format = params.getOutputFormat();
        DataSet data = pair.getFirstElement();
        int width = params.getWidth();
        double[] weights = pair.getSecondElement();
        boolean sortByWeights = true;
        double v = weights[0];
        int i = 1;
        while (i < weights.length) {
            if (weights[i] != v) {
                sortByWeights = false;
            }
            ++i;
        }
        int blockSpacer = params.getHeightOfSequenceLogo();
        int numBestForSorting = params.getNumberOfDependencies();
        if (numBestForSorting >= data.getElementLength()) {
            numBestForSorting = data.getElementLength() - 1;
        }
        prot.appendHeading("Blocks of sequences");
        int[] numPerChunk = params.getNumbersOfSequencesForBlocks();
        int[] blockHeight = params.getHeightsOfBlocks();
        int n = data.getNumberOfElements();
        int i2 = 0;
        while (i2 < numPerChunk.length - 1) {
            n -= numPerChunk[i2];
            ++i2;
        }
        if (n <= 0) {
            prot.appendWarning("Block definition requires " + -n + " more sequences than present in the input data set. Terminating.");
            return null;
        }
        numPerChunk[numPerChunk.length - 1] = n;
        i2 = 0;
        while (i2 < numPerChunk.length) {
            prot.append("Block " + (i2 + 1) + " contains " + numPerChunk[i2] + " sequences and has height " + blockHeight[i2] + ".<br />");
            ++i2;
        }
        GalaxyAdaptor.LinkedImageResult res = DependencyLogoWeb.run(format, pdfPath, data, width, weights, numPerChunk, blockHeight, blockSpacer, numBestForSorting, sortByWeights);
        return res;
    }

    private static GalaxyAdaptor.LinkedImageResult run(GraphicsAdaptorFactory.OutputFormat format, String pdfPath, DataSet data, int width, double[] weights, int[] numPerChunk, int[] blockHeight, int blockSpacer, int numBestForSorting, boolean sortByWeights) throws Exception {
        GraphicsAdaptor adaptor = GraphicsAdaptorFactory.getAdaptor(format);
        DependencyLogoWeb.plot(adaptor, data, width, (double[])weights.clone(), numPerChunk, blockHeight, blockSpacer, numBestForSorting, sortByWeights);
        pdfPath = String.valueOf(pdfPath) + "." + adaptor.getGraphicsExtension();
        adaptor.generateOutput(pdfPath);
        adaptor = GraphicsAdaptorFactory.getAdaptor(GraphicsAdaptorFactory.OutputFormat.PNG);
        blockSpacer = (int)Math.round(400.0 / (double)width * (double)blockSpacer);
        int[] blockHeightSmall = (int[])blockHeight.clone();
        int i = 0;
        while (i < blockHeightSmall.length) {
            blockHeightSmall[i] = (int)Math.round(400.0 / (double)width * (double)blockHeightSmall[i]);
            ++i;
        }
        DependencyLogoWeb.plot(adaptor, data, 600, (double[])weights.clone(), numPerChunk, blockHeightSmall, blockSpacer, numBestForSorting, sortByWeights);
        RasterizedAdaptor rast = (RasterizedAdaptor)adaptor;
        BufferedImage img = rast.getImage();
        GalaxyAdaptor.LinkedImageResult res = new GalaxyAdaptor.LinkedImageResult("Dependency logo", "", img, new GalaxyAdaptor.FileResult(format.name(), "Dependency logo for download", pdfPath));
        return res;
    }

    private static void plot(GraphicsAdaptor adaptor, DataSet data, int width, double[] weights, int[] numPerChunk, int[] blockHeight, int blockSpacer, int numBestForSorting, boolean sortByWeights) throws Exception {
        int height = SeqLogoPlotter.getHeightForDependencyLogo(data.getElementLength(), data.getNumberOfElements(), blockHeight, width, blockSpacer);
        Graphics2D g = adaptor.getGraphics(width, height);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter.plotDependencyLogo(data, null, 1, null, weights, g, width, 0, 0, numPerChunk, blockHeight, 0.03, blockSpacer, false, numBestForSorting, false, sortByWeights, true, 0.1);
    }
}

