/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.epigenetic;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.FileManager;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Arrays;
import projects.tals.RVDSequence;
import projects.tals.epigenetic.MethylationSequenceAnnotation;
import projects.tals.epigenetic.Methylationprofil;
import projects.tals.epigenetic.QuickTBSPredictionToolMethylAccessibilityAnnotation_fai;
import projects.tals.linear.LFModularConditional9C;

public class LFModularConditional9CExtMethyl
extends LFModularConditional9C {
    protected double[] methylSpecsThirteen;
    protected int[] separateMap;
    protected double[] methylSeparateSpecs;

    public LFModularConditional9CExtMethyl(StringBuffer xml, AlphabetContainer thirteen, AlphabetContainer rvds, String[] separateRVDs) throws Exception {
        super(xml);
        String[] splitLine;
        this.methylSpecsThirteen = new double[(int)thirteen.getAlphabetLengthAt(0)];
        this.methylSeparateSpecs = new double[separateRVDs.length];
        StringBuffer SF_13Specs_MethylC = FileManager.readInputStream(QuickTBSPredictionToolMethylAccessibilityAnnotation_fai.class.getClassLoader().getResourceAsStream("projects/tals/epigenetic/PrediTALE13Specs_MethylC.csv"));
        BufferedReader br = new BufferedReader(new BufferedReader(new StringReader(SF_13Specs_MethylC.toString())));
        String line = "";
        while ((line = br.readLine()) != null) {
            splitLine = line.split(",");
            this.methylSpecsThirteen[(int)thirteen.getCode((int)0, (String)splitLine[0])] = Double.parseDouble(splitLine[1]);
        }
        br.close();
        StringBuffer SF_comRVDSpecs_MethylC = FileManager.readInputStream(QuickTBSPredictionToolMethylAccessibilityAnnotation_fai.class.getClassLoader().getResourceAsStream("projects/tals/epigenetic/PrediTALEcomRVDSpecs_MethylC.csv"));
        BufferedReader br2 = new BufferedReader(new BufferedReader(new StringReader(SF_comRVDSpecs_MethylC.toString())));
        this.separateMap = new int[(int)rvds.getAlphabetLengthAt(0)];
        Arrays.fill(this.separateMap, -1);
        int k = 0;
        String[] stringArray = separateRVDs;
        int n = separateRVDs.length;
        int n2 = 0;
        while (n2 < n) {
            String sepRVD = stringArray[n2];
            this.separateMap[(int)rvds.getCode((int)0, (String)sepRVD)] = k++;
            ++n2;
        }
        line = "";
        while ((line = br2.readLine()) != null) {
            splitLine = line.split(",");
            if (!Arrays.asList(separateRVDs).contains(splitLine[0])) continue;
            this.methylSeparateSpecs[this.separateMap[(int)rvds.getCode((int)0, (String)splitLine[0])]] = Double.parseDouble(splitLine[1]);
        }
        br2.close();
    }

    @Override
    public double[][] toPWM(RVDSequence rvds) {
        double[][] pwm = new double[rvds.getLength() + 1][];
        double[] methylC_specs = new double[rvds.getLength() + 1];
        pwm[0] = this.lf0.getSpecs(rvds);
        int i = 1;
        while (i < pwm.length) {
            double[] specs = this.specificity.getSpecs(rvds, i);
            int index_rj = rvds.discreteVal(i - 1);
            int index_dj = rvds.discreteValThirteen(index_rj);
            methylC_specs[i] = this.methylSpecsThirteen[index_dj];
            if (this.separateMap[index_rj] >= 0) {
                int n = i;
                methylC_specs[n] = methylC_specs[n] + this.methylSeparateSpecs[this.separateMap[index_rj]];
            }
            pwm[i] = new double[specs.length + 1];
            System.arraycopy(specs, 0, pwm[i], 0, specs.length);
            pwm[i][specs.length] = methylC_specs[i];
            double pos = this.position == null ? 1.0 : this.position.getLogScoreFor(rvds.getLength() + 1, i);
            int j = 0;
            while (j < pwm[i].length) {
                double[] dArray = pwm[i];
                int n = j++;
                dArray[n] = dArray[n] * pos;
            }
            ++i;
        }
        i = 0;
        while (i < pwm.length) {
            int j = 0;
            while (j < pwm[i].length) {
                double[] dArray = pwm[i];
                int n = j++;
                dArray[n] = dArray[n] / (double)pwm.length;
            }
            ++i;
        }
        return pwm;
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        MethylationSequenceAnnotation methylAnno = (MethylationSequenceAnnotation)seq.getSequenceAnnotationByType("methylationprofil", 0);
        Methylationprofil MP = methylAnno.getMethylationprofile();
        ReferenceSequenceAnnotation data_anno = (ReferenceSequenceAnnotation)seq.getSequenceAnnotationByType("reference", 0);
        RVDSequence rvd_seq = (RVDSequence)data_anno.getReferenceSequence();
        String mask = null;
        SequenceAnnotation mann = seq.getSequenceAnnotationByType("mask", 0);
        if (mann != null) {
            mask = mann.getIdentifier();
        }
        SequenceAnnotation ann = seq.getSequenceAnnotationByType("intgroup", 0);
        int group = 0;
        if (ann != null) {
            String gs = ann.getIdentifier();
            group = Integer.parseInt(gs);
        }
        double score = 0.0;
        if (mask == null || mask.charAt(start) == 'O') {
            score += this.lf0.getLogScoreFor(seq, start);
        }
        int i = start + 1;
        while (i < seq.getLength()) {
            if (mask == null || mask.charAt(i) == 'O') {
                int index_rj = rvd_seq.discreteVal(i - 1);
                int index_dj = rvd_seq.discreteValThirteen(index_rj);
                double spec = (1.0 - MP.getMethylPropAtPos(i)) * this.specificity.getLogScoreFor(seq, i);
                try {
                    if (MP.getMethylPropAtPos(i) > 0.0 & (double)seq.discreteVal(i) == seq.getAlphabetContainer().getCode(0, "C")) {
                        double methylSpecificity = this.methylSpecsThirteen[index_dj];
                        if (this.separateMap[index_rj] >= 0) {
                            methylSpecificity += this.methylSeparateSpecs[this.separateMap[index_rj]];
                        }
                        spec += MP.getMethylPropAtPos(i) * methylSpecificity;
                    }
                }
                catch (WrongAlphabetException e) {
                    e.printStackTrace();
                }
                double pos = this.position == null ? 1.0 : this.position.getLogScoreFor(seq, i);
                score += spec * pos;
            }
            ++i;
        }
        score *= Math.exp(this.a[group]);
        return score += this.b[group];
    }
}

