/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.rnaseq;

import de.jstacs.DataType;
import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.io.FileManager;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import de.jstacs.utils.ToolBox;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import projects.gemoma.ExtractRNAseqEvidence;
import projects.tals.rnaseq.DerTALEv2ComplexFunction;
import umontreal.ssj.probdist.FisherFDist;

public class DerTALEv2Annett
implements JstacsTool {
    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new DerTALEv2Annett());
        cli.run(args);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        LinkedList<Parameter> pars = new LinkedList<Parameter>();
        try {
            pars.add(new FileParameter("Predictions", "Predictions output file", "tsv,tabular", true));
            pars.add(new ParameterSetContainer("Treatment", "", new ExpandableParameterSet(new SimpleParameterSet(new FileParameter("Treatment BAM", "BAM file of mapped reads from treatment experiment. BAM file must have an index with additional extension .bai.", "bam", true)), "Treatment data", "")));
            pars.add(new ParameterSetContainer("Control", "", new ExpandableParameterSet(new SimpleParameterSet(new FileParameter("Control BAM", "BAM file of mapped reads from control experiment. BAM file must have an index with additional extension .bai.", "bam", true)), "Control data", "")));
        }
        catch (CloneNotSupportedException e1) {
            e1.printStackTrace();
        }
        try {
            pars.add(new SimpleParameter(DataType.INT, "Number of predictions", "Number of (top) predictions considered", true, 100));
            pars.add(new SimpleParameter(DataType.INT, "Region width", "Number of bases around the predicted site", true, 3000));
            pars.add(new SimpleParameter(DataType.DOUBLE, "Threshold", "Threshold on the log differential abundance", true, 1.0));
            pars.add(new EnumParameter(ExtractRNAseqEvidence.Stranded.class, "Defines whether the reads are stranded. In case of FR_FIRST_STRAND, the first read of a read pair or the only read in case of single-end data is assumed to be located on forward strand of the cDNA, i.e., reverse to the mRNA orientation. If you are using Illumina TruSeq you should use FR_FIRST_STRAND.", true));
            pars.add(new SimpleParameter(DataType.INT, "Coverage cutoff", "Minimum amount of reads as coverage cuttoff.", true, 10));
            pars.add(new SimpleParameter(DataType.INT, "Region elongation value", "Amount of bases a region is elongated if coverage is above half of coverage cuttoff at start/end of region.", true, 100));
            pars.add(new SimpleParameter(DataType.INT, "Minimum length of candidate region", "Minimum length of candidate region.", true, 100));
        }
        catch (ParameterException e) {
            e.printStackTrace();
        }
        return new ToolParameterSet(this.getShortName(), pars.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        FileParameter.FileRepresentation predsFile = ((FileParameter)parameters.getParameterAt(0)).getFileContents();
        System.out.println(predsFile.getFilename());
        String[] posFiles = this.getFiles((ExpandableParameterSet)parameters.getParameterAt(1).getValue());
        String[] negFiles = this.getFiles((ExpandableParameterSet)parameters.getParameterAt(2).getValue());
        String[] files = new String[posFiles.length + negFiles.length];
        System.arraycopy(posFiles, 0, files, 0, posFiles.length);
        System.arraycopy(negFiles, 0, files, posFiles.length, negFiles.length);
        String[] fileNames = new String[files.length];
        int i = 0;
        while (i < fileNames.length) {
            fileNames[i] = Paths.get(files[i], new String[0]).getFileName().toString();
            ++i;
        }
        int numberOfSamples = files.length;
        int numTop = (Integer)parameters.getParameterAt(3).getValue();
        int regionWidth = (Integer)parameters.getParameterAt(4).getValue();
        double t = (Double)parameters.getParameterAt(5).getValue();
        ExtractRNAseqEvidence.Stranded stranded = (ExtractRNAseqEvidence.Stranded)((Object)parameters.getParameterAt(6).getValue());
        int covCuttoff = (Integer)parameters.getParameterAt(7).getValue();
        int regionElongation = (Integer)parameters.getParameterAt(8).getValue();
        int minLengthRegion = (Integer)parameters.getParameterAt(9).getValue();
        LinkedList<Entry> predsList = new LinkedList<Entry>();
        BufferedReader br = new BufferedReader(new StringReader(predsFile.getContent()));
        String curr = null;
        curr = br.readLine();
        if (curr != null) {
            String strand;
            String[] parts;
            if (curr.startsWith("options_used:")) {
                while ((curr = br.readLine()) != null) {
                    if (!curr.startsWith("Best") && !curr.startsWith("Sequence")) {
                        parts = (curr = curr.replaceAll("\\s+", " ")).split(" ");
                        strand = parts[1];
                        if (strand.equals("Plus")) {
                            strand = "+";
                        } else if (strand.equals("Minus")) {
                            strand = "-";
                        }
                        predsList.add(new Entry(parts[0], Integer.parseInt(parts[3]), strand));
                    }
                    if (predsList.size() < numTop) {
                        continue;
                    }
                    break;
                }
            } else if (curr.startsWith(">")) {
                parts = (curr = curr.replaceAll("\\s+", " ")).split(" ");
                strand = parts[1];
                strand = strand.contains("_revcom") ? "-" : "+";
                predsList.add(new Entry(parts[1].replace("_revcom", ""), Integer.parseInt(parts[3]), strand));
                while ((curr = br.readLine()) != null) {
                    parts = (curr = curr.replaceAll("\\s+", " ")).split(" ");
                    strand = parts[1];
                    strand = strand.contains("_revcom") ? "-" : "+";
                    predsList.add(new Entry(parts[1].replace("_revcom", ""), Integer.parseInt(parts[3]), strand));
                    if (predsList.size() < numTop) {
                        continue;
                    }
                    break;
                }
            } else if (curr.startsWith("#")) {
                while ((curr = br.readLine()) != null) {
                    if (!curr.startsWith("#")) {
                        parts = curr.split("\t");
                        predsList.add(new Entry(parts[0], Integer.parseInt(parts[1]), parts[2]));
                    }
                    if (predsList.size() < numTop) {
                        continue;
                    }
                    break;
                }
            } else {
                throw new RuntimeException("File format of the prediction file does not look like the output of PrediTALE, Talvez or Target Finder!");
            }
        }
        br.close();
        SamReaderFactory srf = SamReaderFactory.makeDefault();
        srf.validationStringency(ValidationStringency.SILENT);
        SamReader[] sr = new SamReader[numberOfSamples];
        double[] libSize = new double[numberOfSamples];
        Arrays.fill(libSize, 0.0);
        double meanLibSize = 0.0;
        int k = 0;
        while (k < numberOfSamples) {
            String fName = files[k];
            System.out.println("k. bam file: " + k);
            if (!new File(String.valueOf(fName) + ".bai").exists()) {
                throw new RuntimeException("No index found for file " + fName + ". The index must be in the same directory as the specified BAM file with filename " + fName + ".bai.");
            }
            sr[k] = srf.open(SamInputResource.of(new File(fName)).index(new File(String.valueOf(fName) + ".bai")));
            ++k;
        }
        System.out.println("...calculate scaling factor for each library...");
        k = 0;
        while (k < numberOfSamples) {
            int nRefs = sr[k].getFileHeader().getSequenceDictionary().size();
            int i2 = 0;
            while (i2 < nRefs) {
                int n = k;
                libSize[n] = libSize[n] + (double)sr[k].indexing().getIndex().getMetaData(i2).getAlignedRecordCount();
                ++i2;
            }
            System.out.println("libSize " + k + ": " + libSize[k]);
            meanLibSize += libSize[k];
            ++k;
        }
        meanLibSize = ToolBox.mean(libSize);
        System.out.println("meanLibSize: " + meanLibSize);
        double[] scalingFactor = new double[numberOfSamples];
        Arrays.fill(scalingFactor, 0.0);
        int k2 = 0;
        while (k2 < numberOfSamples) {
            scalingFactor[k2] = meanLibSize / libSize[k2];
            System.out.println("scalingFactor " + k2 + ": " + scalingFactor[k2]);
            ++k2;
        }
        StringBuffer statValues = new StringBuffer();
        statValues.append("Chr\tBS-Pos\tBS strand\tstart region\tend region\tstrand\tisSignificant\tFstat\tthreshold\tp-value\n");
        for (Entry en : predsList) {
            int k3;
            int fwd_bwd;
            System.out.println("BS-Pos: " + en.getPos());
            TreeMap[][] counts = new TreeMap[2][numberOfSamples];
            boolean isCovAboveThresholdEnd = false;
            boolean isCovAboveThresholdStart = false;
            int k4 = 0;
            while (k4 < numberOfSamples) {
                int start = Math.max(0, en.getPos() - regionWidth);
                int end = Math.min(sr[k4].getFileHeader().getSequence(en.chr).getSequenceLength(), en.getPos() + regionWidth);
                counts[0][k4] = new TreeMap();
                counts[1][k4] = new TreeMap();
                this.calculateCovergage(sr[k4], stranded, start, end, en, counts[0][k4], counts[1][k4]);
                fwd_bwd = 0;
                while (fwd_bwd < 2) {
                    if ((Integer)counts[fwd_bwd][k4].get(counts[fwd_bwd][k4].firstKey()) > covCuttoff / 2 && (Integer)counts[0][k4].firstKey() > 0) {
                        isCovAboveThresholdStart = true;
                    }
                    if ((Integer)counts[fwd_bwd][k4].get(counts[fwd_bwd][k4].lastKey()) > covCuttoff / 2 && (Integer)counts[0][k4].lastKey() < sr[k4].getFileHeader().getSequence(en.chr).getSequenceLength()) {
                        isCovAboveThresholdEnd = true;
                    }
                    ++fwd_bwd;
                }
                ++k4;
            }
            double halfCuttoff = (double)covCuttoff / 2.0;
            while (isCovAboveThresholdEnd) {
                isCovAboveThresholdEnd = false;
                k3 = 0;
                while (k3 < numberOfSamples) {
                    int start = Math.max(0, (Integer)counts[0][k3].lastKey() + 1);
                    int end = Math.min(sr[k3].getFileHeader().getSequence(en.chr).getSequenceLength(), start + regionElongation);
                    this.calculateCovergage(sr[k3], stranded, start, end, en, counts[0][k3], counts[1][k3]);
                    if (((double)((Integer)counts[0][k3].get(counts[0][k3].lastKey())).intValue() > halfCuttoff || (double)((Integer)counts[1][k3].get(counts[1][k3].lastKey())).intValue() > halfCuttoff) && (Integer)counts[0][k3].lastKey() < sr[k3].getFileHeader().getSequence(en.chr).getSequenceLength()) {
                        isCovAboveThresholdEnd = true;
                    }
                    ++k3;
                }
            }
            while (isCovAboveThresholdStart) {
                isCovAboveThresholdStart = false;
                k3 = 0;
                while (k3 < numberOfSamples) {
                    int end = Math.max(0, (Integer)counts[0][k3].firstKey() - 1);
                    int start = Math.max(0, end - regionElongation);
                    this.calculateCovergage(sr[k3], stranded, start, end, en, counts[0][k3], counts[1][k3]);
                    if (((double)((Integer)counts[0][k3].get(counts[0][k3].firstKey())).intValue() > halfCuttoff || (double)((Integer)counts[1][k3].get(counts[1][k3].firstKey())).intValue() > halfCuttoff) && (Integer)counts[0][k3].firstKey() > 0) {
                        isCovAboveThresholdStart = true;
                    }
                    ++k3;
                }
            }
            ArrayList[] candRegions = new ArrayList[]{new ArrayList(), new ArrayList()};
            System.out.println("...calc candRegionsFwd...");
            this.getCandidateRegions(candRegions[0], counts[0], posFiles.length, negFiles.length, covCuttoff, minLengthRegion, en.getPos(), regionWidth, Strand.FWD);
            System.out.println("...calc candRegionsBwd...");
            this.getCandidateRegions(candRegions[1], counts[1], posFiles.length, negFiles.length, covCuttoff, minLengthRegion, en.getPos(), regionWidth, Strand.REV);
            fwd_bwd = 0;
            while (fwd_bwd < 2) {
                if (!candRegions[fwd_bwd].isEmpty()) {
                    for (CandidateRegion candReg : candRegions[fwd_bwd]) {
                        System.out.println("start: " + candReg.start + ", stop: " + ", strand: " + (Object)((Object)candReg.strand));
                        this.countReadsWithinRegion(sr, posFiles.length, negFiles.length, candReg, en, stranded);
                        double[] yCounts = new double[numberOfSamples];
                        Arrays.fill(yCounts, 0.0);
                        int[][] xIndicators = new int[numberOfSamples][2];
                        int k5 = 0;
                        while (k5 < numberOfSamples) {
                            Arrays.fill(xIndicators[k5], 0);
                            ++k5;
                        }
                        k5 = 0;
                        while (k5 < numberOfSamples) {
                            candReg.setNormalizedCounts(k5, ((double)candReg.getCountReads(k5) + 1.0) * scalingFactor[k5]);
                            yCounts[k5] = Math.log(candReg.getNormalizedCount(k5));
                            if (k5 < posFiles.length) {
                                xIndicators[k5][1] = 1;
                                System.out.println("Treatment");
                                System.out.println(String.valueOf(candReg.getCountReads(k5)) + "->" + candReg.getNormalizedCount(k5));
                            } else {
                                xIndicators[k5][0] = 1;
                                System.out.println("Control");
                                System.out.println(String.valueOf(candReg.getCountReads(k5)) + "->" + candReg.getNormalizedCount(k5));
                            }
                            ++k5;
                        }
                        DerTALEv2ComplexFunction df = new DerTALEv2ComplexFunction(yCounts, xIndicators);
                        double meanCounts = ToolBox.mean(yCounts);
                        System.out.println("meanCounts: " + meanCounts);
                        double[] currentParameters = new double[]{meanCounts, 0.0, 0.0};
                        double linEps = 1.0E-6;
                        Optimizer.optimize((byte)18, df, currentParameters, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), linEps, new ConstantStartDistance(1.0E-4), System.out);
                        System.out.println(Arrays.toString(currentParameters));
                        double RSS1 = df.evaluateFunction(currentParameters);
                        System.out.println(RSS1);
                        double RSS0 = 0.0;
                        int k6 = 0;
                        while (k6 < numberOfSamples) {
                            double temp = yCounts[k6] - meanCounts;
                            RSS0 += temp * temp;
                            ++k6;
                        }
                        System.out.println("RSS0: " + RSS0);
                        double offset = 0.0;
                        double Fstat = (RSS0 - RSS1) / (double)(xIndicators[0].length - 1) / (offset + RSS1 / (double)(numberOfSamples - xIndicators[0].length));
                        System.out.println("Fstat:" + Fstat);
                        FisherFDist f = new FisherFDist(xIndicators[0].length - 1, numberOfSamples - xIndicators[0].length);
                        double pval = f.barF(Fstat);
                        double threshold = f.inverseF(0.95);
                        System.out.println("pval: " + pval);
                        candReg.setpValue(pval);
                        System.out.println("threshold: " + threshold);
                        String strand = "-";
                        if (fwd_bwd == 0) {
                            strand = "+";
                        }
                        boolean isSignificant = false;
                        if (Fstat > threshold) {
                            isSignificant = true;
                            System.out.println("significant: BS:" + en.getChr() + ":" + en.getPos() + ":" + en.strand + ", candRegion: " + candReg.getStart() + ":" + candReg.getEnd() + ":" + strand);
                        } else {
                            System.out.println("not significant! BS:" + en.getChr() + ":" + en.getPos() + ":" + en.strand + ", candRegion: " + candReg.getStart() + ":" + candReg.getEnd() + ":" + strand);
                        }
                        candReg.setSignificance(isSignificant);
                        statValues.append(String.valueOf(en.getChr()) + "\t" + en.getPos() + "\t" + en.strand + "\t" + candReg.getStart() + "\t" + candReg.getEnd() + "\t" + strand + "\t" + isSignificant + "\t" + Fstat + "\t" + threshold + "\t" + pval + "\n");
                        if (!(Fstat > threshold)) continue;
                        int k7 = 0;
                        while (k7 < files.length) {
                            String fName = files[k7];
                            System.out.println("...calculateProfileCounts...");
                            double[] profileCounts = this.calculateProfileCounts(en, srf, fName, candReg, scalingFactor[k7], stranded);
                            if (k7 < posFiles.length) {
                                candReg.addPositives(profileCounts);
                            } else {
                                candReg.addNegatives(profileCounts);
                            }
                            ++k7;
                        }
                        en.addCandidateRegion(candReg);
                    }
                }
                ++fwd_bwd;
            }
        }
        LinkedList<TextResult> ress = new LinkedList<TextResult>();
        for (Entry en : predsList) {
            int countCands = 0;
            if (en.getCandidateRegions() != null) {
                System.out.println("...getProfileResult for significant regions...");
                for (CandidateRegion candReg : en.getCandidateRegions()) {
                    ++countCands;
                    String profileResult = candReg.getProfileResult(fileNames, t, en.getPos(), candReg);
                    if (profileResult == null) continue;
                    ress.add(new TextResult("Profile for " + en.chr + ":" + en.pos + ":" + en.strand + " candidateRegion:" + candReg.getStart() + ":" + candReg.getEnd() + ":" + candReg.getStrand().toString(), "", new FileParameter.FileRepresentation("", profileResult), "tsv", this.getToolName(), null, true));
                }
            }
            System.out.println("Found " + countCands + " significant regions for BS-Pos: " + en.pos);
        }
        TextResult trstatValues = new TextResult("Differentially abundant", "", new FileParameter.FileRepresentation("", statValues.toString()), "tsv", this.getToolName(), null, true);
        ress.addFirst(trstatValues);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(new Result[][]{ress.toArray(new Result[0])}), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    private boolean isFwd(SAMRecord sr, ExtractRNAseqEvidence.Stranded stranded) {
        if (stranded == ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED) {
            return true;
        }
        if (stranded == ExtractRNAseqEvidence.Stranded.FR_FIRST_STRAND) {
            return sr.getReadPairedFlag() && sr.getFirstOfPairFlag() && sr.getReadNegativeStrandFlag() || sr.getReadPairedFlag() && sr.getSecondOfPairFlag() && sr.getMateNegativeStrandFlag() || (!sr.getReadPairedFlag() || !sr.getProperPairFlag()) && !sr.getReadNegativeStrandFlag();
        }
        return !(sr.getReadPairedFlag() && sr.getFirstOfPairFlag() && sr.getReadNegativeStrandFlag() || sr.getReadPairedFlag() && sr.getSecondOfPairFlag() && sr.getMateNegativeStrandFlag()) && (sr.getReadPairedFlag() && sr.getProperPairFlag() || !sr.getReadNegativeStrandFlag());
    }

    private void calculateCovergage(SamReader sr, ExtractRNAseqEvidence.Stranded stranded, int start, int end, Entry en, TreeMap<Integer, Integer> countsFwd, TreeMap<Integer, Integer> countsBwd) {
        int i = start;
        while (i <= end) {
            countsFwd.put(i, 0);
            countsBwd.put(i, 0);
            ++i;
        }
        SAMRecordIterator sri = sr.query(en.chr, start, end, false);
        int readGenomicStart = -1;
        int readGenomicEnd = -1;
        while (sri.hasNext()) {
            int i2;
            SAMRecord rec = (SAMRecord)sri.next();
            int quali = rec.getMappingQuality();
            if (quali <= 20) continue;
            boolean isReadFwd = this.isFwd(rec, stranded);
            readGenomicStart = rec.getAlignmentStart();
            readGenomicEnd = rec.getAlignmentEnd();
            int readStartRegion = Math.max(readGenomicStart, start);
            int readEndRegion = Math.min(readGenomicEnd, end);
            if (isReadFwd) {
                i2 = readStartRegion;
                while (i2 <= readEndRegion) {
                    countsFwd.replace(i2, countsFwd.get(i2) + 1);
                    ++i2;
                }
                continue;
            }
            i2 = readStartRegion;
            while (i2 <= readEndRegion) {
                countsBwd.replace(i2, countsBwd.get(i2) + 1);
                ++i2;
            }
        }
        sri.close();
    }

    private void countReadsWithinRegion(SamReader[] sr, int posFilesLength, int negFilesLength, CandidateRegion candReg, Entry en, ExtractRNAseqEvidence.Stranded stranded) {
        boolean isCandRegionFWD = true;
        if (candReg.getStrand() == Strand.REV) {
            isCandRegionFWD = false;
        }
        int k = 0;
        while (k < sr.length) {
            SAMRecordIterator sri = sr[k].query(en.chr, candReg.start, candReg.end, false);
            while (sri.hasNext()) {
                boolean isReadFwd;
                SAMRecord rec = (SAMRecord)sri.next();
                int quali = rec.getMappingQuality();
                if (quali <= 20 || (isReadFwd = this.isFwd(rec, stranded)) != isCandRegionFWD) continue;
                candReg.setCountReads(k, candReg.getCountReads(k) + 1);
            }
            sri.close();
            ++k;
        }
    }

    private void getCandidateRegions(ArrayList<CandidateRegion> candRegions, TreeMap<Integer, Integer>[] counts, int posFilesLength, int negFilesLength, int covCuttoff, int minLengthRegion, int BSpos, int regionWidth, Strand strand) {
        int candStart = -1;
        int candEnd = -1;
        boolean isWithinCand = false;
        System.out.println("BSpos: " + BSpos);
        System.out.println("FistPos: " + counts[0].firstKey());
        System.out.println("LastPos: " + counts[0].lastKey());
        System.out.println("keySet-size: " + counts[0].keySet().size());
        for (int pos : counts[0].keySet()) {
            double meanPos = 0.0;
            double meanNeg = 0.0;
            int k = 0;
            while (k < counts.length) {
                if (k < posFilesLength) {
                    meanPos += (double)counts[k].get(pos).intValue();
                } else {
                    meanNeg += (double)counts[k].get(pos).intValue();
                }
                ++k;
            }
            meanNeg /= (double)negFilesLength;
            if ((meanPos /= (double)posFilesLength) >= (double)covCuttoff || meanNeg >= (double)covCuttoff) {
                if (!isWithinCand && (candStart = pos) > BSpos && Math.abs(pos - BSpos) >= regionWidth) {
                    isWithinCand = false;
                    break;
                }
                candEnd = pos;
                isWithinCand = true;
                continue;
            }
            if (isWithinCand) {
                if (candEnd < BSpos && Math.abs(BSpos - pos) >= regionWidth) {
                    isWithinCand = false;
                    break;
                }
                if (candEnd - candStart >= minLengthRegion) {
                    System.out.println("candStart:" + candStart);
                    System.out.println("candEnd:" + candEnd);
                    candRegions.add(new CandidateRegion(candStart, candEnd, strand, posFilesLength, negFilesLength));
                }
            }
            isWithinCand = false;
        }
    }

    private double[] calculateProfileCounts(Entry en, SamReaderFactory srf, String fName, CandidateRegion candReg, double scalingFactor, ExtractRNAseqEvidence.Stranded stranded) {
        if (!new File(String.valueOf(fName) + ".bai").exists()) {
            throw new RuntimeException("No index found for file " + fName + ". The index must be in the same directory as the specified BAM file with filename " + fName + ".bai.");
        }
        boolean isCandRegionFWD = true;
        if (candReg.getStrand() == Strand.REV) {
            isCandRegionFWD = false;
        }
        int start = candReg.getStart();
        int end = candReg.getEnd();
        int extraBases = 100;
        System.out.println("candReg.getStart()" + candReg.getStart());
        if (start > en.getPos()) {
            start -= start - en.getPos();
        } else if (end < en.getPos()) {
            end += en.getPos() - end;
        }
        candReg.setcorrectedCandStartPos(start -= extraBases);
        System.out.println("BS-pos: " + en.getPos());
        System.out.println("correctedStart: " + start);
        SamReader sr = srf.open(SamInputResource.of(new File(fName)).index(new File(String.valueOf(fName) + ".bai")));
        SAMRecordIterator sri = sr.query(en.chr, start, end += extraBases, false);
        double[] counts = new double[end - start + 1];
        Arrays.fill(counts, 0.0);
        while (sri.hasNext()) {
            boolean isReadFwd;
            SAMRecord rec = (SAMRecord)sri.next();
            int quali = rec.getMappingQuality();
            if (quali <= 20 || (isReadFwd = this.isFwd(rec, stranded)) != isCandRegionFWD) continue;
            List<AlignmentBlock> lab = rec.getAlignmentBlocks();
            for (AlignmentBlock ab : lab) {
                int blockstart = ab.getReferenceStart();
                int len = ab.getLength();
                int i = Math.max(start, blockstart) - start;
                while (i < Math.min(end, blockstart + len) - start) {
                    int n = i++;
                    counts[n] = counts[n] + scalingFactor;
                }
            }
        }
        return counts;
    }

    private String[] getFiles(ExpandableParameterSet value) {
        String[] vals = new String[value.getNumberOfParameters()];
        int i = 0;
        while (i < value.getNumberOfParameters()) {
            vals[i] = ((ParameterSet)value.getParameterAt(i).getValue()).getParameterAt(0).getValue().toString();
            ++i;
        }
        return vals;
    }

    @Override
    public String getToolName() {
        return "DerTALE2";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "dertale2";
    }

    @Override
    public String getDescription() {
        return "filters genome-wide predictions for differential expression";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(DerTALEv2Annett.class.getClassLoader().getResourceAsStream("projects/tals/rnaseq/DerTALE.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return new String[]{"@article{erkes19preditale,\n\ttitle = {{PrediTALE}: A novel model learned from quantitative data allows for new perspectives on {TALE} targeting},\n\tauthor = {Erkes, Annett AND M\\\"ucke, Stefanie AND Reschke, Maik AND Boch, Jens AND Grau, Jan},\n\tjournal = {PLOS Computational Biology},\n\tyear = {2019},\n\tvolume = {15},\n\tnumber = {7},\n\tpages = {1-31},\n\tdoi = {10.1371/journal.pcbi.1007206}\n\t}\n"};
    }

    private static class CandidateRegion {
        private int start;
        private int end;
        private Strand strand;
        private int[] countReads;
        private double[] normalizedCounts;
        private LinkedList<double[]> positives;
        private LinkedList<double[]> negatives;
        private int correctedCandStartPos;
        private double pValue;
        private boolean isSignificant;

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public Strand getStrand() {
            return this.strand;
        }

        public void addPositives(double[] positives) {
            if (this.positives == null) {
                this.positives = new LinkedList();
            } else if (this.positives.getFirst().length != positives.length) {
                throw new RuntimeException();
            }
            this.positives.add(positives);
        }

        public void addNegatives(double[] negatives) {
            if (this.negatives == null) {
                this.negatives = new LinkedList();
            } else if (this.negatives.getFirst().length != negatives.length) {
                throw new RuntimeException();
            }
            this.negatives.add(negatives);
        }

        public int getcorrectedCandStartPos() {
            return this.correctedCandStartPos;
        }

        public void setcorrectedCandStartPos(int correctedCandStartPos) {
            this.correctedCandStartPos = correctedCandStartPos;
        }

        public double getpValue() {
            return this.pValue;
        }

        public void setpValue(double pValue) {
            this.pValue = pValue;
        }

        public void setSignificance(boolean isSignificant) {
            this.isSignificant = isSignificant;
        }

        private CandidateRegion(int start, int end, Strand strand, int numberTreatment, int numberControl) {
            this.start = start;
            this.end = end;
            this.strand = strand;
            this.countReads = new int[numberTreatment + numberControl];
            Arrays.fill(this.countReads, 0);
            this.normalizedCounts = new double[numberTreatment + numberControl];
            Arrays.fill(this.normalizedCounts, 0.0);
            this.correctedCandStartPos = -1;
            this.pValue = -1.0;
            this.isSignificant = false;
        }

        public int getCountReads(int index) {
            return this.countReads[index];
        }

        public void setCountReads(int index, int count) {
            this.countReads[index] = count;
        }

        public double getNormalizedCount(int index) {
            return this.normalizedCounts[index];
        }

        public void setNormalizedCounts(int index, double normalizedCount) {
            this.normalizedCounts[index] = normalizedCount;
        }

        public String getProfileResult(String[] header, double t, int enPos, CandidateRegion candReg) {
            int mid = candReg.positives.getFirst().length / 2;
            StringBuffer sb = new StringBuffer();
            sb.append("Position");
            int i = 0;
            while (i < header.length) {
                sb.append("\t" + header[i]);
                ++i;
            }
            sb.append("\tabove threshold\t");
            sb.append("pValue:" + candReg.getpValue() + "\n");
            System.out.println(this.correctedCandStartPos);
            int aktPos = 0;
            int i2 = 0;
            while (i2 < candReg.positives.get(0).length) {
                aktPos = i2 + candReg.getcorrectedCandStartPos();
                sb.append(aktPos);
                int j = 0;
                while (j < candReg.positives.size()) {
                    sb.append("\t" + candReg.positives.get(j)[i2]);
                    ++j;
                }
                j = 0;
                while (j < candReg.negatives.size()) {
                    sb.append("\t" + candReg.negatives.get(j)[i2]);
                    ++j;
                }
                if (aktPos >= candReg.getStart() && aktPos <= candReg.getEnd()) {
                    sb.append("\tTRUE\n");
                } else {
                    sb.append("\tFALSE\n");
                }
                ++i2;
            }
            System.out.println("BS-pos: " + enPos);
            System.out.println("candReg.getStart(): " + candReg.getStart());
            System.out.println("candReg.getEnd(): " + candReg.getEnd());
            System.out.println("lastPos:" + aktPos);
            System.out.println(candReg.getcorrectedCandStartPos());
            return sb.toString();
        }
    }

    private static enum Compare {
        EXTREMES,
        MEDIAN,
        MEAN;

    }

    private static class Entry {
        private String chr;
        private int pos;
        private String strand;
        private LinkedList<CandidateRegion> candidateRegions;

        public static String getHeader() {
            return "Chr\tPosition\tStrand";
        }

        public String toString() {
            return String.valueOf(this.chr) + "\t" + this.pos + "\t" + this.strand;
        }

        public Entry(String chr, int pos, String strand) {
            this.chr = chr;
            this.pos = pos;
            this.strand = strand;
        }

        public String getChr() {
            return this.chr;
        }

        public int getPos() {
            return this.pos;
        }

        public String getStrand() {
            return this.strand;
        }

        public void addCandidateRegion(CandidateRegion candReg) {
            if (this.candidateRegions == null) {
                this.candidateRegions = new LinkedList();
            }
            this.candidateRegions.add(candReg);
        }

        public LinkedList<CandidateRegion> getCandidateRegions() {
            return this.candidateRegions;
        }
    }

    private static enum Strand {
        FWD,
        REV,
        UNK;


        public String toString() {
            switch (this) {
                case FWD: {
                    return "+";
                }
                case REV: {
                    return "-";
                }
            }
            return ".";
        }
    }
}

