/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.AbstractHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.HMMFactory;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import projects.xanthogenomes.Tools;

public class NHMMer {
    public static void main(String[] args) throws Exception {
        DNADataSet ds = new DNADataSet(args[3]);
        int[][] res = NHMMer.run(new FileReader(args[0]), new FileReader(args[1]), new FileReader(args[2]), ds, new ProgressUpdater(), false);
        int i = 0;
        while (i < res.length) {
            System.out.println(Arrays.toString(res[i]));
            ++i;
        }
    }

    public static int[][] run(Reader repeatHMMer, Reader startHMMer, Reader endHMMer, DataSet ds, ProgressUpdater progress, boolean sensitive) throws Exception {
        int[] reg;
        int[] cterm;
        int[] nterm;
        int[] refinestartend;
        int[] curr;
        StringBuffer repeatConsensus = new StringBuffer();
        Pair<AbstractHMM, HomogeneousMMDiffSM> repeats = HMMFactory.parseProfileHMMFromHMMer(repeatHMMer, repeatConsensus, null, null);
        StringBuffer startConsensus = new StringBuffer();
        LinkedList<Integer> startMatchStates = new LinkedList<Integer>();
        LinkedList<Integer> startSilentStates = new LinkedList<Integer>();
        Pair<AbstractHMM, HomogeneousMMDiffSM> start = HMMFactory.parseProfileHMMFromHMMer(startHMMer, startConsensus, startMatchStates, startSilentStates);
        StringBuffer endConsensus = new StringBuffer();
        LinkedList<Integer> endMatchStates = new LinkedList<Integer>();
        LinkedList<Integer> endSilentStates = new LinkedList<Integer>();
        Pair<AbstractHMM, HomogeneousMMDiffSM> end = HMMFactory.parseProfileHMMFromHMMer(endHMMer, endConsensus, endMatchStates, endSilentStates);
        progress.setLast(4.0);
        LinkedList<int[]> fwd = NHMMer.findRepeats(ds, repeats.getFirstElement(), repeats.getSecondElement(), repeatConsensus.toString(), progress, 0.0, sensitive);
        LinkedList<int[]> rev = NHMMer.findRepeats(ds.getReverseComplementaryDataSet(), repeats.getFirstElement(), repeats.getSecondElement(), repeatConsensus.toString(), progress, 1.0, sensitive);
        int totalNum = fwd.size() + rev.size();
        double k = 0.0;
        LinkedList<int[]> list = new LinkedList<int[]>();
        int i = 0;
        while (i < fwd.size()) {
            curr = fwd.get(i);
            refinestartend = new int[]{curr[1], curr[2]};
            nterm = NHMMer.getBestTerminus(ds, curr[0], curr[1], curr[2], true, true, start.getFirstElement(), start.getSecondElement(), startConsensus.toString(), startMatchStates, startSilentStates);
            if (nterm != null) {
                refinestartend[0] = nterm[0];
            }
            if ((cterm = NHMMer.getBestTerminus(ds, curr[0], curr[1], curr[2], true, false, end.getFirstElement(), end.getSecondElement(), endConsensus.toString(), endMatchStates, endSilentStates)) != null) {
                refinestartend[1] = cterm[1];
            }
            reg = NHMMer.refine(refinestartend[0], refinestartend[1], ds.getElementAt(curr[0]));
            int mRNALength = Math.max(refinestartend[1], reg[1]) - Math.min(refinestartend[0], reg[0]);
            int cdsLength = reg[1] - reg[0];
            if (mRNALength - startConsensus.length() / 3 > cdsLength || mRNALength - endConsensus.length() / 3 > cdsLength) {
                list.add(new int[]{curr[0], reg[0], reg[1], 1, Math.min(refinestartend[0], reg[0]), Math.max(refinestartend[1], reg[1]), 1});
            } else {
                int[] nArray = new int[7];
                nArray[0] = curr[0];
                nArray[1] = reg[0];
                nArray[2] = reg[1];
                nArray[3] = 1;
                nArray[4] = reg[0];
                nArray[5] = reg[1];
                list.add(nArray);
            }
            progress.setCurrent(2.0 * k / (double)totalNum + 2.0);
            ++i;
            k += 1.0;
        }
        i = 0;
        while (i < rev.size()) {
            curr = rev.get(i);
            refinestartend = new int[]{curr[1], curr[2]};
            nterm = NHMMer.getBestTerminus(ds, curr[0], curr[1], curr[2], false, true, start.getFirstElement(), start.getSecondElement(), startConsensus.toString(), startMatchStates, startSilentStates);
            if (nterm != null) {
                refinestartend[0] = nterm[0];
            }
            if ((cterm = NHMMer.getBestTerminus(ds, curr[0], curr[1], curr[2], false, false, end.getFirstElement(), end.getSecondElement(), endConsensus.toString(), endMatchStates, endSilentStates)) != null) {
                refinestartend[1] = cterm[1];
            }
            reg = NHMMer.refine(refinestartend[0], refinestartend[1], ds.getElementAt(curr[0]).reverseComplement());
            int el = ds.getElementAt(curr[0]).getLength();
            int mRNALength = Math.max(refinestartend[1], reg[1]) - Math.min(refinestartend[0], reg[0]);
            int cdsLength = reg[1] - reg[0];
            if (mRNALength - startConsensus.length() / 3 > cdsLength || mRNALength - endConsensus.length() / 3 > cdsLength) {
                list.add(new int[]{curr[0], el - reg[1], el - reg[0], -1, el - Math.max(refinestartend[1], reg[1]), el - Math.min(refinestartend[0], reg[0]), 1});
            } else {
                int[] nArray = new int[7];
                nArray[0] = curr[0];
                nArray[1] = el - reg[1];
                nArray[2] = el - reg[0];
                nArray[3] = -1;
                nArray[4] = el - reg[1];
                nArray[5] = el - reg[0];
                list.add(nArray);
            }
            progress.setCurrent(2.0 * k / (double)totalNum + 2.0);
            ++i;
            k += 1.0;
        }
        LinkedList<int[]> toRemove = new LinkedList<int[]>();
        int i2 = 1;
        while (i2 < list.size()) {
            int[] temp2;
            int[] temp = (int[])list.get(i2 - 1);
            if (temp[0] == (temp2 = (int[])list.get(i2))[0] && temp[3] == temp2[3]) {
                if (temp[1] >= temp2[1] && temp[2] <= temp2[2]) {
                    toRemove.add(temp);
                } else if (temp[1] <= temp2[1] && temp[2] >= temp2[2]) {
                    toRemove.add(temp2);
                }
            }
            ++i2;
        }
        list.removeAll(toRemove);
        return (int[][])list.toArray((T[])new int[0][]);
    }

    /*
     * Unable to fully structure code
     */
    private static int[] refine(int start, int end, Sequence original) throws WrongAlphabetException, WrongSequenceTypeException {
        block9: {
            sequence = original.getSubSequence(start, end - start + 1);
            maxframe = -1;
            maxorf = 0;
            maxlen = 0;
            i = 0;
            while (i < 3) {
                prot = Tools.Translator.DEFAULT.translate(sequence, i);
                parts = prot.toString().split("\\*");
                j = 0;
                while (j < parts.length) {
                    if (parts[j].length() > maxlen) {
                        maxlen = parts[j].length();
                        maxframe = i;
                        maxorf = j;
                    }
                    ++j;
                }
                ++i;
            }
            prot = Tools.Translator.DEFAULT.translate(sequence, maxframe);
            parts = prot.toString().split("\\*");
            off = maxframe;
            i = 0;
            while (i < maxorf) {
                off += (parts[i].length() + 1) * 3;
                ++i;
            }
            len = (parts[maxorf].length() + 1) * 3;
            if (maxorf <= 0) ** GOTO lbl42
            sub = original.getSubSequence(start + off, len);
            i = 0;
            while (i < sub.getLength() - 2) {
                codon = sub.toString(i, i + 3);
                if ("ATG".equals(codon)) {
                    off += i;
                    len -= i;
                    break block9;
                }
                i += 3;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                off -= 3;
                len += 3;
lbl42:
                // 2 sources

                ** while (start + off - 3 >= 0 && !"ATG".equals((Object)original.toString((int)(start + off), (int)(start + off + 3))))
            }
        }
        while (start + off + len + 3 < original.getLength() && !"*".equals(Tools.Translator.DEFAULT.translate(original.getSubSequence(start + off + len - 3, 3), 0).toString())) {
            len += 3;
        }
        while (start + off + len + 3 > original.getLength()) {
            len -= 3;
        }
        return new int[]{start + off, start + off + len};
    }

    public static int[] getBestTerminus(DataSet ds, int id, int start, int end, boolean fwd, boolean isStart, AbstractHMM hmm, HomogeneousMMDiffSM hom, String consensus, LinkedList<Integer> matchStates, LinkedList<Integer> silentStates) throws Exception {
        int endIdx;
        double rat;
        double bg;
        double fg;
        int i;
        int numLower;
        int numLay = consensus.length();
        int w = numLay = (int)Math.round((double)numLay * 1.1);
        double t = (double)consensus.length() * Math.log(1.5);
        Sequence seq = ds.getElementAt(id);
        if (!fwd) {
            seq = seq.reverseComplement();
        }
        DoubleList scores = new DoubleList();
        IntList positions = new IntList();
        if (isStart) {
            numLower = 0;
            i = start - w + (int)Math.round(0.1 * (double)consensus.length());
            while (i >= Math.max(0, start - w - 200)) {
                fg = hmm.getLogProbFor(seq, i, i + w - 1);
                bg = hom.getLogProbFor(seq, i, i + w - 1);
                rat = fg - bg;
                numLower = scores.length() > 0 && rat < scores.get(scores.length() - 1) ? ++numLower : 0;
                if (numLower <= 10) {
                    scores.add(rat);
                    positions.add(i);
                    i -= 5;
                    continue;
                }
                break;
            }
        } else {
            numLower = 0;
            i = end - (int)Math.round(0.1 * (double)consensus.length());
            while (i < Math.min(end + 200, seq.getLength() - w + 1)) {
                fg = hmm.getLogProbFor(seq, i, i + w - 1);
                bg = hom.getLogProbFor(seq, i, i + w - 1);
                rat = fg - bg;
                numLower = scores.length() > 0 && rat < scores.get(scores.length() - 1) ? ++numLower : 0;
                if (numLower <= 10) {
                    scores.add(rat);
                    positions.add(i);
                    i += 5;
                    continue;
                }
                break;
            }
        }
        if (positions.length() == 0) {
            return null;
        }
        int idx = ToolBox.getMaxIndex(scores.toArray());
        int[] region = new int[2];
        Pair<IntList, Double> vit = hmm.getViterbiPathFor(positions.get(idx), positions.get(idx) + w - 1, seq);
        IntList states = vit.getFirstElement();
        double[] count = new double[states.length()];
        int i2 = 0;
        while (i2 < states.length()) {
            count[i2] = matchStates.contains(states.get(i2)) ? (i2 > 0 ? count[i2 - 1] + 1.0 : 1.0) : (i2 > 0 && count[i2 - 1] > 0.0 ? count[i2 - 1] - 1.0 : 0.0);
            ++i2;
        }
        int startIdx = endIdx = ToolBox.getMaxIndex(count);
        while (startIdx >= 0 && count[startIdx] > 0.0) {
            --startIdx;
        }
        int offStart = 0;
        int i3 = 0;
        while (i3 < startIdx) {
            if (!silentStates.contains(states.get(i3))) {
                ++offStart;
            }
            ++i3;
        }
        int offEnd = 0;
        int i4 = states.length() - 1;
        while (i4 > endIdx) {
            if (!silentStates.contains(states.get(i4))) {
                ++offEnd;
            }
            --i4;
        }
        region[0] = positions.get(idx) + offStart;
        region[1] = positions.get(idx) + w - offEnd;
        return region;
    }

    public static LinkedList<int[]> findRepeats(DataSet ds, AbstractHMM hmm, HomogeneousMMDiffSM hom, String consensus, ProgressUpdater progress, double progressOffset, boolean sensitive) throws Exception {
        int totalLength = 0;
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            totalLength += ds.getElementAt(i).getLength();
            ++i;
        }
        int numLay = consensus.length();
        int w = numLay = (int)Math.round((double)numLay * 1.1);
        int frag = 10;
        if (sensitive) {
            frag = 5;
        }
        HashSet<String> parts = new HashSet<String>();
        int i2 = 0;
        while (i2 < consensus.length() / frag) {
            parts.add(consensus.substring(i2 * frag, (i2 + 1) * frag).toUpperCase());
            ++i2;
        }
        double t = (double)consensus.length() * Math.log(1.3);
        LinkedList<int[]> found = new LinkedList<int[]>();
        double l = 0.0;
        int i3 = 0;
        while (i3 < ds.getNumberOfElements()) {
            Sequence seq = ds.getElementAt(i3);
            if (seq.getLength() >= w) {
                int j;
                double[] vals = new double[seq.getLength() - w + 1];
                int num = -1;
                int j2 = 0;
                while (j2 < seq.getLength() - w + 1) {
                    if (j2 % 1000 == 0) {
                        progress.setCurrent(l / (double)totalLength + progressOffset);
                    }
                    Sequence sub = seq.getSubSequence(j2, w);
                    if (num == -1) {
                        num = 0;
                        String substr = sub.toString();
                        String[] parts2 = parts.toArray(new String[0]);
                        int k = 0;
                        while (k < parts2.length) {
                            if (substr.indexOf(parts2[k]) > -1) {
                                ++num;
                            }
                            ++k;
                        }
                    }
                    if (num > parts.size() / 2) {
                        double rat;
                        double fg = hmm.getLogProbFor(sub);
                        double bg = hom.getLogProbFor(sub);
                        vals[j2] = rat = fg - bg;
                    }
                    if (j2 < seq.getLength() - w) {
                        String substr1 = seq.toString(j2, j2 + frag);
                        String substr2 = seq.toString(j2 + w - frag + 1, j2 + w + 1);
                        if (parts.contains(substr1)) {
                            --num;
                        }
                        if (parts.contains(substr2)) {
                            ++num;
                        }
                    }
                    ++j2;
                    l += 1.0;
                }
                LinkedList<ComparableElement<Double, Integer>> list = new LinkedList<ComparableElement<Double, Integer>>();
                while (true) {
                    int maxIdx = ToolBox.getMaxIndex(vals);
                    double max = vals[maxIdx];
                    j = Math.max(0, maxIdx - w / 2);
                    while (j < maxIdx + w / 2 && j < vals.length) {
                        vals[j] = 0.0;
                        ++j;
                    }
                    if (!(max > t)) break;
                    list.add(new ComparableElement<Double, Integer>(max, maxIdx));
                }
                Object[] els = list.toArray(new ComparableElement[0]);
                Arrays.sort(els);
                if (els.length > 0) {
                    int start = (Integer)((ComparableElement)els[0]).getWeight();
                    int end = (Integer)((ComparableElement)els[0]).getWeight() + consensus.length();
                    j = 1;
                    while (j < els.length) {
                        if ((Integer)((ComparableElement)els[j]).getWeight() - 500 > (Integer)((ComparableElement)els[j - 1]).getWeight() || j == els.length - 1) {
                            end = (Integer)((ComparableElement)els[j - 1]).getWeight() + consensus.length();
                            found.add(new int[]{i3, start, end});
                            start = (Integer)((ComparableElement)els[j]).getWeight();
                            end = (Integer)((ComparableElement)els[j]).getWeight() + consensus.length();
                        }
                        ++j;
                    }
                }
            }
            ++i3;
        }
        return found;
    }
}

