/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.Singleton;
import de.jstacs.Storable;
import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.PairwiseStringAlignment;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.OperationNotSupportedException;
import projects.xanthogenomes.RVDAlphabetContainer;
import projects.xanthogenomes.TALEConsensus;
import projects.xanthogenomes.Tools;

public class TALE
implements Storable {
    private String strain;
    private String accession;
    private Integer startPos;
    private Integer endPos;
    private Boolean strand;
    private String id;
    private Sequence start;
    private Repeat[] repeats;
    private Sequence end;
    private Sequence rvdSequence;
    private boolean isNew;
    private TALE dnaOriginal;

    void addAnnotation(String strain, String accession, Integer startPos, Integer endPos, Boolean strand) {
        this.strain = strain;
        if (this.dnaOriginal != null) {
            this.dnaOriginal.strain = strain;
        }
        this.accession = accession;
        if (this.dnaOriginal != null) {
            this.dnaOriginal.accession = accession;
        }
        this.startPos = startPos;
        if (this.dnaOriginal != null) {
            this.dnaOriginal.startPos = startPos;
        }
        this.endPos = endPos;
        if (this.dnaOriginal != null) {
            this.dnaOriginal.endPos = endPos;
        }
        this.strand = strand;
        if (this.dnaOriginal != null) {
            this.dnaOriginal.strand = strand;
        }
    }

    public void setStrain(String strain) {
        this.strain = strain;
        if (this.dnaOriginal != null) {
            this.dnaOriginal.strain = strain;
        }
    }

    private String annotationToColumns() {
        StringBuffer buf = new StringBuffer();
        if (this.strain != null) {
            buf.append(this.strain);
        }
        buf.append("\t");
        if (this.accession != null) {
            buf.append(this.accession);
        }
        buf.append("\t");
        if (this.startPos != null) {
            buf.append(this.startPos);
        }
        buf.append("\t");
        if (this.endPos != null) {
            buf.append(this.endPos);
        }
        buf.append("\t");
        if (this.strand != null) {
            buf.append(this.strand != false ? "+1" : "-1");
        }
        return buf.toString();
    }

    public String annotationToString() {
        StringBuffer buf = new StringBuffer();
        if (this.startPos != null && this.endPos != null) {
            buf.append("[" + (this.accession != null ? String.valueOf(this.accession) + ": " : "") + this.startPos + "-" + this.endPos + ":" + (this.strand != null ? (this.strand.booleanValue() ? "+1" : "-1") : "") + "]");
        }
        return buf.toString();
    }

    public Sequence getRvdSequence() {
        return this.rvdSequence;
    }

    public TALE getDnaOriginal() {
        return this.dnaOriginal;
    }

    private void setDnaOriginal(TALE dnaOriginal) {
        this.dnaOriginal = dnaOriginal;
    }

    public String toString() {
        return this.id;
    }

    public TALE(String id, Sequence rvds, boolean parseId, boolean isNew) throws IllegalArgumentException, WrongAlphabetException {
        this.id = parseId ? this.parse(id) : id;
        this.end = null;
        this.start = null;
        this.isNew = isNew;
        if (!RVDAlphabetContainer.SINGLETON.checkConsistency(rvds.getAlphabetContainer())) {
            throw new WrongAlphabetException();
        }
        this.rvdSequence = rvds;
        this.repeats = new Repeat[this.rvdSequence.getLength()];
        int i = 0;
        while (i < this.rvdSequence.getLength()) {
            this.repeats[i] = new Repeat(null);
            this.repeats[i].rvdPosition = -1;
            this.repeats[i].rvd = RVDAlphabetContainer.SINGLETON.getSymbol(i, this.rvdSequence.discreteVal(i));
            ++i;
        }
    }

    public TALE(String id, Sequence start, Repeat[] repeats, Sequence end) throws OperationNotSupportedException, WrongAlphabetException, WrongSequenceTypeException {
        this(true, id, start, repeats, end);
    }

    public TALE(boolean parseId, String id, Sequence start, Repeat[] repeats, Sequence end) throws OperationNotSupportedException, WrongAlphabetException, WrongSequenceTypeException {
        this(parseId, id, start, repeats, end, false);
    }

    public TALE(String id, Sequence start, Repeat[] repeats, Sequence end, boolean isNew) throws OperationNotSupportedException, WrongAlphabetException, WrongSequenceTypeException {
        this(true, id, start, repeats, end, isNew);
    }

    public TALE(boolean parseId, String id, Sequence start, Repeat[] repeats, Sequence end, boolean isNew) throws WrongAlphabetException, WrongSequenceTypeException, OperationNotSupportedException {
        this.id = parseId ? this.parse(id) : id;
        this.start = start;
        this.repeats = repeats;
        this.end = end;
        this.isNew = isNew;
        if (start.getAlphabetContainer().checkConsistency(Tools.Translator.DEFAULT.getProteinAlphabet())) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.repeats.length) {
                int[] idl = repeats[i].getRVDIndexAndLength(i < repeats.length - 1 ? TALEConsensus.repeat : TALEConsensus.lastRepeat);
                this.repeats[i].rvd = repeats[i].getRVD(idl);
                this.repeats[i].maskedRepeats = repeats[i].getBlankedRepeats(idl);
                this.repeats[i].rvdPosition = idl[0];
                this.repeats[i].rvdLength = idl[1];
                sb.append(this.repeats[i].rvd);
                if (i < this.repeats.length - 1) {
                    sb.append("-");
                }
                ++i;
            }
            this.rvdSequence = Sequence.create(RVDAlphabetContainer.SINGLETON, sb.toString(), "-");
        }
    }

    private String parse(String id2) {
        String oldId = id2;
        Pattern p = Pattern.compile("\\s*\\[([0-9]+)\\-([0-9]+)\\:(\\-?\\+?[0-9])\\]");
        Matcher m = p.matcher(oldId);
        if (m.find()) {
            int start = Integer.parseInt(m.group(1));
            int end = Integer.parseInt(m.group(2));
            boolean strand = Integer.parseInt(m.group(3)) >= 0;
            this.addAnnotation(null, null, start, end, strand);
            oldId = m.replaceFirst("");
        }
        return oldId;
    }

    public TALE(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "TALE");
        this.dnaOriginal = (TALE)XMLParser.extractObjectForTags(xml, "dnaOriginal");
        this.id = (String)XMLParser.extractObjectForTags(xml, "id");
        this.isNew = (Boolean)XMLParser.extractObjectForTags(xml, "isNew");
        this.repeats = (Repeat[])XMLParser.extractObjectForTags(xml, "repeats");
        try {
            this.end = XMLParser.extractSequencesWithTags(xml, "end")[0];
            this.rvdSequence = XMLParser.extractSequencesWithTags(xml, "rvdSequence")[0];
            if (this.rvdSequence != null && !Singleton.class.isAssignableFrom(this.rvdSequence.getAlphabetContainer().getClass())) {
                this.rvdSequence = Sequence.create(RVDAlphabetContainer.SINGLETON, this.rvdSequence.toString("-", 0, this.rvdSequence.getLength()), "-");
            }
            this.start = XMLParser.extractSequencesWithTags(xml, "start")[0];
        }
        catch (WrongAlphabetException e) {
            NonParsableException ex = new NonParsableException();
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        try {
            this.strain = (String)XMLParser.extractObjectForTags(xml, "strain");
            this.accession = (String)XMLParser.extractObjectForTags(xml, "accession");
            this.startPos = (Integer)XMLParser.extractObjectForTags(xml, "startPos");
            this.endPos = (Integer)XMLParser.extractObjectForTags(xml, "endPos");
            this.strand = (Boolean)XMLParser.extractObjectForTags(xml, "strand");
            if (this.dnaOriginal != null) {
                if (this.dnaOriginal.strain == null) {
                    this.dnaOriginal.strain = this.strain;
                }
                if (this.dnaOriginal.accession == null) {
                    this.dnaOriginal.accession = this.accession;
                }
                if (this.dnaOriginal.startPos == null) {
                    this.dnaOriginal.startPos = this.startPos;
                }
                if (this.dnaOriginal.endPos == null) {
                    this.dnaOriginal.endPos = this.endPos;
                }
                if (this.dnaOriginal.strand == null) {
                    this.dnaOriginal.strand = this.strand;
                }
            }
        }
        catch (NonParsableException nonParsableException) {
            // empty catch block
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.dnaOriginal, "dnaOriginal");
        XMLParser.appendObjectWithTags(xml, this.id, "id");
        XMLParser.appendObjectWithTags(xml, this.isNew, "isNew");
        XMLParser.appendObjectWithTags(xml, this.repeats, "repeats");
        XMLParser.appendSequencesWithTags(xml, "end", this.end);
        XMLParser.appendSequencesWithTags(xml, "rvdSequence", this.rvdSequence);
        XMLParser.appendSequencesWithTags(xml, "start", this.start);
        XMLParser.appendObjectWithTags(xml, this.strain, "strain");
        XMLParser.appendObjectWithTags(xml, this.accession, "accession");
        XMLParser.appendObjectWithTags(xml, this.startPos, "startPos");
        XMLParser.appendObjectWithTags(xml, this.endPos, "endPos");
        XMLParser.appendObjectWithTags(xml, this.strand, "strand");
        XMLParser.addTags(xml, "TALE");
        return xml;
    }

    public TALE getTranslatedTALE(Tools.Translator t) throws IllegalArgumentException, WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException, IOException, DoubleSymbolException, OperationNotSupportedException {
        Repeat[] trans = new Repeat[this.repeats.length];
        int i = 0;
        while (i < this.repeats.length) {
            Sequence temp = this.repeats[i].getRepeat();
            temp = Tools.Translator.DEFAULT.translate(temp, 0);
            trans[i] = new Repeat(temp);
            ++i;
        }
        TALE tale = new TALE(this.id, t.translate(this.start, 0), trans, t.translate(this.end, 0));
        tale.setDnaOriginal(this);
        tale.accession = this.accession;
        tale.strain = this.strain;
        tale.startPos = this.startPos;
        tale.endPos = this.endPos;
        tale.strand = this.strand;
        return tale;
    }

    public String getId() {
        return this.id;
    }

    public Sequence getStart() {
        return this.start;
    }

    public int getNumberOfRepeats() {
        return this.repeats.length;
    }

    public Repeat getRepeat(int i) {
        return this.repeats[i];
    }

    public Repeat[] getRepeats() {
        return this.repeats;
    }

    public Sequence getRVDSequence(Sequence consensus, Sequence lastConsensus) throws IllegalArgumentException, WrongAlphabetException, OperationNotSupportedException {
        StringBuffer reps = new StringBuffer();
        int i = 0;
        while (i < this.repeats.length) {
            reps.append(this.repeats[i].getRVD(i < this.repeats.length - 1 ? consensus : lastConsensus));
            if (i < this.repeats.length) {
                reps.append("-");
            }
            ++i;
        }
        return Sequence.create(RVDAlphabetContainer.SINGLETON, reps.toString(), "-");
    }

    public Sequence getEnd() {
        return this.end;
    }

    public static TALE[] translateTALEs(TALE[] tales, Tools.Translator t) throws IllegalArgumentException, IOException, DoubleSymbolException, WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException, OperationNotSupportedException {
        TALE[] trans = new TALE[tales.length];
        int i = 0;
        while (i < tales.length) {
            trans[i] = tales[i].getTranslatedTALE(t);
            ++i;
        }
        return trans;
    }

    public static TALE[] readTALEs(String startFile, String repeatFile, String endFile) throws IllegalArgumentException, IOException, WrongAlphabetException, OperationNotSupportedException, WrongSequenceTypeException {
        HashMap<String, Sequence> starts = new HashMap<String, Sequence>();
        BufferedReader read = new BufferedReader(new FileReader(startFile));
        String str = null;
        String key = null;
        LinkedList<String> keyList = new LinkedList<String>();
        while ((str = read.readLine()) != null) {
            if (str.startsWith(">")) {
                key = str.substring(1).trim();
                keyList.add(key);
                continue;
            }
            starts.put(key, Sequence.create(DNAAlphabetContainer.SINGLETON, str.trim()));
        }
        read.close();
        HashMap<String, Sequence> ends = new HashMap<String, Sequence>();
        read = new BufferedReader(new FileReader(endFile));
        str = null;
        key = null;
        while ((str = read.readLine()) != null) {
            if (str.startsWith(">")) {
                key = str.substring(1).trim();
                continue;
            }
            ends.put(key, Sequence.create(DNAAlphabetContainer.SINGLETON, str.trim()));
        }
        read.close();
        HashMap<String, Repeat[]> repeats = new HashMap<String, Repeat[]>();
        read = new BufferedReader(new FileReader(repeatFile));
        str = null;
        key = null;
        LinkedList<Repeat> rep = new LinkedList<Repeat>();
        while ((str = read.readLine()) != null) {
            if (str.startsWith(">")) {
                if (key != null) {
                    repeats.put(key, rep.toArray(new Repeat[0]));
                    rep.clear();
                }
                key = str.substring(1).trim();
                continue;
            }
            rep.add(new Repeat(Sequence.create(DNAAlphabetContainer.SINGLETON, str.trim())));
        }
        if (key != null) {
            repeats.put(key, rep.toArray(new Repeat[0]));
            rep.clear();
        }
        read.close();
        if (starts.size() != ends.size() || starts.size() != repeats.size()) {
            System.out.println(String.valueOf(starts.size()) + " " + ends.size() + " " + repeats.size());
        }
        Iterator keys = keyList.iterator();
        TALE[] tales = new TALE[starts.size()];
        int i = 0;
        while (keys.hasNext()) {
            key = (String)keys.next();
            tales[i] = new TALE(key, (Sequence)starts.get(key), (Repeat[])repeats.get(key), (Sequence)ends.get(key));
            ++i;
        }
        return tales;
    }

    public String getRVD(int i, Sequence repeatCons) {
        return this.repeats[i].getRvd();
    }

    public Sequence[] getBlankedRepeats(int i, Sequence repeatCons) throws OperationNotSupportedException, WrongAlphabetException, WrongSequenceTypeException {
        return this.repeats[i].getBlankedRepeats(repeatCons);
    }

    public void setId(String newId) {
        this.id = newId;
        if (this.dnaOriginal != null) {
            this.dnaOriginal.setId(newId);
        }
    }

    public void drawLeaf(Graphics2D graphics, int xoff, int yoff, int height, int margin) {
        graphics = (Graphics2D)graphics.create();
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(this.id, graphics);
        Sequence rvds = this.getRvdSequence();
        Rectangle2D rect2 = graphics.getFontMetrics().getStringBounds(rvds.toString("-", 0, rvds.getLength()), graphics);
        double h = (rect.getHeight() + rect2.getHeight()) * 1.2;
        double rat = (double)height / h;
        int size = graphics.getFont().getSize();
        size = (int)((double)size * rat);
        graphics.setFont(new Font(graphics.getFont().getFontName(), graphics.getFont().getStyle(), size));
        rect = graphics.getFontMetrics().getStringBounds(this.id, graphics);
        rect2 = graphics.getFontMetrics().getStringBounds(rvds.toString("-", 0, rvds.getLength()), graphics);
        int w = this.getWidth(graphics, height);
        if (this.isNew) {
            graphics.setColor(Color.BLUE);
        }
        graphics.drawRect(xoff + margin / 4, yoff, w + margin / 2, height);
        graphics.drawString(this.id, xoff + margin / 2, yoff - margin / 4 + (int)((double)height / 2.0 - rect.getCenterY()));
        graphics.drawString(rvds.toString("-", 0, rvds.getLength()), xoff + margin / 2, yoff - margin / 4 + (int)((double)height - rect2.getCenterY()));
    }

    public int getWidth(Graphics2D graphics, int height) {
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(this.id, graphics);
        Sequence rvds = this.getRvdSequence();
        Rectangle2D rect2 = graphics.getFontMetrics().getStringBounds(rvds.toString("-", 0, rvds.getLength()), graphics);
        double h = (rect.getHeight() + rect2.getHeight()) * 1.2;
        double rat = (double)height / h;
        double w = Math.max(rect.getWidth(), rect2.getWidth());
        return (int)(w *= rat);
    }

    public void setIsNew(boolean b) {
        this.isNew = b;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String getCodon(int repeat, int position) {
        Repeat r = this.repeats[repeat];
        if (r.getMaskedRepeats() != null) {
            int before = r.getMaskedRepeats()[0].getLength() * 3;
            TALE dna = this.getDnaOriginal();
            if (dna == null) {
                return null;
            }
            String rvd = r.getRvd();
            if (position == 0) {
                return dna.getRepeat(repeat).getRepeat().getSubSequence(before, 3).toString();
            }
            if (position == 1) {
                if (rvd.endsWith("*")) {
                    return "---";
                }
                return dna.getRepeat(repeat).getRepeat().getSubSequence(before + 3, 3).toString();
            }
            return null;
        }
        return null;
    }

    public boolean containsAberrantRepeat() {
        int i = 0;
        while (i < this.repeats.length - 1) {
            if (this.repeats[i].getType() != Type.UNKNOWN && this.repeats[i].getType() != Type.NORMAL) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ResultSet annotationToResultSet() {
        return new ResultSet(new Result[][]{{new CategoricalResult("ID", "", this.getId()), new CategoricalResult("Strain", "", this.strain == null ? "" : this.strain), new CategoricalResult("Accession", "", this.accession == null ? "" : this.accession), new NumericalResult("Start", "", this.startPos == null ? -1 : this.startPos), new NumericalResult("End", "", this.endPos == null ? -1 : this.endPos), new CategoricalResult("Strand", "", this.strand == null ? "" : (this.strand != false ? "+1" : "-1")), new NumericalResult("Repeats", "", this.getNumberOfRepeats()), new CategoricalResult("RVDs", "", this.getRvdSequence().toString())}});
    }

    public void setAccession(String accession2) {
        this.accession = accession2;
        if (this.dnaOriginal != null) {
            this.dnaOriginal.accession = accession2;
        }
    }

    public String getStrain() {
        return this.strain;
    }

    public String getAccession() {
        return this.accession;
    }

    public static class Repeat
    implements Storable {
        private Sequence repeat;
        private String rvd;
        private Sequence[] maskedRepeats;
        private int rvdPosition;
        private int rvdLength;

        public Repeat(StringBuffer xml) throws NonParsableException, IllegalArgumentException, WrongAlphabetException {
            xml = XMLParser.extractForTag(xml, "Repeat");
            this.repeat = XMLParser.extractSequencesWithTags(xml, "repeat")[0];
            this.rvd = (String)XMLParser.extractObjectForTags(xml, "rvd");
            this.maskedRepeats = XMLParser.extractSequencesWithTags(xml, "maskedRepeats");
            this.rvdPosition = (Integer)XMLParser.extractObjectForTags(xml, "rvdPosition");
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer xml = new StringBuffer();
            XMLParser.appendSequencesWithTags(xml, "repeat", this.repeat);
            XMLParser.appendObjectWithTags(xml, this.rvd, "rvd");
            XMLParser.appendSequencesWithTags(xml, "maskedRepeats", this.maskedRepeats);
            XMLParser.appendObjectWithTags(xml, this.rvdPosition, "rvdPosition");
            XMLParser.addTags(xml, "Repeat");
            return xml;
        }

        public int getRvdPosition() {
            return this.rvdPosition;
        }

        public int getRvdLength() {
            if (this.rvd != null) {
                return this.rvd.charAt(1) == '*' ? 1 : 2;
            }
            return 0;
        }

        public Repeat(Sequence repeat) {
            this.repeat = repeat;
        }

        public Type getType() {
            if (this.repeat != null && this.repeat.getAlphabetContainer().checkConsistency(Tools.Translator.DEFAULT.getProteinAlphabet())) {
                int expected = this.rvd.endsWith("*") ? 33 : 34;
                int diff = this.repeat.getLength() - expected;
                if (diff == 0) {
                    return Type.NORMAL;
                }
                if (diff < 0) {
                    return Type.SHORT;
                }
                if (diff == 1) {
                    return Type.THIRTYFIVE;
                }
                return Type.LONG;
            }
            return Type.UNKNOWN;
        }

        public Sequence getRepeat() {
            return this.repeat;
        }

        public String getRvd() {
            return this.rvd;
        }

        public Sequence[] getMaskedRepeats() {
            return this.maskedRepeats;
        }

        private int[] getRVDIndexAndLength(Sequence consensus) throws OperationNotSupportedException {
            PairwiseStringAlignment al = Tools.Aligner.DEFAULT.align(this.repeat.reverse(), consensus.reverse(), Alignment.AlignmentType.GLOBAL);
            String ca = new StringBuffer(al.getAlignedString(1)).reverse().toString();
            int k = 0;
            int j = 0;
            while (k < 11) {
                if (ca.charAt(j) != '-') {
                    ++k;
                }
                ++j;
            }
            int l = j;
            while (k < 12) {
                if (ca.charAt(l) != '-') {
                    ++k;
                }
                ++l;
            }
            String ra = new StringBuffer(al.getAlignedString(0)).reverse().toString();
            char twelve = ra.charAt(j);
            char thirteen = ra.charAt(l);
            int idx = ra.substring(0, j + 1).replaceAll("-", "").length() - 1;
            int length = 2;
            if (twelve == '-' && thirteen == '-') {
                throw new RuntimeException("Both RVD positions are gaps.\n" + this.repeat + "\n" + consensus + "\n");
            }
            if (twelve == '-') {
                length = 1;
            } else if (thirteen == '-') {
                length = 1;
            }
            return new int[]{++idx, length};
        }

        private Sequence[] getBlankedRepeats(int[] idl) throws WrongAlphabetException, WrongSequenceTypeException {
            int index = idl[0];
            int length = idl[1];
            if (length == 1) {
                int[] cont1 = new int[index];
                int[] cont2 = new int[this.repeat.getLength() - index - 1];
                int j = 0;
                int i = 0;
                while (i < this.repeat.getLength()) {
                    if (i < index) {
                        cont1[j] = this.repeat.discreteVal(i);
                        ++j;
                    } else if (i > index) {
                        cont2[j] = this.repeat.discreteVal(i);
                        ++j;
                    } else {
                        j = 0;
                    }
                    ++i;
                }
                return new Sequence[]{new IntSequence(this.repeat.getAlphabetContainer(), cont1), new IntSequence(this.repeat.getAlphabetContainer(), cont2)};
            }
            int[] cont1 = new int[index];
            int[] cont2 = new int[this.repeat.getLength() - index - 2];
            int j = 0;
            int i = 0;
            while (i < this.repeat.getLength()) {
                if (i < index) {
                    cont1[j] = this.repeat.discreteVal(i);
                    ++j;
                } else if (i > index + length - 1) {
                    cont2[j] = this.repeat.discreteVal(i);
                    ++j;
                } else {
                    j = 0;
                }
                ++i;
            }
            return new Sequence[]{new IntSequence(this.repeat.getAlphabetContainer(), cont1), new IntSequence(this.repeat.getAlphabetContainer(), cont2)};
        }

        public Sequence[] getBlankedRepeats(Sequence consensus) throws WrongAlphabetException, WrongSequenceTypeException, OperationNotSupportedException {
            int[] idl = this.getRVDIndexAndLength(consensus);
            return this.getBlankedRepeats(idl);
        }

        private String getRVD(int[] idl) {
            int index = idl[0];
            int length = idl[1];
            StringBuffer reps = new StringBuffer();
            if (length == 1) {
                reps.append(this.repeat.getSubSequence(index, 1) + "*");
            } else {
                reps.append(this.repeat.getSubSequence(index, 2).toString());
            }
            return reps.toString();
        }

        public String getRVD(Sequence consensus) throws OperationNotSupportedException {
            int[] idl = this.getRVDIndexAndLength(consensus);
            return this.getRVD(idl);
        }
    }

    public static enum Type {
        NORMAL,
        LONG,
        SHORT,
        THIRTYFIVE,
        UNKNOWN;

    }
}

