/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes.alignmentCosts;

import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALESequence;

public class RVDCosts
implements Costs {
    private double gap;
    private double twelve;
    private double thirteen;
    private double bonus;

    public RVDCosts(double gap, double twelve, double thirteen, double bonus) {
        this.gap = gap;
        this.twelve = twelve;
        this.thirteen = thirteen;
        this.bonus = bonus;
    }

    public RVDCosts(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "RVDCosts");
        this.bonus = (Double)XMLParser.extractObjectForTags(xml, "bonus");
        this.gap = (Double)XMLParser.extractObjectForTags(xml, "gap");
        this.thirteen = (Double)XMLParser.extractObjectForTags(xml, "thirteen");
        this.twelve = (Double)XMLParser.extractObjectForTags(xml, "twelve");
    }

    @Override
    public double getCostFor(Sequence s1, Sequence s2, int i, int j) {
        TALESequence t1 = (TALESequence)s1;
        TALESequence t2 = (TALESequence)s2;
        TALE tale1 = t1.getTALE();
        TALE tale2 = t2.getTALE();
        String rvd1 = tale1.getRepeat(i - 1).getRvd();
        String rvd2 = tale2.getRepeat(j - 1).getRvd();
        double cost = this.getCostFor(rvd1, rvd2);
        return cost;
    }

    public double getCostFor(AlphabetContainer rvdAlp, int rvd1, int rvd2) {
        return this.getCostFor(rvdAlp.getSymbol(0, rvd1), rvdAlp.getSymbol(0, rvd2));
    }

    private double getCostFor(String rvd1, String rvd2) {
        double cost = 0.0;
        if (rvd1.charAt(0) != rvd2.charAt(0)) {
            cost += this.twelve;
        }
        if (rvd1.charAt(1) != rvd2.charAt(1)) {
            cost += this.thirteen;
        }
        if (cost == 0.0) {
            cost += this.bonus;
        }
        return cost;
    }

    @Override
    public double getInsertCosts() {
        return this.getGapCosts();
    }

    @Override
    public double getDeleteCosts() {
        return this.getGapCosts();
    }

    public double getGapCosts() {
        return this.gap;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.bonus, "bonus");
        XMLParser.appendObjectWithTags(xml, this.gap, "gap");
        XMLParser.appendObjectWithTags(xml, this.thirteen, "thirteen");
        XMLParser.appendObjectWithTags(xml, this.twelve, "twelve");
        XMLParser.addTags(xml, "RVDCosts");
        return xml;
    }
}

