/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes.tools;

import de.jstacs.io.FileManager;
import de.jstacs.parameters.FileParameter;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojavax.Namespace;
import org.biojavax.Note;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNamespace;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;
import org.biojavax.ontology.ComparableTerm;
import projects.xanthogenomes.tools.TALEAnalysisTool;

public class RenameTool
implements JstacsTool {
    @Override
    public ToolParameterSet getToolParameters() {
        FileParameter names = new FileParameter("Rename Table", "A tab-separated table containing the old name in the first column and the new name in the second column. Output \"TALE names\" of \"TALE Class Assignment\" tool.", "tsv", true);
        FileParameter input = new FileParameter("Input file", "The input Genbank or GFF3 file that should be renamed.", "gb,gbk,genbank,gff,gff3", true);
        return new ToolParameterSet(this.getShortName(), names, input);
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        FileParameter names = (FileParameter)parameters.getParameterAt(0);
        FileParameter input = (FileParameter)parameters.getParameterAt(1);
        HashMap<String, String> nameMap = new HashMap<String, String>();
        String[] lines = names.getFileContents().getContent().split("\n");
        int i = 0;
        while (i < lines.length) {
            lines[i] = lines[i].trim();
            if (!lines[i].startsWith("#")) {
                String[] temp = lines[i].split("\t");
                nameMap.put(temp[0], temp[1]);
                if (temp[0].endsWith(" (Pseudo)")) {
                    nameMap.put(temp[0].substring(0, temp[0].length() - 9), temp[1]);
                }
            }
            ++i;
        }
        if (input.getFileContents().getExtension().equalsIgnoreCase("gff") || input.getFileContents().getExtension().equalsIgnoreCase("gff3")) {
            StringBuffer res = new StringBuffer();
            lines = input.getFileContents().getContent().split("\n");
            int i2 = 0;
            while (i2 < lines.length) {
                String[] parts = lines[i2].split("\t");
                String[] ann = parts[8].split("\\;");
                int j = 0;
                while (j < ann.length) {
                    String[] keyval = ann[j].trim().split("=");
                    if ((keyval[0].equalsIgnoreCase("id") || keyval[0].equalsIgnoreCase("parent")) && nameMap.containsKey(keyval[1])) {
                        keyval[1] = (String)nameMap.get(keyval[1]);
                        ann[j] = String.valueOf(keyval[0]) + "=" + keyval[1];
                    }
                    ++j;
                }
                StringBuffer temp = new StringBuffer();
                int j2 = 0;
                while (j2 < ann.length) {
                    temp.append(ann[j2]);
                    if (j2 < ann.length - 1) {
                        temp.append(";");
                    }
                    ++j2;
                }
                parts[8] = temp.toString();
                j2 = 0;
                while (j2 < parts.length) {
                    res.append(parts[j2]);
                    if (j2 < parts.length - 1) {
                        res.append("\t");
                    }
                    ++j2;
                }
                res.append("\n");
                ++i2;
            }
            TextResult fres = new TextResult("Renamed GFF: TALE loci", "Renamed TALEs in GFF format", new FileParameter.FileRepresentation("", res.toString()), "gff3", "Rename", null, true);
            protocol.append("Renamed TALEs in GFF file.\n");
            return new ToolResult("Result of " + this.getToolName() + " (GFF)", String.valueOf(this.getToolName()) + " on \"" + input.getFileContents().getFilename() + "\"", null, new ResultSet(fres), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SimpleNamespace ns = new SimpleNamespace("biojava");
        ComparableTerm gene = RichObjectFactory.getDefaultOntology().getOrCreateTerm("gene");
        BufferedReader br = new BufferedReader(new StringReader(input.getFileContents().getContent()));
        RichSequenceIterator it = RichSequence.IOTools.readGenbankDNA((BufferedReader)br, (Namespace)ns);
        LinkedList li = new LinkedList();
        while (it.hasNext()) {
            RichSequence seq = it.nextRichSequence();
            Iterator featit = seq.features();
            while (featit.hasNext()) {
                Feature f = (Feature)featit.next();
                if (!(f instanceof RichFeature)) continue;
                for (Note n : ((RichFeature)f).getNoteSet()) {
                    if (!n.getTerm().equals(gene) || !nameMap.containsKey(n.getValue())) continue;
                    n.setValue((String)nameMap.get(n.getValue()));
                }
            }
            RichSequence.IOTools.writeGenbank((OutputStream)os, (Sequence)seq, (Namespace)ns);
        }
        String cont = os.toString("UTF-8");
        TextResult fres2 = new TextResult("Renamed Genbank: TALEs", "Renamed TALEs in Genbank format", new FileParameter.FileRepresentation("", cont), "gb", "Rename", null, true);
        protocol.append("Renamed TALEs in Genbank file.\n");
        return new ToolResult("Result of " + this.getToolName() + " (Genbank)", String.valueOf(this.getToolName()) + " on \"" + input.getFileContents().getFilename() + "\"", null, new ResultSet(fres2), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "Rename TALEs in File";
    }

    @Override
    public String getShortName() {
        return "rename";
    }

    @Override
    public String getDescription() {
        return "Renames TALEs in in Genbank or GFF3 file";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(TALEAnalysisTool.class.getClassLoader().getResourceAsStream("projects/xanthogenomes/tools/RenameTool.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getToolVersion() {
        return "1.1";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

