/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes.utils;

import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALEFamilyBuilder;

public class RenameTALEs {
    public static void main(String[] args) throws NonParsableException, IOException {
        TALEFamilyBuilder tfb = new TALEFamilyBuilder(FileManager.readFile(args[0]));
        TALEFamilyBuilder.TALEFamily[] fams = tfb.getFamilies();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new FileReader(args[1]));
        String str = null;
        while ((str = br.readLine()) != null) {
            String[] parts = str.split("\t");
            nameMap.put(parts[0], parts[2]);
        }
        br.close();
        int i = 0;
        while (i < fams.length) {
            TALE[] tales = fams[i].getFamilyMembers();
            int j = 0;
            while (j < tales.length) {
                String strain = tales[j].getStrain();
                String name = tales[j].getId();
                if (nameMap.containsKey(strain)) {
                    String newStrain = (String)nameMap.get(strain);
                    String newName = name.replace(strain, newStrain);
                    System.out.println(String.valueOf(strain) + "\t" + name + "  ->  " + newStrain + "\t" + newName);
                    tales[j].setId(newName);
                    tales[j].setStrain(newStrain);
                }
                ++j;
            }
            ++i;
        }
        FileManager.writeFile(args[0].replace(".xml", "_curated.xml"), (CharSequence)tfb.toXML());
    }
}

